// gpu/ipc/common/mailbox_holder.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_MAILBOX_HOLDER_MOJOM_BLINK_H_
#define GPU_IPC_COMMON_MAILBOX_HOLDER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/mailbox_holder.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox_holder.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox_holder.mojom-blink-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox.mojom-blink.h"
#include "gpu/ipc/common/sync_token.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "gpu/ipc/common/mailbox_holder_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gpu::mojom::blink {








class BLINK_PLATFORM_EXPORT MailboxHolder {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MailboxHolder, T>::value>;
  using DataView = MailboxHolderDataView;
  using Data_ = internal::MailboxHolder_Data;

  template <typename... Args>
  static MailboxHolderPtr New(Args&&... args) {
    return MailboxHolderPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MailboxHolderPtr From(const U& u) {
    return mojo::TypeConverter<MailboxHolderPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MailboxHolder>::Convert(*this);
  }


  MailboxHolder();

  MailboxHolder(
      const ::gpu::Mailbox& mailbox,
      const ::gpu::SyncToken& sync_token,
      uint32_t texture_target);


  ~MailboxHolder();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MailboxHolderPtr>
  MailboxHolderPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MailboxHolder::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MailboxHolder::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MailboxHolder::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MailboxHolder::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MailboxHolder::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MailboxHolder::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MailboxHolder_UnserializedMessageContext<
            UserType, MailboxHolder::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MailboxHolder::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MailboxHolder::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MailboxHolder_UnserializedMessageContext<
            UserType, MailboxHolder::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MailboxHolder::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::Mailbox mailbox;
  
  ::gpu::SyncToken sync_token;
  
  uint32_t texture_target;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MailboxHolder::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MailboxHolder::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MailboxHolder::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MailboxHolder::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MailboxHolderPtr MailboxHolder::Clone() const {
  return New(
      mojo::Clone(mailbox),
      mojo::Clone(sync_token),
      mojo::Clone(texture_target)
  );
}

template <typename T, MailboxHolder::EnableIfSame<T>*>
bool MailboxHolder::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mailbox, other_struct.mailbox))
    return false;
  if (!mojo::Equals(this->sync_token, other_struct.sync_token))
    return false;
  if (!mojo::Equals(this->texture_target, other_struct.texture_target))
    return false;
  return true;
}

template <typename T, MailboxHolder::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mailbox < rhs.mailbox)
    return true;
  if (rhs.mailbox < lhs.mailbox)
    return false;
  if (lhs.sync_token < rhs.sync_token)
    return true;
  if (rhs.sync_token < lhs.sync_token)
    return false;
  if (lhs.texture_target < rhs.texture_target)
    return true;
  if (rhs.texture_target < lhs.texture_target)
    return false;
  return false;
}


}  // gpu::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::gpu::mojom::blink::MailboxHolder::DataView,
                                         ::gpu::mojom::blink::MailboxHolderPtr> {
  static bool IsNull(const ::gpu::mojom::blink::MailboxHolderPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::MailboxHolderPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::blink::MailboxHolder::mailbox)& mailbox(
      const ::gpu::mojom::blink::MailboxHolderPtr& input) {
    return input->mailbox;
  }

  static const decltype(::gpu::mojom::blink::MailboxHolder::sync_token)& sync_token(
      const ::gpu::mojom::blink::MailboxHolderPtr& input) {
    return input->sync_token;
  }

  static decltype(::gpu::mojom::blink::MailboxHolder::texture_target) texture_target(
      const ::gpu::mojom::blink::MailboxHolderPtr& input) {
    return input->texture_target;
  }

  static bool Read(::gpu::mojom::blink::MailboxHolder::DataView input, ::gpu::mojom::blink::MailboxHolderPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_MAILBOX_HOLDER_MOJOM_BLINK_H_