// gpu/ipc/common/gpu_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/gpu_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_info.mojom-params-data.h"
#include "gpu/ipc/common/gpu_info.mojom-shared-message-ids.h"

#include "gpu/ipc/common/gpu_info.mojom-import-headers.h"
#include "gpu/ipc/common/gpu_info.mojom-test-utils.h"


namespace gpu::mojom {
GpuDevice::GpuDevice()
    : vendor_id(),
      device_id(),
      active(),
      vendor_string(),
      device_string(),
      driver_vendor(),
      driver_version(),
      gpu_preference() {}

GpuDevice::GpuDevice(
    uint32_t vendor_id_in,
    uint32_t device_id_in,
    bool active_in,
    const std::string& vendor_string_in,
    const std::string& device_string_in,
    const std::string& driver_vendor_in,
    const std::string& driver_version_in,
    ::gl::GpuPreference gpu_preference_in)
    : vendor_id(std::move(vendor_id_in)),
      device_id(std::move(device_id_in)),
      active(std::move(active_in)),
      vendor_string(std::move(vendor_string_in)),
      device_string(std::move(device_string_in)),
      driver_vendor(std::move(driver_vendor_in)),
      driver_version(std::move(driver_version_in)),
      gpu_preference(std::move(gpu_preference_in)) {}

GpuDevice::~GpuDevice() = default;

void GpuDevice::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_id"), this->vendor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active"), this->active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_string"), this->vendor_string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_string"), this->device_string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "driver_vendor"), this->driver_vendor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "driver_version"), this->driver_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_preference"), this->gpu_preference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gl::GpuPreference>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuDevice::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoDecodeAcceleratorSupportedProfile::VideoDecodeAcceleratorSupportedProfile()
    : profile(),
      max_resolution(),
      min_resolution(),
      encrypted_only() {}

VideoDecodeAcceleratorSupportedProfile::VideoDecodeAcceleratorSupportedProfile(
    ::gpu::VideoCodecProfile profile_in,
    const ::gfx::Size& max_resolution_in,
    const ::gfx::Size& min_resolution_in,
    bool encrypted_only_in)
    : profile(std::move(profile_in)),
      max_resolution(std::move(max_resolution_in)),
      min_resolution(std::move(min_resolution_in)),
      encrypted_only(std::move(encrypted_only_in)) {}

VideoDecodeAcceleratorSupportedProfile::~VideoDecodeAcceleratorSupportedProfile() = default;

void VideoDecodeAcceleratorSupportedProfile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_resolution"), this->max_resolution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_resolution"), this->min_resolution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encrypted_only"), this->encrypted_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoDecodeAcceleratorSupportedProfile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoDecodeAcceleratorCapabilities::VideoDecodeAcceleratorCapabilities()
    : supported_profiles(),
      flags() {}

VideoDecodeAcceleratorCapabilities::VideoDecodeAcceleratorCapabilities(
    std::vector<::gpu::VideoDecodeAcceleratorSupportedProfile> supported_profiles_in,
    uint32_t flags_in)
    : supported_profiles(std::move(supported_profiles_in)),
      flags(std::move(flags_in)) {}

VideoDecodeAcceleratorCapabilities::~VideoDecodeAcceleratorCapabilities() = default;

void VideoDecodeAcceleratorCapabilities::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_profiles"), this->supported_profiles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::VideoDecodeAcceleratorSupportedProfile>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flags"), this->flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoDecodeAcceleratorCapabilities::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoEncodeAcceleratorSupportedProfile::VideoEncodeAcceleratorSupportedProfile()
    : profile(),
      min_resolution(),
      max_resolution(),
      max_framerate_numerator(),
      max_framerate_denominator() {}

VideoEncodeAcceleratorSupportedProfile::VideoEncodeAcceleratorSupportedProfile(
    ::gpu::VideoCodecProfile profile_in,
    const ::gfx::Size& min_resolution_in,
    const ::gfx::Size& max_resolution_in,
    uint32_t max_framerate_numerator_in,
    uint32_t max_framerate_denominator_in)
    : profile(std::move(profile_in)),
      min_resolution(std::move(min_resolution_in)),
      max_resolution(std::move(max_resolution_in)),
      max_framerate_numerator(std::move(max_framerate_numerator_in)),
      max_framerate_denominator(std::move(max_framerate_denominator_in)) {}

VideoEncodeAcceleratorSupportedProfile::~VideoEncodeAcceleratorSupportedProfile() = default;

void VideoEncodeAcceleratorSupportedProfile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_resolution"), this->min_resolution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_resolution"), this->max_resolution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_numerator"), this->max_framerate_numerator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_denominator"), this->max_framerate_denominator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoEncodeAcceleratorSupportedProfile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ImageDecodeAcceleratorSupportedProfile::ImageDecodeAcceleratorSupportedProfile()
    : image_type(),
      min_encoded_dimensions(),
      max_encoded_dimensions(),
      subsamplings() {}

ImageDecodeAcceleratorSupportedProfile::ImageDecodeAcceleratorSupportedProfile(
    ImageDecodeAcceleratorType image_type_in,
    const ::gfx::Size& min_encoded_dimensions_in,
    const ::gfx::Size& max_encoded_dimensions_in,
    std::vector<ImageDecodeAcceleratorSubsampling> subsamplings_in)
    : image_type(std::move(image_type_in)),
      min_encoded_dimensions(std::move(min_encoded_dimensions_in)),
      max_encoded_dimensions(std::move(max_encoded_dimensions_in)),
      subsamplings(std::move(subsamplings_in)) {}

ImageDecodeAcceleratorSupportedProfile::~ImageDecodeAcceleratorSupportedProfile() = default;

void ImageDecodeAcceleratorSupportedProfile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_type"), this->image_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ImageDecodeAcceleratorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_encoded_dimensions"), this->min_encoded_dimensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_encoded_dimensions"), this->max_encoded_dimensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subsamplings"), this->subsamplings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<ImageDecodeAcceleratorSubsampling>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ImageDecodeAcceleratorSupportedProfile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuInfo::GpuInfo()
    : initialization_time(),
      optimus(),
      amd_switchable(),
      gpu(),
      secondary_gpus(),
      npus(),
      pixel_shader_version(),
      vertex_shader_version(),
      max_msaa_samples(),
      machine_model_name(),
      machine_model_version(),
      display_type(),
      skia_backend_type(),
      gl_version(),
      gl_vendor(),
      gl_renderer(),
      gl_extensions(),
      gl_ws_vendor(),
      gl_ws_version(),
      gl_ws_extensions(),
      gl_reset_notification_strategy(),
      gl_implementation_parts(),
      direct_rendering_version(),
      sandboxed(),
      in_process_gpu(),
      passthrough_cmd_decoder(),
      can_support_threaded_texture_mailbox(),
      video_decode_accelerator_supported_profiles(),
      video_encode_accelerator_supported_profiles(),
      jpeg_decode_accelerator_supported(),
      subpixel_font_rendering(),
      visibility_callback_call_count() {}

GpuInfo::GpuInfo(
    ::base::TimeDelta initialization_time_in,
    bool optimus_in,
    bool amd_switchable_in,
    const ::gpu::GPUInfo::GPUDevice& gpu_in,
    std::vector<::gpu::GPUInfo::GPUDevice> secondary_gpus_in,
    std::vector<::gpu::GPUInfo::GPUDevice> npus_in,
    const std::string& pixel_shader_version_in,
    const std::string& vertex_shader_version_in,
    const std::string& max_msaa_samples_in,
    const std::string& machine_model_name_in,
    const std::string& machine_model_version_in,
    const std::string& display_type_in,
    SkiaBackendType skia_backend_type_in,
    const std::string& gl_version_in,
    const std::string& gl_vendor_in,
    const std::string& gl_renderer_in,
    const std::string& gl_extensions_in,
    const std::string& gl_ws_vendor_in,
    const std::string& gl_ws_version_in,
    const std::string& gl_ws_extensions_in,
    uint32_t gl_reset_notification_strategy_in,
    ::gl::mojom::GLImplementationPartsPtr gl_implementation_parts_in,
    const std::string& direct_rendering_version_in,
    bool sandboxed_in,
    bool in_process_gpu_in,
    bool passthrough_cmd_decoder_in,
    bool can_support_threaded_texture_mailbox_in,
    std::vector<::gpu::VideoDecodeAcceleratorSupportedProfile> video_decode_accelerator_supported_profiles_in,
    std::vector<::gpu::VideoEncodeAcceleratorSupportedProfile> video_encode_accelerator_supported_profiles_in,
    bool jpeg_decode_accelerator_supported_in,
    bool subpixel_font_rendering_in,
    uint32_t visibility_callback_call_count_in)
    : initialization_time(std::move(initialization_time_in)),
      optimus(std::move(optimus_in)),
      amd_switchable(std::move(amd_switchable_in)),
      gpu(std::move(gpu_in)),
      secondary_gpus(std::move(secondary_gpus_in)),
      npus(std::move(npus_in)),
      pixel_shader_version(std::move(pixel_shader_version_in)),
      vertex_shader_version(std::move(vertex_shader_version_in)),
      max_msaa_samples(std::move(max_msaa_samples_in)),
      machine_model_name(std::move(machine_model_name_in)),
      machine_model_version(std::move(machine_model_version_in)),
      display_type(std::move(display_type_in)),
      skia_backend_type(std::move(skia_backend_type_in)),
      gl_version(std::move(gl_version_in)),
      gl_vendor(std::move(gl_vendor_in)),
      gl_renderer(std::move(gl_renderer_in)),
      gl_extensions(std::move(gl_extensions_in)),
      gl_ws_vendor(std::move(gl_ws_vendor_in)),
      gl_ws_version(std::move(gl_ws_version_in)),
      gl_ws_extensions(std::move(gl_ws_extensions_in)),
      gl_reset_notification_strategy(std::move(gl_reset_notification_strategy_in)),
      gl_implementation_parts(std::move(gl_implementation_parts_in)),
      direct_rendering_version(std::move(direct_rendering_version_in)),
      sandboxed(std::move(sandboxed_in)),
      in_process_gpu(std::move(in_process_gpu_in)),
      passthrough_cmd_decoder(std::move(passthrough_cmd_decoder_in)),
      can_support_threaded_texture_mailbox(std::move(can_support_threaded_texture_mailbox_in)),
      video_decode_accelerator_supported_profiles(std::move(video_decode_accelerator_supported_profiles_in)),
      video_encode_accelerator_supported_profiles(std::move(video_encode_accelerator_supported_profiles_in)),
      jpeg_decode_accelerator_supported(std::move(jpeg_decode_accelerator_supported_in)),
      subpixel_font_rendering(std::move(subpixel_font_rendering_in)),
      visibility_callback_call_count(std::move(visibility_callback_call_count_in)) {}

GpuInfo::~GpuInfo() = default;

void GpuInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initialization_time"), this->initialization_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optimus"), this->optimus,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "amd_switchable"), this->amd_switchable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu"), this->gpu,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::GPUInfo::GPUDevice&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secondary_gpus"), this->secondary_gpus,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::GPUInfo::GPUDevice>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "npus"), this->npus,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::GPUInfo::GPUDevice>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_shader_version"), this->pixel_shader_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vertex_shader_version"), this->vertex_shader_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_msaa_samples"), this->max_msaa_samples,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "machine_model_name"), this->machine_model_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "machine_model_version"), this->machine_model_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_type"), this->display_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skia_backend_type"), this->skia_backend_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SkiaBackendType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_version"), this->gl_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_vendor"), this->gl_vendor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_renderer"), this->gl_renderer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_extensions"), this->gl_extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_ws_vendor"), this->gl_ws_vendor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_ws_version"), this->gl_ws_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_ws_extensions"), this->gl_ws_extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_reset_notification_strategy"), this->gl_reset_notification_strategy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_implementation_parts"), this->gl_implementation_parts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gl::mojom::GLImplementationPartsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direct_rendering_version"), this->direct_rendering_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sandboxed"), this->sandboxed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_process_gpu"), this->in_process_gpu,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "passthrough_cmd_decoder"), this->passthrough_cmd_decoder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_support_threaded_texture_mailbox"), this->can_support_threaded_texture_mailbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_decode_accelerator_supported_profiles"), this->video_decode_accelerator_supported_profiles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::VideoDecodeAcceleratorSupportedProfile>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_encode_accelerator_supported_profiles"), this->video_encode_accelerator_supported_profiles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::VideoEncodeAcceleratorSupportedProfile>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "jpeg_decode_accelerator_supported"), this->jpeg_decode_accelerator_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subpixel_font_rendering"), this->subpixel_font_rendering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visibility_callback_call_count"), this->visibility_callback_call_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // gpu::mojom


namespace mojo {


// static
bool StructTraits<::gpu::mojom::GpuDevice::DataView, ::gpu::mojom::GpuDevicePtr>::Read(
    ::gpu::mojom::GpuDevice::DataView input,
    ::gpu::mojom::GpuDevicePtr* output) {
  bool success = true;
  ::gpu::mojom::GpuDevicePtr result(::gpu::mojom::GpuDevice::New());
  
      if (success)
        result->vendor_id = input.vendor_id();
      if (success)
        result->device_id = input.device_id();
      if (success)
        result->active = input.active();
      if (success && !input.ReadVendorString(&result->vendor_string))
        success = false;
      if (success && !input.ReadDeviceString(&result->device_string))
        success = false;
      if (success && !input.ReadDriverVendor(&result->driver_vendor))
        success = false;
      if (success && !input.ReadDriverVersion(&result->driver_version))
        success = false;
      if (success && !input.ReadGpuPreference(&result->gpu_preference))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::VideoDecodeAcceleratorSupportedProfile::DataView, ::gpu::mojom::VideoDecodeAcceleratorSupportedProfilePtr>::Read(
    ::gpu::mojom::VideoDecodeAcceleratorSupportedProfile::DataView input,
    ::gpu::mojom::VideoDecodeAcceleratorSupportedProfilePtr* output) {
  bool success = true;
  ::gpu::mojom::VideoDecodeAcceleratorSupportedProfilePtr result(::gpu::mojom::VideoDecodeAcceleratorSupportedProfile::New());
  
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadMaxResolution(&result->max_resolution))
        success = false;
      if (success && !input.ReadMinResolution(&result->min_resolution))
        success = false;
      if (success)
        result->encrypted_only = input.encrypted_only();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::VideoDecodeAcceleratorCapabilities::DataView, ::gpu::mojom::VideoDecodeAcceleratorCapabilitiesPtr>::Read(
    ::gpu::mojom::VideoDecodeAcceleratorCapabilities::DataView input,
    ::gpu::mojom::VideoDecodeAcceleratorCapabilitiesPtr* output) {
  bool success = true;
  ::gpu::mojom::VideoDecodeAcceleratorCapabilitiesPtr result(::gpu::mojom::VideoDecodeAcceleratorCapabilities::New());
  
      if (success && !input.ReadSupportedProfiles(&result->supported_profiles))
        success = false;
      if (success)
        result->flags = input.flags();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::VideoEncodeAcceleratorSupportedProfile::DataView, ::gpu::mojom::VideoEncodeAcceleratorSupportedProfilePtr>::Read(
    ::gpu::mojom::VideoEncodeAcceleratorSupportedProfile::DataView input,
    ::gpu::mojom::VideoEncodeAcceleratorSupportedProfilePtr* output) {
  bool success = true;
  ::gpu::mojom::VideoEncodeAcceleratorSupportedProfilePtr result(::gpu::mojom::VideoEncodeAcceleratorSupportedProfile::New());
  
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadMinResolution(&result->min_resolution))
        success = false;
      if (success && !input.ReadMaxResolution(&result->max_resolution))
        success = false;
      if (success)
        result->max_framerate_numerator = input.max_framerate_numerator();
      if (success)
        result->max_framerate_denominator = input.max_framerate_denominator();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::ImageDecodeAcceleratorSupportedProfile::DataView, ::gpu::mojom::ImageDecodeAcceleratorSupportedProfilePtr>::Read(
    ::gpu::mojom::ImageDecodeAcceleratorSupportedProfile::DataView input,
    ::gpu::mojom::ImageDecodeAcceleratorSupportedProfilePtr* output) {
  bool success = true;
  ::gpu::mojom::ImageDecodeAcceleratorSupportedProfilePtr result(::gpu::mojom::ImageDecodeAcceleratorSupportedProfile::New());
  
      if (success && !input.ReadImageType(&result->image_type))
        success = false;
      if (success && !input.ReadMinEncodedDimensions(&result->min_encoded_dimensions))
        success = false;
      if (success && !input.ReadMaxEncodedDimensions(&result->max_encoded_dimensions))
        success = false;
      if (success && !input.ReadSubsamplings(&result->subsamplings))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::GpuInfo::DataView, ::gpu::mojom::GpuInfoPtr>::Read(
    ::gpu::mojom::GpuInfo::DataView input,
    ::gpu::mojom::GpuInfoPtr* output) {
  bool success = true;
  ::gpu::mojom::GpuInfoPtr result(::gpu::mojom::GpuInfo::New());
  
      if (success && !input.ReadInitializationTime(&result->initialization_time))
        success = false;
      if (success)
        result->optimus = input.optimus();
      if (success)
        result->amd_switchable = input.amd_switchable();
      if (success && !input.ReadGpu(&result->gpu))
        success = false;
      if (success && !input.ReadSecondaryGpus(&result->secondary_gpus))
        success = false;
      if (success && !input.ReadNpus(&result->npus))
        success = false;
      if (success && !input.ReadPixelShaderVersion(&result->pixel_shader_version))
        success = false;
      if (success && !input.ReadVertexShaderVersion(&result->vertex_shader_version))
        success = false;
      if (success && !input.ReadMaxMsaaSamples(&result->max_msaa_samples))
        success = false;
      if (success && !input.ReadMachineModelName(&result->machine_model_name))
        success = false;
      if (success && !input.ReadMachineModelVersion(&result->machine_model_version))
        success = false;
      if (success && !input.ReadDisplayType(&result->display_type))
        success = false;
      if (success && !input.ReadSkiaBackendType(&result->skia_backend_type))
        success = false;
      if (success && !input.ReadGlVersion(&result->gl_version))
        success = false;
      if (success && !input.ReadGlVendor(&result->gl_vendor))
        success = false;
      if (success && !input.ReadGlRenderer(&result->gl_renderer))
        success = false;
      if (success && !input.ReadGlExtensions(&result->gl_extensions))
        success = false;
      if (success && !input.ReadGlWsVendor(&result->gl_ws_vendor))
        success = false;
      if (success && !input.ReadGlWsVersion(&result->gl_ws_version))
        success = false;
      if (success && !input.ReadGlWsExtensions(&result->gl_ws_extensions))
        success = false;
      if (success)
        result->gl_reset_notification_strategy = input.gl_reset_notification_strategy();
      if (success && !input.ReadGlImplementationParts(&result->gl_implementation_parts))
        success = false;
      if (success && !input.ReadDirectRenderingVersion(&result->direct_rendering_version))
        success = false;
      if (success)
        result->sandboxed = input.sandboxed();
      if (success)
        result->in_process_gpu = input.in_process_gpu();
      if (success)
        result->passthrough_cmd_decoder = input.passthrough_cmd_decoder();
      if (success)
        result->can_support_threaded_texture_mailbox = input.can_support_threaded_texture_mailbox();
      if (success && !input.ReadVideoDecodeAcceleratorSupportedProfiles(&result->video_decode_accelerator_supported_profiles))
        success = false;
      if (success && !input.ReadVideoEncodeAcceleratorSupportedProfiles(&result->video_encode_accelerator_supported_profiles))
        success = false;
      if (success)
        result->jpeg_decode_accelerator_supported = input.jpeg_decode_accelerator_supported();
      if (success)
        result->subpixel_font_rendering = input.subpixel_font_rendering();
      if (success)
        result->visibility_callback_call_count = input.visibility_callback_call_count();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gpu::mojom {




}  // gpu::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif