// gpu/ipc/common/gpu_channel.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_SEND_VALIDATION_H_
#define GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_SEND_VALIDATION_H_

#include "gpu/ipc/common/gpu_channel.mojom-shared-internal.h"
#include "gpu/ipc/common/capabilities.mojom-shared.h"
#include "gpu/ipc/common/context_result.mojom-shared.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"
#include "gpu/ipc/common/shared_image_pool_id.mojom-shared.h"
#include "gpu/ipc/common/shared_image_pool_client_interface.mojom-shared.h"
#include "gpu/ipc/common/surface_handle.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "skia/public/mojom/surface_origin.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared.h"
#include "ui/gfx/mojom/presentation_feedback.mojom-shared.h"
#include "ui/gl/mojom/gpu_preference.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "gpu/ipc/common/gpu_channel.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gpu::mojom::ContextType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gpu::mojom::ContextColorSpace, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gpu::mojom::SchedulingPriority, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::RasterCreationAttribsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::RasterCreationAttribsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::RasterCreationAttribs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->enable_gpu_rasterization = Traits::enable_gpu_rasterization(input);

      fragment->lose_context_when_out_of_memory = Traits::lose_context_when_out_of_memory(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::GLESCreationAttribsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GLESCreationAttribsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::GLESCreationAttribs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::gl::mojom::GpuPreference>(
        Traits::gpu_preference(input),
        &fragment->gpu_preference);

      fragment->fail_if_major_perf_caveat = Traits::fail_if_major_perf_caveat(input);

      fragment->lose_context_when_out_of_memory = Traits::lose_context_when_out_of_memory(input);

      
      mojo::internal::Serialize<::gpu::mojom::ContextType>(
        Traits::context_type(input),
        &fragment->context_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::WebGPUCreationAttribsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::WebGPUCreationAttribsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::WebGPUCreationAttribs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::CreateCommandBufferParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CreateCommandBufferParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CreateCommandBufferParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->stream_id = Traits::stream_id(input);

      
      mojo::internal::Serialize<::gpu::mojom::SchedulingPriority>(
        Traits::stream_priority(input),
        &fragment->stream_priority);

      decltype(Traits::attribs(input)) in_attribs = Traits::attribs(input);
      mojo::internal::MessageFragment<decltype(fragment->attribs)>
          attribs_fragment(fragment.message());
      attribs_fragment.Claim(&fragment->attribs);
      
      mojo::internal::Serialize<::gpu::mojom::ContextCreationAttribsDataView, send_validation>(
        in_attribs,
        attribs_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attribs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attribs in CreateCommandBufferParams struct");

      decltype(Traits::active_url(input)) in_active_url = Traits::active_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->active_url)::BaseType> active_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_active_url,
        active_url_fragment);

      fragment->active_url.Set(
          active_url_fragment.is_null() ? nullptr : active_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->active_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null active_url in CreateCommandBufferParams struct");

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in CreateCommandBufferParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::CommandBufferStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CommandBufferStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CommandBufferState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->get_offset = Traits::get_offset(input);

      fragment->token = Traits::token(input);

      fragment->release_count = Traits::release_count(input);

      
      mojo::internal::Serialize<::gpu::mojom::Error>(
        Traits::error(input),
        &fragment->error);

      
      mojo::internal::Serialize<::gpu::mojom::ContextLostReason>(
        Traits::context_lost_reason(input),
        &fragment->context_lost_reason);

      fragment->generation = Traits::generation(input);

      fragment->set_get_buffer_count = Traits::set_get_buffer_count(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::SwapBuffersCompleteParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::SwapBuffersCompleteParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::SwapBuffersCompleteParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::DeferredRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::DeferredRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::DeferredRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::params(input)) in_params = Traits::params(input);
      mojo::internal::MessageFragment<decltype(fragment->params)>
          params_fragment(fragment.message());
      params_fragment.Claim(&fragment->params);
      
      mojo::internal::Serialize<::gpu::mojom::DeferredRequestParamsDataView, send_validation>(
        in_params,
        params_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in DeferredRequest struct");

      decltype(Traits::sync_token_fences(input)) in_sync_token_fences = Traits::sync_token_fences(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sync_token_fences)::BaseType>
          sync_token_fences_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& sync_token_fences_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>, send_validation>(
        in_sync_token_fences,
        sync_token_fences_fragment,
        &sync_token_fences_validate_params);

      fragment->sync_token_fences.Set(
          sync_token_fences_fragment.is_null() ? nullptr : sync_token_fences_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sync_token_fences.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token_fences in DeferredRequest struct");

      fragment->release_count = Traits::release_count(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::DeferredCommandBufferRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::DeferredCommandBufferRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::DeferredCommandBufferRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->routing_id = Traits::routing_id(input);

      decltype(Traits::params(input)) in_params = Traits::params(input);
      mojo::internal::MessageFragment<decltype(fragment->params)>
          params_fragment(fragment.message());
      params_fragment.Claim(&fragment->params);
      
      mojo::internal::Serialize<::gpu::mojom::DeferredCommandBufferRequestParamsDataView, send_validation>(
        in_params,
        params_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in DeferredCommandBufferRequest struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::AsyncFlushParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::AsyncFlushParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::AsyncFlushParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->put_offset = Traits::put_offset(input);

      fragment->flush_id = Traits::flush_id(input);

      decltype(Traits::sync_token_fences(input)) in_sync_token_fences = Traits::sync_token_fences(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sync_token_fences)::BaseType>
          sync_token_fences_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& sync_token_fences_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::SyncTokenDataView>, send_validation>(
        in_sync_token_fences,
        sync_token_fences_fragment,
        &sync_token_fences_validate_params);

      fragment->sync_token_fences.Set(
          sync_token_fences_fragment.is_null() ? nullptr : sync_token_fences_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sync_token_fences.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token_fences in AsyncFlushParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::SharedImageInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::SharedImageInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::SharedImageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::meta(input)) in_meta = Traits::meta(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->meta)::BaseType> meta_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SharedImageMetadataDataView, send_validation>(
        in_meta,
        meta_fragment);

      fragment->meta.Set(
          meta_fragment.is_null() ? nullptr : meta_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->meta.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null meta in SharedImageInfo struct");

      decltype(Traits::debug_label(input)) in_debug_label = Traits::debug_label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->debug_label)::BaseType> debug_label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_debug_label,
        debug_label_fragment);

      fragment->debug_label.Set(
          debug_label_fragment.is_null() ? nullptr : debug_label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->debug_label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null debug_label in SharedImageInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::CreateSharedImageParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CreateSharedImageParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CreateSharedImageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::MailboxDataView, send_validation>(
        in_mailbox,
        mailbox_fragment);

      fragment->mailbox.Set(
          mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mailbox.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in CreateSharedImageParams struct");

      decltype(Traits::si_info(input)) in_si_info = Traits::si_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->si_info)::BaseType> si_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SharedImageInfoDataView, send_validation>(
        in_si_info,
        si_info_fragment);

      fragment->si_info.Set(
          si_info_fragment.is_null() ? nullptr : si_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->si_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null si_info in CreateSharedImageParams struct");

      decltype(Traits::pool_id(input)) in_pool_id = Traits::pool_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pool_id)::BaseType> pool_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SharedImagePoolIdDataView, send_validation>(
        in_pool_id,
        pool_id_fragment);

      fragment->pool_id.Set(
          pool_id_fragment.is_null() ? nullptr : pool_id_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::CreateSharedImageWithDataParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CreateSharedImageWithDataParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CreateSharedImageWithDataParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::MailboxDataView, send_validation>(
        in_mailbox,
        mailbox_fragment);

      fragment->mailbox.Set(
          mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mailbox.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in CreateSharedImageWithDataParams struct");

      decltype(Traits::si_info(input)) in_si_info = Traits::si_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->si_info)::BaseType> si_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SharedImageInfoDataView, send_validation>(
        in_si_info,
        si_info_fragment);

      fragment->si_info.Set(
          si_info_fragment.is_null() ? nullptr : si_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->si_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null si_info in CreateSharedImageWithDataParams struct");

      fragment->pixel_data_offset = Traits::pixel_data_offset(input);

      fragment->pixel_data_size = Traits::pixel_data_size(input);

      fragment->done_with_shm = Traits::done_with_shm(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::CreateSharedImageWithBufferParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CreateSharedImageWithBufferParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CreateSharedImageWithBufferParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::MailboxDataView, send_validation>(
        in_mailbox,
        mailbox_fragment);

      fragment->mailbox.Set(
          mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mailbox.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in CreateSharedImageWithBufferParams struct");

      decltype(Traits::si_info(input)) in_si_info = Traits::si_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->si_info)::BaseType> si_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SharedImageInfoDataView, send_validation>(
        in_si_info,
        si_info_fragment);

      fragment->si_info.Set(
          si_info_fragment.is_null() ? nullptr : si_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->si_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null si_info in CreateSharedImageWithBufferParams struct");

      decltype(Traits::buffer_handle(input)) in_buffer_handle = Traits::buffer_handle(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->buffer_handle)::BaseType> buffer_handle_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView, send_validation>(
        in_buffer_handle,
        buffer_handle_fragment);

      fragment->buffer_handle.Set(
          buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->buffer_handle.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buffer_handle in CreateSharedImageWithBufferParams struct");

      decltype(Traits::pool_id(input)) in_pool_id = Traits::pool_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pool_id)::BaseType> pool_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SharedImagePoolIdDataView, send_validation>(
        in_pool_id,
        pool_id_fragment);

      fragment->pool_id.Set(
          pool_id_fragment.is_null() ? nullptr : pool_id_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::UpdateSharedImageParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::UpdateSharedImageParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::UpdateSharedImageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::MailboxDataView, send_validation>(
        in_mailbox,
        mailbox_fragment);

      fragment->mailbox.Set(
          mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mailbox.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in UpdateSharedImageParams struct");

      decltype(Traits::in_fence_handle(input)) in_in_fence_handle = Traits::in_fence_handle(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->in_fence_handle)::BaseType> in_fence_handle_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView, send_validation>(
        in_in_fence_handle,
        in_fence_handle_fragment);

      fragment->in_fence_handle.Set(
          in_fence_handle_fragment.is_null() ? nullptr : in_fence_handle_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::AddReferenceToSharedImageParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::AddReferenceToSharedImageParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::AddReferenceToSharedImageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::MailboxDataView, send_validation>(
        in_mailbox,
        mailbox_fragment);

      fragment->mailbox.Set(
          mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mailbox.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in AddReferenceToSharedImageParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::CopyToGpuMemoryBufferParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CopyToGpuMemoryBufferParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CopyToGpuMemoryBufferParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::MailboxDataView, send_validation>(
        in_mailbox,
        mailbox_fragment);

      fragment->mailbox.Set(
          mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mailbox.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in CopyToGpuMemoryBufferParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::CreateSharedImagePoolParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::CreateSharedImagePoolParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::CreateSharedImagePoolParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::pool_id(input)) in_pool_id = Traits::pool_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pool_id)::BaseType> pool_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SharedImagePoolIdDataView, send_validation>(
        in_pool_id,
        pool_id_fragment);

      fragment->pool_id.Set(
          pool_id_fragment.is_null() ? nullptr : pool_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pool_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pool_id in CreateSharedImagePoolParams struct");

      decltype(Traits::client_remote(input)) in_client_remote = Traits::client_remote(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::gpu::mojom::SharedImagePoolClientInterfaceInterfaceBase>>(
        in_client_remote,
        &fragment->client_remote,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->client_remote)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid client_remote in CreateSharedImagePoolParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::DestroySharedImagePoolParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::DestroySharedImagePoolParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::DestroySharedImagePoolParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::pool_id(input)) in_pool_id = Traits::pool_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pool_id)::BaseType> pool_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SharedImagePoolIdDataView, send_validation>(
        in_pool_id,
        pool_id_fragment);

      fragment->pool_id.Set(
          pool_id_fragment.is_null() ? nullptr : pool_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pool_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pool_id in DestroySharedImagePoolParams struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::ContextCreationAttribsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gpu::mojom::ContextCreationAttribsDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gpu::mojom::internal::ContextCreationAttribs_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::gpu::mojom::ContextCreationAttribsDataView::Tag::kGles: {
    decltype(Traits::gles(input))
    in_gles = Traits::gles(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gles)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::GLESCreationAttribsDataView, send_validation>(
  in_gles,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gles in ContextCreationAttribs union");
    fragment->data.f_gles.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::ContextCreationAttribsDataView::Tag::kRaster: {
    decltype(Traits::raster(input))
    in_raster = Traits::raster(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_raster)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::RasterCreationAttribsDataView, send_validation>(
  in_raster,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null raster in ContextCreationAttribs union");
    fragment->data.f_raster.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::ContextCreationAttribsDataView::Tag::kWebgpu: {
    decltype(Traits::webgpu(input))
    in_webgpu = Traits::webgpu(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_webgpu)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::WebGPUCreationAttribsDataView, send_validation>(
  in_webgpu,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null webgpu in ContextCreationAttribs union");
    fragment->data.f_webgpu.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::DeferredRequestParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gpu::mojom::DeferredRequestParamsDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gpu::mojom::internal::DeferredRequestParams_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::gpu::mojom::DeferredRequestParamsDataView::Tag::kCommandBufferRequest: {
    decltype(Traits::command_buffer_request(input))
    in_command_buffer_request = Traits::command_buffer_request(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_command_buffer_request)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::DeferredCommandBufferRequestDataView, send_validation>(
  in_command_buffer_request,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null command_buffer_request in DeferredRequestParams union");
    fragment->data.f_command_buffer_request.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredRequestParamsDataView::Tag::kSharedImageRequest: {
    decltype(Traits::shared_image_request(input))
    in_shared_image_request = Traits::shared_image_request(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_image_request)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::gpu::mojom::DeferredSharedImageRequestDataView, send_validation>(
  in_shared_image_request,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_image_request in DeferredRequestParams union");
    fragment->data.f_shared_image_request.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::DeferredCommandBufferRequestParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gpu::mojom::DeferredCommandBufferRequestParamsDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gpu::mojom::internal::DeferredCommandBufferRequestParams_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::gpu::mojom::DeferredCommandBufferRequestParamsDataView::Tag::kAsyncFlush: {
    decltype(Traits::async_flush(input))
    in_async_flush = Traits::async_flush(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_async_flush)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::AsyncFlushParamsDataView, send_validation>(
  in_async_flush,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null async_flush in DeferredCommandBufferRequestParams union");
    fragment->data.f_async_flush.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredCommandBufferRequestParamsDataView::Tag::kDestroyTransferBuffer: {
    decltype(Traits::destroy_transfer_buffer(input))
    in_destroy_transfer_buffer = Traits::destroy_transfer_buffer(input);
    fragment->data.f_destroy_transfer_buffer = in_destroy_transfer_buffer;
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::DeferredSharedImageRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gpu::mojom::DeferredSharedImageRequestDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gpu::mojom::internal::DeferredSharedImageRequest_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kNop: {
    decltype(Traits::nop(input))
    in_nop = Traits::nop(input);
    fragment->data.f_nop = in_nop;
    break;
  }
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kCreateSharedImage: {
    decltype(Traits::create_shared_image(input))
    in_create_shared_image = Traits::create_shared_image(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_create_shared_image)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::CreateSharedImageParamsDataView, send_validation>(
  in_create_shared_image,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null create_shared_image in DeferredSharedImageRequest union");
    fragment->data.f_create_shared_image.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kCreateSharedImageWithData: {
    decltype(Traits::create_shared_image_with_data(input))
    in_create_shared_image_with_data = Traits::create_shared_image_with_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_create_shared_image_with_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::CreateSharedImageWithDataParamsDataView, send_validation>(
  in_create_shared_image_with_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null create_shared_image_with_data in DeferredSharedImageRequest union");
    fragment->data.f_create_shared_image_with_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kCreateSharedImageWithBuffer: {
    decltype(Traits::create_shared_image_with_buffer(input))
    in_create_shared_image_with_buffer = Traits::create_shared_image_with_buffer(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_create_shared_image_with_buffer)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::CreateSharedImageWithBufferParamsDataView, send_validation>(
  in_create_shared_image_with_buffer,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null create_shared_image_with_buffer in DeferredSharedImageRequest union");
    fragment->data.f_create_shared_image_with_buffer.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kRegisterUploadBuffer: {
    decltype(Traits::register_upload_buffer(input))
    in_register_upload_buffer = Traits::register_upload_buffer(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_register_upload_buffer)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, send_validation>(
  in_register_upload_buffer,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null register_upload_buffer in DeferredSharedImageRequest union");
    fragment->data.f_register_upload_buffer.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kUpdateSharedImage: {
    decltype(Traits::update_shared_image(input))
    in_update_shared_image = Traits::update_shared_image(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_update_shared_image)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::UpdateSharedImageParamsDataView, send_validation>(
  in_update_shared_image,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null update_shared_image in DeferredSharedImageRequest union");
    fragment->data.f_update_shared_image.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kCopyToGpuMemoryBuffer: {
    decltype(Traits::copy_to_gpu_memory_buffer(input))
    in_copy_to_gpu_memory_buffer = Traits::copy_to_gpu_memory_buffer(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_copy_to_gpu_memory_buffer)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::CopyToGpuMemoryBufferParamsDataView, send_validation>(
  in_copy_to_gpu_memory_buffer,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null copy_to_gpu_memory_buffer in DeferredSharedImageRequest union");
    fragment->data.f_copy_to_gpu_memory_buffer.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kDestroySharedImage: {
    decltype(Traits::destroy_shared_image(input))
    in_destroy_shared_image = Traits::destroy_shared_image(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_destroy_shared_image)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::MailboxDataView, send_validation>(
  in_destroy_shared_image,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null destroy_shared_image in DeferredSharedImageRequest union");
    fragment->data.f_destroy_shared_image.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kAddReferenceToSharedImage: {
    decltype(Traits::add_reference_to_shared_image(input))
    in_add_reference_to_shared_image = Traits::add_reference_to_shared_image(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_add_reference_to_shared_image)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::AddReferenceToSharedImageParamsDataView, send_validation>(
  in_add_reference_to_shared_image,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null add_reference_to_shared_image in DeferredSharedImageRequest union");
    fragment->data.f_add_reference_to_shared_image.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kCreateSharedImagePool: {
    decltype(Traits::create_shared_image_pool(input))
    in_create_shared_image_pool = Traits::create_shared_image_pool(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_create_shared_image_pool)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::CreateSharedImagePoolParamsDataView, send_validation>(
  in_create_shared_image_pool,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null create_shared_image_pool in DeferredSharedImageRequest union");
    fragment->data.f_create_shared_image_pool.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::DeferredSharedImageRequestDataView::Tag::kDestroySharedImagePool: {
    decltype(Traits::destroy_shared_image_pool(input))
    in_destroy_shared_image_pool = Traits::destroy_shared_image_pool(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_destroy_shared_image_pool)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::DestroySharedImagePoolParamsDataView, send_validation>(
  in_destroy_shared_image_pool,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null destroy_shared_image_pool in DeferredSharedImageRequest union");
    fragment->data.f_destroy_shared_image_pool.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_SEND_VALIDATION_H_