// gpu/ipc/common/exported_shared_image.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_SEND_VALIDATION_H_
#define GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_SEND_VALIDATION_H_

#include "gpu/ipc/common/exported_shared_image.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"

#include "gpu/ipc/common/exported_shared_image.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::ExportedSharedImageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::ExportedSharedImageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::ExportedSharedImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::MailboxDataView, send_validation>(
        in_mailbox,
        mailbox_fragment);

      fragment->mailbox.Set(
          mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mailbox.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in ExportedSharedImage struct");

      decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->metadata)::BaseType> metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SharedImageMetadataDataView, send_validation>(
        in_metadata,
        metadata_fragment);

      fragment->metadata.Set(
          metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->metadata.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metadata in ExportedSharedImage struct");

      decltype(Traits::creation_sync_token(input)) in_creation_sync_token = Traits::creation_sync_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->creation_sync_token)::BaseType> creation_sync_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView, send_validation>(
        in_creation_sync_token,
        creation_sync_token_fragment);

      fragment->creation_sync_token.Set(
          creation_sync_token_fragment.is_null() ? nullptr : creation_sync_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->creation_sync_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null creation_sync_token in ExportedSharedImage struct");

      decltype(Traits::debug_label(input)) in_debug_label = Traits::debug_label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->debug_label)::BaseType> debug_label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_debug_label,
        debug_label_fragment);

      fragment->debug_label.Set(
          debug_label_fragment.is_null() ? nullptr : debug_label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->debug_label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null debug_label in ExportedSharedImage struct");

      decltype(Traits::buffer_handle(input)) in_buffer_handle = Traits::buffer_handle(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->buffer_handle)::BaseType> buffer_handle_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView, send_validation>(
        in_buffer_handle,
        buffer_handle_fragment);

      fragment->buffer_handle.Set(
          buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());
      fragment->buffer_usage_$flag = Traits::buffer_usage(input).has_value();
      if (Traits::buffer_usage(input).has_value()) {
        
        mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
          Traits::buffer_usage(input).value(),
          &fragment->buffer_usage_$value);
      } else {
        fragment->buffer_usage_$value =
            static_cast<int32_t>(::gfx::mojom::BufferUsage::kMinValue);
      }

      fragment->texture_target = Traits::texture_target(input);
  }
};

}  // namespace mojo::internal

#endif  // GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_SEND_VALIDATION_H_