// extensions/common/mojom/renderer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'extensions/common/mojom/renderer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('extensions.mojom');
  var api_permission_id$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/api_permission_id.mojom', 'api_permission_id.mojom.js');
  }
  var channel$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/channel.mojom', 'channel.mojom.js');
  }
  var extension_id$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/extension_id.mojom', 'extension_id.mojom.js');
  }
  var feature_session_type$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/feature_session_type.mojom', 'feature_session_type.mojom.js');
  }
  var host_id$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/host_id.mojom', 'host_id.mojom.js');
  }
  var manifest$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/manifest.mojom', 'manifest.mojom.js');
  }
  var permission_set$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/permission_set.mojom', 'permission_set.mojom.js');
  }
  var url_pattern_set$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/url_pattern_set.mojom', 'url_pattern_set.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../mojo/public/mojom/base/values.mojom.js');
  }



  function ExtensionLoadedParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ExtensionLoadedParams.prototype.initDefaults_ = function() {
    this.manifest = null;
    this.location = 0;
    this.usesDefaultPolicyBlockedAllowedHosts = false;
    this.userScriptsAllowed = false;
    this.path = null;
    this.activePermissions = null;
    this.withheldPermissions = null;
    this.tabSpecificPermissions = null;
    this.policyBlockedHosts = null;
    this.policyAllowedHosts = null;
    this.id = null;
    this.workerActivationToken = null;
    this.creationFlags = 0;
    this.guid = null;
  };
  ExtensionLoadedParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ExtensionLoadedParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 104}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExtensionLoadedParams.manifest
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExtensionLoadedParams.location
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, manifest$.ManifestLocation);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExtensionLoadedParams.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExtensionLoadedParams.activePermissions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, permission_set$.PermissionSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExtensionLoadedParams.withheldPermissions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, permission_set$.PermissionSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExtensionLoadedParams.tabSpecificPermissions
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 40, false, codec.Int32, new codec.PointerTo(permission_set$.PermissionSet), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExtensionLoadedParams.policyBlockedHosts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, url_pattern_set$.URLPatternSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExtensionLoadedParams.policyAllowedHosts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, url_pattern_set$.URLPatternSet, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ExtensionLoadedParams.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 64, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExtensionLoadedParams.workerActivationToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ExtensionLoadedParams.guid
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 88, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ExtensionLoadedParams.encodedSize = codec.kStructHeaderSize + 96;

  ExtensionLoadedParams.decode = function(decoder) {
    var packed;
    var val = new ExtensionLoadedParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.manifest =
        decoder.decodeStructPointer(values$.DictionaryValue);
    val.location =
        decoder.decodeStruct(new codec.Enum(manifest$.ManifestLocation));
    packed = decoder.readUint8();
    val.usesDefaultPolicyBlockedAllowedHosts = (packed >> 0) & 1 ? true : false;
    val.userScriptsAllowed = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.activePermissions =
        decoder.decodeStructPointer(permission_set$.PermissionSet);
    val.withheldPermissions =
        decoder.decodeStructPointer(permission_set$.PermissionSet);
    val.tabSpecificPermissions =
        decoder.decodeMapPointer(codec.Int32, new codec.PointerTo(permission_set$.PermissionSet));
    val.policyBlockedHosts =
        decoder.decodeStructPointer(url_pattern_set$.URLPatternSet);
    val.policyAllowedHosts =
        decoder.decodeStructPointer(url_pattern_set$.URLPatternSet);
    val.id =
        decoder.decodeStruct(codec.String);
    val.workerActivationToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.creationFlags =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.guid =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ExtensionLoadedParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ExtensionLoadedParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(values$.DictionaryValue, val.manifest);
    encoder.encodeStruct(codec.Int32, val.location);
    packed = 0;
    packed |= (val.usesDefaultPolicyBlockedAllowedHosts & 1) << 0
    packed |= (val.userScriptsAllowed & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    encoder.encodeStructPointer(permission_set$.PermissionSet, val.activePermissions);
    encoder.encodeStructPointer(permission_set$.PermissionSet, val.withheldPermissions);
    encoder.encodeMapPointer(codec.Int32, new codec.PointerTo(permission_set$.PermissionSet), val.tabSpecificPermissions);
    encoder.encodeStructPointer(url_pattern_set$.URLPatternSet, val.policyBlockedHosts);
    encoder.encodeStructPointer(url_pattern_set$.URLPatternSet, val.policyAllowedHosts);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.workerActivationToken);
    encoder.encodeStruct(codec.Int32, val.creationFlags);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.guid);
  };
  function UserScriptWorldInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UserScriptWorldInfo.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.worldId = null;
    this.csp = null;
    this.enableMessaging = false;
  };
  UserScriptWorldInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UserScriptWorldInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UserScriptWorldInfo.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UserScriptWorldInfo.worldId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate UserScriptWorldInfo.csp
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  UserScriptWorldInfo.encodedSize = codec.kStructHeaderSize + 32;

  UserScriptWorldInfo.decode = function(decoder) {
    var packed;
    var val = new UserScriptWorldInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.worldId =
        decoder.decodeStruct(codec.String);
    val.csp =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.enableMessaging = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UserScriptWorldInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UserScriptWorldInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStruct(codec.String, val.worldId);
    encoder.encodeStruct(codec.String, val.csp);
    packed = 0;
    packed |= (val.enableMessaging & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Renderer_ActivateExtension_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_ActivateExtension_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
  };
  Renderer_ActivateExtension_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_ActivateExtension_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_ActivateExtension_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_ActivateExtension_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_ActivateExtension_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_ActivateExtension_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    return val;
  };

  Renderer_ActivateExtension_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_ActivateExtension_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
  };
  function Renderer_SetActivityLoggingEnabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_SetActivityLoggingEnabled_Params.prototype.initDefaults_ = function() {
    this.enabled = false;
  };
  Renderer_SetActivityLoggingEnabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_SetActivityLoggingEnabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Renderer_SetActivityLoggingEnabled_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_SetActivityLoggingEnabled_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_SetActivityLoggingEnabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Renderer_SetActivityLoggingEnabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_SetActivityLoggingEnabled_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Renderer_LoadExtensions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_LoadExtensions_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  Renderer_LoadExtensions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_LoadExtensions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_LoadExtensions_Params.params
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ExtensionLoadedParams), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_LoadExtensions_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_LoadExtensions_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_LoadExtensions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeArrayPointer(new codec.PointerTo(ExtensionLoadedParams));
    return val;
  };

  Renderer_LoadExtensions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_LoadExtensions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ExtensionLoadedParams), val.params);
  };
  function Renderer_UnloadExtension_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_UnloadExtension_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
  };
  Renderer_UnloadExtension_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_UnloadExtension_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UnloadExtension_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_UnloadExtension_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_UnloadExtension_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_UnloadExtension_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    return val;
  };

  Renderer_UnloadExtension_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_UnloadExtension_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
  };
  function Renderer_SuspendExtension_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_SuspendExtension_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
  };
  Renderer_SuspendExtension_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_SuspendExtension_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_SuspendExtension_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_SuspendExtension_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_SuspendExtension_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_SuspendExtension_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    return val;
  };

  Renderer_SuspendExtension_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_SuspendExtension_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
  };
  function Renderer_SuspendExtension_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_SuspendExtension_ResponseParams.prototype.initDefaults_ = function() {
  };
  Renderer_SuspendExtension_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_SuspendExtension_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_SuspendExtension_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Renderer_SuspendExtension_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Renderer_SuspendExtension_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Renderer_SuspendExtension_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_SuspendExtension_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Renderer_CancelSuspendExtension_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_CancelSuspendExtension_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
  };
  Renderer_CancelSuspendExtension_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_CancelSuspendExtension_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_CancelSuspendExtension_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_CancelSuspendExtension_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_CancelSuspendExtension_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_CancelSuspendExtension_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    return val;
  };

  Renderer_CancelSuspendExtension_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_CancelSuspendExtension_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
  };
  function Renderer_SetDeveloperMode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_SetDeveloperMode_Params.prototype.initDefaults_ = function() {
    this.developerModeOnly = false;
  };
  Renderer_SetDeveloperMode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_SetDeveloperMode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Renderer_SetDeveloperMode_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_SetDeveloperMode_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_SetDeveloperMode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.developerModeOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Renderer_SetDeveloperMode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_SetDeveloperMode_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.developerModeOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Renderer_SetUserScriptsAllowed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_SetUserScriptsAllowed_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.allowed = false;
  };
  Renderer_SetUserScriptsAllowed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_SetUserScriptsAllowed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_SetUserScriptsAllowed_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Renderer_SetUserScriptsAllowed_Params.encodedSize = codec.kStructHeaderSize + 16;

  Renderer_SetUserScriptsAllowed_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_SetUserScriptsAllowed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    packed = decoder.readUint8();
    val.allowed = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Renderer_SetUserScriptsAllowed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_SetUserScriptsAllowed_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    packed = 0;
    packed |= (val.allowed & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Renderer_SetSessionInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_SetSessionInfo_Params.prototype.initDefaults_ = function() {
    this.channel = 0;
    this.session = 0;
  };
  Renderer_SetSessionInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_SetSessionInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_SetSessionInfo_Params.channel
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, channel$.Channel);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_SetSessionInfo_Params.session
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, feature_session_type$.FeatureSessionType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_SetSessionInfo_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_SetSessionInfo_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_SetSessionInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.channel =
        decoder.decodeStruct(new codec.Enum(channel$.Channel));
    val.session =
        decoder.decodeStruct(new codec.Enum(feature_session_type$.FeatureSessionType));
    return val;
  };

  Renderer_SetSessionInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_SetSessionInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.channel);
    encoder.encodeStruct(codec.Int32, val.session);
  };
  function Renderer_SetSystemFont_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_SetSystemFont_Params.prototype.initDefaults_ = function() {
    this.fontFamily = null;
    this.fontSize = null;
  };
  Renderer_SetSystemFont_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_SetSystemFont_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_SetSystemFont_Params.fontFamily
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_SetSystemFont_Params.fontSize
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_SetSystemFont_Params.encodedSize = codec.kStructHeaderSize + 16;

  Renderer_SetSystemFont_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_SetSystemFont_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fontFamily =
        decoder.decodeStruct(codec.String);
    val.fontSize =
        decoder.decodeStruct(codec.String);
    return val;
  };

  Renderer_SetSystemFont_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_SetSystemFont_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.fontFamily);
    encoder.encodeStruct(codec.String, val.fontSize);
  };
  function Renderer_SetWebViewPartitionID_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_SetWebViewPartitionID_Params.prototype.initDefaults_ = function() {
    this.partitionId = null;
  };
  Renderer_SetWebViewPartitionID_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_SetWebViewPartitionID_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_SetWebViewPartitionID_Params.partitionId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_SetWebViewPartitionID_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_SetWebViewPartitionID_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_SetWebViewPartitionID_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.partitionId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  Renderer_SetWebViewPartitionID_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_SetWebViewPartitionID_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.partitionId);
  };
  function Renderer_SetScriptingAllowlist_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_SetScriptingAllowlist_Params.prototype.initDefaults_ = function() {
    this.extensionIds = null;
  };
  Renderer_SetScriptingAllowlist_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_SetScriptingAllowlist_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_SetScriptingAllowlist_Params.extensionIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(extension_id$.ExtensionId), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_SetScriptingAllowlist_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_SetScriptingAllowlist_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_SetScriptingAllowlist_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionIds =
        decoder.decodeArrayPointer(new codec.PointerTo(extension_id$.ExtensionId));
    return val;
  };

  Renderer_SetScriptingAllowlist_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_SetScriptingAllowlist_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(extension_id$.ExtensionId), val.extensionIds);
  };
  function Renderer_UpdateUserScriptWorlds_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_UpdateUserScriptWorlds_Params.prototype.initDefaults_ = function() {
    this.infos = null;
  };
  Renderer_UpdateUserScriptWorlds_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_UpdateUserScriptWorlds_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdateUserScriptWorlds_Params.infos
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(UserScriptWorldInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_UpdateUserScriptWorlds_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_UpdateUserScriptWorlds_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_UpdateUserScriptWorlds_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.infos =
        decoder.decodeArrayPointer(new codec.PointerTo(UserScriptWorldInfo));
    return val;
  };

  Renderer_UpdateUserScriptWorlds_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_UpdateUserScriptWorlds_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(UserScriptWorldInfo), val.infos);
  };
  function Renderer_ClearUserScriptWorldConfig_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_ClearUserScriptWorldConfig_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.worldId = null;
  };
  Renderer_ClearUserScriptWorldConfig_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_ClearUserScriptWorldConfig_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_ClearUserScriptWorldConfig_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_ClearUserScriptWorldConfig_Params.worldId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_ClearUserScriptWorldConfig_Params.encodedSize = codec.kStructHeaderSize + 16;

  Renderer_ClearUserScriptWorldConfig_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_ClearUserScriptWorldConfig_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.worldId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  Renderer_ClearUserScriptWorldConfig_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_ClearUserScriptWorldConfig_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStruct(codec.String, val.worldId);
  };
  function Renderer_ShouldSuspend_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_ShouldSuspend_Params.prototype.initDefaults_ = function() {
  };
  Renderer_ShouldSuspend_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_ShouldSuspend_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_ShouldSuspend_Params.encodedSize = codec.kStructHeaderSize + 0;

  Renderer_ShouldSuspend_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_ShouldSuspend_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Renderer_ShouldSuspend_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_ShouldSuspend_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function Renderer_ShouldSuspend_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_ShouldSuspend_ResponseParams.prototype.initDefaults_ = function() {
  };
  Renderer_ShouldSuspend_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_ShouldSuspend_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_ShouldSuspend_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Renderer_ShouldSuspend_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Renderer_ShouldSuspend_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Renderer_ShouldSuspend_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_ShouldSuspend_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Renderer_TransferBlobs_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_TransferBlobs_Params.prototype.initDefaults_ = function() {
  };
  Renderer_TransferBlobs_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_TransferBlobs_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_TransferBlobs_Params.encodedSize = codec.kStructHeaderSize + 0;

  Renderer_TransferBlobs_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_TransferBlobs_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Renderer_TransferBlobs_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_TransferBlobs_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function Renderer_TransferBlobs_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_TransferBlobs_ResponseParams.prototype.initDefaults_ = function() {
  };
  Renderer_TransferBlobs_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_TransferBlobs_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_TransferBlobs_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Renderer_TransferBlobs_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Renderer_TransferBlobs_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Renderer_TransferBlobs_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_TransferBlobs_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Renderer_UpdatePermissions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_UpdatePermissions_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.activePermissions = null;
    this.withheldPermissions = null;
    this.policyBlockedHosts = null;
    this.policyAllowedHosts = null;
    this.usesDefaultPolicyHostRestrictions = false;
  };
  Renderer_UpdatePermissions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_UpdatePermissions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdatePermissions_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdatePermissions_Params.activePermissions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, permission_set$.PermissionSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdatePermissions_Params.withheldPermissions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, permission_set$.PermissionSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdatePermissions_Params.policyBlockedHosts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url_pattern_set$.URLPatternSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdatePermissions_Params.policyAllowedHosts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, url_pattern_set$.URLPatternSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Renderer_UpdatePermissions_Params.encodedSize = codec.kStructHeaderSize + 48;

  Renderer_UpdatePermissions_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_UpdatePermissions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.activePermissions =
        decoder.decodeStructPointer(permission_set$.PermissionSet);
    val.withheldPermissions =
        decoder.decodeStructPointer(permission_set$.PermissionSet);
    val.policyBlockedHosts =
        decoder.decodeStructPointer(url_pattern_set$.URLPatternSet);
    val.policyAllowedHosts =
        decoder.decodeStructPointer(url_pattern_set$.URLPatternSet);
    packed = decoder.readUint8();
    val.usesDefaultPolicyHostRestrictions = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Renderer_UpdatePermissions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_UpdatePermissions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStructPointer(permission_set$.PermissionSet, val.activePermissions);
    encoder.encodeStructPointer(permission_set$.PermissionSet, val.withheldPermissions);
    encoder.encodeStructPointer(url_pattern_set$.URLPatternSet, val.policyBlockedHosts);
    encoder.encodeStructPointer(url_pattern_set$.URLPatternSet, val.policyAllowedHosts);
    packed = 0;
    packed |= (val.usesDefaultPolicyHostRestrictions & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Renderer_UpdateDefaultPolicyHostRestrictions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_UpdateDefaultPolicyHostRestrictions_Params.prototype.initDefaults_ = function() {
    this.defaultPolicyBlockedHosts = null;
    this.defaultPolicyAllowedHosts = null;
  };
  Renderer_UpdateDefaultPolicyHostRestrictions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_UpdateDefaultPolicyHostRestrictions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdateDefaultPolicyHostRestrictions_Params.defaultPolicyBlockedHosts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url_pattern_set$.URLPatternSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdateDefaultPolicyHostRestrictions_Params.defaultPolicyAllowedHosts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url_pattern_set$.URLPatternSet, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_UpdateDefaultPolicyHostRestrictions_Params.encodedSize = codec.kStructHeaderSize + 16;

  Renderer_UpdateDefaultPolicyHostRestrictions_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_UpdateDefaultPolicyHostRestrictions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.defaultPolicyBlockedHosts =
        decoder.decodeStructPointer(url_pattern_set$.URLPatternSet);
    val.defaultPolicyAllowedHosts =
        decoder.decodeStructPointer(url_pattern_set$.URLPatternSet);
    return val;
  };

  Renderer_UpdateDefaultPolicyHostRestrictions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_UpdateDefaultPolicyHostRestrictions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url_pattern_set$.URLPatternSet, val.defaultPolicyBlockedHosts);
    encoder.encodeStructPointer(url_pattern_set$.URLPatternSet, val.defaultPolicyAllowedHosts);
  };
  function Renderer_UpdateUserHostRestrictions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_UpdateUserHostRestrictions_Params.prototype.initDefaults_ = function() {
    this.userBlockedHosts = null;
    this.userAllowedHosts = null;
  };
  Renderer_UpdateUserHostRestrictions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_UpdateUserHostRestrictions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdateUserHostRestrictions_Params.userBlockedHosts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url_pattern_set$.URLPatternSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdateUserHostRestrictions_Params.userAllowedHosts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url_pattern_set$.URLPatternSet, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_UpdateUserHostRestrictions_Params.encodedSize = codec.kStructHeaderSize + 16;

  Renderer_UpdateUserHostRestrictions_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_UpdateUserHostRestrictions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.userBlockedHosts =
        decoder.decodeStructPointer(url_pattern_set$.URLPatternSet);
    val.userAllowedHosts =
        decoder.decodeStructPointer(url_pattern_set$.URLPatternSet);
    return val;
  };

  Renderer_UpdateUserHostRestrictions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_UpdateUserHostRestrictions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url_pattern_set$.URLPatternSet, val.userBlockedHosts);
    encoder.encodeStructPointer(url_pattern_set$.URLPatternSet, val.userAllowedHosts);
  };
  function Renderer_UpdateTabSpecificPermissions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_UpdateTabSpecificPermissions_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.newHosts = null;
    this.tabId = 0;
    this.updateOriginAllowlist = false;
  };
  Renderer_UpdateTabSpecificPermissions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_UpdateTabSpecificPermissions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdateTabSpecificPermissions_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdateTabSpecificPermissions_Params.newHosts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url_pattern_set$.URLPatternSet, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Renderer_UpdateTabSpecificPermissions_Params.encodedSize = codec.kStructHeaderSize + 24;

  Renderer_UpdateTabSpecificPermissions_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_UpdateTabSpecificPermissions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.newHosts =
        decoder.decodeStructPointer(url_pattern_set$.URLPatternSet);
    val.tabId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.updateOriginAllowlist = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Renderer_UpdateTabSpecificPermissions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_UpdateTabSpecificPermissions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStructPointer(url_pattern_set$.URLPatternSet, val.newHosts);
    encoder.encodeStruct(codec.Int32, val.tabId);
    packed = 0;
    packed |= (val.updateOriginAllowlist & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Renderer_UpdateUserScripts_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_UpdateUserScripts_Params.prototype.initDefaults_ = function() {
    this.region = null;
    this.owner = null;
  };
  Renderer_UpdateUserScripts_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_UpdateUserScripts_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdateUserScripts_Params.region
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_memory$.ReadOnlySharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_UpdateUserScripts_Params.owner
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, host_id$.HostID, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_UpdateUserScripts_Params.encodedSize = codec.kStructHeaderSize + 16;

  Renderer_UpdateUserScripts_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_UpdateUserScripts_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.region =
        decoder.decodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion);
    val.owner =
        decoder.decodeStructPointer(host_id$.HostID);
    return val;
  };

  Renderer_UpdateUserScripts_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_UpdateUserScripts_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion, val.region);
    encoder.encodeStructPointer(host_id$.HostID, val.owner);
  };
  function Renderer_ClearTabSpecificPermissions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_ClearTabSpecificPermissions_Params.prototype.initDefaults_ = function() {
    this.extensionIds = null;
    this.tabId = 0;
    this.updateOriginAllowlist = false;
  };
  Renderer_ClearTabSpecificPermissions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_ClearTabSpecificPermissions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_ClearTabSpecificPermissions_Params.extensionIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(extension_id$.ExtensionId), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Renderer_ClearTabSpecificPermissions_Params.encodedSize = codec.kStructHeaderSize + 16;

  Renderer_ClearTabSpecificPermissions_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_ClearTabSpecificPermissions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionIds =
        decoder.decodeArrayPointer(new codec.PointerTo(extension_id$.ExtensionId));
    val.tabId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.updateOriginAllowlist = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Renderer_ClearTabSpecificPermissions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_ClearTabSpecificPermissions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(extension_id$.ExtensionId), val.extensionIds);
    encoder.encodeStruct(codec.Int32, val.tabId);
    packed = 0;
    packed |= (val.updateOriginAllowlist & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Renderer_WatchPages_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Renderer_WatchPages_Params.prototype.initDefaults_ = function() {
    this.cssSelectors = null;
  };
  Renderer_WatchPages_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Renderer_WatchPages_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Renderer_WatchPages_Params.cssSelectors
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Renderer_WatchPages_Params.encodedSize = codec.kStructHeaderSize + 8;

  Renderer_WatchPages_Params.decode = function(decoder) {
    var packed;
    var val = new Renderer_WatchPages_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cssSelectors =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  Renderer_WatchPages_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Renderer_WatchPages_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.cssSelectors);
  };
  var kRenderer_ActivateExtension_Name = 0;
  var kRenderer_SetActivityLoggingEnabled_Name = 1;
  var kRenderer_LoadExtensions_Name = 2;
  var kRenderer_UnloadExtension_Name = 3;
  var kRenderer_SuspendExtension_Name = 4;
  var kRenderer_CancelSuspendExtension_Name = 5;
  var kRenderer_SetDeveloperMode_Name = 6;
  var kRenderer_SetUserScriptsAllowed_Name = 7;
  var kRenderer_SetSessionInfo_Name = 8;
  var kRenderer_SetSystemFont_Name = 9;
  var kRenderer_SetWebViewPartitionID_Name = 10;
  var kRenderer_SetScriptingAllowlist_Name = 11;
  var kRenderer_UpdateUserScriptWorlds_Name = 12;
  var kRenderer_ClearUserScriptWorldConfig_Name = 13;
  var kRenderer_ShouldSuspend_Name = 14;
  var kRenderer_TransferBlobs_Name = 15;
  var kRenderer_UpdatePermissions_Name = 16;
  var kRenderer_UpdateDefaultPolicyHostRestrictions_Name = 17;
  var kRenderer_UpdateUserHostRestrictions_Name = 18;
  var kRenderer_UpdateTabSpecificPermissions_Name = 19;
  var kRenderer_UpdateUserScripts_Name = 20;
  var kRenderer_ClearTabSpecificPermissions_Name = 21;
  var kRenderer_WatchPages_Name = 22;

  function RendererPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(Renderer,
                                                   handleOrPtrInfo);
  }

  function RendererAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        Renderer, associatedInterfacePtrInfo);
  }

  RendererAssociatedPtr.prototype =
      Object.create(RendererPtr.prototype);
  RendererAssociatedPtr.prototype.constructor =
      RendererAssociatedPtr;

  function RendererProxy(receiver) {
    this.receiver_ = receiver;
  }
  RendererPtr.prototype.activateExtension = function() {
    return RendererProxy.prototype.activateExtension
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.activateExtension = function(extensionId) {
    var params_ = new Renderer_ActivateExtension_Params();
    params_.extensionId = extensionId;
    var builder = new codec.MessageV0Builder(
        kRenderer_ActivateExtension_Name,
        codec.align(Renderer_ActivateExtension_Params.encodedSize));
    builder.encodeStruct(Renderer_ActivateExtension_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.setActivityLoggingEnabled = function() {
    return RendererProxy.prototype.setActivityLoggingEnabled
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.setActivityLoggingEnabled = function(enabled) {
    var params_ = new Renderer_SetActivityLoggingEnabled_Params();
    params_.enabled = enabled;
    var builder = new codec.MessageV0Builder(
        kRenderer_SetActivityLoggingEnabled_Name,
        codec.align(Renderer_SetActivityLoggingEnabled_Params.encodedSize));
    builder.encodeStruct(Renderer_SetActivityLoggingEnabled_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.loadExtensions = function() {
    return RendererProxy.prototype.loadExtensions
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.loadExtensions = function(params) {
    var params_ = new Renderer_LoadExtensions_Params();
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kRenderer_LoadExtensions_Name,
        codec.align(Renderer_LoadExtensions_Params.encodedSize));
    builder.encodeStruct(Renderer_LoadExtensions_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.unloadExtension = function() {
    return RendererProxy.prototype.unloadExtension
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.unloadExtension = function(extensionId) {
    var params_ = new Renderer_UnloadExtension_Params();
    params_.extensionId = extensionId;
    var builder = new codec.MessageV0Builder(
        kRenderer_UnloadExtension_Name,
        codec.align(Renderer_UnloadExtension_Params.encodedSize));
    builder.encodeStruct(Renderer_UnloadExtension_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.suspendExtension = function() {
    return RendererProxy.prototype.suspendExtension
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.suspendExtension = function(extensionId) {
    var params_ = new Renderer_SuspendExtension_Params();
    params_.extensionId = extensionId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRenderer_SuspendExtension_Name,
          codec.align(Renderer_SuspendExtension_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Renderer_SuspendExtension_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Renderer_SuspendExtension_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RendererPtr.prototype.cancelSuspendExtension = function() {
    return RendererProxy.prototype.cancelSuspendExtension
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.cancelSuspendExtension = function(extensionId) {
    var params_ = new Renderer_CancelSuspendExtension_Params();
    params_.extensionId = extensionId;
    var builder = new codec.MessageV0Builder(
        kRenderer_CancelSuspendExtension_Name,
        codec.align(Renderer_CancelSuspendExtension_Params.encodedSize));
    builder.encodeStruct(Renderer_CancelSuspendExtension_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.setDeveloperMode = function() {
    return RendererProxy.prototype.setDeveloperMode
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.setDeveloperMode = function(developerModeOnly) {
    var params_ = new Renderer_SetDeveloperMode_Params();
    params_.developerModeOnly = developerModeOnly;
    var builder = new codec.MessageV0Builder(
        kRenderer_SetDeveloperMode_Name,
        codec.align(Renderer_SetDeveloperMode_Params.encodedSize));
    builder.encodeStruct(Renderer_SetDeveloperMode_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.setUserScriptsAllowed = function() {
    return RendererProxy.prototype.setUserScriptsAllowed
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.setUserScriptsAllowed = function(extensionId, allowed) {
    var params_ = new Renderer_SetUserScriptsAllowed_Params();
    params_.extensionId = extensionId;
    params_.allowed = allowed;
    var builder = new codec.MessageV0Builder(
        kRenderer_SetUserScriptsAllowed_Name,
        codec.align(Renderer_SetUserScriptsAllowed_Params.encodedSize));
    builder.encodeStruct(Renderer_SetUserScriptsAllowed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.setSessionInfo = function() {
    return RendererProxy.prototype.setSessionInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.setSessionInfo = function(channel, session) {
    var params_ = new Renderer_SetSessionInfo_Params();
    params_.channel = channel;
    params_.session = session;
    var builder = new codec.MessageV0Builder(
        kRenderer_SetSessionInfo_Name,
        codec.align(Renderer_SetSessionInfo_Params.encodedSize));
    builder.encodeStruct(Renderer_SetSessionInfo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.setSystemFont = function() {
    return RendererProxy.prototype.setSystemFont
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.setSystemFont = function(fontFamily, fontSize) {
    var params_ = new Renderer_SetSystemFont_Params();
    params_.fontFamily = fontFamily;
    params_.fontSize = fontSize;
    var builder = new codec.MessageV0Builder(
        kRenderer_SetSystemFont_Name,
        codec.align(Renderer_SetSystemFont_Params.encodedSize));
    builder.encodeStruct(Renderer_SetSystemFont_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.setWebViewPartitionID = function() {
    return RendererProxy.prototype.setWebViewPartitionID
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.setWebViewPartitionID = function(partitionId) {
    var params_ = new Renderer_SetWebViewPartitionID_Params();
    params_.partitionId = partitionId;
    var builder = new codec.MessageV0Builder(
        kRenderer_SetWebViewPartitionID_Name,
        codec.align(Renderer_SetWebViewPartitionID_Params.encodedSize));
    builder.encodeStruct(Renderer_SetWebViewPartitionID_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.setScriptingAllowlist = function() {
    return RendererProxy.prototype.setScriptingAllowlist
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.setScriptingAllowlist = function(extensionIds) {
    var params_ = new Renderer_SetScriptingAllowlist_Params();
    params_.extensionIds = extensionIds;
    var builder = new codec.MessageV0Builder(
        kRenderer_SetScriptingAllowlist_Name,
        codec.align(Renderer_SetScriptingAllowlist_Params.encodedSize));
    builder.encodeStruct(Renderer_SetScriptingAllowlist_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.updateUserScriptWorlds = function() {
    return RendererProxy.prototype.updateUserScriptWorlds
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.updateUserScriptWorlds = function(infos) {
    var params_ = new Renderer_UpdateUserScriptWorlds_Params();
    params_.infos = infos;
    var builder = new codec.MessageV0Builder(
        kRenderer_UpdateUserScriptWorlds_Name,
        codec.align(Renderer_UpdateUserScriptWorlds_Params.encodedSize));
    builder.encodeStruct(Renderer_UpdateUserScriptWorlds_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.clearUserScriptWorldConfig = function() {
    return RendererProxy.prototype.clearUserScriptWorldConfig
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.clearUserScriptWorldConfig = function(extensionId, worldId) {
    var params_ = new Renderer_ClearUserScriptWorldConfig_Params();
    params_.extensionId = extensionId;
    params_.worldId = worldId;
    var builder = new codec.MessageV0Builder(
        kRenderer_ClearUserScriptWorldConfig_Name,
        codec.align(Renderer_ClearUserScriptWorldConfig_Params.encodedSize));
    builder.encodeStruct(Renderer_ClearUserScriptWorldConfig_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.shouldSuspend = function() {
    return RendererProxy.prototype.shouldSuspend
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.shouldSuspend = function() {
    var params_ = new Renderer_ShouldSuspend_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRenderer_ShouldSuspend_Name,
          codec.align(Renderer_ShouldSuspend_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Renderer_ShouldSuspend_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Renderer_ShouldSuspend_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RendererPtr.prototype.transferBlobs = function() {
    return RendererProxy.prototype.transferBlobs
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.transferBlobs = function() {
    var params_ = new Renderer_TransferBlobs_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRenderer_TransferBlobs_Name,
          codec.align(Renderer_TransferBlobs_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Renderer_TransferBlobs_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Renderer_TransferBlobs_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RendererPtr.prototype.updatePermissions = function() {
    return RendererProxy.prototype.updatePermissions
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.updatePermissions = function(extensionId, activePermissions, withheldPermissions, policyBlockedHosts, policyAllowedHosts, usesDefaultPolicyHostRestrictions) {
    var params_ = new Renderer_UpdatePermissions_Params();
    params_.extensionId = extensionId;
    params_.activePermissions = activePermissions;
    params_.withheldPermissions = withheldPermissions;
    params_.policyBlockedHosts = policyBlockedHosts;
    params_.policyAllowedHosts = policyAllowedHosts;
    params_.usesDefaultPolicyHostRestrictions = usesDefaultPolicyHostRestrictions;
    var builder = new codec.MessageV0Builder(
        kRenderer_UpdatePermissions_Name,
        codec.align(Renderer_UpdatePermissions_Params.encodedSize));
    builder.encodeStruct(Renderer_UpdatePermissions_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.updateDefaultPolicyHostRestrictions = function() {
    return RendererProxy.prototype.updateDefaultPolicyHostRestrictions
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.updateDefaultPolicyHostRestrictions = function(defaultPolicyBlockedHosts, defaultPolicyAllowedHosts) {
    var params_ = new Renderer_UpdateDefaultPolicyHostRestrictions_Params();
    params_.defaultPolicyBlockedHosts = defaultPolicyBlockedHosts;
    params_.defaultPolicyAllowedHosts = defaultPolicyAllowedHosts;
    var builder = new codec.MessageV0Builder(
        kRenderer_UpdateDefaultPolicyHostRestrictions_Name,
        codec.align(Renderer_UpdateDefaultPolicyHostRestrictions_Params.encodedSize));
    builder.encodeStruct(Renderer_UpdateDefaultPolicyHostRestrictions_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.updateUserHostRestrictions = function() {
    return RendererProxy.prototype.updateUserHostRestrictions
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.updateUserHostRestrictions = function(userBlockedHosts, userAllowedHosts) {
    var params_ = new Renderer_UpdateUserHostRestrictions_Params();
    params_.userBlockedHosts = userBlockedHosts;
    params_.userAllowedHosts = userAllowedHosts;
    var builder = new codec.MessageV0Builder(
        kRenderer_UpdateUserHostRestrictions_Name,
        codec.align(Renderer_UpdateUserHostRestrictions_Params.encodedSize));
    builder.encodeStruct(Renderer_UpdateUserHostRestrictions_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.updateTabSpecificPermissions = function() {
    return RendererProxy.prototype.updateTabSpecificPermissions
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.updateTabSpecificPermissions = function(extensionId, newHosts, tabId, updateOriginAllowlist) {
    var params_ = new Renderer_UpdateTabSpecificPermissions_Params();
    params_.extensionId = extensionId;
    params_.newHosts = newHosts;
    params_.tabId = tabId;
    params_.updateOriginAllowlist = updateOriginAllowlist;
    var builder = new codec.MessageV0Builder(
        kRenderer_UpdateTabSpecificPermissions_Name,
        codec.align(Renderer_UpdateTabSpecificPermissions_Params.encodedSize));
    builder.encodeStruct(Renderer_UpdateTabSpecificPermissions_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.updateUserScripts = function() {
    return RendererProxy.prototype.updateUserScripts
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.updateUserScripts = function(region, owner) {
    var params_ = new Renderer_UpdateUserScripts_Params();
    params_.region = region;
    params_.owner = owner;
    var builder = new codec.MessageV0Builder(
        kRenderer_UpdateUserScripts_Name,
        codec.align(Renderer_UpdateUserScripts_Params.encodedSize));
    builder.encodeStruct(Renderer_UpdateUserScripts_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.clearTabSpecificPermissions = function() {
    return RendererProxy.prototype.clearTabSpecificPermissions
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.clearTabSpecificPermissions = function(extensionIds, tabId, updateOriginAllowlist) {
    var params_ = new Renderer_ClearTabSpecificPermissions_Params();
    params_.extensionIds = extensionIds;
    params_.tabId = tabId;
    params_.updateOriginAllowlist = updateOriginAllowlist;
    var builder = new codec.MessageV0Builder(
        kRenderer_ClearTabSpecificPermissions_Name,
        codec.align(Renderer_ClearTabSpecificPermissions_Params.encodedSize));
    builder.encodeStruct(Renderer_ClearTabSpecificPermissions_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  RendererPtr.prototype.watchPages = function() {
    return RendererProxy.prototype.watchPages
        .apply(this.ptr.getProxy(), arguments);
  };

  RendererProxy.prototype.watchPages = function(cssSelectors) {
    var params_ = new Renderer_WatchPages_Params();
    params_.cssSelectors = cssSelectors;
    var builder = new codec.MessageV0Builder(
        kRenderer_WatchPages_Name,
        codec.align(Renderer_WatchPages_Params.encodedSize));
    builder.encodeStruct(Renderer_WatchPages_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RendererStub(delegate) {
    this.delegate_ = delegate;
  }
  RendererStub.prototype.activateExtension = function(extensionId) {
    return this.delegate_ && this.delegate_.activateExtension && this.delegate_.activateExtension(extensionId);
  }
  RendererStub.prototype.setActivityLoggingEnabled = function(enabled) {
    return this.delegate_ && this.delegate_.setActivityLoggingEnabled && this.delegate_.setActivityLoggingEnabled(enabled);
  }
  RendererStub.prototype.loadExtensions = function(params) {
    return this.delegate_ && this.delegate_.loadExtensions && this.delegate_.loadExtensions(params);
  }
  RendererStub.prototype.unloadExtension = function(extensionId) {
    return this.delegate_ && this.delegate_.unloadExtension && this.delegate_.unloadExtension(extensionId);
  }
  RendererStub.prototype.suspendExtension = function(extensionId) {
    return this.delegate_ && this.delegate_.suspendExtension && this.delegate_.suspendExtension(extensionId);
  }
  RendererStub.prototype.cancelSuspendExtension = function(extensionId) {
    return this.delegate_ && this.delegate_.cancelSuspendExtension && this.delegate_.cancelSuspendExtension(extensionId);
  }
  RendererStub.prototype.setDeveloperMode = function(developerModeOnly) {
    return this.delegate_ && this.delegate_.setDeveloperMode && this.delegate_.setDeveloperMode(developerModeOnly);
  }
  RendererStub.prototype.setUserScriptsAllowed = function(extensionId, allowed) {
    return this.delegate_ && this.delegate_.setUserScriptsAllowed && this.delegate_.setUserScriptsAllowed(extensionId, allowed);
  }
  RendererStub.prototype.setSessionInfo = function(channel, session) {
    return this.delegate_ && this.delegate_.setSessionInfo && this.delegate_.setSessionInfo(channel, session);
  }
  RendererStub.prototype.setSystemFont = function(fontFamily, fontSize) {
    return this.delegate_ && this.delegate_.setSystemFont && this.delegate_.setSystemFont(fontFamily, fontSize);
  }
  RendererStub.prototype.setWebViewPartitionID = function(partitionId) {
    return this.delegate_ && this.delegate_.setWebViewPartitionID && this.delegate_.setWebViewPartitionID(partitionId);
  }
  RendererStub.prototype.setScriptingAllowlist = function(extensionIds) {
    return this.delegate_ && this.delegate_.setScriptingAllowlist && this.delegate_.setScriptingAllowlist(extensionIds);
  }
  RendererStub.prototype.updateUserScriptWorlds = function(infos) {
    return this.delegate_ && this.delegate_.updateUserScriptWorlds && this.delegate_.updateUserScriptWorlds(infos);
  }
  RendererStub.prototype.clearUserScriptWorldConfig = function(extensionId, worldId) {
    return this.delegate_ && this.delegate_.clearUserScriptWorldConfig && this.delegate_.clearUserScriptWorldConfig(extensionId, worldId);
  }
  RendererStub.prototype.shouldSuspend = function() {
    return this.delegate_ && this.delegate_.shouldSuspend && this.delegate_.shouldSuspend();
  }
  RendererStub.prototype.transferBlobs = function() {
    return this.delegate_ && this.delegate_.transferBlobs && this.delegate_.transferBlobs();
  }
  RendererStub.prototype.updatePermissions = function(extensionId, activePermissions, withheldPermissions, policyBlockedHosts, policyAllowedHosts, usesDefaultPolicyHostRestrictions) {
    return this.delegate_ && this.delegate_.updatePermissions && this.delegate_.updatePermissions(extensionId, activePermissions, withheldPermissions, policyBlockedHosts, policyAllowedHosts, usesDefaultPolicyHostRestrictions);
  }
  RendererStub.prototype.updateDefaultPolicyHostRestrictions = function(defaultPolicyBlockedHosts, defaultPolicyAllowedHosts) {
    return this.delegate_ && this.delegate_.updateDefaultPolicyHostRestrictions && this.delegate_.updateDefaultPolicyHostRestrictions(defaultPolicyBlockedHosts, defaultPolicyAllowedHosts);
  }
  RendererStub.prototype.updateUserHostRestrictions = function(userBlockedHosts, userAllowedHosts) {
    return this.delegate_ && this.delegate_.updateUserHostRestrictions && this.delegate_.updateUserHostRestrictions(userBlockedHosts, userAllowedHosts);
  }
  RendererStub.prototype.updateTabSpecificPermissions = function(extensionId, newHosts, tabId, updateOriginAllowlist) {
    return this.delegate_ && this.delegate_.updateTabSpecificPermissions && this.delegate_.updateTabSpecificPermissions(extensionId, newHosts, tabId, updateOriginAllowlist);
  }
  RendererStub.prototype.updateUserScripts = function(region, owner) {
    return this.delegate_ && this.delegate_.updateUserScripts && this.delegate_.updateUserScripts(region, owner);
  }
  RendererStub.prototype.clearTabSpecificPermissions = function(extensionIds, tabId, updateOriginAllowlist) {
    return this.delegate_ && this.delegate_.clearTabSpecificPermissions && this.delegate_.clearTabSpecificPermissions(extensionIds, tabId, updateOriginAllowlist);
  }
  RendererStub.prototype.watchPages = function(cssSelectors) {
    return this.delegate_ && this.delegate_.watchPages && this.delegate_.watchPages(cssSelectors);
  }

  RendererStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRenderer_ActivateExtension_Name:
      var params = reader.decodeStruct(Renderer_ActivateExtension_Params);
      this.activateExtension(params.extensionId);
      return true;
    case kRenderer_SetActivityLoggingEnabled_Name:
      var params = reader.decodeStruct(Renderer_SetActivityLoggingEnabled_Params);
      this.setActivityLoggingEnabled(params.enabled);
      return true;
    case kRenderer_LoadExtensions_Name:
      var params = reader.decodeStruct(Renderer_LoadExtensions_Params);
      this.loadExtensions(params.params);
      return true;
    case kRenderer_UnloadExtension_Name:
      var params = reader.decodeStruct(Renderer_UnloadExtension_Params);
      this.unloadExtension(params.extensionId);
      return true;
    case kRenderer_CancelSuspendExtension_Name:
      var params = reader.decodeStruct(Renderer_CancelSuspendExtension_Params);
      this.cancelSuspendExtension(params.extensionId);
      return true;
    case kRenderer_SetDeveloperMode_Name:
      var params = reader.decodeStruct(Renderer_SetDeveloperMode_Params);
      this.setDeveloperMode(params.developerModeOnly);
      return true;
    case kRenderer_SetUserScriptsAllowed_Name:
      var params = reader.decodeStruct(Renderer_SetUserScriptsAllowed_Params);
      this.setUserScriptsAllowed(params.extensionId, params.allowed);
      return true;
    case kRenderer_SetSessionInfo_Name:
      var params = reader.decodeStruct(Renderer_SetSessionInfo_Params);
      this.setSessionInfo(params.channel, params.session);
      return true;
    case kRenderer_SetSystemFont_Name:
      var params = reader.decodeStruct(Renderer_SetSystemFont_Params);
      this.setSystemFont(params.fontFamily, params.fontSize);
      return true;
    case kRenderer_SetWebViewPartitionID_Name:
      var params = reader.decodeStruct(Renderer_SetWebViewPartitionID_Params);
      this.setWebViewPartitionID(params.partitionId);
      return true;
    case kRenderer_SetScriptingAllowlist_Name:
      var params = reader.decodeStruct(Renderer_SetScriptingAllowlist_Params);
      this.setScriptingAllowlist(params.extensionIds);
      return true;
    case kRenderer_UpdateUserScriptWorlds_Name:
      var params = reader.decodeStruct(Renderer_UpdateUserScriptWorlds_Params);
      this.updateUserScriptWorlds(params.infos);
      return true;
    case kRenderer_ClearUserScriptWorldConfig_Name:
      var params = reader.decodeStruct(Renderer_ClearUserScriptWorldConfig_Params);
      this.clearUserScriptWorldConfig(params.extensionId, params.worldId);
      return true;
    case kRenderer_UpdatePermissions_Name:
      var params = reader.decodeStruct(Renderer_UpdatePermissions_Params);
      this.updatePermissions(params.extensionId, params.activePermissions, params.withheldPermissions, params.policyBlockedHosts, params.policyAllowedHosts, params.usesDefaultPolicyHostRestrictions);
      return true;
    case kRenderer_UpdateDefaultPolicyHostRestrictions_Name:
      var params = reader.decodeStruct(Renderer_UpdateDefaultPolicyHostRestrictions_Params);
      this.updateDefaultPolicyHostRestrictions(params.defaultPolicyBlockedHosts, params.defaultPolicyAllowedHosts);
      return true;
    case kRenderer_UpdateUserHostRestrictions_Name:
      var params = reader.decodeStruct(Renderer_UpdateUserHostRestrictions_Params);
      this.updateUserHostRestrictions(params.userBlockedHosts, params.userAllowedHosts);
      return true;
    case kRenderer_UpdateTabSpecificPermissions_Name:
      var params = reader.decodeStruct(Renderer_UpdateTabSpecificPermissions_Params);
      this.updateTabSpecificPermissions(params.extensionId, params.newHosts, params.tabId, params.updateOriginAllowlist);
      return true;
    case kRenderer_UpdateUserScripts_Name:
      var params = reader.decodeStruct(Renderer_UpdateUserScripts_Params);
      this.updateUserScripts(params.region, params.owner);
      return true;
    case kRenderer_ClearTabSpecificPermissions_Name:
      var params = reader.decodeStruct(Renderer_ClearTabSpecificPermissions_Params);
      this.clearTabSpecificPermissions(params.extensionIds, params.tabId, params.updateOriginAllowlist);
      return true;
    case kRenderer_WatchPages_Name:
      var params = reader.decodeStruct(Renderer_WatchPages_Params);
      this.watchPages(params.cssSelectors);
      return true;
    default:
      return false;
    }
  };

  RendererStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRenderer_SuspendExtension_Name:
      var params = reader.decodeStruct(Renderer_SuspendExtension_Params);
      this.suspendExtension(params.extensionId).then(function(response) {
        var responseParams =
            new Renderer_SuspendExtension_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kRenderer_SuspendExtension_Name,
            codec.align(Renderer_SuspendExtension_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Renderer_SuspendExtension_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRenderer_ShouldSuspend_Name:
      var params = reader.decodeStruct(Renderer_ShouldSuspend_Params);
      this.shouldSuspend().then(function(response) {
        var responseParams =
            new Renderer_ShouldSuspend_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kRenderer_ShouldSuspend_Name,
            codec.align(Renderer_ShouldSuspend_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Renderer_ShouldSuspend_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRenderer_TransferBlobs_Name:
      var params = reader.decodeStruct(Renderer_TransferBlobs_Params);
      this.transferBlobs().then(function(response) {
        var responseParams =
            new Renderer_TransferBlobs_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kRenderer_TransferBlobs_Name,
            codec.align(Renderer_TransferBlobs_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Renderer_TransferBlobs_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateRendererRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRenderer_ActivateExtension_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_ActivateExtension_Params;
      break;
      case kRenderer_SetActivityLoggingEnabled_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_SetActivityLoggingEnabled_Params;
      break;
      case kRenderer_LoadExtensions_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_LoadExtensions_Params;
      break;
      case kRenderer_UnloadExtension_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_UnloadExtension_Params;
      break;
      case kRenderer_SuspendExtension_Name:
        if (message.expectsResponse())
          paramsClass = Renderer_SuspendExtension_Params;
      break;
      case kRenderer_CancelSuspendExtension_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_CancelSuspendExtension_Params;
      break;
      case kRenderer_SetDeveloperMode_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_SetDeveloperMode_Params;
      break;
      case kRenderer_SetUserScriptsAllowed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_SetUserScriptsAllowed_Params;
      break;
      case kRenderer_SetSessionInfo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_SetSessionInfo_Params;
      break;
      case kRenderer_SetSystemFont_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_SetSystemFont_Params;
      break;
      case kRenderer_SetWebViewPartitionID_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_SetWebViewPartitionID_Params;
      break;
      case kRenderer_SetScriptingAllowlist_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_SetScriptingAllowlist_Params;
      break;
      case kRenderer_UpdateUserScriptWorlds_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_UpdateUserScriptWorlds_Params;
      break;
      case kRenderer_ClearUserScriptWorldConfig_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_ClearUserScriptWorldConfig_Params;
      break;
      case kRenderer_ShouldSuspend_Name:
        if (message.expectsResponse())
          paramsClass = Renderer_ShouldSuspend_Params;
      break;
      case kRenderer_TransferBlobs_Name:
        if (message.expectsResponse())
          paramsClass = Renderer_TransferBlobs_Params;
      break;
      case kRenderer_UpdatePermissions_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_UpdatePermissions_Params;
      break;
      case kRenderer_UpdateDefaultPolicyHostRestrictions_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_UpdateDefaultPolicyHostRestrictions_Params;
      break;
      case kRenderer_UpdateUserHostRestrictions_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_UpdateUserHostRestrictions_Params;
      break;
      case kRenderer_UpdateTabSpecificPermissions_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_UpdateTabSpecificPermissions_Params;
      break;
      case kRenderer_UpdateUserScripts_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_UpdateUserScripts_Params;
      break;
      case kRenderer_ClearTabSpecificPermissions_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_ClearTabSpecificPermissions_Params;
      break;
      case kRenderer_WatchPages_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Renderer_WatchPages_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRendererResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kRenderer_SuspendExtension_Name:
        if (message.isResponse())
          paramsClass = Renderer_SuspendExtension_ResponseParams;
        break;
      case kRenderer_ShouldSuspend_Name:
        if (message.isResponse())
          paramsClass = Renderer_ShouldSuspend_ResponseParams;
        break;
      case kRenderer_TransferBlobs_Name:
        if (message.isResponse())
          paramsClass = Renderer_TransferBlobs_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var Renderer = {
    name: 'extensions.mojom.Renderer',
    kVersion: 0,
    ptrClass: RendererPtr,
    proxyClass: RendererProxy,
    stubClass: RendererStub,
    validateRequest: validateRendererRequest,
    validateResponse: validateRendererResponse,
  };
  RendererStub.prototype.validator = validateRendererRequest;
  RendererProxy.prototype.validator = validateRendererResponse;
  exports.ExtensionLoadedParams = ExtensionLoadedParams;
  exports.UserScriptWorldInfo = UserScriptWorldInfo;
  exports.Renderer = Renderer;
  exports.RendererPtr = RendererPtr;
  exports.RendererAssociatedPtr = RendererAssociatedPtr;
})();