// extensions/common/mojom/renderer.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_TEST_UTILS_H_
#define EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_TEST_UTILS_H_

#include "extensions/common/mojom/renderer.mojom.h"


namespace extensions::mojom {


class  RendererInterceptorForTesting : public Renderer {
  virtual Renderer* GetForwardingInterface() = 0;
  void ActivateExtension(const ::extensions::ExtensionId& extension_id) override;
  void SetActivityLoggingEnabled(bool enabled) override;
  void LoadExtensions(std::vector<ExtensionLoadedParamsPtr> params) override;
  void UnloadExtension(const ::extensions::ExtensionId& extension_id) override;
  void SuspendExtension(const ::extensions::ExtensionId& extension_id, SuspendExtensionCallback callback) override;
  void CancelSuspendExtension(const ::extensions::ExtensionId& extension_id) override;
  void SetDeveloperMode(bool developer_mode_only) override;
  void SetUserScriptsAllowed(const ::extensions::ExtensionId& extension_id, bool allowed) override;
  void SetSessionInfo(version_info::Channel channel, ::extensions::mojom::FeatureSessionType session) override;
  void SetSystemFont(const std::string& font_family, const std::string& font_size) override;
  void SetWebViewPartitionID(const std::string& partition_id) override;
  void SetScriptingAllowlist(const std::vector<::extensions::ExtensionId>& extension_ids) override;
  void UpdateUserScriptWorlds(std::vector<UserScriptWorldInfoPtr> infos) override;
  void ClearUserScriptWorldConfig(const ::extensions::ExtensionId& extension_id, const std::optional<std::string>& world_id) override;
  void ShouldSuspend(ShouldSuspendCallback callback) override;
  void TransferBlobs(TransferBlobsCallback callback) override;
  void UpdatePermissions(const ::extensions::ExtensionId& extension_id, ::extensions::PermissionSet active_permissions, ::extensions::PermissionSet withheld_permissions, ::extensions::URLPatternSet policy_blocked_hosts, ::extensions::URLPatternSet policy_allowed_hosts, bool uses_default_policy_host_restrictions) override;
  void UpdateDefaultPolicyHostRestrictions(::extensions::URLPatternSet default_policy_blocked_hosts, ::extensions::URLPatternSet default_policy_allowed_hosts) override;
  void UpdateUserHostRestrictions(::extensions::URLPatternSet user_blocked_hosts, ::extensions::URLPatternSet user_allowed_hosts) override;
  void UpdateTabSpecificPermissions(const ::extensions::ExtensionId& extension_id, ::extensions::URLPatternSet new_hosts, int32_t tab_id, bool update_origin_allowlist) override;
  void UpdateUserScripts(::base::ReadOnlySharedMemoryRegion region, ::extensions::mojom::HostIDPtr owner) override;
  void ClearTabSpecificPermissions(const std::vector<::extensions::ExtensionId>& extension_ids, int32_t tab_id, bool update_origin_allowlist) override;
  void WatchPages(const std::vector<std::string>& css_selectors) override;
};
class  RendererAsyncWaiter {
 public:
  explicit RendererAsyncWaiter(Renderer* proxy);

  RendererAsyncWaiter(const RendererAsyncWaiter&) = delete;
  RendererAsyncWaiter& operator=(const RendererAsyncWaiter&) = delete;

  ~RendererAsyncWaiter();
  void SuspendExtension(
      const ::extensions::ExtensionId& extension_id);
  
  void ShouldSuspend(
      );
  
  void TransferBlobs(
      );
  

 private:
  Renderer* const proxy_;
};




}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_TEST_UTILS_H_