// extensions/common/mojom/frame.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_TEST_UTILS_H_
#define EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_TEST_UTILS_H_

#include "extensions/common/mojom/frame.mojom.h"


namespace extensions::mojom {


class  LocalFrameInterceptorForTesting : public LocalFrame {
  virtual LocalFrame* GetForwardingInterface() = 0;
  void SetFrameName(const std::string& frame_name) override;
  void SetSpatialNavigationEnabled(bool spatial_nav_enabled) override;
  void SetTabId(int32_t tab_id) override;
  void AppWindowClosed(bool send_onclosed) override;
  void NotifyRenderViewType(::extensions::mojom::ViewType view_type) override;
  void MessageInvoke(const ::extensions::ExtensionId& extension_id, const std::string& module_name, const std::string& function_name, ::base::Value::List args) override;
  void ExecuteCode(ExecuteCodeParamsPtr param, ExecuteCodeCallback callback) override;
  void ExecuteDeclarativeScript(int32_t tab_id, const ::extensions::ExtensionId& extension_id, const std::string& script_id, const ::GURL& url) override;
  void UpdateBrowserWindowId(int32_t window_id) override;
  void DispatchOnConnect(const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host, DispatchOnConnectCallback callback) override;
};
class  LocalFrameAsyncWaiter {
 public:
  explicit LocalFrameAsyncWaiter(LocalFrame* proxy);

  LocalFrameAsyncWaiter(const LocalFrameAsyncWaiter&) = delete;
  LocalFrameAsyncWaiter& operator=(const LocalFrameAsyncWaiter&) = delete;

  ~LocalFrameAsyncWaiter();
  void ExecuteCode(
      ExecuteCodeParamsPtr param, std::string* out_error, ::GURL* out_url, std::optional<::base::Value>* out_result);
  
  void DispatchOnConnect(
      const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host, bool* out_success);
  bool DispatchOnConnect(const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host);

 private:
  LocalFrame* const proxy_;
};


class  LocalFrameHostInterceptorForTesting : public LocalFrameHost {
  virtual LocalFrameHost* GetForwardingInterface() = 0;
  void RequestScriptInjectionPermission(const ::extensions::ExtensionId& extension_id, ::extensions::mojom::InjectionType script_type, ::extensions::mojom::RunLocation run_location, RequestScriptInjectionPermissionCallback callback) override;
  void GetAppInstallState(const ::GURL& url, GetAppInstallStateCallback callback) override;
  void Request(RequestParamsPtr params, RequestCallback callback) override;
  void ResponseAck(const ::base::Uuid& request_uuid) override;
  void WatchedPageChange(const std::vector<std::string>& css_selectors) override;
  void DetailedConsoleMessageAdded(const ::std::u16string& message, const ::std::u16string& source, const std::vector<::extensions::StackFrame>& stack_trace, ::blink::mojom::ConsoleMessageLevel level) override;
  void ContentScriptsExecuting(const base::flat_map<std::string, std::vector<std::string>>& extension_id_to_scripts, const ::GURL& frame_url) override;
  void IncrementLazyKeepaliveCount() override;
  void DecrementLazyKeepaliveCount() override;
  void AppWindowReady() override;
  void OpenChannelToExtension(::extensions::mojom::ExternalConnectionInfoPtr info, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) override;
  void OpenChannelToNativeApp(const std::string& native_app_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) override;
  void OpenChannelToTab(int32_t tab_id, int32_t frame_id, const std::optional<std::string>& document_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) override;
};
class  LocalFrameHostAsyncWaiter {
 public:
  explicit LocalFrameHostAsyncWaiter(LocalFrameHost* proxy);

  LocalFrameHostAsyncWaiter(const LocalFrameHostAsyncWaiter&) = delete;
  LocalFrameHostAsyncWaiter& operator=(const LocalFrameHostAsyncWaiter&) = delete;

  ~LocalFrameHostAsyncWaiter();
  void RequestScriptInjectionPermission(
      const ::extensions::ExtensionId& extension_id, ::extensions::mojom::InjectionType script_type, ::extensions::mojom::RunLocation run_location, bool* out_granted);
  bool RequestScriptInjectionPermission(const ::extensions::ExtensionId& extension_id, ::extensions::mojom::InjectionType script_type, ::extensions::mojom::RunLocation run_location);
  void GetAppInstallState(
      const ::GURL& url, std::string* out_state);
  std::string GetAppInstallState(const ::GURL& url);
  void Request(
      RequestParamsPtr params, bool* out_success, ::base::Value::List* out_response_wrapper, std::string* out_error, ::extensions::mojom::ExtraResponseDataPtr* out_extra_data);
  

 private:
  LocalFrameHost* const proxy_;
};




}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_TEST_UTILS_H_