// extensions/common/mojom/event_dispatcher.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'extensions/common/mojom/event_dispatcher.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('extensions.mojom');
  var host_id$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/host_id.mojom', 'host_id.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../mojo/public/mojom/base/values.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../url/mojom/url.mojom.js');
  }



  function EventFilteringInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventFilteringInfo.prototype.initDefaults_ = function() {
    this.url = null;
    this.serviceType = null;
    this.hasInstanceId = false;
    this.hasWindowExposedByDefault = false;
    this.windowExposedByDefault = false;
    this.instanceId = 0;
    this.windowType = null;
  };
  EventFilteringInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventFilteringInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventFilteringInfo.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventFilteringInfo.serviceType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;




    // validate EventFilteringInfo.windowType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  EventFilteringInfo.encodedSize = codec.kStructHeaderSize + 32;

  EventFilteringInfo.decode = function(decoder) {
    var packed;
    var val = new EventFilteringInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.serviceType =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.hasInstanceId = (packed >> 0) & 1 ? true : false;
    val.hasWindowExposedByDefault = (packed >> 1) & 1 ? true : false;
    val.windowExposedByDefault = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.instanceId =
        decoder.decodeStruct(codec.Int32);
    val.windowType =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EventFilteringInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventFilteringInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.serviceType);
    packed = 0;
    packed |= (val.hasInstanceId & 1) << 0
    packed |= (val.hasWindowExposedByDefault & 1) << 1
    packed |= (val.windowExposedByDefault & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.instanceId);
    encoder.encodeStruct(codec.String, val.windowType);
  };
  function DispatchEventParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DispatchEventParams.prototype.initDefaults_ = function() {
    this.workerThreadId = 0;
    this.eventId = 0;
    this.hostId = null;
    this.eventName = null;
    this.isUserGesture = false;
    this.filteringInfo = null;
  };
  DispatchEventParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DispatchEventParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DispatchEventParams.hostId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, host_id$.HostID, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DispatchEventParams.eventName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate DispatchEventParams.filteringInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, EventFilteringInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DispatchEventParams.encodedSize = codec.kStructHeaderSize + 40;

  DispatchEventParams.decode = function(decoder) {
    var packed;
    var val = new DispatchEventParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.workerThreadId =
        decoder.decodeStruct(codec.Int32);
    val.eventId =
        decoder.decodeStruct(codec.Int32);
    val.hostId =
        decoder.decodeStructPointer(host_id$.HostID);
    val.eventName =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.isUserGesture = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.filteringInfo =
        decoder.decodeStructPointer(EventFilteringInfo);
    return val;
  };

  DispatchEventParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DispatchEventParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.workerThreadId);
    encoder.encodeStruct(codec.Int32, val.eventId);
    encoder.encodeStructPointer(host_id$.HostID, val.hostId);
    encoder.encodeStruct(codec.String, val.eventName);
    packed = 0;
    packed |= (val.isUserGesture & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(EventFilteringInfo, val.filteringInfo);
  };
  function EventDispatcher_DispatchEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventDispatcher_DispatchEvent_Params.prototype.initDefaults_ = function() {
    this.params = null;
    this.eventArgs = null;
  };
  EventDispatcher_DispatchEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventDispatcher_DispatchEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventDispatcher_DispatchEvent_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DispatchEventParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventDispatcher_DispatchEvent_Params.eventArgs
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, values$.ListValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventDispatcher_DispatchEvent_Params.encodedSize = codec.kStructHeaderSize + 16;

  EventDispatcher_DispatchEvent_Params.decode = function(decoder) {
    var packed;
    var val = new EventDispatcher_DispatchEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(DispatchEventParams);
    val.eventArgs =
        decoder.decodeStructPointer(values$.ListValue);
    return val;
  };

  EventDispatcher_DispatchEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventDispatcher_DispatchEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DispatchEventParams, val.params);
    encoder.encodeStructPointer(values$.ListValue, val.eventArgs);
  };
  function EventDispatcher_DispatchEvent_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventDispatcher_DispatchEvent_ResponseParams.prototype.initDefaults_ = function() {
    this.eventWillRunInLazyBackgroundPageScript = false;
  };
  EventDispatcher_DispatchEvent_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventDispatcher_DispatchEvent_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  EventDispatcher_DispatchEvent_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  EventDispatcher_DispatchEvent_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new EventDispatcher_DispatchEvent_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.eventWillRunInLazyBackgroundPageScript = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EventDispatcher_DispatchEvent_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventDispatcher_DispatchEvent_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.eventWillRunInLazyBackgroundPageScript & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kEventDispatcher_DispatchEvent_Name = 0;

  function EventDispatcherPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(EventDispatcher,
                                                   handleOrPtrInfo);
  }

  function EventDispatcherAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        EventDispatcher, associatedInterfacePtrInfo);
  }

  EventDispatcherAssociatedPtr.prototype =
      Object.create(EventDispatcherPtr.prototype);
  EventDispatcherAssociatedPtr.prototype.constructor =
      EventDispatcherAssociatedPtr;

  function EventDispatcherProxy(receiver) {
    this.receiver_ = receiver;
  }
  EventDispatcherPtr.prototype.dispatchEvent = function() {
    return EventDispatcherProxy.prototype.dispatchEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  EventDispatcherProxy.prototype.dispatchEvent = function(params, eventArgs) {
    var params_ = new EventDispatcher_DispatchEvent_Params();
    params_.params = params;
    params_.eventArgs = eventArgs;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kEventDispatcher_DispatchEvent_Name,
          codec.align(EventDispatcher_DispatchEvent_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(EventDispatcher_DispatchEvent_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(EventDispatcher_DispatchEvent_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function EventDispatcherStub(delegate) {
    this.delegate_ = delegate;
  }
  EventDispatcherStub.prototype.dispatchEvent = function(params, eventArgs) {
    return this.delegate_ && this.delegate_.dispatchEvent && this.delegate_.dispatchEvent(params, eventArgs);
  }

  EventDispatcherStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  EventDispatcherStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEventDispatcher_DispatchEvent_Name:
      var params = reader.decodeStruct(EventDispatcher_DispatchEvent_Params);
      this.dispatchEvent(params.params, params.eventArgs).then(function(response) {
        var responseParams =
            new EventDispatcher_DispatchEvent_ResponseParams();
        responseParams.eventWillRunInLazyBackgroundPageScript = response.eventWillRunInLazyBackgroundPageScript;
        var builder = new codec.MessageV1Builder(
            kEventDispatcher_DispatchEvent_Name,
            codec.align(EventDispatcher_DispatchEvent_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(EventDispatcher_DispatchEvent_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateEventDispatcherRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kEventDispatcher_DispatchEvent_Name:
        if (message.expectsResponse())
          paramsClass = EventDispatcher_DispatchEvent_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateEventDispatcherResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kEventDispatcher_DispatchEvent_Name:
        if (message.isResponse())
          paramsClass = EventDispatcher_DispatchEvent_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var EventDispatcher = {
    name: 'extensions.mojom.EventDispatcher',
    kVersion: 0,
    ptrClass: EventDispatcherPtr,
    proxyClass: EventDispatcherProxy,
    stubClass: EventDispatcherStub,
    validateRequest: validateEventDispatcherRequest,
    validateResponse: validateEventDispatcherResponse,
  };
  EventDispatcherStub.prototype.validator = validateEventDispatcherRequest;
  EventDispatcherProxy.prototype.validator = validateEventDispatcherResponse;
  exports.EventFilteringInfo = EventFilteringInfo;
  exports.DispatchEventParams = DispatchEventParams;
  exports.EventDispatcher = EventDispatcher;
  exports.EventDispatcherPtr = EventDispatcherPtr;
  exports.EventDispatcherAssociatedPtr = EventDispatcherAssociatedPtr;
})();