// device/vr/public/mojom/xr_session.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_SEND_VALIDATION_H_
#define DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_SEND_VALIDATION_H_

#include "device/vr/public/mojom/xr_session.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "device/vr/public/mojom/xr_session.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::RequestSessionError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRSessionFeature, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRSessionMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRDepthUsage, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRDepthDataFormat, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRDepthType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRTrackedImageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRTrackedImageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRTrackedImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bitmap)::BaseType> bitmap_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::BitmapN32DataView, send_validation>(
        in_bitmap,
        bitmap_fragment);

      fragment->bitmap.Set(
          bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bitmap.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bitmap in XRTrackedImage struct");

      decltype(Traits::size_in_pixels(input)) in_size_in_pixels = Traits::size_in_pixels(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->size_in_pixels)::BaseType> size_in_pixels_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_size_in_pixels,
        size_in_pixels_fragment);

      fragment->size_in_pixels.Set(
          size_in_pixels_fragment.is_null() ? nullptr : size_in_pixels_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->size_in_pixels.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size_in_pixels in XRTrackedImage struct");

      fragment->width_in_meters = Traits::width_in_meters(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRDepthOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDepthOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::usage_preferences(input)) in_usage_preferences = Traits::usage_preferences(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->usage_preferences)::BaseType>
          usage_preferences_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& usage_preferences_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthUsage_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRDepthUsage>, send_validation>(
        in_usage_preferences,
        usage_preferences_fragment,
        &usage_preferences_validate_params);

      fragment->usage_preferences.Set(
          usage_preferences_fragment.is_null() ? nullptr : usage_preferences_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->usage_preferences.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null usage_preferences in XRDepthOptions struct");

      decltype(Traits::data_format_preferences(input)) in_data_format_preferences = Traits::data_format_preferences(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data_format_preferences)::BaseType>
          data_format_preferences_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& data_format_preferences_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthDataFormat_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRDepthDataFormat>, send_validation>(
        in_data_format_preferences,
        data_format_preferences_fragment,
        &data_format_preferences_validate_params);

      fragment->data_format_preferences.Set(
          data_format_preferences_fragment.is_null() ? nullptr : data_format_preferences_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data_format_preferences.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data_format_preferences in XRDepthOptions struct");

      decltype(Traits::depth_type_request(input)) in_depth_type_request = Traits::depth_type_request(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->depth_type_request)::BaseType>
          depth_type_request_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& depth_type_request_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthType_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRDepthType>, send_validation>(
        in_depth_type_request,
        depth_type_request_fragment,
        &depth_type_request_validate_params);

      fragment->depth_type_request.Set(
          depth_type_request_fragment.is_null() ? nullptr : depth_type_request_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->depth_type_request.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null depth_type_request in XRDepthOptions struct");

      fragment->match_depth_view = Traits::match_depth_view(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRSessionOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSessionOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRSessionOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::XRSessionMode>(
        Traits::mode(input),
        &fragment->mode);

      decltype(Traits::required_features(input)) in_required_features = Traits::required_features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->required_features)::BaseType>
          required_features_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& required_features_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>, send_validation>(
        in_required_features,
        required_features_fragment,
        &required_features_validate_params);

      fragment->required_features.Set(
          required_features_fragment.is_null() ? nullptr : required_features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->required_features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null required_features in XRSessionOptions struct");

      decltype(Traits::optional_features(input)) in_optional_features = Traits::optional_features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->optional_features)::BaseType>
          optional_features_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& optional_features_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>, send_validation>(
        in_optional_features,
        optional_features_fragment,
        &optional_features_validate_params);

      fragment->optional_features.Set(
          optional_features_fragment.is_null() ? nullptr : optional_features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->optional_features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null optional_features in XRSessionOptions struct");

      decltype(Traits::tracked_images(input)) in_tracked_images = Traits::tracked_images(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tracked_images)::BaseType>
          tracked_images_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& tracked_images_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>, send_validation>(
        in_tracked_images,
        tracked_images_fragment,
        &tracked_images_validate_params);

      fragment->tracked_images.Set(
          tracked_images_fragment.is_null() ? nullptr : tracked_images_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tracked_images.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tracked_images in XRSessionOptions struct");

      decltype(Traits::depth_options(input)) in_depth_options = Traits::depth_options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->depth_options)::BaseType> depth_options_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRDepthOptionsDataView, send_validation>(
        in_depth_options,
        depth_options_fragment);

      fragment->depth_options.Set(
          depth_options_fragment.is_null() ? nullptr : depth_options_fragment.data());

      fragment->trace_id = Traits::trace_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XrFrameStatisticsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XrFrameStatisticsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XrFrameStatistics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->trace_id = Traits::trace_id(input);

      decltype(Traits::duration(input)) in_duration = Traits::duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->duration)::BaseType> duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_duration,
        duration_fragment);

      fragment->duration.Set(
          duration_fragment.is_null() ? nullptr : duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in XrFrameStatistics struct");

      fragment->num_frames = Traits::num_frames(input);

      fragment->dropped_frames = Traits::dropped_frames(input);

      decltype(Traits::frame_data_time(input)) in_frame_data_time = Traits::frame_data_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_data_time)::BaseType> frame_data_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_frame_data_time,
        frame_data_time_fragment);

      fragment->frame_data_time.Set(
          frame_data_time_fragment.is_null() ? nullptr : frame_data_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_data_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_data_time in XrFrameStatistics struct");

      decltype(Traits::page_animation_frame_time(input)) in_page_animation_frame_time = Traits::page_animation_frame_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->page_animation_frame_time)::BaseType> page_animation_frame_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_page_animation_frame_time,
        page_animation_frame_time_fragment);

      fragment->page_animation_frame_time.Set(
          page_animation_frame_time_fragment.is_null() ? nullptr : page_animation_frame_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->page_animation_frame_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_animation_frame_time in XrFrameStatistics struct");

      decltype(Traits::submit_frame_time(input)) in_submit_frame_time = Traits::submit_frame_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->submit_frame_time)::BaseType> submit_frame_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_submit_frame_time,
        submit_frame_time_fragment);

      fragment->submit_frame_time.Set(
          submit_frame_time_fragment.is_null() ? nullptr : submit_frame_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->submit_frame_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null submit_frame_time in XrFrameStatistics struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XrLogMessageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XrLogMessageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XrLogMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->trace_id = Traits::trace_id(input);

      decltype(Traits::message(input)) in_message = Traits::message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->message)::BaseType> message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_message,
        message_fragment);

      fragment->message.Set(
          message_fragment.is_null() ? nullptr : message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in XrLogMessage struct");
  }
};

}  // namespace mojo::internal

#endif  // DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_SEND_VALIDATION_H_