// device/vr/public/mojom/browser_test_interfaces.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_H_
#define DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/browser_test_interfaces.mojom-features.h"  // IWYU pragma: export
#include "device/vr/public/mojom/browser_test_interfaces.mojom-shared.h"  // IWYU pragma: export
#include "device/vr/public/mojom/browser_test_interfaces.mojom-forward.h"  // IWYU pragma: export
#include "device/vr/public/mojom/openxr_interaction_profile_type.mojom-forward.h"
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/transform.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"




namespace device_test::mojom {

class XRTestHookProxy;

template <typename ImplRefTraits>
class XRTestHookStub;

class XRTestHookRequestValidator;
class XRTestHookResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) XRTestHook
    : public XRTestHookInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device_test.mojom.XRTestHook";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1, 
    2, 
    3, 
    4, 
    5, 
    6, 
    7, 
    8
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRTestHookInterfaceBase;
  using Proxy_ = XRTestHookProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRTestHookStub<ImplRefTraits>;

  using RequestValidator_ = XRTestHookRequestValidator;
  using ResponseValidator_ = XRTestHookResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnFrameSubmittedMinVersion = 0,
    kWaitGetDeviceConfigMinVersion = 0,
    kWaitGetPresentingPoseMinVersion = 0,
    kWaitGetMagicWindowPoseMinVersion = 0,
    kWaitGetControllerRoleForTrackedDeviceIndexMinVersion = 0,
    kWaitGetTrackedDeviceClassMinVersion = 0,
    kWaitGetControllerDataMinVersion = 0,
    kWaitGetEventDataMinVersion = 0,
    kWaitGetCanCreateSessionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFrameSubmitted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitGetDeviceConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitGetPresentingPose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitGetMagicWindowPose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitGetControllerRoleForTrackedDeviceIndex_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitGetTrackedDeviceClass_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitGetControllerData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitGetEventData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitGetCanCreateSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRTestHook() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool OnFrameSubmitted(std::vector<ViewDataPtr> frame_data);
  using OnFrameSubmittedCallback = base::OnceCallback<void()>;
  using OnFrameSubmittedMojoCallback = base::OnceCallback<void()>;

  virtual void OnFrameSubmitted(std::vector<ViewDataPtr> frame_data, OnFrameSubmittedCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitGetDeviceConfig(DeviceConfigPtr* out_config);
  using WaitGetDeviceConfigCallback = base::OnceCallback<void(DeviceConfigPtr)>;
  using WaitGetDeviceConfigMojoCallback = base::OnceCallback<void(DeviceConfigPtr)>;

  virtual void WaitGetDeviceConfig(WaitGetDeviceConfigCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitGetPresentingPose(PoseFrameDataPtr* out_data);
  using WaitGetPresentingPoseCallback = base::OnceCallback<void(PoseFrameDataPtr)>;
  using WaitGetPresentingPoseMojoCallback = base::OnceCallback<void(PoseFrameDataPtr)>;

  virtual void WaitGetPresentingPose(WaitGetPresentingPoseCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitGetMagicWindowPose(PoseFrameDataPtr* out_data);
  using WaitGetMagicWindowPoseCallback = base::OnceCallback<void(PoseFrameDataPtr)>;
  using WaitGetMagicWindowPoseMojoCallback = base::OnceCallback<void(PoseFrameDataPtr)>;

  virtual void WaitGetMagicWindowPose(WaitGetMagicWindowPoseCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitGetControllerRoleForTrackedDeviceIndex(uint32_t index, ControllerRole* out_role);
  using WaitGetControllerRoleForTrackedDeviceIndexCallback = base::OnceCallback<void(ControllerRole)>;
  using WaitGetControllerRoleForTrackedDeviceIndexMojoCallback = base::OnceCallback<void(ControllerRole)>;

  virtual void WaitGetControllerRoleForTrackedDeviceIndex(uint32_t index, WaitGetControllerRoleForTrackedDeviceIndexCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitGetTrackedDeviceClass(uint32_t index, TrackedDeviceClass* out_device_class);
  using WaitGetTrackedDeviceClassCallback = base::OnceCallback<void(TrackedDeviceClass)>;
  using WaitGetTrackedDeviceClassMojoCallback = base::OnceCallback<void(TrackedDeviceClass)>;

  virtual void WaitGetTrackedDeviceClass(uint32_t index, WaitGetTrackedDeviceClassCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitGetControllerData(uint32_t index, ControllerFrameDataPtr* out_data);
  using WaitGetControllerDataCallback = base::OnceCallback<void(ControllerFrameDataPtr)>;
  using WaitGetControllerDataMojoCallback = base::OnceCallback<void(ControllerFrameDataPtr)>;

  virtual void WaitGetControllerData(uint32_t index, WaitGetControllerDataCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitGetEventData(EventDataPtr* out_data);
  using WaitGetEventDataCallback = base::OnceCallback<void(EventDataPtr)>;
  using WaitGetEventDataMojoCallback = base::OnceCallback<void(EventDataPtr)>;

  virtual void WaitGetEventData(WaitGetEventDataCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WaitGetCanCreateSession(bool* out_can_create_session);
  using WaitGetCanCreateSessionCallback = base::OnceCallback<void(bool)>;
  using WaitGetCanCreateSessionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void WaitGetCanCreateSession(WaitGetCanCreateSessionCallback callback) = 0;
};

class XRServiceTestHookProxy;

template <typename ImplRefTraits>
class XRServiceTestHookStub;

class XRServiceTestHookRequestValidator;
class XRServiceTestHookResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) XRServiceTestHook
    : public XRServiceTestHookInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device_test.mojom.XRServiceTestHook";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRServiceTestHookInterfaceBase;
  using Proxy_ = XRServiceTestHookProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRServiceTestHookStub<ImplRefTraits>;

  using RequestValidator_ = XRServiceTestHookRequestValidator;
  using ResponseValidator_ = XRServiceTestHookResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetTestHookMinVersion = 0,
    kTerminateDeviceServiceProcessForTestingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetTestHook_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TerminateDeviceServiceProcessForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRServiceTestHook() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetTestHook(::mojo::PendingRemote<XRTestHook> hook);
  using SetTestHookCallback = base::OnceCallback<void()>;
  using SetTestHookMojoCallback = base::OnceCallback<void()>;

  virtual void SetTestHook(::mojo::PendingRemote<XRTestHook> hook, SetTestHookCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool TerminateDeviceServiceProcessForTesting();
  using TerminateDeviceServiceProcessForTestingCallback = base::OnceCallback<void()>;
  using TerminateDeviceServiceProcessForTestingMojoCallback = base::OnceCallback<void()>;

  virtual void TerminateDeviceServiceProcessForTesting(TerminateDeviceServiceProcessForTestingCallback callback) = 0;
};



class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) XRTestHookProxy
    : public XRTestHook {
 public:
  using InterfaceType = XRTestHook;

  explicit XRTestHookProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool OnFrameSubmitted(std::vector<ViewDataPtr> frame_data) final;
  
  void OnFrameSubmitted(std::vector<ViewDataPtr> frame_data, OnFrameSubmittedCallback callback) final;
  
  bool WaitGetDeviceConfig(DeviceConfigPtr* out_config) final;
  
  void WaitGetDeviceConfig(WaitGetDeviceConfigCallback callback) final;
  
  bool WaitGetPresentingPose(PoseFrameDataPtr* out_data) final;
  
  void WaitGetPresentingPose(WaitGetPresentingPoseCallback callback) final;
  
  bool WaitGetMagicWindowPose(PoseFrameDataPtr* out_data) final;
  
  void WaitGetMagicWindowPose(WaitGetMagicWindowPoseCallback callback) final;
  
  bool WaitGetControllerRoleForTrackedDeviceIndex(uint32_t index, ControllerRole* out_role) final;
  
  void WaitGetControllerRoleForTrackedDeviceIndex(uint32_t index, WaitGetControllerRoleForTrackedDeviceIndexCallback callback) final;
  
  bool WaitGetTrackedDeviceClass(uint32_t index, TrackedDeviceClass* out_device_class) final;
  
  void WaitGetTrackedDeviceClass(uint32_t index, WaitGetTrackedDeviceClassCallback callback) final;
  
  bool WaitGetControllerData(uint32_t index, ControllerFrameDataPtr* out_data) final;
  
  void WaitGetControllerData(uint32_t index, WaitGetControllerDataCallback callback) final;
  
  bool WaitGetEventData(EventDataPtr* out_data) final;
  
  void WaitGetEventData(WaitGetEventDataCallback callback) final;
  
  bool WaitGetCanCreateSession(bool* out_can_create_session) final;
  
  void WaitGetCanCreateSession(WaitGetCanCreateSessionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) XRServiceTestHookProxy
    : public XRServiceTestHook {
 public:
  using InterfaceType = XRServiceTestHook;

  explicit XRServiceTestHookProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool SetTestHook(::mojo::PendingRemote<XRTestHook> hook) final;
  
  void SetTestHook(::mojo::PendingRemote<XRTestHook> hook, SetTestHookCallback callback) final;
  
  bool TerminateDeviceServiceProcessForTesting() final;
  
  void TerminateDeviceServiceProcessForTesting(TerminateDeviceServiceProcessForTestingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) XRTestHookStubDispatch {
 public:
  static bool Accept(XRTestHook* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRTestHook* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRTestHook>>
class XRTestHookStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRTestHookStub() = default;
  ~XRTestHookStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRTestHookStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRTestHookStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) XRServiceTestHookStubDispatch {
 public:
  static bool Accept(XRServiceTestHook* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRServiceTestHook* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRServiceTestHook>>
class XRServiceTestHookStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRServiceTestHookStub() = default;
  ~XRServiceTestHookStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRServiceTestHookStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRServiceTestHookStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) XRTestHookRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) XRServiceTestHookRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) XRTestHookResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) XRServiceTestHookResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) Color {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Color, T>::value>;
  using DataView = ColorDataView;
  using Data_ = internal::Color_Data;

  template <typename... Args>
  static ColorPtr New(Args&&... args) {
    return ColorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ColorPtr From(const U& u) {
    return mojo::TypeConverter<ColorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Color>::Convert(*this);
  }


  Color();

  Color(
      uint8_t r,
      uint8_t g,
      uint8_t b,
      uint8_t a);


  ~Color();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ColorPtr>
  ColorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Color::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Color::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Color::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Color::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Color::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Color::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Color_UnserializedMessageContext<
            UserType, Color::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Color::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Color::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Color_UnserializedMessageContext<
            UserType, Color::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Color::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t r;
  
  uint8_t g;
  
  uint8_t b;
  
  uint8_t a;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Color::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Color::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Color::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Color::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) ProjectionRaw {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProjectionRaw, T>::value>;
  using DataView = ProjectionRawDataView;
  using Data_ = internal::ProjectionRaw_Data;

  template <typename... Args>
  static ProjectionRawPtr New(Args&&... args) {
    return ProjectionRawPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProjectionRawPtr From(const U& u) {
    return mojo::TypeConverter<ProjectionRawPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProjectionRaw>::Convert(*this);
  }


  ProjectionRaw();

  ProjectionRaw(
      float left,
      float right,
      float top,
      float bottom);


  ~ProjectionRaw();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProjectionRawPtr>
  ProjectionRawPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProjectionRaw::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProjectionRaw::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProjectionRaw::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProjectionRaw::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProjectionRaw::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProjectionRaw::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProjectionRaw_UnserializedMessageContext<
            UserType, ProjectionRaw::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProjectionRaw::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProjectionRaw::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProjectionRaw_UnserializedMessageContext<
            UserType, ProjectionRaw::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProjectionRaw::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float left;
  
  float right;
  
  float top;
  
  float bottom;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProjectionRaw::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProjectionRaw::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProjectionRaw::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProjectionRaw::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) ControllerAxisData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ControllerAxisData, T>::value>;
  using DataView = ControllerAxisDataDataView;
  using Data_ = internal::ControllerAxisData_Data;

  template <typename... Args>
  static ControllerAxisDataPtr New(Args&&... args) {
    return ControllerAxisDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ControllerAxisDataPtr From(const U& u) {
    return mojo::TypeConverter<ControllerAxisDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ControllerAxisData>::Convert(*this);
  }


  ControllerAxisData();

  ControllerAxisData(
      float x,
      float y,
      uint8_t axis_type);


  ~ControllerAxisData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ControllerAxisDataPtr>
  ControllerAxisDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ControllerAxisData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ControllerAxisData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ControllerAxisData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ControllerAxisData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ControllerAxisData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ControllerAxisData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ControllerAxisData_UnserializedMessageContext<
            UserType, ControllerAxisData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ControllerAxisData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ControllerAxisData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ControllerAxisData_UnserializedMessageContext<
            UserType, ControllerAxisData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ControllerAxisData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float y;
  
  uint8_t axis_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ControllerAxisData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ControllerAxisData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ControllerAxisData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ControllerAxisData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) EventData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EventData, T>::value>;
  using DataView = EventDataDataView;
  using Data_ = internal::EventData_Data;

  template <typename... Args>
  static EventDataPtr New(Args&&... args) {
    return EventDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EventDataPtr From(const U& u) {
    return mojo::TypeConverter<EventDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EventData>::Convert(*this);
  }


  EventData();

  EventData(
      EventType type,
      ::device::mojom::OpenXrInteractionProfileType interaction_profile);


  ~EventData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EventDataPtr>
  EventDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EventData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EventData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EventData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EventData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EventData_UnserializedMessageContext<
            UserType, EventData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EventData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EventData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EventData_UnserializedMessageContext<
            UserType, EventData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EventData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  EventType type;
  
  ::device::mojom::OpenXrInteractionProfileType interaction_profile;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EventData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EventData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EventData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EventData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) ViewData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewData, T>::value>;
  using DataView = ViewDataDataView;
  using Data_ = internal::ViewData_Data;

  template <typename... Args>
  static ViewDataPtr New(Args&&... args) {
    return ViewDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewDataPtr From(const U& u) {
    return mojo::TypeConverter<ViewDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewData>::Convert(*this);
  }


  ViewData();

  ViewData(
      ColorPtr color,
      Eye eye,
      const ::gfx::Rect& viewport);

ViewData(const ViewData&) = delete;
ViewData& operator=(const ViewData&) = delete;

  ~ViewData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewDataPtr>
  ViewDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewData_UnserializedMessageContext<
            UserType, ViewData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewData_UnserializedMessageContext<
            UserType, ViewData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ColorPtr color;
  
  Eye eye;
  
  ::gfx::Rect viewport;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) PoseFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PoseFrameData, T>::value>;
  using DataView = PoseFrameDataDataView;
  using Data_ = internal::PoseFrameData_Data;

  template <typename... Args>
  static PoseFrameDataPtr New(Args&&... args) {
    return PoseFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PoseFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<PoseFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PoseFrameData>::Convert(*this);
  }


  PoseFrameData();

  explicit PoseFrameData(
      const std::optional<::gfx::Transform>& device_to_origin);


  ~PoseFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PoseFrameDataPtr>
  PoseFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PoseFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PoseFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PoseFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PoseFrameData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PoseFrameData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PoseFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PoseFrameData_UnserializedMessageContext<
            UserType, PoseFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PoseFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PoseFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PoseFrameData_UnserializedMessageContext<
            UserType, PoseFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PoseFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::gfx::Transform> device_to_origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PoseFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PoseFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PoseFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PoseFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) DeviceConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceConfig, T>::value>;
  using DataView = DeviceConfigDataView;
  using Data_ = internal::DeviceConfig_Data;

  template <typename... Args>
  static DeviceConfigPtr New(Args&&... args) {
    return DeviceConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceConfigPtr From(const U& u) {
    return mojo::TypeConverter<DeviceConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceConfig>::Convert(*this);
  }


  DeviceConfig();

  DeviceConfig(
      float interpupillary_distance,
      ProjectionRawPtr projection_left,
      ProjectionRawPtr projection_right);

DeviceConfig(const DeviceConfig&) = delete;
DeviceConfig& operator=(const DeviceConfig&) = delete;

  ~DeviceConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceConfigPtr>
  DeviceConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceConfig_UnserializedMessageContext<
            UserType, DeviceConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceConfig_UnserializedMessageContext<
            UserType, DeviceConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float interpupillary_distance;
  
  ProjectionRawPtr projection_left;
  
  ProjectionRawPtr projection_right;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) ControllerFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ControllerFrameData, T>::value>;
  using DataView = ControllerFrameDataDataView;
  using Data_ = internal::ControllerFrameData_Data;

  template <typename... Args>
  static ControllerFrameDataPtr New(Args&&... args) {
    return ControllerFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ControllerFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<ControllerFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ControllerFrameData>::Convert(*this);
  }


  ControllerFrameData();

  ControllerFrameData(
      uint32_t packet_number,
      uint64_t buttons_pressed,
      uint64_t buttons_touched,
      uint64_t supported_buttons,
      std::vector<ControllerAxisDataPtr> axis_data,
      PoseFrameDataPtr pose_data,
      ControllerRole role,
      ::device::mojom::XRHandTrackingDataPtr hand_data,
      bool is_valid);

ControllerFrameData(const ControllerFrameData&) = delete;
ControllerFrameData& operator=(const ControllerFrameData&) = delete;

  ~ControllerFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ControllerFrameDataPtr>
  ControllerFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ControllerFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ControllerFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ControllerFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ControllerFrameData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ControllerFrameData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ControllerFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ControllerFrameData_UnserializedMessageContext<
            UserType, ControllerFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ControllerFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ControllerFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ControllerFrameData_UnserializedMessageContext<
            UserType, ControllerFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ControllerFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t packet_number;
  
  uint64_t buttons_pressed;
  
  uint64_t buttons_touched;
  
  uint64_t supported_buttons;
  
  std::vector<ControllerAxisDataPtr> axis_data;
  
  PoseFrameDataPtr pose_data;
  
  ControllerRole role;
  
  ::device::mojom::XRHandTrackingDataPtr hand_data;
  
  bool is_valid;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ControllerFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ControllerFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ControllerFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ControllerFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
ColorPtr Color::Clone() const {
  return New(
      mojo::Clone(r),
      mojo::Clone(g),
      mojo::Clone(b),
      mojo::Clone(a)
  );
}

template <typename T, Color::EnableIfSame<T>*>
bool Color::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->r, other_struct.r))
    return false;
  if (!mojo::Equals(this->g, other_struct.g))
    return false;
  if (!mojo::Equals(this->b, other_struct.b))
    return false;
  if (!mojo::Equals(this->a, other_struct.a))
    return false;
  return true;
}

template <typename T, Color::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.r < rhs.r)
    return true;
  if (rhs.r < lhs.r)
    return false;
  if (lhs.g < rhs.g)
    return true;
  if (rhs.g < lhs.g)
    return false;
  if (lhs.b < rhs.b)
    return true;
  if (rhs.b < lhs.b)
    return false;
  if (lhs.a < rhs.a)
    return true;
  if (rhs.a < lhs.a)
    return false;
  return false;
}
template <typename StructPtrType>
ViewDataPtr ViewData::Clone() const {
  return New(
      mojo::Clone(color),
      mojo::Clone(eye),
      mojo::Clone(viewport)
  );
}

template <typename T, ViewData::EnableIfSame<T>*>
bool ViewData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->eye, other_struct.eye))
    return false;
  if (!mojo::Equals(this->viewport, other_struct.viewport))
    return false;
  return true;
}

template <typename T, ViewData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.eye < rhs.eye)
    return true;
  if (rhs.eye < lhs.eye)
    return false;
  if (lhs.viewport < rhs.viewport)
    return true;
  if (rhs.viewport < lhs.viewport)
    return false;
  return false;
}
template <typename StructPtrType>
PoseFrameDataPtr PoseFrameData::Clone() const {
  return New(
      mojo::Clone(device_to_origin)
  );
}

template <typename T, PoseFrameData::EnableIfSame<T>*>
bool PoseFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_to_origin, other_struct.device_to_origin))
    return false;
  return true;
}

template <typename T, PoseFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_to_origin < rhs.device_to_origin)
    return true;
  if (rhs.device_to_origin < lhs.device_to_origin)
    return false;
  return false;
}
template <typename StructPtrType>
ProjectionRawPtr ProjectionRaw::Clone() const {
  return New(
      mojo::Clone(left),
      mojo::Clone(right),
      mojo::Clone(top),
      mojo::Clone(bottom)
  );
}

template <typename T, ProjectionRaw::EnableIfSame<T>*>
bool ProjectionRaw::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->left, other_struct.left))
    return false;
  if (!mojo::Equals(this->right, other_struct.right))
    return false;
  if (!mojo::Equals(this->top, other_struct.top))
    return false;
  if (!mojo::Equals(this->bottom, other_struct.bottom))
    return false;
  return true;
}

template <typename T, ProjectionRaw::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.left < rhs.left)
    return true;
  if (rhs.left < lhs.left)
    return false;
  if (lhs.right < rhs.right)
    return true;
  if (rhs.right < lhs.right)
    return false;
  if (lhs.top < rhs.top)
    return true;
  if (rhs.top < lhs.top)
    return false;
  if (lhs.bottom < rhs.bottom)
    return true;
  if (rhs.bottom < lhs.bottom)
    return false;
  return false;
}
template <typename StructPtrType>
DeviceConfigPtr DeviceConfig::Clone() const {
  return New(
      mojo::Clone(interpupillary_distance),
      mojo::Clone(projection_left),
      mojo::Clone(projection_right)
  );
}

template <typename T, DeviceConfig::EnableIfSame<T>*>
bool DeviceConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interpupillary_distance, other_struct.interpupillary_distance))
    return false;
  if (!mojo::Equals(this->projection_left, other_struct.projection_left))
    return false;
  if (!mojo::Equals(this->projection_right, other_struct.projection_right))
    return false;
  return true;
}

template <typename T, DeviceConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.interpupillary_distance < rhs.interpupillary_distance)
    return true;
  if (rhs.interpupillary_distance < lhs.interpupillary_distance)
    return false;
  if (lhs.projection_left < rhs.projection_left)
    return true;
  if (rhs.projection_left < lhs.projection_left)
    return false;
  if (lhs.projection_right < rhs.projection_right)
    return true;
  if (rhs.projection_right < lhs.projection_right)
    return false;
  return false;
}
template <typename StructPtrType>
ControllerAxisDataPtr ControllerAxisData::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(axis_type)
  );
}

template <typename T, ControllerAxisData::EnableIfSame<T>*>
bool ControllerAxisData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->axis_type, other_struct.axis_type))
    return false;
  return true;
}

template <typename T, ControllerAxisData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.axis_type < rhs.axis_type)
    return true;
  if (rhs.axis_type < lhs.axis_type)
    return false;
  return false;
}
template <typename StructPtrType>
ControllerFrameDataPtr ControllerFrameData::Clone() const {
  return New(
      mojo::Clone(packet_number),
      mojo::Clone(buttons_pressed),
      mojo::Clone(buttons_touched),
      mojo::Clone(supported_buttons),
      mojo::Clone(axis_data),
      mojo::Clone(pose_data),
      mojo::Clone(role),
      mojo::Clone(hand_data),
      mojo::Clone(is_valid)
  );
}

template <typename T, ControllerFrameData::EnableIfSame<T>*>
bool ControllerFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->packet_number, other_struct.packet_number))
    return false;
  if (!mojo::Equals(this->buttons_pressed, other_struct.buttons_pressed))
    return false;
  if (!mojo::Equals(this->buttons_touched, other_struct.buttons_touched))
    return false;
  if (!mojo::Equals(this->supported_buttons, other_struct.supported_buttons))
    return false;
  if (!mojo::Equals(this->axis_data, other_struct.axis_data))
    return false;
  if (!mojo::Equals(this->pose_data, other_struct.pose_data))
    return false;
  if (!mojo::Equals(this->role, other_struct.role))
    return false;
  if (!mojo::Equals(this->hand_data, other_struct.hand_data))
    return false;
  if (!mojo::Equals(this->is_valid, other_struct.is_valid))
    return false;
  return true;
}

template <typename T, ControllerFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.packet_number < rhs.packet_number)
    return true;
  if (rhs.packet_number < lhs.packet_number)
    return false;
  if (lhs.buttons_pressed < rhs.buttons_pressed)
    return true;
  if (rhs.buttons_pressed < lhs.buttons_pressed)
    return false;
  if (lhs.buttons_touched < rhs.buttons_touched)
    return true;
  if (rhs.buttons_touched < lhs.buttons_touched)
    return false;
  if (lhs.supported_buttons < rhs.supported_buttons)
    return true;
  if (rhs.supported_buttons < lhs.supported_buttons)
    return false;
  if (lhs.axis_data < rhs.axis_data)
    return true;
  if (rhs.axis_data < lhs.axis_data)
    return false;
  if (lhs.pose_data < rhs.pose_data)
    return true;
  if (rhs.pose_data < lhs.pose_data)
    return false;
  if (lhs.role < rhs.role)
    return true;
  if (rhs.role < lhs.role)
    return false;
  if (lhs.hand_data < rhs.hand_data)
    return true;
  if (rhs.hand_data < lhs.hand_data)
    return false;
  if (lhs.is_valid < rhs.is_valid)
    return true;
  if (rhs.is_valid < lhs.is_valid)
    return false;
  return false;
}
template <typename StructPtrType>
EventDataPtr EventData::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(interaction_profile)
  );
}

template <typename T, EventData::EnableIfSame<T>*>
bool EventData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->interaction_profile, other_struct.interaction_profile))
    return false;
  return true;
}

template <typename T, EventData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.interaction_profile < rhs.interaction_profile)
    return true;
  if (rhs.interaction_profile < lhs.interaction_profile)
    return false;
  return false;
}


}  // device_test::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) StructTraits<::device_test::mojom::Color::DataView,
                                         ::device_test::mojom::ColorPtr> {
  static bool IsNull(const ::device_test::mojom::ColorPtr& input) { return !input; }
  static void SetToNull(::device_test::mojom::ColorPtr* output) { output->reset(); }

  static decltype(::device_test::mojom::Color::r) r(
      const ::device_test::mojom::ColorPtr& input) {
    return input->r;
  }

  static decltype(::device_test::mojom::Color::g) g(
      const ::device_test::mojom::ColorPtr& input) {
    return input->g;
  }

  static decltype(::device_test::mojom::Color::b) b(
      const ::device_test::mojom::ColorPtr& input) {
    return input->b;
  }

  static decltype(::device_test::mojom::Color::a) a(
      const ::device_test::mojom::ColorPtr& input) {
    return input->a;
  }

  static bool Read(::device_test::mojom::Color::DataView input, ::device_test::mojom::ColorPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) StructTraits<::device_test::mojom::ViewData::DataView,
                                         ::device_test::mojom::ViewDataPtr> {
  static bool IsNull(const ::device_test::mojom::ViewDataPtr& input) { return !input; }
  static void SetToNull(::device_test::mojom::ViewDataPtr* output) { output->reset(); }

  static const decltype(::device_test::mojom::ViewData::color)& color(
      const ::device_test::mojom::ViewDataPtr& input) {
    return input->color;
  }

  static decltype(::device_test::mojom::ViewData::eye) eye(
      const ::device_test::mojom::ViewDataPtr& input) {
    return input->eye;
  }

  static const decltype(::device_test::mojom::ViewData::viewport)& viewport(
      const ::device_test::mojom::ViewDataPtr& input) {
    return input->viewport;
  }

  static bool Read(::device_test::mojom::ViewData::DataView input, ::device_test::mojom::ViewDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) StructTraits<::device_test::mojom::PoseFrameData::DataView,
                                         ::device_test::mojom::PoseFrameDataPtr> {
  static bool IsNull(const ::device_test::mojom::PoseFrameDataPtr& input) { return !input; }
  static void SetToNull(::device_test::mojom::PoseFrameDataPtr* output) { output->reset(); }

  static const decltype(::device_test::mojom::PoseFrameData::device_to_origin)& device_to_origin(
      const ::device_test::mojom::PoseFrameDataPtr& input) {
    return input->device_to_origin;
  }

  static bool Read(::device_test::mojom::PoseFrameData::DataView input, ::device_test::mojom::PoseFrameDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) StructTraits<::device_test::mojom::ProjectionRaw::DataView,
                                         ::device_test::mojom::ProjectionRawPtr> {
  static bool IsNull(const ::device_test::mojom::ProjectionRawPtr& input) { return !input; }
  static void SetToNull(::device_test::mojom::ProjectionRawPtr* output) { output->reset(); }

  static decltype(::device_test::mojom::ProjectionRaw::left) left(
      const ::device_test::mojom::ProjectionRawPtr& input) {
    return input->left;
  }

  static decltype(::device_test::mojom::ProjectionRaw::right) right(
      const ::device_test::mojom::ProjectionRawPtr& input) {
    return input->right;
  }

  static decltype(::device_test::mojom::ProjectionRaw::top) top(
      const ::device_test::mojom::ProjectionRawPtr& input) {
    return input->top;
  }

  static decltype(::device_test::mojom::ProjectionRaw::bottom) bottom(
      const ::device_test::mojom::ProjectionRawPtr& input) {
    return input->bottom;
  }

  static bool Read(::device_test::mojom::ProjectionRaw::DataView input, ::device_test::mojom::ProjectionRawPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) StructTraits<::device_test::mojom::DeviceConfig::DataView,
                                         ::device_test::mojom::DeviceConfigPtr> {
  static bool IsNull(const ::device_test::mojom::DeviceConfigPtr& input) { return !input; }
  static void SetToNull(::device_test::mojom::DeviceConfigPtr* output) { output->reset(); }

  static decltype(::device_test::mojom::DeviceConfig::interpupillary_distance) interpupillary_distance(
      const ::device_test::mojom::DeviceConfigPtr& input) {
    return input->interpupillary_distance;
  }

  static const decltype(::device_test::mojom::DeviceConfig::projection_left)& projection_left(
      const ::device_test::mojom::DeviceConfigPtr& input) {
    return input->projection_left;
  }

  static const decltype(::device_test::mojom::DeviceConfig::projection_right)& projection_right(
      const ::device_test::mojom::DeviceConfigPtr& input) {
    return input->projection_right;
  }

  static bool Read(::device_test::mojom::DeviceConfig::DataView input, ::device_test::mojom::DeviceConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) StructTraits<::device_test::mojom::ControllerAxisData::DataView,
                                         ::device_test::mojom::ControllerAxisDataPtr> {
  static bool IsNull(const ::device_test::mojom::ControllerAxisDataPtr& input) { return !input; }
  static void SetToNull(::device_test::mojom::ControllerAxisDataPtr* output) { output->reset(); }

  static decltype(::device_test::mojom::ControllerAxisData::x) x(
      const ::device_test::mojom::ControllerAxisDataPtr& input) {
    return input->x;
  }

  static decltype(::device_test::mojom::ControllerAxisData::y) y(
      const ::device_test::mojom::ControllerAxisDataPtr& input) {
    return input->y;
  }

  static decltype(::device_test::mojom::ControllerAxisData::axis_type) axis_type(
      const ::device_test::mojom::ControllerAxisDataPtr& input) {
    return input->axis_type;
  }

  static bool Read(::device_test::mojom::ControllerAxisData::DataView input, ::device_test::mojom::ControllerAxisDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) StructTraits<::device_test::mojom::ControllerFrameData::DataView,
                                         ::device_test::mojom::ControllerFrameDataPtr> {
  static bool IsNull(const ::device_test::mojom::ControllerFrameDataPtr& input) { return !input; }
  static void SetToNull(::device_test::mojom::ControllerFrameDataPtr* output) { output->reset(); }

  static decltype(::device_test::mojom::ControllerFrameData::packet_number) packet_number(
      const ::device_test::mojom::ControllerFrameDataPtr& input) {
    return input->packet_number;
  }

  static decltype(::device_test::mojom::ControllerFrameData::buttons_pressed) buttons_pressed(
      const ::device_test::mojom::ControllerFrameDataPtr& input) {
    return input->buttons_pressed;
  }

  static decltype(::device_test::mojom::ControllerFrameData::buttons_touched) buttons_touched(
      const ::device_test::mojom::ControllerFrameDataPtr& input) {
    return input->buttons_touched;
  }

  static decltype(::device_test::mojom::ControllerFrameData::supported_buttons) supported_buttons(
      const ::device_test::mojom::ControllerFrameDataPtr& input) {
    return input->supported_buttons;
  }

  static const decltype(::device_test::mojom::ControllerFrameData::axis_data)& axis_data(
      const ::device_test::mojom::ControllerFrameDataPtr& input) {
    return input->axis_data;
  }

  static const decltype(::device_test::mojom::ControllerFrameData::pose_data)& pose_data(
      const ::device_test::mojom::ControllerFrameDataPtr& input) {
    return input->pose_data;
  }

  static decltype(::device_test::mojom::ControllerFrameData::role) role(
      const ::device_test::mojom::ControllerFrameDataPtr& input) {
    return input->role;
  }

  static const decltype(::device_test::mojom::ControllerFrameData::hand_data)& hand_data(
      const ::device_test::mojom::ControllerFrameDataPtr& input) {
    return input->hand_data;
  }

  static decltype(::device_test::mojom::ControllerFrameData::is_valid) is_valid(
      const ::device_test::mojom::ControllerFrameDataPtr& input) {
    return input->is_valid;
  }

  static bool Read(::device_test::mojom::ControllerFrameData::DataView input, ::device_test::mojom::ControllerFrameDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS) StructTraits<::device_test::mojom::EventData::DataView,
                                         ::device_test::mojom::EventDataPtr> {
  static bool IsNull(const ::device_test::mojom::EventDataPtr& input) { return !input; }
  static void SetToNull(::device_test::mojom::EventDataPtr* output) { output->reset(); }

  static decltype(::device_test::mojom::EventData::type) type(
      const ::device_test::mojom::EventDataPtr& input) {
    return input->type;
  }

  static decltype(::device_test::mojom::EventData::interaction_profile) interaction_profile(
      const ::device_test::mojom::EventDataPtr& input) {
    return input->interaction_profile;
  }

  static bool Read(::device_test::mojom::EventData::DataView input, ::device_test::mojom::EventDataPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_H_