// device/vr/public/mojom/browser_test_interfaces.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/vr/public/mojom/browser_test_interfaces.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/browser_test_interfaces.mojom-params-data.h"
#include "device/vr/public/mojom/browser_test_interfaces.mojom-shared-message-ids.h"

#include "device/vr/public/mojom/browser_test_interfaces.mojom-import-headers.h"
#include "device/vr/public/mojom/browser_test_interfaces.mojom-test-utils.h"


namespace device_test::mojom {
Color::Color()
    : r(),
      g(),
      b(),
      a() {}

Color::Color(
    uint8_t r_in,
    uint8_t g_in,
    uint8_t b_in,
    uint8_t a_in)
    : r(std::move(r_in)),
      g(std::move(g_in)),
      b(std::move(b_in)),
      a(std::move(a_in)) {}

Color::~Color() = default;
size_t Color::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->r);
  seed = mojo::internal::Hash(seed, this->g);
  seed = mojo::internal::Hash(seed, this->b);
  seed = mojo::internal::Hash(seed, this->a);
  return seed;
}

void Color::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "r"), this->r,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "g"), this->g,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "b"), this->b,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "a"), this->a,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Color::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ViewData::ViewData()
    : color(),
      eye(),
      viewport() {}

ViewData::ViewData(
    ColorPtr color_in,
    Eye eye_in,
    const ::gfx::Rect& viewport_in)
    : color(std::move(color_in)),
      eye(std::move(eye_in)),
      viewport(std::move(viewport_in)) {}

ViewData::~ViewData() = default;

void ViewData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ColorPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "eye"), this->eye,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Eye>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport"), this->viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ViewData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PoseFrameData::PoseFrameData()
    : device_to_origin() {}

PoseFrameData::PoseFrameData(
    const std::optional<::gfx::Transform>& device_to_origin_in)
    : device_to_origin(std::move(device_to_origin_in)) {}

PoseFrameData::~PoseFrameData() = default;

void PoseFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_to_origin"), this->device_to_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Transform>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PoseFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProjectionRaw::ProjectionRaw()
    : left(),
      right(),
      top(),
      bottom() {}

ProjectionRaw::ProjectionRaw(
    float left_in,
    float right_in,
    float top_in,
    float bottom_in)
    : left(std::move(left_in)),
      right(std::move(right_in)),
      top(std::move(top_in)),
      bottom(std::move(bottom_in)) {}

ProjectionRaw::~ProjectionRaw() = default;
size_t ProjectionRaw::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->left);
  seed = mojo::internal::Hash(seed, this->right);
  seed = mojo::internal::Hash(seed, this->top);
  seed = mojo::internal::Hash(seed, this->bottom);
  return seed;
}

void ProjectionRaw::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left"), this->left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right"), this->right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top"), this->top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom"), this->bottom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProjectionRaw::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeviceConfig::DeviceConfig()
    : interpupillary_distance(),
      projection_left(),
      projection_right() {}

DeviceConfig::DeviceConfig(
    float interpupillary_distance_in,
    ProjectionRawPtr projection_left_in,
    ProjectionRawPtr projection_right_in)
    : interpupillary_distance(std::move(interpupillary_distance_in)),
      projection_left(std::move(projection_left_in)),
      projection_right(std::move(projection_right_in)) {}

DeviceConfig::~DeviceConfig() = default;
size_t DeviceConfig::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->interpupillary_distance);
  seed = mojo::internal::Hash(seed, this->projection_left);
  seed = mojo::internal::Hash(seed, this->projection_right);
  return seed;
}

void DeviceConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interpupillary_distance"), this->interpupillary_distance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "projection_left"), this->projection_left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProjectionRawPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "projection_right"), this->projection_right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProjectionRawPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DeviceConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ControllerAxisData::ControllerAxisData()
    : x(),
      y(),
      axis_type() {}

ControllerAxisData::ControllerAxisData(
    float x_in,
    float y_in,
    uint8_t axis_type_in)
    : x(std::move(x_in)),
      y(std::move(y_in)),
      axis_type(std::move(axis_type_in)) {}

ControllerAxisData::~ControllerAxisData() = default;
size_t ControllerAxisData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->x);
  seed = mojo::internal::Hash(seed, this->y);
  seed = mojo::internal::Hash(seed, this->axis_type);
  return seed;
}

void ControllerAxisData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis_type"), this->axis_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ControllerAxisData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ControllerFrameData::ControllerFrameData()
    : packet_number(),
      buttons_pressed(),
      buttons_touched(),
      supported_buttons(),
      axis_data(),
      pose_data(),
      role(ControllerRole::kControllerRoleInvalid),
      hand_data(),
      is_valid() {}

ControllerFrameData::ControllerFrameData(
    uint32_t packet_number_in,
    uint64_t buttons_pressed_in,
    uint64_t buttons_touched_in,
    uint64_t supported_buttons_in,
    std::vector<ControllerAxisDataPtr> axis_data_in,
    PoseFrameDataPtr pose_data_in,
    ControllerRole role_in,
    ::device::mojom::XRHandTrackingDataPtr hand_data_in,
    bool is_valid_in)
    : packet_number(std::move(packet_number_in)),
      buttons_pressed(std::move(buttons_pressed_in)),
      buttons_touched(std::move(buttons_touched_in)),
      supported_buttons(std::move(supported_buttons_in)),
      axis_data(std::move(axis_data_in)),
      pose_data(std::move(pose_data_in)),
      role(std::move(role_in)),
      hand_data(std::move(hand_data_in)),
      is_valid(std::move(is_valid_in)) {}

ControllerFrameData::~ControllerFrameData() = default;

void ControllerFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "packet_number"), this->packet_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buttons_pressed"), this->buttons_pressed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buttons_touched"), this->buttons_touched,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_buttons"), this->supported_buttons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis_data"), this->axis_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ControllerAxisDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pose_data"), this->pose_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PoseFrameDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "role"), this->role,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ControllerRole>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hand_data"), this->hand_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::XRHandTrackingDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_valid"), this->is_valid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ControllerFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EventData::EventData()
    : type(EventType::kNoEvent),
      interaction_profile(::device::mojom::OpenXrInteractionProfileType::kInvalid) {}

EventData::EventData(
    EventType type_in,
    ::device::mojom::OpenXrInteractionProfileType interaction_profile_in)
    : type(std::move(type_in)),
      interaction_profile(std::move(interaction_profile_in)) {}

EventData::~EventData() = default;
size_t EventData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->interaction_profile);
  return seed;
}

void EventData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EventType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interaction_profile"), this->interaction_profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::OpenXrInteractionProfileType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EventData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

XRTestHook::IPCStableHashFunction XRTestHook::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRTestHook>(message.name())) {
    case messages::XRTestHook::kOnFrameSubmitted: {
      return &XRTestHook::OnFrameSubmitted_Sym::IPCStableHash;
    }
    case messages::XRTestHook::kWaitGetDeviceConfig: {
      return &XRTestHook::WaitGetDeviceConfig_Sym::IPCStableHash;
    }
    case messages::XRTestHook::kWaitGetPresentingPose: {
      return &XRTestHook::WaitGetPresentingPose_Sym::IPCStableHash;
    }
    case messages::XRTestHook::kWaitGetMagicWindowPose: {
      return &XRTestHook::WaitGetMagicWindowPose_Sym::IPCStableHash;
    }
    case messages::XRTestHook::kWaitGetControllerRoleForTrackedDeviceIndex: {
      return &XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex_Sym::IPCStableHash;
    }
    case messages::XRTestHook::kWaitGetTrackedDeviceClass: {
      return &XRTestHook::WaitGetTrackedDeviceClass_Sym::IPCStableHash;
    }
    case messages::XRTestHook::kWaitGetControllerData: {
      return &XRTestHook::WaitGetControllerData_Sym::IPCStableHash;
    }
    case messages::XRTestHook::kWaitGetEventData: {
      return &XRTestHook::WaitGetEventData_Sym::IPCStableHash;
    }
    case messages::XRTestHook::kWaitGetCanCreateSession: {
      return &XRTestHook::WaitGetCanCreateSession_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRTestHook::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRTestHook>(message.name())) {
      case messages::XRTestHook::kOnFrameSubmitted:
            return "Receive device_test::mojom::XRTestHook::OnFrameSubmitted";
      case messages::XRTestHook::kWaitGetDeviceConfig:
            return "Receive device_test::mojom::XRTestHook::WaitGetDeviceConfig";
      case messages::XRTestHook::kWaitGetPresentingPose:
            return "Receive device_test::mojom::XRTestHook::WaitGetPresentingPose";
      case messages::XRTestHook::kWaitGetMagicWindowPose:
            return "Receive device_test::mojom::XRTestHook::WaitGetMagicWindowPose";
      case messages::XRTestHook::kWaitGetControllerRoleForTrackedDeviceIndex:
            return "Receive device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex";
      case messages::XRTestHook::kWaitGetTrackedDeviceClass:
            return "Receive device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass";
      case messages::XRTestHook::kWaitGetControllerData:
            return "Receive device_test::mojom::XRTestHook::WaitGetControllerData";
      case messages::XRTestHook::kWaitGetEventData:
            return "Receive device_test::mojom::XRTestHook::WaitGetEventData";
      case messages::XRTestHook::kWaitGetCanCreateSession:
            return "Receive device_test::mojom::XRTestHook::WaitGetCanCreateSession";
    }
  } else {
    switch (static_cast<messages::XRTestHook>(message.name())) {
      case messages::XRTestHook::kOnFrameSubmitted:
            return "Receive reply device_test::mojom::XRTestHook::OnFrameSubmitted";
      case messages::XRTestHook::kWaitGetDeviceConfig:
            return "Receive reply device_test::mojom::XRTestHook::WaitGetDeviceConfig";
      case messages::XRTestHook::kWaitGetPresentingPose:
            return "Receive reply device_test::mojom::XRTestHook::WaitGetPresentingPose";
      case messages::XRTestHook::kWaitGetMagicWindowPose:
            return "Receive reply device_test::mojom::XRTestHook::WaitGetMagicWindowPose";
      case messages::XRTestHook::kWaitGetControllerRoleForTrackedDeviceIndex:
            return "Receive reply device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex";
      case messages::XRTestHook::kWaitGetTrackedDeviceClass:
            return "Receive reply device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass";
      case messages::XRTestHook::kWaitGetControllerData:
            return "Receive reply device_test::mojom::XRTestHook::WaitGetControllerData";
      case messages::XRTestHook::kWaitGetEventData:
            return "Receive reply device_test::mojom::XRTestHook::WaitGetEventData";
      case messages::XRTestHook::kWaitGetCanCreateSession:
            return "Receive reply device_test::mojom::XRTestHook::WaitGetCanCreateSession";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRTestHook::OnFrameSubmitted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x37fbe44b;  // IPCStableHash for device_test::mojom::XRTestHook::OnFrameSubmitted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRTestHook::WaitGetDeviceConfig_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6acc342c;  // IPCStableHash for device_test::mojom::XRTestHook::WaitGetDeviceConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRTestHook::WaitGetPresentingPose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ee6f7af;  // IPCStableHash for device_test::mojom::XRTestHook::WaitGetPresentingPose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRTestHook::WaitGetMagicWindowPose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13fefe0f;  // IPCStableHash for device_test::mojom::XRTestHook::WaitGetMagicWindowPose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2a176eb1;  // IPCStableHash for device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRTestHook::WaitGetTrackedDeviceClass_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xadafe81c;  // IPCStableHash for device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRTestHook::WaitGetControllerData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a2dae24;  // IPCStableHash for device_test::mojom::XRTestHook::WaitGetControllerData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRTestHook::WaitGetEventData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54ed9e67;  // IPCStableHash for device_test::mojom::XRTestHook::WaitGetEventData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRTestHook::WaitGetCanCreateSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b60cb43;  // IPCStableHash for device_test::mojom::XRTestHook::WaitGetCanCreateSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool XRTestHook::OnFrameSubmitted(std::vector<ViewDataPtr> frame_data) {
  NOTREACHED();
}
bool XRTestHook::WaitGetDeviceConfig(DeviceConfigPtr* out_config) {
  NOTREACHED();
}
bool XRTestHook::WaitGetPresentingPose(PoseFrameDataPtr* out_data) {
  NOTREACHED();
}
bool XRTestHook::WaitGetMagicWindowPose(PoseFrameDataPtr* out_data) {
  NOTREACHED();
}
bool XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex(uint32_t index, ControllerRole* out_role) {
  NOTREACHED();
}
bool XRTestHook::WaitGetTrackedDeviceClass(uint32_t index, TrackedDeviceClass* out_device_class) {
  NOTREACHED();
}
bool XRTestHook::WaitGetControllerData(uint32_t index, ControllerFrameDataPtr* out_data) {
  NOTREACHED();
}
bool XRTestHook::WaitGetEventData(EventDataPtr* out_data) {
  NOTREACHED();
}
bool XRTestHook::WaitGetCanCreateSession(bool* out_can_create_session) {
  NOTREACHED();
}
class XRTestHook_OnFrameSubmitted_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_OnFrameSubmitted_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  XRTestHook_OnFrameSubmitted_HandleSyncResponse(const XRTestHook_OnFrameSubmitted_HandleSyncResponse&) = delete;
  XRTestHook_OnFrameSubmitted_HandleSyncResponse& operator=(const XRTestHook_OnFrameSubmitted_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class XRTestHook_OnFrameSubmitted_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_OnFrameSubmitted_ForwardToCallback(
      XRTestHook::OnFrameSubmittedCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRTestHook_OnFrameSubmitted_ForwardToCallback(const XRTestHook_OnFrameSubmitted_ForwardToCallback&) = delete;
  XRTestHook_OnFrameSubmitted_ForwardToCallback& operator=(const XRTestHook_OnFrameSubmitted_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::OnFrameSubmittedCallback callback_;
};
class XRTestHook_WaitGetDeviceConfig_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetDeviceConfig_HandleSyncResponse(
      bool* result, DeviceConfigPtr* out_config)
      : result_(result), out_config_(out_config) {
    DCHECK(!*result_);
  }

  XRTestHook_WaitGetDeviceConfig_HandleSyncResponse(const XRTestHook_WaitGetDeviceConfig_HandleSyncResponse&) = delete;
  XRTestHook_WaitGetDeviceConfig_HandleSyncResponse& operator=(const XRTestHook_WaitGetDeviceConfig_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  DeviceConfigPtr* out_config_;};

class XRTestHook_WaitGetDeviceConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetDeviceConfig_ForwardToCallback(
      XRTestHook::WaitGetDeviceConfigCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRTestHook_WaitGetDeviceConfig_ForwardToCallback(const XRTestHook_WaitGetDeviceConfig_ForwardToCallback&) = delete;
  XRTestHook_WaitGetDeviceConfig_ForwardToCallback& operator=(const XRTestHook_WaitGetDeviceConfig_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetDeviceConfigCallback callback_;
};
class XRTestHook_WaitGetPresentingPose_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetPresentingPose_HandleSyncResponse(
      bool* result, PoseFrameDataPtr* out_data)
      : result_(result), out_data_(out_data) {
    DCHECK(!*result_);
  }

  XRTestHook_WaitGetPresentingPose_HandleSyncResponse(const XRTestHook_WaitGetPresentingPose_HandleSyncResponse&) = delete;
  XRTestHook_WaitGetPresentingPose_HandleSyncResponse& operator=(const XRTestHook_WaitGetPresentingPose_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PoseFrameDataPtr* out_data_;};

class XRTestHook_WaitGetPresentingPose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetPresentingPose_ForwardToCallback(
      XRTestHook::WaitGetPresentingPoseCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRTestHook_WaitGetPresentingPose_ForwardToCallback(const XRTestHook_WaitGetPresentingPose_ForwardToCallback&) = delete;
  XRTestHook_WaitGetPresentingPose_ForwardToCallback& operator=(const XRTestHook_WaitGetPresentingPose_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetPresentingPoseCallback callback_;
};
class XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse(
      bool* result, PoseFrameDataPtr* out_data)
      : result_(result), out_data_(out_data) {
    DCHECK(!*result_);
  }

  XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse(const XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse&) = delete;
  XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse& operator=(const XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PoseFrameDataPtr* out_data_;};

class XRTestHook_WaitGetMagicWindowPose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetMagicWindowPose_ForwardToCallback(
      XRTestHook::WaitGetMagicWindowPoseCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRTestHook_WaitGetMagicWindowPose_ForwardToCallback(const XRTestHook_WaitGetMagicWindowPose_ForwardToCallback&) = delete;
  XRTestHook_WaitGetMagicWindowPose_ForwardToCallback& operator=(const XRTestHook_WaitGetMagicWindowPose_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetMagicWindowPoseCallback callback_;
};
class XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse(
      bool* result, ControllerRole* out_role)
      : result_(result), out_role_(out_role) {
    DCHECK(!*result_);
  }

  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse(const XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse&) = delete;
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse& operator=(const XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ControllerRole* out_role_;};

class XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback(
      XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback(const XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback&) = delete;
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback& operator=(const XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback callback_;
};
class XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse(
      bool* result, TrackedDeviceClass* out_device_class)
      : result_(result), out_device_class_(out_device_class) {
    DCHECK(!*result_);
  }

  XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse(const XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse&) = delete;
  XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse& operator=(const XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  TrackedDeviceClass* out_device_class_;};

class XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback(
      XRTestHook::WaitGetTrackedDeviceClassCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback(const XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback&) = delete;
  XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback& operator=(const XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetTrackedDeviceClassCallback callback_;
};
class XRTestHook_WaitGetControllerData_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetControllerData_HandleSyncResponse(
      bool* result, ControllerFrameDataPtr* out_data)
      : result_(result), out_data_(out_data) {
    DCHECK(!*result_);
  }

  XRTestHook_WaitGetControllerData_HandleSyncResponse(const XRTestHook_WaitGetControllerData_HandleSyncResponse&) = delete;
  XRTestHook_WaitGetControllerData_HandleSyncResponse& operator=(const XRTestHook_WaitGetControllerData_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ControllerFrameDataPtr* out_data_;};

class XRTestHook_WaitGetControllerData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetControllerData_ForwardToCallback(
      XRTestHook::WaitGetControllerDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRTestHook_WaitGetControllerData_ForwardToCallback(const XRTestHook_WaitGetControllerData_ForwardToCallback&) = delete;
  XRTestHook_WaitGetControllerData_ForwardToCallback& operator=(const XRTestHook_WaitGetControllerData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetControllerDataCallback callback_;
};
class XRTestHook_WaitGetEventData_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetEventData_HandleSyncResponse(
      bool* result, EventDataPtr* out_data)
      : result_(result), out_data_(out_data) {
    DCHECK(!*result_);
  }

  XRTestHook_WaitGetEventData_HandleSyncResponse(const XRTestHook_WaitGetEventData_HandleSyncResponse&) = delete;
  XRTestHook_WaitGetEventData_HandleSyncResponse& operator=(const XRTestHook_WaitGetEventData_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  EventDataPtr* out_data_;};

class XRTestHook_WaitGetEventData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetEventData_ForwardToCallback(
      XRTestHook::WaitGetEventDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRTestHook_WaitGetEventData_ForwardToCallback(const XRTestHook_WaitGetEventData_ForwardToCallback&) = delete;
  XRTestHook_WaitGetEventData_ForwardToCallback& operator=(const XRTestHook_WaitGetEventData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetEventDataCallback callback_;
};
class XRTestHook_WaitGetCanCreateSession_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetCanCreateSession_HandleSyncResponse(
      bool* result, bool* out_can_create_session)
      : result_(result), out_can_create_session_(out_can_create_session) {
    DCHECK(!*result_);
  }

  XRTestHook_WaitGetCanCreateSession_HandleSyncResponse(const XRTestHook_WaitGetCanCreateSession_HandleSyncResponse&) = delete;
  XRTestHook_WaitGetCanCreateSession_HandleSyncResponse& operator=(const XRTestHook_WaitGetCanCreateSession_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_can_create_session_;};

class XRTestHook_WaitGetCanCreateSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRTestHook_WaitGetCanCreateSession_ForwardToCallback(
      XRTestHook::WaitGetCanCreateSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRTestHook_WaitGetCanCreateSession_ForwardToCallback(const XRTestHook_WaitGetCanCreateSession_ForwardToCallback&) = delete;
  XRTestHook_WaitGetCanCreateSession_ForwardToCallback& operator=(const XRTestHook_WaitGetCanCreateSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRTestHook::WaitGetCanCreateSessionCallback callback_;
};

XRTestHookProxy::XRTestHookProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool XRTestHookProxy::OnFrameSubmitted(
    std::vector<ViewDataPtr> param_frame_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call device_test::mojom::XRTestHook::OnFrameSubmitted (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_data"), param_frame_data,
                        "<value of type std::vector<ViewDataPtr>>");
   });
#else
  TRACE_EVENT0("mojom", "XRTestHook::OnFrameSubmitted");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kOnFrameSubmitted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_OnFrameSubmitted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_data)::BaseType>
      frame_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& frame_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device_test::mojom::ViewDataDataView>>(
    param_frame_data,
    frame_data_fragment,
    &frame_data_validate_params);

  params->frame_data.Set(
      frame_data_fragment.is_null() ? nullptr : frame_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_data in XRTestHook.OnFrameSubmitted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("OnFrameSubmitted");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_OnFrameSubmitted_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "XRTestHook::OnFrameSubmitted");
#endif
  return result;
}

void XRTestHookProxy::OnFrameSubmitted(
    std::vector<ViewDataPtr> in_frame_data, OnFrameSubmittedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device_test::mojom::XRTestHook::OnFrameSubmitted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_data"), in_frame_data,
                        "<value of type std::vector<ViewDataPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kOnFrameSubmitted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_OnFrameSubmitted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_data)::BaseType>
      frame_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& frame_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device_test::mojom::ViewDataDataView>>(
    in_frame_data,
    frame_data_fragment,
    &frame_data_validate_params);

  params->frame_data.Set(
      frame_data_fragment.is_null() ? nullptr : frame_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_data in XRTestHook.OnFrameSubmitted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("OnFrameSubmitted");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_OnFrameSubmitted_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool XRTestHookProxy::WaitGetDeviceConfig(
    DeviceConfigPtr* out_param_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call device_test::mojom::XRTestHook::WaitGetDeviceConfig (sync)");
#else
  TRACE_EVENT0("mojom", "XRTestHook::WaitGetDeviceConfig");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetDeviceConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetDeviceConfig_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetDeviceConfig");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetDeviceConfig_HandleSyncResponse(
          &result, out_param_config));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "XRTestHook::WaitGetDeviceConfig", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), out_param_config,
                        "<value of type DeviceConfigPtr>");
   });
#endif
  return result;
}

void XRTestHookProxy::WaitGetDeviceConfig(
    WaitGetDeviceConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device_test::mojom::XRTestHook::WaitGetDeviceConfig");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetDeviceConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetDeviceConfig_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetDeviceConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetDeviceConfig_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool XRTestHookProxy::WaitGetPresentingPose(
    PoseFrameDataPtr* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call device_test::mojom::XRTestHook::WaitGetPresentingPose (sync)");
#else
  TRACE_EVENT0("mojom", "XRTestHook::WaitGetPresentingPose");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetPresentingPose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetPresentingPose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetPresentingPose");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetPresentingPose_HandleSyncResponse(
          &result, out_param_data));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "XRTestHook::WaitGetPresentingPose", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), out_param_data,
                        "<value of type PoseFrameDataPtr>");
   });
#endif
  return result;
}

void XRTestHookProxy::WaitGetPresentingPose(
    WaitGetPresentingPoseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device_test::mojom::XRTestHook::WaitGetPresentingPose");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetPresentingPose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetPresentingPose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetPresentingPose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetPresentingPose_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool XRTestHookProxy::WaitGetMagicWindowPose(
    PoseFrameDataPtr* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call device_test::mojom::XRTestHook::WaitGetMagicWindowPose (sync)");
#else
  TRACE_EVENT0("mojom", "XRTestHook::WaitGetMagicWindowPose");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetMagicWindowPose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetMagicWindowPose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetMagicWindowPose");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse(
          &result, out_param_data));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "XRTestHook::WaitGetMagicWindowPose", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), out_param_data,
                        "<value of type PoseFrameDataPtr>");
   });
#endif
  return result;
}

void XRTestHookProxy::WaitGetMagicWindowPose(
    WaitGetMagicWindowPoseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device_test::mojom::XRTestHook::WaitGetMagicWindowPose");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetMagicWindowPose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetMagicWindowPose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetMagicWindowPose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetMagicWindowPose_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool XRTestHookProxy::WaitGetControllerRoleForTrackedDeviceIndex(
    uint32_t param_index, ControllerRole* out_param_role) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), param_index,
                        "<value of type uint32_t>");
   });
#else
  TRACE_EVENT0("mojom", "XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetControllerRoleForTrackedDeviceIndex), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data> params(
          message);
  params.Allocate();

  params->index = param_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerRoleForTrackedDeviceIndex");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse(
          &result, out_param_role));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("role"), out_param_role,
                        "<value of type ControllerRole>");
   });
#endif
  return result;
}

void XRTestHookProxy::WaitGetControllerRoleForTrackedDeviceIndex(
    uint32_t in_index, WaitGetControllerRoleForTrackedDeviceIndexCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetControllerRoleForTrackedDeviceIndex), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerRoleForTrackedDeviceIndex");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool XRTestHookProxy::WaitGetTrackedDeviceClass(
    uint32_t param_index, TrackedDeviceClass* out_param_device_class) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), param_index,
                        "<value of type uint32_t>");
   });
#else
  TRACE_EVENT0("mojom", "XRTestHook::WaitGetTrackedDeviceClass");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetTrackedDeviceClass), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetTrackedDeviceClass_Params_Data> params(
          message);
  params.Allocate();

  params->index = param_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetTrackedDeviceClass");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse(
          &result, out_param_device_class));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "XRTestHook::WaitGetTrackedDeviceClass", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_class"), out_param_device_class,
                        "<value of type TrackedDeviceClass>");
   });
#endif
  return result;
}

void XRTestHookProxy::WaitGetTrackedDeviceClass(
    uint32_t in_index, WaitGetTrackedDeviceClassCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetTrackedDeviceClass), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetTrackedDeviceClass_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetTrackedDeviceClass");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool XRTestHookProxy::WaitGetControllerData(
    uint32_t param_index, ControllerFrameDataPtr* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call device_test::mojom::XRTestHook::WaitGetControllerData (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), param_index,
                        "<value of type uint32_t>");
   });
#else
  TRACE_EVENT0("mojom", "XRTestHook::WaitGetControllerData");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetControllerData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetControllerData_Params_Data> params(
          message);
  params.Allocate();

  params->index = param_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerData");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetControllerData_HandleSyncResponse(
          &result, out_param_data));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "XRTestHook::WaitGetControllerData", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), out_param_data,
                        "<value of type ControllerFrameDataPtr>");
   });
#endif
  return result;
}

void XRTestHookProxy::WaitGetControllerData(
    uint32_t in_index, WaitGetControllerDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device_test::mojom::XRTestHook::WaitGetControllerData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetControllerData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetControllerData_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetControllerData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool XRTestHookProxy::WaitGetEventData(
    EventDataPtr* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call device_test::mojom::XRTestHook::WaitGetEventData (sync)");
#else
  TRACE_EVENT0("mojom", "XRTestHook::WaitGetEventData");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetEventData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetEventData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetEventData");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetEventData_HandleSyncResponse(
          &result, out_param_data));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "XRTestHook::WaitGetEventData", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), out_param_data,
                        "<value of type EventDataPtr>");
   });
#endif
  return result;
}

void XRTestHookProxy::WaitGetEventData(
    WaitGetEventDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device_test::mojom::XRTestHook::WaitGetEventData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetEventData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetEventData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetEventData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetEventData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool XRTestHookProxy::WaitGetCanCreateSession(
    bool* out_param_can_create_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call device_test::mojom::XRTestHook::WaitGetCanCreateSession (sync)");
#else
  TRACE_EVENT0("mojom", "XRTestHook::WaitGetCanCreateSession");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetCanCreateSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetCanCreateSession_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetCanCreateSession");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetCanCreateSession_HandleSyncResponse(
          &result, out_param_can_create_session));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "XRTestHook::WaitGetCanCreateSession", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_create_session"), out_param_can_create_session,
                        "<value of type bool>");
   });
#endif
  return result;
}

void XRTestHookProxy::WaitGetCanCreateSession(
    WaitGetCanCreateSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device_test::mojom::XRTestHook::WaitGetCanCreateSession");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetCanCreateSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetCanCreateSession_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetCanCreateSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRTestHook_WaitGetCanCreateSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class XRTestHook_OnFrameSubmitted_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRTestHook::OnFrameSubmittedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRTestHook_OnFrameSubmitted_ProxyToResponder> proxy(
        new XRTestHook_OnFrameSubmitted_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRTestHook_OnFrameSubmitted_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_OnFrameSubmitted_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRTestHook_OnFrameSubmitted_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRTestHook::OnFrameSubmittedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool XRTestHook_OnFrameSubmitted_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRTestHook.0
  bool success = true;
  XRTestHook_OnFrameSubmitted_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void XRTestHook_OnFrameSubmitted_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device_test::mojom::XRTestHook::OnFrameSubmitted");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kOnFrameSubmitted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("OnFrameSubmitted");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_OnFrameSubmitted_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRTestHook.0
  bool success = true;
  XRTestHook_OnFrameSubmitted_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 0, true);
    return false;
  }
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetDeviceConfig_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRTestHook::WaitGetDeviceConfigCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRTestHook_WaitGetDeviceConfig_ProxyToResponder> proxy(
        new XRTestHook_WaitGetDeviceConfig_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRTestHook_WaitGetDeviceConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetDeviceConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRTestHook_WaitGetDeviceConfig_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRTestHook::WaitGetDeviceConfigCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceConfigPtr in_config);
};

bool XRTestHook_WaitGetDeviceConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRTestHook.1
  bool success = true;
  DeviceConfigPtr p_config{};
  XRTestHook_WaitGetDeviceConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_config));
  }
  return true;
}

void XRTestHook_WaitGetDeviceConfig_ProxyToResponder::Run(
    DeviceConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device_test::mojom::XRTestHook::WaitGetDeviceConfig", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type DeviceConfigPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetDeviceConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::device_test::mojom::DeviceConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetDeviceConfig");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetDeviceConfig_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRTestHook.1
  bool success = true;
  DeviceConfigPtr p_config{};
  XRTestHook_WaitGetDeviceConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 1, true);
    return false;
  }
  *out_config_ = std::move(p_config);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetPresentingPose_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRTestHook::WaitGetPresentingPoseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRTestHook_WaitGetPresentingPose_ProxyToResponder> proxy(
        new XRTestHook_WaitGetPresentingPose_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRTestHook_WaitGetPresentingPose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetPresentingPose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRTestHook_WaitGetPresentingPose_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRTestHook::WaitGetPresentingPoseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PoseFrameDataPtr in_data);
};

bool XRTestHook_WaitGetPresentingPose_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRTestHook.2
  bool success = true;
  PoseFrameDataPtr p_data{};
  XRTestHook_WaitGetPresentingPose_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void XRTestHook_WaitGetPresentingPose_ProxyToResponder::Run(
    PoseFrameDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device_test::mojom::XRTestHook::WaitGetPresentingPose", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type PoseFrameDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetPresentingPose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::device_test::mojom::PoseFrameDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetPresentingPose");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetPresentingPose_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRTestHook.2
  bool success = true;
  PoseFrameDataPtr p_data{};
  XRTestHook_WaitGetPresentingPose_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 2, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetMagicWindowPose_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRTestHook::WaitGetMagicWindowPoseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRTestHook_WaitGetMagicWindowPose_ProxyToResponder> proxy(
        new XRTestHook_WaitGetMagicWindowPose_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRTestHook_WaitGetMagicWindowPose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetMagicWindowPose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRTestHook_WaitGetMagicWindowPose_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRTestHook::WaitGetMagicWindowPoseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PoseFrameDataPtr in_data);
};

bool XRTestHook_WaitGetMagicWindowPose_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRTestHook.3
  bool success = true;
  PoseFrameDataPtr p_data{};
  XRTestHook_WaitGetMagicWindowPose_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void XRTestHook_WaitGetMagicWindowPose_ProxyToResponder::Run(
    PoseFrameDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device_test::mojom::XRTestHook::WaitGetMagicWindowPose", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type PoseFrameDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetMagicWindowPose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::device_test::mojom::PoseFrameDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetMagicWindowPose");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetMagicWindowPose_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRTestHook.3
  bool success = true;
  PoseFrameDataPtr p_data{};
  XRTestHook_WaitGetMagicWindowPose_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 3, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder> proxy(
        new XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRTestHook::WaitGetControllerRoleForTrackedDeviceIndexCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ControllerRole in_role);
};

bool XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRTestHook.4
  bool success = true;
  ControllerRole p_role{};
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRole(&p_role))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_role));
  }
  return true;
}

void XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder::Run(
    ControllerRole in_role) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device_test::mojom::XRTestHook::WaitGetControllerRoleForTrackedDeviceIndex", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("role"), in_role,
                        "<value of type ControllerRole>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetControllerRoleForTrackedDeviceIndex), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device_test::mojom::ControllerRole>(
    in_role,
    &params->role);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerRoleForTrackedDeviceIndex");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRTestHook.4
  bool success = true;
  ControllerRole p_role{};
  XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRole(&p_role))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 4, true);
    return false;
  }
  *out_role_ = std::move(p_role);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRTestHook::WaitGetTrackedDeviceClassCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder> proxy(
        new XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRTestHook::WaitGetTrackedDeviceClassCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TrackedDeviceClass in_device_class);
};

bool XRTestHook_WaitGetTrackedDeviceClass_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRTestHook.5
  bool success = true;
  TrackedDeviceClass p_device_class{};
  XRTestHook_WaitGetTrackedDeviceClass_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDeviceClass(&p_device_class))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_device_class));
  }
  return true;
}

void XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder::Run(
    TrackedDeviceClass in_device_class) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device_test::mojom::XRTestHook::WaitGetTrackedDeviceClass", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_class"), in_device_class,
                        "<value of type TrackedDeviceClass>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetTrackedDeviceClass), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device_test::mojom::TrackedDeviceClass>(
    in_device_class,
    &params->device_class);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetTrackedDeviceClass");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetTrackedDeviceClass_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRTestHook.5
  bool success = true;
  TrackedDeviceClass p_device_class{};
  XRTestHook_WaitGetTrackedDeviceClass_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDeviceClass(&p_device_class))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 5, true);
    return false;
  }
  *out_device_class_ = std::move(p_device_class);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetControllerData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRTestHook::WaitGetControllerDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRTestHook_WaitGetControllerData_ProxyToResponder> proxy(
        new XRTestHook_WaitGetControllerData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRTestHook_WaitGetControllerData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetControllerData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRTestHook_WaitGetControllerData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRTestHook::WaitGetControllerDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ControllerFrameDataPtr in_data);
};

bool XRTestHook_WaitGetControllerData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetControllerData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetControllerData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRTestHook.6
  bool success = true;
  ControllerFrameDataPtr p_data{};
  XRTestHook_WaitGetControllerData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void XRTestHook_WaitGetControllerData_ProxyToResponder::Run(
    ControllerFrameDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device_test::mojom::XRTestHook::WaitGetControllerData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ControllerFrameDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetControllerData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetControllerData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::device_test::mojom::ControllerFrameDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetControllerData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetControllerData_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetControllerData_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetControllerData_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRTestHook.6
  bool success = true;
  ControllerFrameDataPtr p_data{};
  XRTestHook_WaitGetControllerData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 6, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetEventData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRTestHook::WaitGetEventDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRTestHook_WaitGetEventData_ProxyToResponder> proxy(
        new XRTestHook_WaitGetEventData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRTestHook_WaitGetEventData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetEventData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRTestHook_WaitGetEventData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRTestHook::WaitGetEventDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      EventDataPtr in_data);
};

bool XRTestHook_WaitGetEventData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetEventData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetEventData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRTestHook.7
  bool success = true;
  EventDataPtr p_data{};
  XRTestHook_WaitGetEventData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void XRTestHook_WaitGetEventData_ProxyToResponder::Run(
    EventDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device_test::mojom::XRTestHook::WaitGetEventData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type EventDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetEventData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetEventData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::device_test::mojom::EventDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetEventData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetEventData_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetEventData_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetEventData_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRTestHook.7
  bool success = true;
  EventDataPtr p_data{};
  XRTestHook_WaitGetEventData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 7, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  *result_ = true;
  return true;
}
class XRTestHook_WaitGetCanCreateSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRTestHook::WaitGetCanCreateSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRTestHook_WaitGetCanCreateSession_ProxyToResponder> proxy(
        new XRTestHook_WaitGetCanCreateSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRTestHook_WaitGetCanCreateSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRTestHook_WaitGetCanCreateSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRTestHook_WaitGetCanCreateSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRTestHook::WaitGetCanCreateSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_can_create_session);
};

bool XRTestHook_WaitGetCanCreateSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetCanCreateSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRTestHook_WaitGetCanCreateSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRTestHook.8
  bool success = true;
  bool p_can_create_session{};
  XRTestHook_WaitGetCanCreateSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_can_create_session = input_data_view.can_create_session();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_can_create_session));
  }
  return true;
}

void XRTestHook_WaitGetCanCreateSession_ProxyToResponder::Run(
    bool in_can_create_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device_test::mojom::XRTestHook::WaitGetCanCreateSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_create_session"), in_can_create_session,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRTestHook::kWaitGetCanCreateSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRTestHook_WaitGetCanCreateSession_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->can_create_session = in_can_create_session;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRTestHook::Name_);
  message.set_method_name("WaitGetCanCreateSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRTestHook_WaitGetCanCreateSession_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRTestHook_WaitGetCanCreateSession_ResponseParams_Data* params =
      reinterpret_cast<internal::XRTestHook_WaitGetCanCreateSession_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRTestHook.8
  bool success = true;
  bool p_can_create_session{};
  XRTestHook_WaitGetCanCreateSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_can_create_session = input_data_view.can_create_session();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRTestHook::Name_, 8, true);
    return false;
  }
  *out_can_create_session_ = std::move(p_can_create_session);
  *result_ = true;
  return true;
}

// static
bool XRTestHookStubDispatch::Accept(
    XRTestHook* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRTestHook>(message->header()->name)) {
    case messages::XRTestHook::kOnFrameSubmitted: {
      break;
    }
    case messages::XRTestHook::kWaitGetDeviceConfig: {
      break;
    }
    case messages::XRTestHook::kWaitGetPresentingPose: {
      break;
    }
    case messages::XRTestHook::kWaitGetMagicWindowPose: {
      break;
    }
    case messages::XRTestHook::kWaitGetControllerRoleForTrackedDeviceIndex: {
      break;
    }
    case messages::XRTestHook::kWaitGetTrackedDeviceClass: {
      break;
    }
    case messages::XRTestHook::kWaitGetControllerData: {
      break;
    }
    case messages::XRTestHook::kWaitGetEventData: {
      break;
    }
    case messages::XRTestHook::kWaitGetCanCreateSession: {
      break;
    }
  }
  return false;
}

// static
bool XRTestHookStubDispatch::AcceptWithResponder(
    XRTestHook* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRTestHook>(message->header()->name)) {
    case messages::XRTestHook::kOnFrameSubmitted: {
      internal::XRTestHook_OnFrameSubmitted_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_OnFrameSubmitted_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRTestHook.0
      bool success = true;
      std::vector<ViewDataPtr> p_frame_data{};
      XRTestHook_OnFrameSubmitted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameData(&p_frame_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 0, false);
        return false;
      }
      auto callback =
          XRTestHook_OnFrameSubmitted_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameSubmitted(        
        std::move(p_frame_data), std::move(callback));
      return true;
    }
    case messages::XRTestHook::kWaitGetDeviceConfig: {
      internal::XRTestHook_WaitGetDeviceConfig_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetDeviceConfig_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRTestHook.1
      bool success = true;
      XRTestHook_WaitGetDeviceConfig_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 1, false);
        return false;
      }
      auto callback =
          XRTestHook_WaitGetDeviceConfig_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetDeviceConfig(std::move(callback));
      return true;
    }
    case messages::XRTestHook::kWaitGetPresentingPose: {
      internal::XRTestHook_WaitGetPresentingPose_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetPresentingPose_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRTestHook.2
      bool success = true;
      XRTestHook_WaitGetPresentingPose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 2, false);
        return false;
      }
      auto callback =
          XRTestHook_WaitGetPresentingPose_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetPresentingPose(std::move(callback));
      return true;
    }
    case messages::XRTestHook::kWaitGetMagicWindowPose: {
      internal::XRTestHook_WaitGetMagicWindowPose_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetMagicWindowPose_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRTestHook.3
      bool success = true;
      XRTestHook_WaitGetMagicWindowPose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 3, false);
        return false;
      }
      auto callback =
          XRTestHook_WaitGetMagicWindowPose_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetMagicWindowPose(std::move(callback));
      return true;
    }
    case messages::XRTestHook::kWaitGetControllerRoleForTrackedDeviceIndex: {
      internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRTestHook.4
      bool success = true;
      uint32_t p_index{};
      XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 4, false);
        return false;
      }
      auto callback =
          XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetControllerRoleForTrackedDeviceIndex(        
        std::move(p_index), std::move(callback));
      return true;
    }
    case messages::XRTestHook::kWaitGetTrackedDeviceClass: {
      internal::XRTestHook_WaitGetTrackedDeviceClass_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetTrackedDeviceClass_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRTestHook.5
      bool success = true;
      uint32_t p_index{};
      XRTestHook_WaitGetTrackedDeviceClass_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 5, false);
        return false;
      }
      auto callback =
          XRTestHook_WaitGetTrackedDeviceClass_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetTrackedDeviceClass(        
        std::move(p_index), std::move(callback));
      return true;
    }
    case messages::XRTestHook::kWaitGetControllerData: {
      internal::XRTestHook_WaitGetControllerData_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetControllerData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRTestHook.6
      bool success = true;
      uint32_t p_index{};
      XRTestHook_WaitGetControllerData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 6, false);
        return false;
      }
      auto callback =
          XRTestHook_WaitGetControllerData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetControllerData(        
        std::move(p_index), std::move(callback));
      return true;
    }
    case messages::XRTestHook::kWaitGetEventData: {
      internal::XRTestHook_WaitGetEventData_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetEventData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRTestHook.7
      bool success = true;
      XRTestHook_WaitGetEventData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 7, false);
        return false;
      }
      auto callback =
          XRTestHook_WaitGetEventData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetEventData(std::move(callback));
      return true;
    }
    case messages::XRTestHook::kWaitGetCanCreateSession: {
      internal::XRTestHook_WaitGetCanCreateSession_Params_Data* params =
          reinterpret_cast<
              internal::XRTestHook_WaitGetCanCreateSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRTestHook.8
      bool success = true;
      XRTestHook_WaitGetCanCreateSession_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRTestHook::Name_, 8, false);
        return false;
      }
      auto callback =
          XRTestHook_WaitGetCanCreateSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitGetCanCreateSession(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRTestHookValidationInfo[] = {
    { &internal::XRTestHook_OnFrameSubmitted_Params_Data::Validate,
     &internal::XRTestHook_OnFrameSubmitted_ResponseParams_Data::Validate},
    { &internal::XRTestHook_WaitGetDeviceConfig_Params_Data::Validate,
     &internal::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data::Validate},
    { &internal::XRTestHook_WaitGetPresentingPose_Params_Data::Validate,
     &internal::XRTestHook_WaitGetPresentingPose_ResponseParams_Data::Validate},
    { &internal::XRTestHook_WaitGetMagicWindowPose_Params_Data::Validate,
     &internal::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data::Validate},
    { &internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data::Validate,
     &internal::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data::Validate},
    { &internal::XRTestHook_WaitGetTrackedDeviceClass_Params_Data::Validate,
     &internal::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data::Validate},
    { &internal::XRTestHook_WaitGetControllerData_Params_Data::Validate,
     &internal::XRTestHook_WaitGetControllerData_ResponseParams_Data::Validate},
    { &internal::XRTestHook_WaitGetEventData_Params_Data::Validate,
     &internal::XRTestHook_WaitGetEventData_ResponseParams_Data::Validate},
    { &internal::XRTestHook_WaitGetCanCreateSession_Params_Data::Validate,
     &internal::XRTestHook_WaitGetCanCreateSession_ResponseParams_Data::Validate},
};

bool XRTestHookRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device_test::mojom::XRTestHook::Name_,
    kXRTestHookValidationInfo);
}

bool XRTestHookResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device_test::mojom::XRTestHook::Name_,
    kXRTestHookValidationInfo);
}
// The declaration includes the definition on other builds.

XRServiceTestHook::IPCStableHashFunction XRServiceTestHook::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::XRServiceTestHook>(message.name())) {
    case messages::XRServiceTestHook::kSetTestHook: {
      return &XRServiceTestHook::SetTestHook_Sym::IPCStableHash;
    }
    case messages::XRServiceTestHook::kTerminateDeviceServiceProcessForTesting: {
      return &XRServiceTestHook::TerminateDeviceServiceProcessForTesting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* XRServiceTestHook::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::XRServiceTestHook>(message.name())) {
      case messages::XRServiceTestHook::kSetTestHook:
            return "Receive device_test::mojom::XRServiceTestHook::SetTestHook";
      case messages::XRServiceTestHook::kTerminateDeviceServiceProcessForTesting:
            return "Receive device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting";
    }
  } else {
    switch (static_cast<messages::XRServiceTestHook>(message.name())) {
      case messages::XRServiceTestHook::kSetTestHook:
            return "Receive reply device_test::mojom::XRServiceTestHook::SetTestHook";
      case messages::XRServiceTestHook::kTerminateDeviceServiceProcessForTesting:
            return "Receive reply device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t XRServiceTestHook::SetTestHook_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x88428ddf;  // IPCStableHash for device_test::mojom::XRServiceTestHook::SetTestHook
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t XRServiceTestHook::TerminateDeviceServiceProcessForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3aed7166;  // IPCStableHash for device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool XRServiceTestHook::SetTestHook(::mojo::PendingRemote<XRTestHook> hook) {
  NOTREACHED();
}
bool XRServiceTestHook::TerminateDeviceServiceProcessForTesting() {
  NOTREACHED();
}
class XRServiceTestHook_SetTestHook_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRServiceTestHook_SetTestHook_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  XRServiceTestHook_SetTestHook_HandleSyncResponse(const XRServiceTestHook_SetTestHook_HandleSyncResponse&) = delete;
  XRServiceTestHook_SetTestHook_HandleSyncResponse& operator=(const XRServiceTestHook_SetTestHook_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class XRServiceTestHook_SetTestHook_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRServiceTestHook_SetTestHook_ForwardToCallback(
      XRServiceTestHook::SetTestHookCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRServiceTestHook_SetTestHook_ForwardToCallback(const XRServiceTestHook_SetTestHook_ForwardToCallback&) = delete;
  XRServiceTestHook_SetTestHook_ForwardToCallback& operator=(const XRServiceTestHook_SetTestHook_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRServiceTestHook::SetTestHookCallback callback_;
};
class XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse(const XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse&) = delete;
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse& operator=(const XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback(
      XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback(const XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback&) = delete;
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback& operator=(const XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback callback_;
};

XRServiceTestHookProxy::XRServiceTestHookProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool XRServiceTestHookProxy::SetTestHook(
    ::mojo::PendingRemote<XRTestHook> param_hook) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call device_test::mojom::XRServiceTestHook::SetTestHook (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hook"), param_hook,
                        "<value of type ::mojo::PendingRemote<XRTestHook>>");
   });
#else
  TRACE_EVENT0("mojom", "XRServiceTestHook::SetTestHook");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRServiceTestHook::kSetTestHook), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRServiceTestHook_SetTestHook_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device_test::mojom::XRTestHookInterfaceBase>>(
    param_hook,
    &params->hook,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("SetTestHook");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRServiceTestHook_SetTestHook_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "XRServiceTestHook::SetTestHook");
#endif
  return result;
}

void XRServiceTestHookProxy::SetTestHook(
    ::mojo::PendingRemote<XRTestHook> in_hook, SetTestHookCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device_test::mojom::XRServiceTestHook::SetTestHook", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hook"), in_hook,
                        "<value of type ::mojo::PendingRemote<XRTestHook>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRServiceTestHook::kSetTestHook), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRServiceTestHook_SetTestHook_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device_test::mojom::XRTestHookInterfaceBase>>(
    in_hook,
    &params->hook,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("SetTestHook");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRServiceTestHook_SetTestHook_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool XRServiceTestHookProxy::TerminateDeviceServiceProcessForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting (sync)");
#else
  TRACE_EVENT0("mojom", "XRServiceTestHook::TerminateDeviceServiceProcessForTesting");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRServiceTestHook::kTerminateDeviceServiceProcessForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("TerminateDeviceServiceProcessForTesting");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "XRServiceTestHook::TerminateDeviceServiceProcessForTesting");
#endif
  return result;
}

void XRServiceTestHookProxy::TerminateDeviceServiceProcessForTesting(
    TerminateDeviceServiceProcessForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRServiceTestHook::kTerminateDeviceServiceProcessForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("TerminateDeviceServiceProcessForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class XRServiceTestHook_SetTestHook_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRServiceTestHook::SetTestHookCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRServiceTestHook_SetTestHook_ProxyToResponder> proxy(
        new XRServiceTestHook_SetTestHook_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRServiceTestHook_SetTestHook_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRServiceTestHook_SetTestHook_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRServiceTestHook_SetTestHook_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRServiceTestHook::SetTestHookCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool XRServiceTestHook_SetTestHook_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRServiceTestHook_SetTestHook_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRServiceTestHook_SetTestHook_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRServiceTestHook.0
  bool success = true;
  XRServiceTestHook_SetTestHook_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRServiceTestHook::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void XRServiceTestHook_SetTestHook_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device_test::mojom::XRServiceTestHook::SetTestHook");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRServiceTestHook::kSetTestHook), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRServiceTestHook_SetTestHook_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("SetTestHook");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRServiceTestHook_SetTestHook_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRServiceTestHook_SetTestHook_ResponseParams_Data* params =
      reinterpret_cast<internal::XRServiceTestHook_SetTestHook_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRServiceTestHook.0
  bool success = true;
  XRServiceTestHook_SetTestHook_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRServiceTestHook::Name_, 0, true);
    return false;
  }
  *result_ = true;
  return true;
}
class XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder> proxy(
        new XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "XRServiceTestHook::TerminateDeviceServiceProcessForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for XRServiceTestHook.1
  bool success = true;
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRServiceTestHook::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device_test::mojom::XRServiceTestHook::TerminateDeviceServiceProcessForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::XRServiceTestHook::kTerminateDeviceServiceProcessForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device_test::mojom::internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRServiceTestHook::Name_);
  message.set_method_name("TerminateDeviceServiceProcessForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool XRServiceTestHook_TerminateDeviceServiceProcessForTesting_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data* params =
      reinterpret_cast<internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for XRServiceTestHook.1
  bool success = true;
  XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRServiceTestHook::Name_, 1, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool XRServiceTestHookStubDispatch::Accept(
    XRServiceTestHook* impl,
    mojo::Message* message) {
  switch (static_cast<messages::XRServiceTestHook>(message->header()->name)) {
    case messages::XRServiceTestHook::kSetTestHook: {
      break;
    }
    case messages::XRServiceTestHook::kTerminateDeviceServiceProcessForTesting: {
      break;
    }
  }
  return false;
}

// static
bool XRServiceTestHookStubDispatch::AcceptWithResponder(
    XRServiceTestHook* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::XRServiceTestHook>(message->header()->name)) {
    case messages::XRServiceTestHook::kSetTestHook: {
      internal::XRServiceTestHook_SetTestHook_Params_Data* params =
          reinterpret_cast<
              internal::XRServiceTestHook_SetTestHook_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRServiceTestHook.0
      bool success = true;
      ::mojo::PendingRemote<XRTestHook> p_hook{};
      XRServiceTestHook_SetTestHook_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_hook =
            input_data_view.TakeHook<decltype(p_hook)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRServiceTestHook::Name_, 0, false);
        return false;
      }
      auto callback =
          XRServiceTestHook_SetTestHook_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTestHook(        
        std::move(p_hook), std::move(callback));
      return true;
    }
    case messages::XRServiceTestHook::kTerminateDeviceServiceProcessForTesting: {
      internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data* params =
          reinterpret_cast<
              internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for XRServiceTestHook.1
      bool success = true;
      XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRServiceTestHook::Name_, 1, false);
        return false;
      }
      auto callback =
          XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TerminateDeviceServiceProcessForTesting(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kXRServiceTestHookValidationInfo[] = {
    { &internal::XRServiceTestHook_SetTestHook_Params_Data::Validate,
     &internal::XRServiceTestHook_SetTestHook_ResponseParams_Data::Validate},
    { &internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data::Validate,
     &internal::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data::Validate},
};

bool XRServiceTestHookRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device_test::mojom::XRServiceTestHook::Name_,
    kXRServiceTestHookValidationInfo);
}

bool XRServiceTestHookResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device_test::mojom::XRServiceTestHook::Name_,
    kXRServiceTestHookValidationInfo);
}


}  // device_test::mojom


namespace mojo {


// static
bool StructTraits<::device_test::mojom::Color::DataView, ::device_test::mojom::ColorPtr>::Read(
    ::device_test::mojom::Color::DataView input,
    ::device_test::mojom::ColorPtr* output) {
  bool success = true;
  ::device_test::mojom::ColorPtr result(::device_test::mojom::Color::New());
  
      if (success)
        result->r = input.r();
      if (success)
        result->g = input.g();
      if (success)
        result->b = input.b();
      if (success)
        result->a = input.a();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::ViewData::DataView, ::device_test::mojom::ViewDataPtr>::Read(
    ::device_test::mojom::ViewData::DataView input,
    ::device_test::mojom::ViewDataPtr* output) {
  bool success = true;
  ::device_test::mojom::ViewDataPtr result(::device_test::mojom::ViewData::New());
  
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success && !input.ReadEye(&result->eye))
        success = false;
      if (success && !input.ReadViewport(&result->viewport))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::PoseFrameData::DataView, ::device_test::mojom::PoseFrameDataPtr>::Read(
    ::device_test::mojom::PoseFrameData::DataView input,
    ::device_test::mojom::PoseFrameDataPtr* output) {
  bool success = true;
  ::device_test::mojom::PoseFrameDataPtr result(::device_test::mojom::PoseFrameData::New());
  
      if (success && !input.ReadDeviceToOrigin(&result->device_to_origin))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::ProjectionRaw::DataView, ::device_test::mojom::ProjectionRawPtr>::Read(
    ::device_test::mojom::ProjectionRaw::DataView input,
    ::device_test::mojom::ProjectionRawPtr* output) {
  bool success = true;
  ::device_test::mojom::ProjectionRawPtr result(::device_test::mojom::ProjectionRaw::New());
  
      if (success)
        result->left = input.left();
      if (success)
        result->right = input.right();
      if (success)
        result->top = input.top();
      if (success)
        result->bottom = input.bottom();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::DeviceConfig::DataView, ::device_test::mojom::DeviceConfigPtr>::Read(
    ::device_test::mojom::DeviceConfig::DataView input,
    ::device_test::mojom::DeviceConfigPtr* output) {
  bool success = true;
  ::device_test::mojom::DeviceConfigPtr result(::device_test::mojom::DeviceConfig::New());
  
      if (success)
        result->interpupillary_distance = input.interpupillary_distance();
      if (success && !input.ReadProjectionLeft(&result->projection_left))
        success = false;
      if (success && !input.ReadProjectionRight(&result->projection_right))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::ControllerAxisData::DataView, ::device_test::mojom::ControllerAxisDataPtr>::Read(
    ::device_test::mojom::ControllerAxisData::DataView input,
    ::device_test::mojom::ControllerAxisDataPtr* output) {
  bool success = true;
  ::device_test::mojom::ControllerAxisDataPtr result(::device_test::mojom::ControllerAxisData::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success)
        result->axis_type = input.axis_type();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::ControllerFrameData::DataView, ::device_test::mojom::ControllerFrameDataPtr>::Read(
    ::device_test::mojom::ControllerFrameData::DataView input,
    ::device_test::mojom::ControllerFrameDataPtr* output) {
  bool success = true;
  ::device_test::mojom::ControllerFrameDataPtr result(::device_test::mojom::ControllerFrameData::New());
  
      if (success)
        result->packet_number = input.packet_number();
      if (success)
        result->buttons_pressed = input.buttons_pressed();
      if (success)
        result->buttons_touched = input.buttons_touched();
      if (success)
        result->supported_buttons = input.supported_buttons();
      if (success && !input.ReadAxisData(&result->axis_data))
        success = false;
      if (success && !input.ReadPoseData(&result->pose_data))
        success = false;
      if (success && !input.ReadRole(&result->role))
        success = false;
      if (success && !input.ReadHandData(&result->hand_data))
        success = false;
      if (success)
        result->is_valid = input.is_valid();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device_test::mojom::EventData::DataView, ::device_test::mojom::EventDataPtr>::Read(
    ::device_test::mojom::EventData::DataView input,
    ::device_test::mojom::EventDataPtr* output) {
  bool success = true;
  ::device_test::mojom::EventDataPtr result(::device_test::mojom::EventData::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadInteractionProfile(&result->interaction_profile))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device_test::mojom {


void XRTestHookInterceptorForTesting::OnFrameSubmitted(std::vector<ViewDataPtr> frame_data, OnFrameSubmittedCallback callback) {
  GetForwardingInterface()->OnFrameSubmitted(
    std::move(frame_data)
    , std::move(callback));
}
void XRTestHookInterceptorForTesting::WaitGetDeviceConfig(WaitGetDeviceConfigCallback callback) {
  GetForwardingInterface()->WaitGetDeviceConfig(std::move(callback));
}
void XRTestHookInterceptorForTesting::WaitGetPresentingPose(WaitGetPresentingPoseCallback callback) {
  GetForwardingInterface()->WaitGetPresentingPose(std::move(callback));
}
void XRTestHookInterceptorForTesting::WaitGetMagicWindowPose(WaitGetMagicWindowPoseCallback callback) {
  GetForwardingInterface()->WaitGetMagicWindowPose(std::move(callback));
}
void XRTestHookInterceptorForTesting::WaitGetControllerRoleForTrackedDeviceIndex(uint32_t index, WaitGetControllerRoleForTrackedDeviceIndexCallback callback) {
  GetForwardingInterface()->WaitGetControllerRoleForTrackedDeviceIndex(
    std::move(index)
    , std::move(callback));
}
void XRTestHookInterceptorForTesting::WaitGetTrackedDeviceClass(uint32_t index, WaitGetTrackedDeviceClassCallback callback) {
  GetForwardingInterface()->WaitGetTrackedDeviceClass(
    std::move(index)
    , std::move(callback));
}
void XRTestHookInterceptorForTesting::WaitGetControllerData(uint32_t index, WaitGetControllerDataCallback callback) {
  GetForwardingInterface()->WaitGetControllerData(
    std::move(index)
    , std::move(callback));
}
void XRTestHookInterceptorForTesting::WaitGetEventData(WaitGetEventDataCallback callback) {
  GetForwardingInterface()->WaitGetEventData(std::move(callback));
}
void XRTestHookInterceptorForTesting::WaitGetCanCreateSession(WaitGetCanCreateSessionCallback callback) {
  GetForwardingInterface()->WaitGetCanCreateSession(std::move(callback));
}
XRTestHookAsyncWaiter::XRTestHookAsyncWaiter(
    XRTestHook* proxy) : proxy_(proxy) {}

XRTestHookAsyncWaiter::~XRTestHookAsyncWaiter() = default;


void XRTestHookAsyncWaiter::OnFrameSubmitted(
    std::vector<ViewDataPtr> frame_data) {
  base::RunLoop loop;
  proxy_->OnFrameSubmitted(
      std::move(frame_data),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void XRTestHookAsyncWaiter::WaitGetDeviceConfig(
    DeviceConfigPtr* out_config) {
  base::RunLoop loop;
  proxy_->WaitGetDeviceConfig(
      base::BindOnce(
          [](base::RunLoop* loop,
             DeviceConfigPtr* out_config
,
             DeviceConfigPtr config) {*out_config = std::move(config);
            loop->Quit();
          },
          &loop,
          out_config));
  loop.Run();
}

DeviceConfigPtr XRTestHookAsyncWaiter::WaitGetDeviceConfig(
    ) {
  DeviceConfigPtr async_wait_result;
  WaitGetDeviceConfig(&async_wait_result);
  return async_wait_result;
}

void XRTestHookAsyncWaiter::WaitGetPresentingPose(
    PoseFrameDataPtr* out_data) {
  base::RunLoop loop;
  proxy_->WaitGetPresentingPose(
      base::BindOnce(
          [](base::RunLoop* loop,
             PoseFrameDataPtr* out_data
,
             PoseFrameDataPtr data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

PoseFrameDataPtr XRTestHookAsyncWaiter::WaitGetPresentingPose(
    ) {
  PoseFrameDataPtr async_wait_result;
  WaitGetPresentingPose(&async_wait_result);
  return async_wait_result;
}

void XRTestHookAsyncWaiter::WaitGetMagicWindowPose(
    PoseFrameDataPtr* out_data) {
  base::RunLoop loop;
  proxy_->WaitGetMagicWindowPose(
      base::BindOnce(
          [](base::RunLoop* loop,
             PoseFrameDataPtr* out_data
,
             PoseFrameDataPtr data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

PoseFrameDataPtr XRTestHookAsyncWaiter::WaitGetMagicWindowPose(
    ) {
  PoseFrameDataPtr async_wait_result;
  WaitGetMagicWindowPose(&async_wait_result);
  return async_wait_result;
}

void XRTestHookAsyncWaiter::WaitGetControllerRoleForTrackedDeviceIndex(
    uint32_t index, ControllerRole* out_role) {
  base::RunLoop loop;
  proxy_->WaitGetControllerRoleForTrackedDeviceIndex(
      std::move(index),
      base::BindOnce(
          [](base::RunLoop* loop,
             ControllerRole* out_role
,
             ControllerRole role) {*out_role = std::move(role);
            loop->Quit();
          },
          &loop,
          out_role));
  loop.Run();
}

ControllerRole XRTestHookAsyncWaiter::WaitGetControllerRoleForTrackedDeviceIndex(
    uint32_t index) {
  ControllerRole async_wait_result;
  WaitGetControllerRoleForTrackedDeviceIndex(std::move(index),&async_wait_result);
  return async_wait_result;
}

void XRTestHookAsyncWaiter::WaitGetTrackedDeviceClass(
    uint32_t index, TrackedDeviceClass* out_device_class) {
  base::RunLoop loop;
  proxy_->WaitGetTrackedDeviceClass(
      std::move(index),
      base::BindOnce(
          [](base::RunLoop* loop,
             TrackedDeviceClass* out_device_class
,
             TrackedDeviceClass device_class) {*out_device_class = std::move(device_class);
            loop->Quit();
          },
          &loop,
          out_device_class));
  loop.Run();
}

TrackedDeviceClass XRTestHookAsyncWaiter::WaitGetTrackedDeviceClass(
    uint32_t index) {
  TrackedDeviceClass async_wait_result;
  WaitGetTrackedDeviceClass(std::move(index),&async_wait_result);
  return async_wait_result;
}

void XRTestHookAsyncWaiter::WaitGetControllerData(
    uint32_t index, ControllerFrameDataPtr* out_data) {
  base::RunLoop loop;
  proxy_->WaitGetControllerData(
      std::move(index),
      base::BindOnce(
          [](base::RunLoop* loop,
             ControllerFrameDataPtr* out_data
,
             ControllerFrameDataPtr data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

ControllerFrameDataPtr XRTestHookAsyncWaiter::WaitGetControllerData(
    uint32_t index) {
  ControllerFrameDataPtr async_wait_result;
  WaitGetControllerData(std::move(index),&async_wait_result);
  return async_wait_result;
}

void XRTestHookAsyncWaiter::WaitGetEventData(
    EventDataPtr* out_data) {
  base::RunLoop loop;
  proxy_->WaitGetEventData(
      base::BindOnce(
          [](base::RunLoop* loop,
             EventDataPtr* out_data
,
             EventDataPtr data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

EventDataPtr XRTestHookAsyncWaiter::WaitGetEventData(
    ) {
  EventDataPtr async_wait_result;
  WaitGetEventData(&async_wait_result);
  return async_wait_result;
}

void XRTestHookAsyncWaiter::WaitGetCanCreateSession(
    bool* out_can_create_session) {
  base::RunLoop loop;
  proxy_->WaitGetCanCreateSession(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_can_create_session
,
             bool can_create_session) {*out_can_create_session = std::move(can_create_session);
            loop->Quit();
          },
          &loop,
          out_can_create_session));
  loop.Run();
}

bool XRTestHookAsyncWaiter::WaitGetCanCreateSession(
    ) {
  bool async_wait_result;
  WaitGetCanCreateSession(&async_wait_result);
  return async_wait_result;
}




void XRServiceTestHookInterceptorForTesting::SetTestHook(::mojo::PendingRemote<XRTestHook> hook, SetTestHookCallback callback) {
  GetForwardingInterface()->SetTestHook(
    std::move(hook)
    , std::move(callback));
}
void XRServiceTestHookInterceptorForTesting::TerminateDeviceServiceProcessForTesting(TerminateDeviceServiceProcessForTestingCallback callback) {
  GetForwardingInterface()->TerminateDeviceServiceProcessForTesting(std::move(callback));
}
XRServiceTestHookAsyncWaiter::XRServiceTestHookAsyncWaiter(
    XRServiceTestHook* proxy) : proxy_(proxy) {}

XRServiceTestHookAsyncWaiter::~XRServiceTestHookAsyncWaiter() = default;


void XRServiceTestHookAsyncWaiter::SetTestHook(
    ::mojo::PendingRemote<XRTestHook> hook) {
  base::RunLoop loop;
  proxy_->SetTestHook(
      std::move(hook),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void XRServiceTestHookAsyncWaiter::TerminateDeviceServiceProcessForTesting(
    ) {
  base::RunLoop loop;
  proxy_->TerminateDeviceServiceProcessForTesting(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // device_test::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif