// device/bluetooth/public/mojom/gatt_characteristic_permissions.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'device/bluetooth/public/mojom/gatt_characteristic_permissions.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('bluetooth.mojom');



  function GattCharacteristicPermissions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GattCharacteristicPermissions.prototype.initDefaults_ = function() {
    this.read = false;
    this.write = false;
    this.readEncrypted = false;
    this.writeEncrypted = false;
    this.readEncryptedAuthenticated = false;
    this.writeEncryptedAuthenticated = false;
  };
  GattCharacteristicPermissions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GattCharacteristicPermissions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;







    return validator.validationError.NONE;
  };

  GattCharacteristicPermissions.encodedSize = codec.kStructHeaderSize + 8;

  GattCharacteristicPermissions.decode = function(decoder) {
    var packed;
    var val = new GattCharacteristicPermissions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.read = (packed >> 0) & 1 ? true : false;
    val.write = (packed >> 1) & 1 ? true : false;
    val.readEncrypted = (packed >> 2) & 1 ? true : false;
    val.writeEncrypted = (packed >> 3) & 1 ? true : false;
    val.readEncryptedAuthenticated = (packed >> 4) & 1 ? true : false;
    val.writeEncryptedAuthenticated = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GattCharacteristicPermissions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GattCharacteristicPermissions.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.read & 1) << 0
    packed |= (val.write & 1) << 1
    packed |= (val.readEncrypted & 1) << 2
    packed |= (val.writeEncrypted & 1) << 3
    packed |= (val.readEncryptedAuthenticated & 1) << 4
    packed |= (val.writeEncryptedAuthenticated & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.GattCharacteristicPermissions = GattCharacteristicPermissions;
})();