// device/bluetooth/public/mojom/adapter.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_PARAMS_DATA_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace bluetooth::mojom {
namespace internal {
class  Advertisement_Unregister_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Advertisement_Unregister_Params_Data>;

  Advertisement_Unregister_Params_Data();
  ~Advertisement_Unregister_Params_Data() = delete;
};
static_assert(sizeof(Advertisement_Unregister_Params_Data) == 8,
              "Bad sizeof(Advertisement_Unregister_Params_Data)");
class  Advertisement_Unregister_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Advertisement_Unregister_ResponseParams_Data>;

  Advertisement_Unregister_ResponseParams_Data();
  ~Advertisement_Unregister_ResponseParams_Data() = delete;
};
static_assert(sizeof(Advertisement_Unregister_ResponseParams_Data) == 8,
              "Bad sizeof(Advertisement_Unregister_ResponseParams_Data)");
class  DiscoverySession_IsActive_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<DiscoverySession_IsActive_Params_Data>;

  DiscoverySession_IsActive_Params_Data();
  ~DiscoverySession_IsActive_Params_Data() = delete;
};
static_assert(sizeof(DiscoverySession_IsActive_Params_Data) == 8,
              "Bad sizeof(DiscoverySession_IsActive_Params_Data)");
class  DiscoverySession_IsActive_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t active : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<DiscoverySession_IsActive_ResponseParams_Data>;

  DiscoverySession_IsActive_ResponseParams_Data();
  ~DiscoverySession_IsActive_ResponseParams_Data() = delete;
};
static_assert(sizeof(DiscoverySession_IsActive_ResponseParams_Data) == 16,
              "Bad sizeof(DiscoverySession_IsActive_ResponseParams_Data)");
class  DiscoverySession_Stop_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<DiscoverySession_Stop_Params_Data>;

  DiscoverySession_Stop_Params_Data();
  ~DiscoverySession_Stop_Params_Data() = delete;
};
static_assert(sizeof(DiscoverySession_Stop_Params_Data) == 8,
              "Bad sizeof(DiscoverySession_Stop_Params_Data)");
class  DiscoverySession_Stop_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<DiscoverySession_Stop_ResponseParams_Data>;

  DiscoverySession_Stop_ResponseParams_Data();
  ~DiscoverySession_Stop_ResponseParams_Data() = delete;
};
static_assert(sizeof(DiscoverySession_Stop_ResponseParams_Data) == 16,
              "Bad sizeof(DiscoverySession_Stop_ResponseParams_Data)");
class  Socket_Disconnect_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Socket_Disconnect_Params_Data>;

  Socket_Disconnect_Params_Data();
  ~Socket_Disconnect_Params_Data() = delete;
};
static_assert(sizeof(Socket_Disconnect_Params_Data) == 8,
              "Bad sizeof(Socket_Disconnect_Params_Data)");
class  Socket_Disconnect_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Socket_Disconnect_ResponseParams_Data>;

  Socket_Disconnect_ResponseParams_Data();
  ~Socket_Disconnect_ResponseParams_Data() = delete;
};
static_assert(sizeof(Socket_Disconnect_ResponseParams_Data) == 8,
              "Bad sizeof(Socket_Disconnect_ResponseParams_Data)");
class  ServerSocket_Accept_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<ServerSocket_Accept_Params_Data>;

  ServerSocket_Accept_Params_Data();
  ~ServerSocket_Accept_Params_Data() = delete;
};
static_assert(sizeof(ServerSocket_Accept_Params_Data) == 8,
              "Bad sizeof(ServerSocket_Accept_Params_Data)");
class  ServerSocket_Accept_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::AcceptConnectionResult_Data> result;

 private:
  friend class mojo::internal::MessageFragment<ServerSocket_Accept_ResponseParams_Data>;

  ServerSocket_Accept_ResponseParams_Data();
  ~ServerSocket_Accept_ResponseParams_Data() = delete;
};
static_assert(sizeof(ServerSocket_Accept_ResponseParams_Data) == 16,
              "Bad sizeof(ServerSocket_Accept_ResponseParams_Data)");
class  ServerSocket_Disconnect_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<ServerSocket_Disconnect_Params_Data>;

  ServerSocket_Disconnect_Params_Data();
  ~ServerSocket_Disconnect_Params_Data() = delete;
};
static_assert(sizeof(ServerSocket_Disconnect_Params_Data) == 8,
              "Bad sizeof(ServerSocket_Disconnect_Params_Data)");
class  ServerSocket_Disconnect_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<ServerSocket_Disconnect_ResponseParams_Data>;

  ServerSocket_Disconnect_ResponseParams_Data();
  ~ServerSocket_Disconnect_ResponseParams_Data() = delete;
};
static_assert(sizeof(ServerSocket_Disconnect_ResponseParams_Data) == 8,
              "Bad sizeof(ServerSocket_Disconnect_ResponseParams_Data)");
class  GattService_CreateCharacteristic_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data> characteristic_uuid;
  mojo::internal::Pointer<::bluetooth::mojom::internal::GattCharacteristicPermissions_Data> permissions;
  mojo::internal::Pointer<::bluetooth::mojom::internal::GattCharacteristicProperties_Data> properties;

 private:
  friend class mojo::internal::MessageFragment<GattService_CreateCharacteristic_Params_Data>;

  GattService_CreateCharacteristic_Params_Data();
  ~GattService_CreateCharacteristic_Params_Data() = delete;
};
static_assert(sizeof(GattService_CreateCharacteristic_Params_Data) == 32,
              "Bad sizeof(GattService_CreateCharacteristic_Params_Data)");
class  GattService_CreateCharacteristic_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<GattService_CreateCharacteristic_ResponseParams_Data>;

  GattService_CreateCharacteristic_ResponseParams_Data();
  ~GattService_CreateCharacteristic_ResponseParams_Data() = delete;
};
static_assert(sizeof(GattService_CreateCharacteristic_ResponseParams_Data) == 16,
              "Bad sizeof(GattService_CreateCharacteristic_ResponseParams_Data)");
class  GattService_Register_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GattService_Register_Params_Data>;

  GattService_Register_Params_Data();
  ~GattService_Register_Params_Data() = delete;
};
static_assert(sizeof(GattService_Register_Params_Data) == 8,
              "Bad sizeof(GattService_Register_Params_Data)");
class  GattService_Register_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t error_code_$flag : 1;
  uint8_t pad0_[3];
  int32_t error_code_$value;

 private:
  friend class mojo::internal::MessageFragment<GattService_Register_ResponseParams_Data>;

  GattService_Register_ResponseParams_Data();
  ~GattService_Register_ResponseParams_Data() = delete;
};
static_assert(sizeof(GattService_Register_ResponseParams_Data) == 16,
              "Bad sizeof(GattService_Register_ResponseParams_Data)");
class  GattServiceObserver_OnLocalCharacteristicRead_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::bluetooth::mojom::internal::DeviceInfo_Data> remote_device;
  mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data> characteristic_uuid;
  mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data> service_uuid;
  uint32_t offset;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GattServiceObserver_OnLocalCharacteristicRead_Params_Data>;

  GattServiceObserver_OnLocalCharacteristicRead_Params_Data();
  ~GattServiceObserver_OnLocalCharacteristicRead_Params_Data() = delete;
};
static_assert(sizeof(GattServiceObserver_OnLocalCharacteristicRead_Params_Data) == 40,
              "Bad sizeof(GattServiceObserver_OnLocalCharacteristicRead_Params_Data)");
class  GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::LocalCharacteristicReadResult_Data read_result;

 private:
  friend class mojo::internal::MessageFragment<GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data>;

  GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data();
  ~GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data() = delete;
};
static_assert(sizeof(GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data) == 24,
              "Bad sizeof(GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data)");
class  Adapter_ConnectToDevice_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> address;

 private:
  friend class mojo::internal::MessageFragment<Adapter_ConnectToDevice_Params_Data>;

  Adapter_ConnectToDevice_Params_Data();
  ~Adapter_ConnectToDevice_Params_Data() = delete;
};
static_assert(sizeof(Adapter_ConnectToDevice_Params_Data) == 16,
              "Bad sizeof(Adapter_ConnectToDevice_Params_Data)");
class  Adapter_ConnectToDevice_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  mojo::internal::Interface_Data device;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Adapter_ConnectToDevice_ResponseParams_Data>;

  Adapter_ConnectToDevice_ResponseParams_Data();
  ~Adapter_ConnectToDevice_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_ConnectToDevice_ResponseParams_Data) == 24,
              "Bad sizeof(Adapter_ConnectToDevice_ResponseParams_Data)");
class  Adapter_GetDevices_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Adapter_GetDevices_Params_Data>;

  Adapter_GetDevices_Params_Data();
  ~Adapter_GetDevices_Params_Data() = delete;
};
static_assert(sizeof(Adapter_GetDevices_Params_Data) == 8,
              "Bad sizeof(Adapter_GetDevices_Params_Data)");
class  Adapter_GetDevices_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::bluetooth::mojom::internal::DeviceInfo_Data>>> devices;

 private:
  friend class mojo::internal::MessageFragment<Adapter_GetDevices_ResponseParams_Data>;

  Adapter_GetDevices_ResponseParams_Data();
  ~Adapter_GetDevices_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_GetDevices_ResponseParams_Data) == 16,
              "Bad sizeof(Adapter_GetDevices_ResponseParams_Data)");
class  Adapter_GetInfo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Adapter_GetInfo_Params_Data>;

  Adapter_GetInfo_Params_Data();
  ~Adapter_GetInfo_Params_Data() = delete;
};
static_assert(sizeof(Adapter_GetInfo_Params_Data) == 8,
              "Bad sizeof(Adapter_GetInfo_Params_Data)");
class  Adapter_GetInfo_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::AdapterInfo_Data> info;

 private:
  friend class mojo::internal::MessageFragment<Adapter_GetInfo_ResponseParams_Data>;

  Adapter_GetInfo_ResponseParams_Data();
  ~Adapter_GetInfo_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_GetInfo_ResponseParams_Data) == 16,
              "Bad sizeof(Adapter_GetInfo_ResponseParams_Data)");
class  Adapter_AddObserver_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data observer;

 private:
  friend class mojo::internal::MessageFragment<Adapter_AddObserver_Params_Data>;

  Adapter_AddObserver_Params_Data();
  ~Adapter_AddObserver_Params_Data() = delete;
};
static_assert(sizeof(Adapter_AddObserver_Params_Data) == 16,
              "Bad sizeof(Adapter_AddObserver_Params_Data)");
class  Adapter_AddObserver_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Adapter_AddObserver_ResponseParams_Data>;

  Adapter_AddObserver_ResponseParams_Data();
  ~Adapter_AddObserver_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_AddObserver_ResponseParams_Data) == 8,
              "Bad sizeof(Adapter_AddObserver_ResponseParams_Data)");
class  Adapter_RegisterAdvertisement_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data> service_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> service_data;
  uint8_t use_scan_response : 1;
  uint8_t connectable : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Adapter_RegisterAdvertisement_Params_Data>;

  Adapter_RegisterAdvertisement_Params_Data();
  ~Adapter_RegisterAdvertisement_Params_Data() = delete;
};
static_assert(sizeof(Adapter_RegisterAdvertisement_Params_Data) == 32,
              "Bad sizeof(Adapter_RegisterAdvertisement_Params_Data)");
class  Adapter_RegisterAdvertisement_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data advertisement;

 private:
  friend class mojo::internal::MessageFragment<Adapter_RegisterAdvertisement_ResponseParams_Data>;

  Adapter_RegisterAdvertisement_ResponseParams_Data();
  ~Adapter_RegisterAdvertisement_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_RegisterAdvertisement_ResponseParams_Data) == 16,
              "Bad sizeof(Adapter_RegisterAdvertisement_ResponseParams_Data)");
class  Adapter_SetDiscoverable_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t discoverable : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Adapter_SetDiscoverable_Params_Data>;

  Adapter_SetDiscoverable_Params_Data();
  ~Adapter_SetDiscoverable_Params_Data() = delete;
};
static_assert(sizeof(Adapter_SetDiscoverable_Params_Data) == 16,
              "Bad sizeof(Adapter_SetDiscoverable_Params_Data)");
class  Adapter_SetDiscoverable_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Adapter_SetDiscoverable_ResponseParams_Data>;

  Adapter_SetDiscoverable_ResponseParams_Data();
  ~Adapter_SetDiscoverable_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_SetDiscoverable_ResponseParams_Data) == 16,
              "Bad sizeof(Adapter_SetDiscoverable_ResponseParams_Data)");
class  Adapter_SetName_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> name;

 private:
  friend class mojo::internal::MessageFragment<Adapter_SetName_Params_Data>;

  Adapter_SetName_Params_Data();
  ~Adapter_SetName_Params_Data() = delete;
};
static_assert(sizeof(Adapter_SetName_Params_Data) == 16,
              "Bad sizeof(Adapter_SetName_Params_Data)");
class  Adapter_SetName_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Adapter_SetName_ResponseParams_Data>;

  Adapter_SetName_ResponseParams_Data();
  ~Adapter_SetName_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_SetName_ResponseParams_Data) == 16,
              "Bad sizeof(Adapter_SetName_ResponseParams_Data)");
class  Adapter_StartDiscoverySession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> client_name;

 private:
  friend class mojo::internal::MessageFragment<Adapter_StartDiscoverySession_Params_Data>;

  Adapter_StartDiscoverySession_Params_Data();
  ~Adapter_StartDiscoverySession_Params_Data() = delete;
};
static_assert(sizeof(Adapter_StartDiscoverySession_Params_Data) == 16,
              "Bad sizeof(Adapter_StartDiscoverySession_Params_Data)");
class  Adapter_StartDiscoverySession_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data session;

 private:
  friend class mojo::internal::MessageFragment<Adapter_StartDiscoverySession_ResponseParams_Data>;

  Adapter_StartDiscoverySession_ResponseParams_Data();
  ~Adapter_StartDiscoverySession_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_StartDiscoverySession_ResponseParams_Data) == 16,
              "Bad sizeof(Adapter_StartDiscoverySession_ResponseParams_Data)");
class  Adapter_ConnectToServiceInsecurely_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> address;
  mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data> service_uuid;
  uint8_t should_unbond_on_error : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Adapter_ConnectToServiceInsecurely_Params_Data>;

  Adapter_ConnectToServiceInsecurely_Params_Data();
  ~Adapter_ConnectToServiceInsecurely_Params_Data() = delete;
};
static_assert(sizeof(Adapter_ConnectToServiceInsecurely_Params_Data) == 32,
              "Bad sizeof(Adapter_ConnectToServiceInsecurely_Params_Data)");
class  Adapter_ConnectToServiceInsecurely_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ConnectToServiceResult_Data> result;

 private:
  friend class mojo::internal::MessageFragment<Adapter_ConnectToServiceInsecurely_ResponseParams_Data>;

  Adapter_ConnectToServiceInsecurely_ResponseParams_Data();
  ~Adapter_ConnectToServiceInsecurely_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_ConnectToServiceInsecurely_ResponseParams_Data) == 16,
              "Bad sizeof(Adapter_ConnectToServiceInsecurely_ResponseParams_Data)");
class  Adapter_CreateRfcommServiceInsecurely_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> service_name;
  mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data> service_uuid;

 private:
  friend class mojo::internal::MessageFragment<Adapter_CreateRfcommServiceInsecurely_Params_Data>;

  Adapter_CreateRfcommServiceInsecurely_Params_Data();
  ~Adapter_CreateRfcommServiceInsecurely_Params_Data() = delete;
};
static_assert(sizeof(Adapter_CreateRfcommServiceInsecurely_Params_Data) == 24,
              "Bad sizeof(Adapter_CreateRfcommServiceInsecurely_Params_Data)");
class  Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data server_socket;

 private:
  friend class mojo::internal::MessageFragment<Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data>;

  Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data();
  ~Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data) == 16,
              "Bad sizeof(Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data)");
class  Adapter_CreateLocalGattService_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::bluetooth::mojom::internal::UUID_Data> service_id;
  mojo::internal::Interface_Data observer;

 private:
  friend class mojo::internal::MessageFragment<Adapter_CreateLocalGattService_Params_Data>;

  Adapter_CreateLocalGattService_Params_Data();
  ~Adapter_CreateLocalGattService_Params_Data() = delete;
};
static_assert(sizeof(Adapter_CreateLocalGattService_Params_Data) == 24,
              "Bad sizeof(Adapter_CreateLocalGattService_Params_Data)");
class  Adapter_CreateLocalGattService_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data gatt_service;

 private:
  friend class mojo::internal::MessageFragment<Adapter_CreateLocalGattService_ResponseParams_Data>;

  Adapter_CreateLocalGattService_ResponseParams_Data();
  ~Adapter_CreateLocalGattService_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_CreateLocalGattService_ResponseParams_Data) == 16,
              "Bad sizeof(Adapter_CreateLocalGattService_ResponseParams_Data)");
class  Adapter_IsLeScatternetDualRoleSupported_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Adapter_IsLeScatternetDualRoleSupported_Params_Data>;

  Adapter_IsLeScatternetDualRoleSupported_Params_Data();
  ~Adapter_IsLeScatternetDualRoleSupported_Params_Data() = delete;
};
static_assert(sizeof(Adapter_IsLeScatternetDualRoleSupported_Params_Data) == 8,
              "Bad sizeof(Adapter_IsLeScatternetDualRoleSupported_Params_Data)");
class  Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_supported : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data>;

  Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data();
  ~Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data() = delete;
};
static_assert(sizeof(Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data) == 16,
              "Bad sizeof(Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data)");
class  AdapterObserver_PresentChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t present : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<AdapterObserver_PresentChanged_Params_Data>;

  AdapterObserver_PresentChanged_Params_Data();
  ~AdapterObserver_PresentChanged_Params_Data() = delete;
};
static_assert(sizeof(AdapterObserver_PresentChanged_Params_Data) == 16,
              "Bad sizeof(AdapterObserver_PresentChanged_Params_Data)");
class  AdapterObserver_PoweredChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t powered : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<AdapterObserver_PoweredChanged_Params_Data>;

  AdapterObserver_PoweredChanged_Params_Data();
  ~AdapterObserver_PoweredChanged_Params_Data() = delete;
};
static_assert(sizeof(AdapterObserver_PoweredChanged_Params_Data) == 16,
              "Bad sizeof(AdapterObserver_PoweredChanged_Params_Data)");
class  AdapterObserver_DiscoverableChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t discoverable : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<AdapterObserver_DiscoverableChanged_Params_Data>;

  AdapterObserver_DiscoverableChanged_Params_Data();
  ~AdapterObserver_DiscoverableChanged_Params_Data() = delete;
};
static_assert(sizeof(AdapterObserver_DiscoverableChanged_Params_Data) == 16,
              "Bad sizeof(AdapterObserver_DiscoverableChanged_Params_Data)");
class  AdapterObserver_DiscoveringChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t discovering : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<AdapterObserver_DiscoveringChanged_Params_Data>;

  AdapterObserver_DiscoveringChanged_Params_Data();
  ~AdapterObserver_DiscoveringChanged_Params_Data() = delete;
};
static_assert(sizeof(AdapterObserver_DiscoveringChanged_Params_Data) == 16,
              "Bad sizeof(AdapterObserver_DiscoveringChanged_Params_Data)");
class  AdapterObserver_DeviceAdded_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::bluetooth::mojom::internal::DeviceInfo_Data> device;

 private:
  friend class mojo::internal::MessageFragment<AdapterObserver_DeviceAdded_Params_Data>;

  AdapterObserver_DeviceAdded_Params_Data();
  ~AdapterObserver_DeviceAdded_Params_Data() = delete;
};
static_assert(sizeof(AdapterObserver_DeviceAdded_Params_Data) == 16,
              "Bad sizeof(AdapterObserver_DeviceAdded_Params_Data)");
class  AdapterObserver_DeviceChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::bluetooth::mojom::internal::DeviceInfo_Data> device;

 private:
  friend class mojo::internal::MessageFragment<AdapterObserver_DeviceChanged_Params_Data>;

  AdapterObserver_DeviceChanged_Params_Data();
  ~AdapterObserver_DeviceChanged_Params_Data() = delete;
};
static_assert(sizeof(AdapterObserver_DeviceChanged_Params_Data) == 16,
              "Bad sizeof(AdapterObserver_DeviceChanged_Params_Data)");
class  AdapterObserver_DeviceRemoved_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::bluetooth::mojom::internal::DeviceInfo_Data> device;

 private:
  friend class mojo::internal::MessageFragment<AdapterObserver_DeviceRemoved_Params_Data>;

  AdapterObserver_DeviceRemoved_Params_Data();
  ~AdapterObserver_DeviceRemoved_Params_Data() = delete;
};
static_assert(sizeof(AdapterObserver_DeviceRemoved_Params_Data) == 16,
              "Bad sizeof(AdapterObserver_DeviceRemoved_Params_Data)");

}  // namespace internal


class Advertisement_Unregister_ParamsDataView {
 public:
  Advertisement_Unregister_ParamsDataView() = default;

  Advertisement_Unregister_ParamsDataView(
      internal::Advertisement_Unregister_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Advertisement_Unregister_Params_Data* data_ = nullptr;
};


class Advertisement_Unregister_ResponseParamsDataView {
 public:
  Advertisement_Unregister_ResponseParamsDataView() = default;

  Advertisement_Unregister_ResponseParamsDataView(
      internal::Advertisement_Unregister_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Advertisement_Unregister_ResponseParams_Data* data_ = nullptr;
};


class DiscoverySession_IsActive_ParamsDataView {
 public:
  DiscoverySession_IsActive_ParamsDataView() = default;

  DiscoverySession_IsActive_ParamsDataView(
      internal::DiscoverySession_IsActive_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::DiscoverySession_IsActive_Params_Data* data_ = nullptr;
};


class DiscoverySession_IsActive_ResponseParamsDataView {
 public:
  DiscoverySession_IsActive_ResponseParamsDataView() = default;

  DiscoverySession_IsActive_ResponseParamsDataView(
      internal::DiscoverySession_IsActive_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool active() const {
    return data_->active;
  }
 private:
  internal::DiscoverySession_IsActive_ResponseParams_Data* data_ = nullptr;
};


class DiscoverySession_Stop_ParamsDataView {
 public:
  DiscoverySession_Stop_ParamsDataView() = default;

  DiscoverySession_Stop_ParamsDataView(
      internal::DiscoverySession_Stop_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::DiscoverySession_Stop_Params_Data* data_ = nullptr;
};


class DiscoverySession_Stop_ResponseParamsDataView {
 public:
  DiscoverySession_Stop_ResponseParamsDataView() = default;

  DiscoverySession_Stop_ResponseParamsDataView(
      internal::DiscoverySession_Stop_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::DiscoverySession_Stop_ResponseParams_Data* data_ = nullptr;
};


class Socket_Disconnect_ParamsDataView {
 public:
  Socket_Disconnect_ParamsDataView() = default;

  Socket_Disconnect_ParamsDataView(
      internal::Socket_Disconnect_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Socket_Disconnect_Params_Data* data_ = nullptr;
};


class Socket_Disconnect_ResponseParamsDataView {
 public:
  Socket_Disconnect_ResponseParamsDataView() = default;

  Socket_Disconnect_ResponseParamsDataView(
      internal::Socket_Disconnect_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Socket_Disconnect_ResponseParams_Data* data_ = nullptr;
};


class ServerSocket_Accept_ParamsDataView {
 public:
  ServerSocket_Accept_ParamsDataView() = default;

  ServerSocket_Accept_ParamsDataView(
      internal::ServerSocket_Accept_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ServerSocket_Accept_Params_Data* data_ = nullptr;
};


class ServerSocket_Accept_ResponseParamsDataView {
 public:
  ServerSocket_Accept_ResponseParamsDataView() = default;

  ServerSocket_Accept_ResponseParamsDataView(
      internal::ServerSocket_Accept_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      AcceptConnectionResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::bluetooth::mojom::AcceptConnectionResultDataView, UserType>(),
    "Attempting to read the optional `result` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResult` instead "
    "of `ReadResult if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::AcceptConnectionResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServerSocket_Accept_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServerSocket_Disconnect_ParamsDataView {
 public:
  ServerSocket_Disconnect_ParamsDataView() = default;

  ServerSocket_Disconnect_ParamsDataView(
      internal::ServerSocket_Disconnect_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ServerSocket_Disconnect_Params_Data* data_ = nullptr;
};


class ServerSocket_Disconnect_ResponseParamsDataView {
 public:
  ServerSocket_Disconnect_ResponseParamsDataView() = default;

  ServerSocket_Disconnect_ResponseParamsDataView(
      internal::ServerSocket_Disconnect_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ServerSocket_Disconnect_ResponseParams_Data* data_ = nullptr;
};


class GattService_CreateCharacteristic_ParamsDataView {
 public:
  GattService_CreateCharacteristic_ParamsDataView() = default;

  GattService_CreateCharacteristic_ParamsDataView(
      internal::GattService_CreateCharacteristic_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCharacteristicUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCharacteristicUuid(UserType* output) {
    
    auto* pointer = data_->characteristic_uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  inline void GetPermissionsDataView(
      ::bluetooth::mojom::GattCharacteristicPermissionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissions(UserType* output) {
    
    auto* pointer = data_->permissions.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::GattCharacteristicPermissionsDataView>(
        pointer, output, message_);
  }
  inline void GetPropertiesDataView(
      ::bluetooth::mojom::GattCharacteristicPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProperties(UserType* output) {
    
    auto* pointer = data_->properties.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::GattCharacteristicPropertiesDataView>(
        pointer, output, message_);
  }
 private:
  internal::GattService_CreateCharacteristic_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GattService_CreateCharacteristic_ResponseParamsDataView {
 public:
  GattService_CreateCharacteristic_ResponseParamsDataView() = default;

  GattService_CreateCharacteristic_ResponseParamsDataView(
      internal::GattService_CreateCharacteristic_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::GattService_CreateCharacteristic_ResponseParams_Data* data_ = nullptr;
};


class GattService_Register_ParamsDataView {
 public:
  GattService_Register_ParamsDataView() = default;

  GattService_Register_ParamsDataView(
      internal::GattService_Register_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GattService_Register_Params_Data* data_ = nullptr;
};


class GattService_Register_ResponseParamsDataView {
 public:
  GattService_Register_ResponseParamsDataView() = default;

  GattService_Register_ResponseParamsDataView(
      internal::GattService_Register_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    if (!data_->error_code_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::bluetooth::mojom::GattServiceErrorCode>(
        data_->error_code_$value, &output->emplace());
  }
  std::optional<::bluetooth::mojom::GattServiceErrorCode> error_code() const {
    if (!data_->error_code_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::bluetooth::mojom::GattServiceErrorCode>(data_->error_code_$value));
  }
 private:
  internal::GattService_Register_ResponseParams_Data* data_ = nullptr;
};


class GattServiceObserver_OnLocalCharacteristicRead_ParamsDataView {
 public:
  GattServiceObserver_OnLocalCharacteristicRead_ParamsDataView() = default;

  GattServiceObserver_OnLocalCharacteristicRead_ParamsDataView(
      internal::GattServiceObserver_OnLocalCharacteristicRead_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRemoteDeviceDataView(
      ::bluetooth::mojom::DeviceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteDevice(UserType* output) {
    
    auto* pointer = data_->remote_device.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::DeviceInfoDataView>(
        pointer, output, message_);
  }
  inline void GetCharacteristicUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCharacteristicUuid(UserType* output) {
    
    auto* pointer = data_->characteristic_uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  inline void GetServiceUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceUuid(UserType* output) {
    
    auto* pointer = data_->service_uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  uint32_t offset() const {
    return data_->offset;
  }
 private:
  internal::GattServiceObserver_OnLocalCharacteristicRead_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsDataView {
 public:
  GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsDataView() = default;

  GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsDataView(
      internal::GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReadResultDataView(
      LocalCharacteristicReadResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReadResult(UserType* output) {
    
    auto* pointer = !data_->read_result.is_null() ? &data_->read_result : nullptr;
    return mojo::internal::Deserialize<::bluetooth::mojom::LocalCharacteristicReadResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::GattServiceObserver_OnLocalCharacteristicRead_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_ConnectToDevice_ParamsDataView {
 public:
  Adapter_ConnectToDevice_ParamsDataView() = default;

  Adapter_ConnectToDevice_ParamsDataView(
      internal::Adapter_ConnectToDevice_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddress(UserType* output) {
    
    auto* pointer = data_->address.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Adapter_ConnectToDevice_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_ConnectToDevice_ResponseParamsDataView {
 public:
  Adapter_ConnectToDevice_ResponseParamsDataView() = default;

  Adapter_ConnectToDevice_ResponseParamsDataView(
      internal::Adapter_ConnectToDevice_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::bluetooth::mojom::ConnectResult>(
        data_value, output);
  }
  ConnectResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::bluetooth::mojom::ConnectResult>(data_->result));
  }
  template <typename UserType>
  UserType TakeDevice() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::bluetooth::mojom::DeviceInterfaceBase>>(
            &data_->device, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Adapter_ConnectToDevice_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_GetDevices_ParamsDataView {
 public:
  Adapter_GetDevices_ParamsDataView() = default;

  Adapter_GetDevices_ParamsDataView(
      internal::Adapter_GetDevices_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Adapter_GetDevices_Params_Data* data_ = nullptr;
};


class Adapter_GetDevices_ResponseParamsDataView {
 public:
  Adapter_GetDevices_ResponseParamsDataView() = default;

  Adapter_GetDevices_ResponseParamsDataView(
      internal::Adapter_GetDevices_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevicesDataView(
      mojo::ArrayDataView<::bluetooth::mojom::DeviceInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevices(UserType* output) {
    
    auto* pointer = data_->devices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::bluetooth::mojom::DeviceInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Adapter_GetDevices_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_GetInfo_ParamsDataView {
 public:
  Adapter_GetInfo_ParamsDataView() = default;

  Adapter_GetInfo_ParamsDataView(
      internal::Adapter_GetInfo_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Adapter_GetInfo_Params_Data* data_ = nullptr;
};


class Adapter_GetInfo_ResponseParamsDataView {
 public:
  Adapter_GetInfo_ResponseParamsDataView() = default;

  Adapter_GetInfo_ResponseParamsDataView(
      internal::Adapter_GetInfo_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      AdapterInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::AdapterInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::Adapter_GetInfo_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_AddObserver_ParamsDataView {
 public:
  Adapter_AddObserver_ParamsDataView() = default;

  Adapter_AddObserver_ParamsDataView(
      internal::Adapter_AddObserver_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::bluetooth::mojom::AdapterObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Adapter_AddObserver_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_AddObserver_ResponseParamsDataView {
 public:
  Adapter_AddObserver_ResponseParamsDataView() = default;

  Adapter_AddObserver_ResponseParamsDataView(
      internal::Adapter_AddObserver_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Adapter_AddObserver_ResponseParams_Data* data_ = nullptr;
};


class Adapter_RegisterAdvertisement_ParamsDataView {
 public:
  Adapter_RegisterAdvertisement_ParamsDataView() = default;

  Adapter_RegisterAdvertisement_ParamsDataView(
      internal::Adapter_RegisterAdvertisement_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServiceIdDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceId(UserType* output) {
    
    auto* pointer = data_->service_id.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  inline void GetServiceDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceData(UserType* output) {
    
    auto* pointer = data_->service_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  bool use_scan_response() const {
    return data_->use_scan_response;
  }
  bool connectable() const {
    return data_->connectable;
  }
 private:
  internal::Adapter_RegisterAdvertisement_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_RegisterAdvertisement_ResponseParamsDataView {
 public:
  Adapter_RegisterAdvertisement_ResponseParamsDataView() = default;

  Adapter_RegisterAdvertisement_ResponseParamsDataView(
      internal::Adapter_RegisterAdvertisement_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeAdvertisement() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::bluetooth::mojom::AdvertisementInterfaceBase>>(
            &data_->advertisement, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Adapter_RegisterAdvertisement_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_SetDiscoverable_ParamsDataView {
 public:
  Adapter_SetDiscoverable_ParamsDataView() = default;

  Adapter_SetDiscoverable_ParamsDataView(
      internal::Adapter_SetDiscoverable_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool discoverable() const {
    return data_->discoverable;
  }
 private:
  internal::Adapter_SetDiscoverable_Params_Data* data_ = nullptr;
};


class Adapter_SetDiscoverable_ResponseParamsDataView {
 public:
  Adapter_SetDiscoverable_ResponseParamsDataView() = default;

  Adapter_SetDiscoverable_ResponseParamsDataView(
      internal::Adapter_SetDiscoverable_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Adapter_SetDiscoverable_ResponseParams_Data* data_ = nullptr;
};


class Adapter_SetName_ParamsDataView {
 public:
  Adapter_SetName_ParamsDataView() = default;

  Adapter_SetName_ParamsDataView(
      internal::Adapter_SetName_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Adapter_SetName_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_SetName_ResponseParamsDataView {
 public:
  Adapter_SetName_ResponseParamsDataView() = default;

  Adapter_SetName_ResponseParamsDataView(
      internal::Adapter_SetName_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Adapter_SetName_ResponseParams_Data* data_ = nullptr;
};


class Adapter_StartDiscoverySession_ParamsDataView {
 public:
  Adapter_StartDiscoverySession_ParamsDataView() = default;

  Adapter_StartDiscoverySession_ParamsDataView(
      internal::Adapter_StartDiscoverySession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetClientNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientName(UserType* output) {
    
    auto* pointer = data_->client_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Adapter_StartDiscoverySession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_StartDiscoverySession_ResponseParamsDataView {
 public:
  Adapter_StartDiscoverySession_ResponseParamsDataView() = default;

  Adapter_StartDiscoverySession_ResponseParamsDataView(
      internal::Adapter_StartDiscoverySession_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSession() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::bluetooth::mojom::DiscoverySessionInterfaceBase>>(
            &data_->session, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Adapter_StartDiscoverySession_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_ConnectToServiceInsecurely_ParamsDataView {
 public:
  Adapter_ConnectToServiceInsecurely_ParamsDataView() = default;

  Adapter_ConnectToServiceInsecurely_ParamsDataView(
      internal::Adapter_ConnectToServiceInsecurely_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddress(UserType* output) {
    
    auto* pointer = data_->address.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetServiceUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceUuid(UserType* output) {
    
    auto* pointer = data_->service_uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  bool should_unbond_on_error() const {
    return data_->should_unbond_on_error;
  }
 private:
  internal::Adapter_ConnectToServiceInsecurely_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_ConnectToServiceInsecurely_ResponseParamsDataView {
 public:
  Adapter_ConnectToServiceInsecurely_ResponseParamsDataView() = default;

  Adapter_ConnectToServiceInsecurely_ResponseParamsDataView(
      internal::Adapter_ConnectToServiceInsecurely_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      ConnectToServiceResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::bluetooth::mojom::ConnectToServiceResultDataView, UserType>(),
    "Attempting to read the optional `result` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResult` instead "
    "of `ReadResult if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::ConnectToServiceResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::Adapter_ConnectToServiceInsecurely_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_CreateRfcommServiceInsecurely_ParamsDataView {
 public:
  Adapter_CreateRfcommServiceInsecurely_ParamsDataView() = default;

  Adapter_CreateRfcommServiceInsecurely_ParamsDataView(
      internal::Adapter_CreateRfcommServiceInsecurely_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServiceNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceName(UserType* output) {
    
    auto* pointer = data_->service_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetServiceUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceUuid(UserType* output) {
    
    auto* pointer = data_->service_uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
 private:
  internal::Adapter_CreateRfcommServiceInsecurely_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_CreateRfcommServiceInsecurely_ResponseParamsDataView {
 public:
  Adapter_CreateRfcommServiceInsecurely_ResponseParamsDataView() = default;

  Adapter_CreateRfcommServiceInsecurely_ResponseParamsDataView(
      internal::Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeServerSocket() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::bluetooth::mojom::ServerSocketInterfaceBase>>(
            &data_->server_socket, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Adapter_CreateRfcommServiceInsecurely_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_CreateLocalGattService_ParamsDataView {
 public:
  Adapter_CreateLocalGattService_ParamsDataView() = default;

  Adapter_CreateLocalGattService_ParamsDataView(
      internal::Adapter_CreateLocalGattService_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServiceIdDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceId(UserType* output) {
    
    auto* pointer = data_->service_id.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::bluetooth::mojom::GattServiceObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Adapter_CreateLocalGattService_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_CreateLocalGattService_ResponseParamsDataView {
 public:
  Adapter_CreateLocalGattService_ResponseParamsDataView() = default;

  Adapter_CreateLocalGattService_ResponseParamsDataView(
      internal::Adapter_CreateLocalGattService_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeGattService() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::bluetooth::mojom::GattServiceInterfaceBase>>(
            &data_->gatt_service, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Adapter_CreateLocalGattService_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Adapter_IsLeScatternetDualRoleSupported_ParamsDataView {
 public:
  Adapter_IsLeScatternetDualRoleSupported_ParamsDataView() = default;

  Adapter_IsLeScatternetDualRoleSupported_ParamsDataView(
      internal::Adapter_IsLeScatternetDualRoleSupported_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Adapter_IsLeScatternetDualRoleSupported_Params_Data* data_ = nullptr;
};


class Adapter_IsLeScatternetDualRoleSupported_ResponseParamsDataView {
 public:
  Adapter_IsLeScatternetDualRoleSupported_ResponseParamsDataView() = default;

  Adapter_IsLeScatternetDualRoleSupported_ResponseParamsDataView(
      internal::Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_supported() const {
    return data_->is_supported;
  }
 private:
  internal::Adapter_IsLeScatternetDualRoleSupported_ResponseParams_Data* data_ = nullptr;
};


class AdapterObserver_PresentChanged_ParamsDataView {
 public:
  AdapterObserver_PresentChanged_ParamsDataView() = default;

  AdapterObserver_PresentChanged_ParamsDataView(
      internal::AdapterObserver_PresentChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool present() const {
    return data_->present;
  }
 private:
  internal::AdapterObserver_PresentChanged_Params_Data* data_ = nullptr;
};


class AdapterObserver_PoweredChanged_ParamsDataView {
 public:
  AdapterObserver_PoweredChanged_ParamsDataView() = default;

  AdapterObserver_PoweredChanged_ParamsDataView(
      internal::AdapterObserver_PoweredChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool powered() const {
    return data_->powered;
  }
 private:
  internal::AdapterObserver_PoweredChanged_Params_Data* data_ = nullptr;
};


class AdapterObserver_DiscoverableChanged_ParamsDataView {
 public:
  AdapterObserver_DiscoverableChanged_ParamsDataView() = default;

  AdapterObserver_DiscoverableChanged_ParamsDataView(
      internal::AdapterObserver_DiscoverableChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool discoverable() const {
    return data_->discoverable;
  }
 private:
  internal::AdapterObserver_DiscoverableChanged_Params_Data* data_ = nullptr;
};


class AdapterObserver_DiscoveringChanged_ParamsDataView {
 public:
  AdapterObserver_DiscoveringChanged_ParamsDataView() = default;

  AdapterObserver_DiscoveringChanged_ParamsDataView(
      internal::AdapterObserver_DiscoveringChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool discovering() const {
    return data_->discovering;
  }
 private:
  internal::AdapterObserver_DiscoveringChanged_Params_Data* data_ = nullptr;
};


class AdapterObserver_DeviceAdded_ParamsDataView {
 public:
  AdapterObserver_DeviceAdded_ParamsDataView() = default;

  AdapterObserver_DeviceAdded_ParamsDataView(
      internal::AdapterObserver_DeviceAdded_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceDataView(
      ::bluetooth::mojom::DeviceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::DeviceInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdapterObserver_DeviceAdded_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdapterObserver_DeviceChanged_ParamsDataView {
 public:
  AdapterObserver_DeviceChanged_ParamsDataView() = default;

  AdapterObserver_DeviceChanged_ParamsDataView(
      internal::AdapterObserver_DeviceChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceDataView(
      ::bluetooth::mojom::DeviceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::DeviceInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdapterObserver_DeviceChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdapterObserver_DeviceRemoved_ParamsDataView {
 public:
  AdapterObserver_DeviceRemoved_ParamsDataView() = default;

  AdapterObserver_DeviceRemoved_ParamsDataView(
      internal::AdapterObserver_DeviceRemoved_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceDataView(
      ::bluetooth::mojom::DeviceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::DeviceInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdapterObserver_DeviceRemoved_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



















inline void ServerSocket_Accept_ResponseParamsDataView::GetResultDataView(
    AcceptConnectionResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = AcceptConnectionResultDataView(pointer, message_);
}






inline void GattService_CreateCharacteristic_ParamsDataView::GetCharacteristicUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->characteristic_uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}
inline void GattService_CreateCharacteristic_ParamsDataView::GetPermissionsDataView(
    ::bluetooth::mojom::GattCharacteristicPermissionsDataView* output) {
  auto pointer = data_->permissions.Get();
  *output = ::bluetooth::mojom::GattCharacteristicPermissionsDataView(pointer, message_);
}
inline void GattService_CreateCharacteristic_ParamsDataView::GetPropertiesDataView(
    ::bluetooth::mojom::GattCharacteristicPropertiesDataView* output) {
  auto pointer = data_->properties.Get();
  *output = ::bluetooth::mojom::GattCharacteristicPropertiesDataView(pointer, message_);
}








inline void GattServiceObserver_OnLocalCharacteristicRead_ParamsDataView::GetRemoteDeviceDataView(
    ::bluetooth::mojom::DeviceInfoDataView* output) {
  auto pointer = data_->remote_device.Get();
  *output = ::bluetooth::mojom::DeviceInfoDataView(pointer, message_);
}
inline void GattServiceObserver_OnLocalCharacteristicRead_ParamsDataView::GetCharacteristicUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->characteristic_uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}
inline void GattServiceObserver_OnLocalCharacteristicRead_ParamsDataView::GetServiceUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->service_uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}


inline void GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsDataView::GetReadResultDataView(
    LocalCharacteristicReadResultDataView* output) {
  auto pointer = &data_->read_result;
  *output = LocalCharacteristicReadResultDataView(pointer, message_);
}


inline void Adapter_ConnectToDevice_ParamsDataView::GetAddressDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->address.Get();
  *output = mojo::StringDataView(pointer, message_);
}






inline void Adapter_GetDevices_ResponseParamsDataView::GetDevicesDataView(
    mojo::ArrayDataView<::bluetooth::mojom::DeviceInfoDataView>* output) {
  auto pointer = data_->devices.Get();
  *output = mojo::ArrayDataView<::bluetooth::mojom::DeviceInfoDataView>(pointer, message_);
}




inline void Adapter_GetInfo_ResponseParamsDataView::GetInfoDataView(
    AdapterInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = AdapterInfoDataView(pointer, message_);
}






inline void Adapter_RegisterAdvertisement_ParamsDataView::GetServiceIdDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->service_id.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}
inline void Adapter_RegisterAdvertisement_ParamsDataView::GetServiceDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->service_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}








inline void Adapter_SetName_ParamsDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void Adapter_StartDiscoverySession_ParamsDataView::GetClientNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->client_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void Adapter_ConnectToServiceInsecurely_ParamsDataView::GetAddressDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->address.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void Adapter_ConnectToServiceInsecurely_ParamsDataView::GetServiceUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->service_uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}


inline void Adapter_ConnectToServiceInsecurely_ResponseParamsDataView::GetResultDataView(
    ConnectToServiceResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = ConnectToServiceResultDataView(pointer, message_);
}


inline void Adapter_CreateRfcommServiceInsecurely_ParamsDataView::GetServiceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->service_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void Adapter_CreateRfcommServiceInsecurely_ParamsDataView::GetServiceUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->service_uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}




inline void Adapter_CreateLocalGattService_ParamsDataView::GetServiceIdDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->service_id.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}
















inline void AdapterObserver_DeviceAdded_ParamsDataView::GetDeviceDataView(
    ::bluetooth::mojom::DeviceInfoDataView* output) {
  auto pointer = data_->device.Get();
  *output = ::bluetooth::mojom::DeviceInfoDataView(pointer, message_);
}


inline void AdapterObserver_DeviceChanged_ParamsDataView::GetDeviceDataView(
    ::bluetooth::mojom::DeviceInfoDataView* output) {
  auto pointer = data_->device.Get();
  *output = ::bluetooth::mojom::DeviceInfoDataView(pointer, message_);
}


inline void AdapterObserver_DeviceRemoved_ParamsDataView::GetDeviceDataView(
    ::bluetooth::mojom::DeviceInfoDataView* output) {
  auto pointer = data_->device.Get();
  *output = ::bluetooth::mojom::DeviceInfoDataView(pointer, message_);
}



}  // bluetooth::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_PARAMS_DATA_H_