// content/public/common/resource_usage_reporter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_H_
#define CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/public/common/resource_usage_reporter.mojom-features.h"  // IWYU pragma: export
#include "content/public/common/resource_usage_reporter.mojom-shared.h"  // IWYU pragma: export
#include "content/public/common/resource_usage_reporter.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class ResourceUsageReporterProxy;

template <typename ImplRefTraits>
class ResourceUsageReporterStub;

class ResourceUsageReporterRequestValidator;
class ResourceUsageReporterResponseValidator;


class CONTENT_EXPORT ResourceUsageReporter
    : public ResourceUsageReporterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.ResourceUsageReporter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ResourceUsageReporterInterfaceBase;
  using Proxy_ = ResourceUsageReporterProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResourceUsageReporterStub<ImplRefTraits>;

  using RequestValidator_ = ResourceUsageReporterRequestValidator;
  using ResponseValidator_ = ResourceUsageReporterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetUsageDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetUsageData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ResourceUsageReporter() = default;

  using GetUsageDataCallback = base::OnceCallback<void(ResourceUsageDataPtr)>;
  using GetUsageDataMojoCallback = base::OnceCallback<void(ResourceUsageDataPtr)>;

  virtual void GetUsageData(GetUsageDataCallback callback) = 0;
};



class CONTENT_EXPORT ResourceUsageReporterProxy
    : public ResourceUsageReporter {
 public:
  using InterfaceType = ResourceUsageReporter;

  explicit ResourceUsageReporterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetUsageData(GetUsageDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT ResourceUsageReporterStubDispatch {
 public:
  static bool Accept(ResourceUsageReporter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResourceUsageReporter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResourceUsageReporter>>
class ResourceUsageReporterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResourceUsageReporterStub() = default;
  ~ResourceUsageReporterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceUsageReporterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceUsageReporterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT ResourceUsageReporterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT ResourceUsageReporterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class CONTENT_EXPORT ResourceTypeStat {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResourceTypeStat, T>::value>;
  using DataView = ResourceTypeStatDataView;
  using Data_ = internal::ResourceTypeStat_Data;

  template <typename... Args>
  static ResourceTypeStatPtr New(Args&&... args) {
    return ResourceTypeStatPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResourceTypeStatPtr From(const U& u) {
    return mojo::TypeConverter<ResourceTypeStatPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResourceTypeStat>::Convert(*this);
  }


  ResourceTypeStat();

  ResourceTypeStat(
      uint64_t count,
      uint64_t size,
      uint64_t live_size,
      uint64_t decoded_size);


  ~ResourceTypeStat();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResourceTypeStatPtr>
  ResourceTypeStatPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResourceTypeStat::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResourceTypeStat::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResourceTypeStat::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceTypeStat::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceTypeStat::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResourceTypeStat::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResourceTypeStat_UnserializedMessageContext<
            UserType, ResourceTypeStat::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResourceTypeStat::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResourceTypeStat::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResourceTypeStat_UnserializedMessageContext<
            UserType, ResourceTypeStat::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResourceTypeStat::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t count;
  
  uint64_t size;
  
  uint64_t live_size;
  
  uint64_t decoded_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResourceTypeStat::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResourceTypeStat::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResourceTypeStat::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResourceTypeStat::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class CONTENT_EXPORT ResourceTypeStats {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResourceTypeStats, T>::value>;
  using DataView = ResourceTypeStatsDataView;
  using Data_ = internal::ResourceTypeStats_Data;

  template <typename... Args>
  static ResourceTypeStatsPtr New(Args&&... args) {
    return ResourceTypeStatsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResourceTypeStatsPtr From(const U& u) {
    return mojo::TypeConverter<ResourceTypeStatsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResourceTypeStats>::Convert(*this);
  }


  ResourceTypeStats();

  ResourceTypeStats(
      ResourceTypeStatPtr images,
      ResourceTypeStatPtr css_style_sheets,
      ResourceTypeStatPtr scripts,
      ResourceTypeStatPtr xsl_style_sheets,
      ResourceTypeStatPtr fonts,
      ResourceTypeStatPtr other);

ResourceTypeStats(const ResourceTypeStats&) = delete;
ResourceTypeStats& operator=(const ResourceTypeStats&) = delete;

  ~ResourceTypeStats();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResourceTypeStatsPtr>
  ResourceTypeStatsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResourceTypeStats::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResourceTypeStats::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResourceTypeStats::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceTypeStats::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceTypeStats::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResourceTypeStats::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResourceTypeStats_UnserializedMessageContext<
            UserType, ResourceTypeStats::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResourceTypeStats::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResourceTypeStats::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResourceTypeStats_UnserializedMessageContext<
            UserType, ResourceTypeStats::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResourceTypeStats::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ResourceTypeStatPtr images;
  
  ResourceTypeStatPtr css_style_sheets;
  
  ResourceTypeStatPtr scripts;
  
  ResourceTypeStatPtr xsl_style_sheets;
  
  ResourceTypeStatPtr fonts;
  
  ResourceTypeStatPtr other;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResourceTypeStats::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResourceTypeStats::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResourceTypeStats::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResourceTypeStats::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT ResourceUsageData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResourceUsageData, T>::value>;
  using DataView = ResourceUsageDataDataView;
  using Data_ = internal::ResourceUsageData_Data;

  template <typename... Args>
  static ResourceUsageDataPtr New(Args&&... args) {
    return ResourceUsageDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResourceUsageDataPtr From(const U& u) {
    return mojo::TypeConverter<ResourceUsageDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResourceUsageData>::Convert(*this);
  }


  ResourceUsageData();

  ResourceUsageData(
      bool reports_v8_stats,
      uint64_t v8_bytes_allocated,
      uint64_t v8_bytes_used,
      ResourceTypeStatsPtr web_cache_stats);

ResourceUsageData(const ResourceUsageData&) = delete;
ResourceUsageData& operator=(const ResourceUsageData&) = delete;

  ~ResourceUsageData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResourceUsageDataPtr>
  ResourceUsageDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResourceUsageData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResourceUsageData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResourceUsageData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceUsageData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceUsageData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResourceUsageData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResourceUsageData_UnserializedMessageContext<
            UserType, ResourceUsageData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResourceUsageData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResourceUsageData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResourceUsageData_UnserializedMessageContext<
            UserType, ResourceUsageData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResourceUsageData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool reports_v8_stats;
  
  uint64_t v8_bytes_allocated;
  
  uint64_t v8_bytes_used;
  
  ResourceTypeStatsPtr web_cache_stats;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResourceUsageData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResourceUsageData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResourceUsageData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResourceUsageData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ResourceTypeStatPtr ResourceTypeStat::Clone() const {
  return New(
      mojo::Clone(count),
      mojo::Clone(size),
      mojo::Clone(live_size),
      mojo::Clone(decoded_size)
  );
}

template <typename T, ResourceTypeStat::EnableIfSame<T>*>
bool ResourceTypeStat::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->count, other_struct.count))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->live_size, other_struct.live_size))
    return false;
  if (!mojo::Equals(this->decoded_size, other_struct.decoded_size))
    return false;
  return true;
}

template <typename T, ResourceTypeStat::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.count < rhs.count)
    return true;
  if (rhs.count < lhs.count)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.live_size < rhs.live_size)
    return true;
  if (rhs.live_size < lhs.live_size)
    return false;
  if (lhs.decoded_size < rhs.decoded_size)
    return true;
  if (rhs.decoded_size < lhs.decoded_size)
    return false;
  return false;
}
template <typename StructPtrType>
ResourceTypeStatsPtr ResourceTypeStats::Clone() const {
  return New(
      mojo::Clone(images),
      mojo::Clone(css_style_sheets),
      mojo::Clone(scripts),
      mojo::Clone(xsl_style_sheets),
      mojo::Clone(fonts),
      mojo::Clone(other)
  );
}

template <typename T, ResourceTypeStats::EnableIfSame<T>*>
bool ResourceTypeStats::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->images, other_struct.images))
    return false;
  if (!mojo::Equals(this->css_style_sheets, other_struct.css_style_sheets))
    return false;
  if (!mojo::Equals(this->scripts, other_struct.scripts))
    return false;
  if (!mojo::Equals(this->xsl_style_sheets, other_struct.xsl_style_sheets))
    return false;
  if (!mojo::Equals(this->fonts, other_struct.fonts))
    return false;
  if (!mojo::Equals(this->other, other_struct.other))
    return false;
  return true;
}

template <typename T, ResourceTypeStats::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.images < rhs.images)
    return true;
  if (rhs.images < lhs.images)
    return false;
  if (lhs.css_style_sheets < rhs.css_style_sheets)
    return true;
  if (rhs.css_style_sheets < lhs.css_style_sheets)
    return false;
  if (lhs.scripts < rhs.scripts)
    return true;
  if (rhs.scripts < lhs.scripts)
    return false;
  if (lhs.xsl_style_sheets < rhs.xsl_style_sheets)
    return true;
  if (rhs.xsl_style_sheets < lhs.xsl_style_sheets)
    return false;
  if (lhs.fonts < rhs.fonts)
    return true;
  if (rhs.fonts < lhs.fonts)
    return false;
  if (lhs.other < rhs.other)
    return true;
  if (rhs.other < lhs.other)
    return false;
  return false;
}
template <typename StructPtrType>
ResourceUsageDataPtr ResourceUsageData::Clone() const {
  return New(
      mojo::Clone(reports_v8_stats),
      mojo::Clone(v8_bytes_allocated),
      mojo::Clone(v8_bytes_used),
      mojo::Clone(web_cache_stats)
  );
}

template <typename T, ResourceUsageData::EnableIfSame<T>*>
bool ResourceUsageData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->reports_v8_stats, other_struct.reports_v8_stats))
    return false;
  if (!mojo::Equals(this->v8_bytes_allocated, other_struct.v8_bytes_allocated))
    return false;
  if (!mojo::Equals(this->v8_bytes_used, other_struct.v8_bytes_used))
    return false;
  if (!mojo::Equals(this->web_cache_stats, other_struct.web_cache_stats))
    return false;
  return true;
}

template <typename T, ResourceUsageData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.reports_v8_stats < rhs.reports_v8_stats)
    return true;
  if (rhs.reports_v8_stats < lhs.reports_v8_stats)
    return false;
  if (lhs.v8_bytes_allocated < rhs.v8_bytes_allocated)
    return true;
  if (rhs.v8_bytes_allocated < lhs.v8_bytes_allocated)
    return false;
  if (lhs.v8_bytes_used < rhs.v8_bytes_used)
    return true;
  if (rhs.v8_bytes_used < lhs.v8_bytes_used)
    return false;
  if (lhs.web_cache_stats < rhs.web_cache_stats)
    return true;
  if (rhs.web_cache_stats < lhs.web_cache_stats)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::ResourceTypeStat::DataView,
                                         ::content::mojom::ResourceTypeStatPtr> {
  static bool IsNull(const ::content::mojom::ResourceTypeStatPtr& input) { return !input; }
  static void SetToNull(::content::mojom::ResourceTypeStatPtr* output) { output->reset(); }

  static decltype(::content::mojom::ResourceTypeStat::count) count(
      const ::content::mojom::ResourceTypeStatPtr& input) {
    return input->count;
  }

  static decltype(::content::mojom::ResourceTypeStat::size) size(
      const ::content::mojom::ResourceTypeStatPtr& input) {
    return input->size;
  }

  static decltype(::content::mojom::ResourceTypeStat::live_size) live_size(
      const ::content::mojom::ResourceTypeStatPtr& input) {
    return input->live_size;
  }

  static decltype(::content::mojom::ResourceTypeStat::decoded_size) decoded_size(
      const ::content::mojom::ResourceTypeStatPtr& input) {
    return input->decoded_size;
  }

  static bool Read(::content::mojom::ResourceTypeStat::DataView input, ::content::mojom::ResourceTypeStatPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::ResourceTypeStats::DataView,
                                         ::content::mojom::ResourceTypeStatsPtr> {
  static bool IsNull(const ::content::mojom::ResourceTypeStatsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::ResourceTypeStatsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::ResourceTypeStats::images)& images(
      const ::content::mojom::ResourceTypeStatsPtr& input) {
    return input->images;
  }

  static const decltype(::content::mojom::ResourceTypeStats::css_style_sheets)& css_style_sheets(
      const ::content::mojom::ResourceTypeStatsPtr& input) {
    return input->css_style_sheets;
  }

  static const decltype(::content::mojom::ResourceTypeStats::scripts)& scripts(
      const ::content::mojom::ResourceTypeStatsPtr& input) {
    return input->scripts;
  }

  static const decltype(::content::mojom::ResourceTypeStats::xsl_style_sheets)& xsl_style_sheets(
      const ::content::mojom::ResourceTypeStatsPtr& input) {
    return input->xsl_style_sheets;
  }

  static const decltype(::content::mojom::ResourceTypeStats::fonts)& fonts(
      const ::content::mojom::ResourceTypeStatsPtr& input) {
    return input->fonts;
  }

  static const decltype(::content::mojom::ResourceTypeStats::other)& other(
      const ::content::mojom::ResourceTypeStatsPtr& input) {
    return input->other;
  }

  static bool Read(::content::mojom::ResourceTypeStats::DataView input, ::content::mojom::ResourceTypeStatsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::ResourceUsageData::DataView,
                                         ::content::mojom::ResourceUsageDataPtr> {
  static bool IsNull(const ::content::mojom::ResourceUsageDataPtr& input) { return !input; }
  static void SetToNull(::content::mojom::ResourceUsageDataPtr* output) { output->reset(); }

  static decltype(::content::mojom::ResourceUsageData::reports_v8_stats) reports_v8_stats(
      const ::content::mojom::ResourceUsageDataPtr& input) {
    return input->reports_v8_stats;
  }

  static decltype(::content::mojom::ResourceUsageData::v8_bytes_allocated) v8_bytes_allocated(
      const ::content::mojom::ResourceUsageDataPtr& input) {
    return input->v8_bytes_allocated;
  }

  static decltype(::content::mojom::ResourceUsageData::v8_bytes_used) v8_bytes_used(
      const ::content::mojom::ResourceUsageDataPtr& input) {
    return input->v8_bytes_used;
  }

  static const decltype(::content::mojom::ResourceUsageData::web_cache_stats)& web_cache_stats(
      const ::content::mojom::ResourceUsageDataPtr& input) {
    return input->web_cache_stats;
  }

  static bool Read(::content::mojom::ResourceUsageData::DataView input, ::content::mojom::ResourceUsageDataPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_H_