// content/common/renderer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_MOJOM_DATA_VIEW_H_
#define CONTENT_COMMON_RENDERER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "content/common/renderer.mojom-shared-internal.h"
#include "content/common/agent_scheduling_group.mojom-shared.h"
#include "content/common/native_types.mojom-shared.h"
#include "ipc/ipc.mojom-shared.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom-shared.h"
#include "mojo/public/mojom/base/process_priority.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-shared.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trials_settings.mojom-shared.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace content::mojom {
class UpdateScrollbarThemeParamsDataView;

class UpdateSystemColorInfoParamsDataView;



}  // content::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::UpdateScrollbarThemeParamsDataView> {
  using Data = ::content::mojom::internal::UpdateScrollbarThemeParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::UpdateSystemColorInfoParamsDataView> {
  using Data = ::content::mojom::internal::UpdateSystemColorInfoParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content::mojom {


enum class RenderProcessVisibleState : int32_t {
  
  kVisible = 0,
  
  kHidden = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, RenderProcessVisibleState value);
inline bool IsKnownEnumValue(RenderProcessVisibleState value) {
  return internal::RenderProcessVisibleState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class RendererInterfaceBase {};

using RendererPtrDataView =
    mojo::InterfacePtrDataView<RendererInterfaceBase>;
using RendererRequestDataView =
    mojo::InterfaceRequestDataView<RendererInterfaceBase>;
using RendererAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RendererInterfaceBase>;
using RendererAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RendererInterfaceBase>;


class UpdateScrollbarThemeParamsDataView {
 public:
  UpdateScrollbarThemeParamsDataView() = default;

  UpdateScrollbarThemeParamsDataView(
      internal::UpdateScrollbarThemeParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_initial_button_delay() const {
    return data_->has_initial_button_delay;
  }
  float initial_button_delay() const {
    return data_->initial_button_delay;
  }
  bool has_autoscroll_button_delay() const {
    return data_->has_autoscroll_button_delay;
  }
  float autoscroll_button_delay() const {
    return data_->autoscroll_button_delay;
  }
  bool jump_on_track_click() const {
    return data_->jump_on_track_click;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPreferredScrollerStyle(UserType* output) const {
    auto data_value = data_->preferred_scroller_style;
    return mojo::internal::Deserialize<::content::mojom::ScrollerStyle>(
        data_value, output);
  }
  ::content::mojom::ScrollerStyle preferred_scroller_style() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::ScrollerStyle>(data_->preferred_scroller_style));
  }
  bool redraw() const {
    return data_->redraw;
  }
  bool scroll_view_rubber_banding() const {
    return data_->scroll_view_rubber_banding;
  }
 private:
  internal::UpdateScrollbarThemeParams_Data* data_ = nullptr;
};


class UpdateSystemColorInfoParamsDataView {
 public:
  UpdateSystemColorInfoParamsDataView() = default;

  UpdateSystemColorInfoParamsDataView(
      internal::UpdateSystemColorInfoParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  std::optional<uint32_t> accent_color() const {

    return data_->accent_color_$flag
        ? std::make_optional(data_->accent_color_$value)
        : std::nullopt;
  }
 private:
  internal::UpdateSystemColorInfoParams_Data* data_ = nullptr;
};


}  // content::mojom

#endif  // CONTENT_COMMON_RENDERER_MOJOM_DATA_VIEW_H_