// content/common/render_widget_host_ns_view.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_WIDGET_HOST_NS_VIEW_MOJOM_DATA_VIEW_H_
#define CONTENT_COMMON_RENDER_WIDGET_HOST_NS_VIEW_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "content/common/render_widget_host_ns_view.mojom-shared-internal.h"
#include "mojo/public/mojom/base/process_id.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared.h"
#include "third_party/blink/public/mojom/webshare/share_error.mojom-shared.h"
#include "ui/base/cursor/mojom/cursor.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"
#include "ui/base/mojom/attributed_string.mojom-shared.h"
#include "ui/display/mojom/screen_infos.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/ca_layer_params.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace remote_cocoa::mojom {
class PopupMenuDataView;



}  // remote_cocoa::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::PopupMenuDataView> {
  using Data = ::remote_cocoa::mojom::internal::PopupMenu_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace remote_cocoa::mojom {
// Interface base classes. They are used for type safety check.
class PopupMenuRunnerInterfaceBase {};

using PopupMenuRunnerPtrDataView =
    mojo::InterfacePtrDataView<PopupMenuRunnerInterfaceBase>;
using PopupMenuRunnerRequestDataView =
    mojo::InterfaceRequestDataView<PopupMenuRunnerInterfaceBase>;
using PopupMenuRunnerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PopupMenuRunnerInterfaceBase>;
using PopupMenuRunnerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PopupMenuRunnerInterfaceBase>;
class RenderWidgetHostNSViewInterfaceBase {};

using RenderWidgetHostNSViewPtrDataView =
    mojo::InterfacePtrDataView<RenderWidgetHostNSViewInterfaceBase>;
using RenderWidgetHostNSViewRequestDataView =
    mojo::InterfaceRequestDataView<RenderWidgetHostNSViewInterfaceBase>;
using RenderWidgetHostNSViewAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderWidgetHostNSViewInterfaceBase>;
using RenderWidgetHostNSViewAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderWidgetHostNSViewInterfaceBase>;
class RenderWidgetHostNSViewHostInterfaceBase {};

using RenderWidgetHostNSViewHostPtrDataView =
    mojo::InterfacePtrDataView<RenderWidgetHostNSViewHostInterfaceBase>;
using RenderWidgetHostNSViewHostRequestDataView =
    mojo::InterfaceRequestDataView<RenderWidgetHostNSViewHostInterfaceBase>;
using RenderWidgetHostNSViewHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderWidgetHostNSViewHostInterfaceBase>;
using RenderWidgetHostNSViewHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderWidgetHostNSViewHostInterfaceBase>;


class PopupMenuDataView {
 public:
  PopupMenuDataView() = default;

  PopupMenuDataView(
      internal::PopupMenu_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemsDataView(
      mojo::ArrayDataView<::blink::mojom::MenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::MenuItemDataView>>(
        pointer, output, message_);
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  double item_font_size() const {
    return data_->item_font_size;
  }
  bool right_aligned() const {
    return data_->right_aligned;
  }
  uint32_t selected_item() const {
    return data_->selected_item;
  }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::remote_cocoa::mojom::PopupMenuRunnerInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PopupMenu_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // remote_cocoa::mojom

#endif  // CONTENT_COMMON_RENDER_WIDGET_HOST_NS_VIEW_MOJOM_DATA_VIEW_H_