// content/common/input/input_injector.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_DATA_VIEW_H_
#define CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "content/common/input/input_injector.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace content::mojom {
class SyntheticSmoothDragDataView;

class SyntheticSmoothScrollDataView;

class SyntheticPinchDataView;

class SyntheticTapDataView;

class SyntheticPointerActionParamsDataView;

class SyntheticPointerActionDataView;



}  // content::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::SyntheticSmoothDragDataView> {
  using Data = ::content::mojom::internal::SyntheticSmoothDrag_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::SyntheticSmoothScrollDataView> {
  using Data = ::content::mojom::internal::SyntheticSmoothScroll_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::SyntheticPinchDataView> {
  using Data = ::content::mojom::internal::SyntheticPinch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::SyntheticTapDataView> {
  using Data = ::content::mojom::internal::SyntheticTap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::SyntheticPointerActionParamsDataView> {
  using Data = ::content::mojom::internal::SyntheticPointerActionParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::SyntheticPointerActionDataView> {
  using Data = ::content::mojom::internal::SyntheticPointerAction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content::mojom {


enum class GestureSourceType : int32_t {
  
  kDefaultInput = 0,
  
  kTouchInput = 1,
  
  kMouseInput = 2,
  
  kTouchpadInput = 2,
  
  kPenInput = 3,
  
  kGestureSourceTypeMax = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, GestureSourceType value);
inline bool IsKnownEnumValue(GestureSourceType value) {
  return internal::GestureSourceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PointerActionType : int32_t {
  
  kNotInitialized = 0,
  
  kPress = 1,
  
  kMove = 2,
  
  kRelease = 3,
  
  kCancel = 4,
  
  kLeave = 5,
  
  kIdle = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, PointerActionType value);
inline bool IsKnownEnumValue(PointerActionType value) {
  return internal::PointerActionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SyntheticButton : int32_t {
  
  kNoButton = 0,
  
  kLeft = 1,
  
  kMiddle = 2,
  
  kRight = 3,
  
  kBack = 4,
  
  kForward = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, SyntheticButton value);
inline bool IsKnownEnumValue(SyntheticButton value) {
  return internal::SyntheticButton_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InputEventPattern : int32_t {
  
  kDefaultPattern = 0,
  
  kOnePerVsync = 1,
  
  kTwoPerVsync = 2,
  
  kEveryOtherVsync = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, InputEventPattern value);
inline bool IsKnownEnumValue(InputEventPattern value) {
  return internal::InputEventPattern_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class InputInjectorInterfaceBase {};

using InputInjectorPtrDataView =
    mojo::InterfacePtrDataView<InputInjectorInterfaceBase>;
using InputInjectorRequestDataView =
    mojo::InterfaceRequestDataView<InputInjectorInterfaceBase>;
using InputInjectorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<InputInjectorInterfaceBase>;
using InputInjectorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<InputInjectorInterfaceBase>;


class SyntheticSmoothDragDataView {
 public:
  SyntheticSmoothDragDataView() = default;

  SyntheticSmoothDragDataView(
      internal::SyntheticSmoothDrag_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadGestureSourceType(UserType* output) const {
    auto data_value = data_->gesture_source_type;
    return mojo::internal::Deserialize<::content::mojom::GestureSourceType>(
        data_value, output);
  }
  GestureSourceType gesture_source_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::GestureSourceType>(data_->gesture_source_type));
  }
  inline void GetStartPointDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartPoint(UserType* output) {
    
    auto* pointer = data_->start_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetDistancesDataView(
      mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDistances(UserType* output) {
    
    auto* pointer = data_->distances.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>>(
        pointer, output, message_);
  }
  float speed_in_pixels_s() const {
    return data_->speed_in_pixels_s;
  }
  float vsync_offset_ms() const {
    return data_->vsync_offset_ms;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInputEventPattern(UserType* output) const {
    auto data_value = data_->input_event_pattern;
    return mojo::internal::Deserialize<::content::mojom::InputEventPattern>(
        data_value, output);
  }
  InputEventPattern input_event_pattern() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::InputEventPattern>(data_->input_event_pattern));
  }
 private:
  internal::SyntheticSmoothDrag_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SyntheticSmoothScrollDataView {
 public:
  SyntheticSmoothScrollDataView() = default;

  SyntheticSmoothScrollDataView(
      internal::SyntheticSmoothScroll_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadGestureSourceType(UserType* output) const {
    auto data_value = data_->gesture_source_type;
    return mojo::internal::Deserialize<::content::mojom::GestureSourceType>(
        data_value, output);
  }
  GestureSourceType gesture_source_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::GestureSourceType>(data_->gesture_source_type));
  }
  inline void GetAnchorDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnchor(UserType* output) {
    
    auto* pointer = data_->anchor.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetDistancesDataView(
      mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDistances(UserType* output) {
    
    auto* pointer = data_->distances.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::Vector2dFDataView>>(
        pointer, output, message_);
  }
  bool prevent_fling() const {
    return data_->prevent_fling;
  }
  float speed_in_pixels_s() const {
    return data_->speed_in_pixels_s;
  }
  float fling_velocity_x() const {
    return data_->fling_velocity_x;
  }
  float fling_velocity_y() const {
    return data_->fling_velocity_y;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadGranularity(UserType* output) const {
    auto data_value = data_->granularity;
    return mojo::internal::Deserialize<::ui::mojom::ScrollGranularity>(
        data_value, output);
  }
  ::ui::mojom::ScrollGranularity granularity() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::ScrollGranularity>(data_->granularity));
  }
  int32_t modifiers() const {
    return data_->modifiers;
  }
  float vsync_offset_ms() const {
    return data_->vsync_offset_ms;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInputEventPattern(UserType* output) const {
    auto data_value = data_->input_event_pattern;
    return mojo::internal::Deserialize<::content::mojom::InputEventPattern>(
        data_value, output);
  }
  InputEventPattern input_event_pattern() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::InputEventPattern>(data_->input_event_pattern));
  }
 private:
  internal::SyntheticSmoothScroll_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SyntheticPinchDataView {
 public:
  SyntheticPinchDataView() = default;

  SyntheticPinchDataView(
      internal::SyntheticPinch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  float scale_factor() const {
    return data_->scale_factor;
  }
  inline void GetAnchorDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnchor(UserType* output) {
    
    auto* pointer = data_->anchor.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  float relative_pointer_speed_in_pixels_s() const {
    return data_->relative_pointer_speed_in_pixels_s;
  }
  float vsync_offset_ms() const {
    return data_->vsync_offset_ms;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInputEventPattern(UserType* output) const {
    auto data_value = data_->input_event_pattern;
    return mojo::internal::Deserialize<::content::mojom::InputEventPattern>(
        data_value, output);
  }
  InputEventPattern input_event_pattern() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::InputEventPattern>(data_->input_event_pattern));
  }
 private:
  internal::SyntheticPinch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SyntheticTapDataView {
 public:
  SyntheticTapDataView() = default;

  SyntheticTapDataView(
      internal::SyntheticTap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadGestureSourceType(UserType* output) const {
    auto data_value = data_->gesture_source_type;
    return mojo::internal::Deserialize<::content::mojom::GestureSourceType>(
        data_value, output);
  }
  GestureSourceType gesture_source_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::GestureSourceType>(data_->gesture_source_type));
  }
  inline void GetPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  float duration_ms() const {
    return data_->duration_ms;
  }
 private:
  internal::SyntheticTap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SyntheticPointerActionParamsDataView {
 public:
  SyntheticPointerActionParamsDataView() = default;

  SyntheticPointerActionParamsDataView(
      internal::SyntheticPointerActionParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPointerActionType(UserType* output) const {
    auto data_value = data_->pointer_action_type;
    return mojo::internal::Deserialize<::content::mojom::PointerActionType>(
        data_value, output);
  }
  PointerActionType pointer_action_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::PointerActionType>(data_->pointer_action_type));
  }
  inline void GetPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  uint32_t pointer_id() const {
    return data_->pointer_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadButton(UserType* output) const {
    auto data_value = data_->button;
    return mojo::internal::Deserialize<::content::mojom::SyntheticButton>(
        data_value, output);
  }
  SyntheticButton button() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::SyntheticButton>(data_->button));
  }
  int32_t key_modifiers() const {
    return data_->key_modifiers;
  }
  float width() const {
    return data_->width;
  }
  float height() const {
    return data_->height;
  }
  float rotation_angle() const {
    return data_->rotation_angle;
  }
  float force() const {
    return data_->force;
  }
  float tangential_pressure() const {
    return data_->tangential_pressure;
  }
  int32_t tilt_x() const {
    return data_->tilt_x;
  }
  int32_t tilt_y() const {
    return data_->tilt_y;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::SyntheticPointerActionParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SyntheticPointerActionDataView {
 public:
  SyntheticPointerActionDataView() = default;

  SyntheticPointerActionDataView(
      internal::SyntheticPointerAction_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadGestureSourceType(UserType* output) const {
    auto data_value = data_->gesture_source_type;
    return mojo::internal::Deserialize<::content::mojom::GestureSourceType>(
        data_value, output);
  }
  GestureSourceType gesture_source_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::GestureSourceType>(data_->gesture_source_type));
  }
  inline void GetParamsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<SyntheticPointerActionParamsDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<::content::mojom::SyntheticPointerActionParamsDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::SyntheticPointerAction_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // content::mojom

#endif  // CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_DATA_VIEW_H_