// content/common/frame.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_MOJOM_H_
#define CONTENT_COMMON_FRAME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/frame.mojom-features.h"  // IWYU pragma: export
#include "content/common/frame.mojom-shared.h"  // IWYU pragma: export
#include "content/common/frame.mojom-forward.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_state.mojom-forward.h"
#include "content/common/frame_messages.mojom-forward.h"
#include "content/common/navigation_client.mojom.h"
#include "content/common/web_ui.mojom-forward.h"
#include "content/public/common/extra_mojo_js_features.mojom-forward.h"
#include "content/public/common/window_container_type.mojom-forward.h"
#include "ipc/constants.mojom-forward.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "services/network/public/mojom/attribution.mojom-forward.h"
#include "services/network/public/mojom/content_security_policy.mojom-forward.h"
#include "services/network/public/mojom/url_loader.mojom-forward.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-forward.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include "services/network/public/mojom/url_request.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom-forward.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-forward.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-forward.h"
#include "third_party/blink/public/mojom/associated_interfaces/associated_interfaces.mojom-forward.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-forward.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-forward.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-forward.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-forward.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-forward.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom.h"
#include "third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-forward.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-forward.h"
#include "third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom-forward.h"
#include "third_party/blink/public/mojom/page/page.mojom.h"
#include "third_party/blink/public/mojom/page/prerender_page_param.mojom.h"
#include "third_party/blink/public/mojom/partitioned_popins/partitioned_popin_params.mojom.h"
#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-forward.h"
#include "third_party/blink/public/mojom/page/widget.mojom-forward.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include "ui/base/mojom/window_open_disposition.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/scheme_host_port.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/frame_owner_element_type_mojom_traits.h"
#include "content/common/input/input_injector_mojom_traits.h"
#include "content/common/input/synthetic_pinch_gesture_params.h"
#include "content/common/input/synthetic_pointer_action_list_params.h"
#include "content/common/input/synthetic_smooth_drag_gesture_params.h"
#include "content/common/input/synthetic_smooth_scroll_gesture_params.h"
#include "content/common/input/synthetic_tap_gesture_params.h"
#include "content/common/navigation_gesture.h"
#include "net/base/network_change_notifier.h"
#include "third_party/blink/public/common/navigation/impression.h"
#include "third_party/blink/public/common/widget/visual_properties.h"
#include "ui/events/types/scroll_types.h"
#include "ui/native_theme/native_theme.h"
#include "content/common/content_export.h"




namespace content::mojom {

class FrameHTMLSerializerHandlerProxy;

template <typename ImplRefTraits>
class FrameHTMLSerializerHandlerStub;

class FrameHTMLSerializerHandlerRequestValidator;


class CONTENT_EXPORT FrameHTMLSerializerHandler
    : public FrameHTMLSerializerHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.FrameHTMLSerializerHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameHTMLSerializerHandlerInterfaceBase;
  using Proxy_ = FrameHTMLSerializerHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameHTMLSerializerHandlerStub<ImplRefTraits>;

  using RequestValidator_ = FrameHTMLSerializerHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidReceiveDataMinVersion = 0,
    kDoneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidReceiveData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Done_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameHTMLSerializerHandler() = default;

  virtual void DidReceiveData(const std::string& data_buffer) = 0;

  virtual void Done() = 0;
};

class FrameProxy;

template <typename ImplRefTraits>
class FrameStub;

class FrameRequestValidator;
class FrameResponseValidator;


class CONTENT_EXPORT Frame
    : public FrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.Frame";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameInterfaceBase;
  using Proxy_ = FrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameStub<ImplRefTraits>;

  using RequestValidator_ = FrameRequestValidator;
  using ResponseValidator_ = FrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCommitSameDocumentNavigationMinVersion = 0,
    kUpdateSubresourceLoaderFactoriesMinVersion = 0,
    kSetWantErrorMessageStackTraceMinVersion = 0,
    kUnloadMinVersion = 0,
    kDeleteMinVersion = 0,
    kUndoCommitNavigationMinVersion = 0,
    kGetInterfaceProviderMinVersion = 0,
    kSnapshotAccessibilityTreeMinVersion = 0,
    kGetSerializedHtmlWithLocalLinksMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CommitSameDocumentNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateSubresourceLoaderFactories_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWantErrorMessageStackTrace_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Unload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Delete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UndoCommitNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetInterfaceProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SnapshotAccessibilityTree_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSerializedHtmlWithLocalLinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Frame() = default;

  using CommitSameDocumentNavigationCallback = base::OnceCallback<void(::blink::mojom::CommitResult)>;
  using CommitSameDocumentNavigationMojoCallback = base::OnceCallback<void(::blink::mojom::CommitResult)>;

  virtual void CommitSameDocumentNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, CommitSameDocumentNavigationCallback callback) = 0;

  virtual void UpdateSubresourceLoaderFactories(::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories) = 0;

  virtual void SetWantErrorMessageStackTrace() = 0;

  virtual void Unload(bool is_loading, ::blink::mojom::FrameReplicationStatePtr new_remote_frame_replication_state, const ::blink::RemoteFrameToken& new_remote_frame_token, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr new_remote_frame_interfaces, ::blink::mojom::RemoteMainFrameInterfacesPtr new_remote_main_frame_interfaces, const std::optional<::base::UnguessableToken>& devtools_frame_token) = 0;

  virtual void Delete(FrameDeleteIntention intention) = 0;

  virtual void UndoCommitNavigation(bool is_loading, ::blink::mojom::FrameReplicationStatePtr new_remote_frame_replication_state, const ::blink::RemoteFrameToken& new_remote_frame_token, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr new_remote_frame_interfaces, ::blink::mojom::RemoteMainFrameInterfacesPtr new_remote_main_frame_interfaces) = 0;

  virtual void GetInterfaceProvider(::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> interfaces) = 0;

  using SnapshotAccessibilityTreeCallback = base::OnceCallback<void(const ::ui::AXTreeUpdate&)>;
  using SnapshotAccessibilityTreeMojoCallback = base::OnceCallback<void(const ::ui::AXTreeUpdate&)>;

  virtual void SnapshotAccessibilityTree(SnapshotAccessibilityTreeParamsPtr params, SnapshotAccessibilityTreeCallback callback) = 0;

  virtual void GetSerializedHtmlWithLocalLinks(const base::flat_map<::GURL, ::base::FilePath>& url_map, const base::flat_map<::blink::FrameToken, ::base::FilePath>& frame_token_map, bool save_with_empty_url, ::mojo::PendingRemote<FrameHTMLSerializerHandler> handler_remote) = 0;
};

class FrameBindingsControlProxy;

template <typename ImplRefTraits>
class FrameBindingsControlStub;

class FrameBindingsControlRequestValidator;


class CONTENT_EXPORT FrameBindingsControl
    : public FrameBindingsControlInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.FrameBindingsControl";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameBindingsControlInterfaceBase;
  using Proxy_ = FrameBindingsControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameBindingsControlStub<ImplRefTraits>;

  using RequestValidator_ = FrameBindingsControlRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAllowBindingsMinVersion = 0,
    kEnableMojoJsBindingsMinVersion = 0,
    kEnableMojoJsBindingsWithBrokerMinVersion = 0,
    kBindWebUIMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AllowBindings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableMojoJsBindings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableMojoJsBindingsWithBroker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindWebUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameBindingsControl() = default;

  virtual void AllowBindings(int64_t enabled_bindings_flags) = 0;

  virtual void EnableMojoJsBindings(::content::mojom::ExtraMojoJsFeaturesPtr features) = 0;

  virtual void EnableMojoJsBindingsWithBroker(::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> broker) = 0;

  virtual void BindWebUI(::mojo::PendingAssociatedReceiver<::content::mojom::WebUI> receiver, ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost> remote) = 0;
};

class NavigationRendererCancellationListenerProxy;

template <typename ImplRefTraits>
class NavigationRendererCancellationListenerStub;

class NavigationRendererCancellationListenerRequestValidator;


class CONTENT_EXPORT NavigationRendererCancellationListener
    : public NavigationRendererCancellationListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.NavigationRendererCancellationListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NavigationRendererCancellationListenerInterfaceBase;
  using Proxy_ = NavigationRendererCancellationListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = NavigationRendererCancellationListenerStub<ImplRefTraits>;

  using RequestValidator_ = NavigationRendererCancellationListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRendererCancellationWindowEndedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RendererCancellationWindowEnded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NavigationRendererCancellationListener() = default;

  virtual void RendererCancellationWindowEnded() = 0;
};

class FrameHostProxy;

template <typename ImplRefTraits>
class FrameHostStub;

class FrameHostRequestValidator;
class FrameHostResponseValidator;


class CONTENT_EXPORT FrameHost
    : public FrameHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.FrameHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameHostInterfaceBase;
  using Proxy_ = FrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameHostStub<ImplRefTraits>;

  using RequestValidator_ = FrameHostRequestValidator;
  using ResponseValidator_ = FrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateNewWindowMinVersion = 0,
    kCreateChildFrameMinVersion = 0,
    kDidCommitProvisionalLoadMinVersion = 0,
    kDidCommitSameDocumentNavigationMinVersion = 0,
    kDidOpenDocumentInputStreamMinVersion = 0,
    kBeginNavigationMinVersion = 0,
    kSubresourceResponseStartedMinVersion = 0,
    kResourceLoadCompleteMinVersion = 0,
    kDidChangeNameMinVersion = 0,
    kCancelInitialHistoryLoadMinVersion = 0,
    kUpdateEncodingMinVersion = 0,
    kUpdateStateMinVersion = 0,
    kOpenURLMinVersion = 0,
    kDidStopLoadingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateNewWindow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateChildFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidCommitProvisionalLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidCommitSameDocumentNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidOpenDocumentInputStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BeginNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubresourceResponseStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResourceLoadComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelInitialHistoryLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateEncoding_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidStopLoading_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameHost() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply);
  using CreateNewWindowCallback = base::OnceCallback<void(CreateNewWindowStatus, CreateNewWindowReplyPtr)>;
  using CreateNewWindowMojoCallback = base::OnceCallback<void(CreateNewWindowStatus, CreateNewWindowReplyPtr)>;

  virtual void CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowCallback callback) = 0;

  virtual void CreateChildFrame(const ::blink::LocalFrameToken& child_frame_token, ::mojo::PendingAssociatedRemote<Frame> frame, ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker, ::blink::mojom::PolicyContainerBindParamsPtr policy_container_bind_params, ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider, ::blink::mojom::TreeScopeType scope, const std::string& frame_name, const std::string& frame_unique_name, bool is_created_by_script, const ::blink::FramePolicy& frame_policy, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties, ::blink::FrameOwnerElementType child_frame_owner_element_type, int64_t document_ukm_source_id) = 0;

  virtual void DidCommitProvisionalLoad(::content::mojom::DidCommitProvisionalLoadParamsPtr params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr interface_params) = 0;

  virtual void DidCommitSameDocumentNavigation(::content::mojom::DidCommitProvisionalLoadParamsPtr params, ::content::mojom::DidCommitSameDocumentNavigationParamsPtr same_document_params) = 0;

  virtual void DidOpenDocumentInputStream(const ::GURL& url) = 0;

  virtual void BeginNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::BeginNavigationParamsPtr begin_params, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token, ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> navigation_client, ::mojo::PendingRemote<::blink::mojom::NavigationStateKeepAliveHandle> initiator_navigation_state_keep_alive_handle, ::mojo::PendingReceiver<NavigationRendererCancellationListener> renderer_cancellation_listener) = 0;

  virtual void SubresourceResponseStarted(const ::url::SchemeHostPort& final_response_url, uint32_t cert_status) = 0;

  virtual void ResourceLoadComplete(::blink::mojom::ResourceLoadInfoPtr url_load_info) = 0;

  virtual void DidChangeName(const std::string& name, const std::string& unique_name) = 0;

  virtual void CancelInitialHistoryLoad() = 0;

  virtual void UpdateEncoding(const std::string& encoding_name) = 0;

  virtual void UpdateState(const ::blink::PageState& state) = 0;

  virtual void OpenURL(::blink::mojom::OpenURLParamsPtr params) = 0;

  virtual void DidStopLoading() = 0;
};



class CONTENT_EXPORT FrameHTMLSerializerHandlerProxy
    : public FrameHTMLSerializerHandler {
 public:
  using InterfaceType = FrameHTMLSerializerHandler;

  explicit FrameHTMLSerializerHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidReceiveData(const std::string& data_buffer) final;
  
  void Done() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT FrameProxy
    : public Frame {
 public:
  using InterfaceType = Frame;

  explicit FrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CommitSameDocumentNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, CommitSameDocumentNavigationCallback callback) final;
  
  void UpdateSubresourceLoaderFactories(::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories) final;
  
  void SetWantErrorMessageStackTrace() final;
  
  void Unload(bool is_loading, ::blink::mojom::FrameReplicationStatePtr new_remote_frame_replication_state, const ::blink::RemoteFrameToken& new_remote_frame_token, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr new_remote_frame_interfaces, ::blink::mojom::RemoteMainFrameInterfacesPtr new_remote_main_frame_interfaces, const std::optional<::base::UnguessableToken>& devtools_frame_token) final;
  
  void Delete(FrameDeleteIntention intention) final;
  
  void UndoCommitNavigation(bool is_loading, ::blink::mojom::FrameReplicationStatePtr new_remote_frame_replication_state, const ::blink::RemoteFrameToken& new_remote_frame_token, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr new_remote_frame_interfaces, ::blink::mojom::RemoteMainFrameInterfacesPtr new_remote_main_frame_interfaces) final;
  
  void GetInterfaceProvider(::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> interfaces) final;
  
  void SnapshotAccessibilityTree(SnapshotAccessibilityTreeParamsPtr params, SnapshotAccessibilityTreeCallback callback) final;
  
  void GetSerializedHtmlWithLocalLinks(const base::flat_map<::GURL, ::base::FilePath>& url_map, const base::flat_map<::blink::FrameToken, ::base::FilePath>& frame_token_map, bool save_with_empty_url, ::mojo::PendingRemote<FrameHTMLSerializerHandler> handler_remote) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT FrameBindingsControlProxy
    : public FrameBindingsControl {
 public:
  using InterfaceType = FrameBindingsControl;

  explicit FrameBindingsControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AllowBindings(int64_t enabled_bindings_flags) final;
  
  void EnableMojoJsBindings(::content::mojom::ExtraMojoJsFeaturesPtr features) final;
  
  void EnableMojoJsBindingsWithBroker(::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> broker) final;
  
  void BindWebUI(::mojo::PendingAssociatedReceiver<::content::mojom::WebUI> receiver, ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost> remote) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT NavigationRendererCancellationListenerProxy
    : public NavigationRendererCancellationListener {
 public:
  using InterfaceType = NavigationRendererCancellationListener;

  explicit NavigationRendererCancellationListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RendererCancellationWindowEnded() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT FrameHostProxy
    : public FrameHost {
 public:
  using InterfaceType = FrameHost;

  explicit FrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply) final;
  
  void CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowCallback callback) final;
  
  void CreateChildFrame(const ::blink::LocalFrameToken& child_frame_token, ::mojo::PendingAssociatedRemote<Frame> frame, ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker, ::blink::mojom::PolicyContainerBindParamsPtr policy_container_bind_params, ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider, ::blink::mojom::TreeScopeType scope, const std::string& frame_name, const std::string& frame_unique_name, bool is_created_by_script, const ::blink::FramePolicy& frame_policy, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties, ::blink::FrameOwnerElementType child_frame_owner_element_type, int64_t document_ukm_source_id) final;
  
  void DidCommitProvisionalLoad(::content::mojom::DidCommitProvisionalLoadParamsPtr params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr interface_params) final;
  
  void DidCommitSameDocumentNavigation(::content::mojom::DidCommitProvisionalLoadParamsPtr params, ::content::mojom::DidCommitSameDocumentNavigationParamsPtr same_document_params) final;
  
  void DidOpenDocumentInputStream(const ::GURL& url) final;
  
  void BeginNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::BeginNavigationParamsPtr begin_params, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token, ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> navigation_client, ::mojo::PendingRemote<::blink::mojom::NavigationStateKeepAliveHandle> initiator_navigation_state_keep_alive_handle, ::mojo::PendingReceiver<NavigationRendererCancellationListener> renderer_cancellation_listener) final;
  
  void SubresourceResponseStarted(const ::url::SchemeHostPort& final_response_url, uint32_t cert_status) final;
  
  void ResourceLoadComplete(::blink::mojom::ResourceLoadInfoPtr url_load_info) final;
  
  void DidChangeName(const std::string& name, const std::string& unique_name) final;
  
  void CancelInitialHistoryLoad() final;
  
  void UpdateEncoding(const std::string& encoding_name) final;
  
  void UpdateState(const ::blink::PageState& state) final;
  
  void OpenURL(::blink::mojom::OpenURLParamsPtr params) final;
  
  void DidStopLoading() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT FrameHTMLSerializerHandlerStubDispatch {
 public:
  static bool Accept(FrameHTMLSerializerHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameHTMLSerializerHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameHTMLSerializerHandler>>
class FrameHTMLSerializerHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameHTMLSerializerHandlerStub() = default;
  ~FrameHTMLSerializerHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameHTMLSerializerHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameHTMLSerializerHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameStubDispatch {
 public:
  static bool Accept(Frame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Frame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Frame>>
class FrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameStub() = default;
  ~FrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameBindingsControlStubDispatch {
 public:
  static bool Accept(FrameBindingsControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameBindingsControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameBindingsControl>>
class FrameBindingsControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameBindingsControlStub() = default;
  ~FrameBindingsControlStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameBindingsControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameBindingsControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT NavigationRendererCancellationListenerStubDispatch {
 public:
  static bool Accept(NavigationRendererCancellationListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NavigationRendererCancellationListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NavigationRendererCancellationListener>>
class NavigationRendererCancellationListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NavigationRendererCancellationListenerStub() = default;
  ~NavigationRendererCancellationListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigationRendererCancellationListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NavigationRendererCancellationListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameHostStubDispatch {
 public:
  static bool Accept(FrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameHost>>
class FrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameHostStub() = default;
  ~FrameHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameHTMLSerializerHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameBindingsControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT NavigationRendererCancellationListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};














class CONTENT_EXPORT CreateMainFrameUnion {
 public:
  using DataView = CreateMainFrameUnionDataView;
  using Data_ = internal::CreateMainFrameUnion_Data;
  using Tag = Data_::CreateMainFrameUnion_Tag;

  template <typename... Args>
  static CreateMainFrameUnionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |local_params|.
  static CreateMainFrameUnionPtr NewLocalParams(
      CreateLocalMainFrameParamsPtr value);
  // Construct an instance holding |provisional_local_params|.
  static CreateMainFrameUnionPtr NewProvisionalLocalParams(
      CreateProvisionalLocalMainFrameParamsPtr value);
  // Construct an instance holding |remote_params|.
  static CreateMainFrameUnionPtr NewRemoteParams(
      CreateRemoteMainFrameParamsPtr value);

  template <typename U>
  static CreateMainFrameUnionPtr From(const U& u) {
    return mojo::TypeConverter<CreateMainFrameUnionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateMainFrameUnion>::Convert(*this);
  }
  ~CreateMainFrameUnion();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CreateMainFrameUnion(const CreateMainFrameUnion& other) = delete;
  CreateMainFrameUnion& operator=(const CreateMainFrameUnion& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CreateMainFrameUnionPtr>
  CreateMainFrameUnionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateMainFrameUnion>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateMainFrameUnion>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_local_params() const { return tag_ == Tag::kLocalParams; }
  const CreateLocalMainFrameParamsPtr& get_local_params() const {
    CHECK(tag_ == Tag::kLocalParams);
    return data_.local_params;
  }
  CreateLocalMainFrameParamsPtr& get_local_params() {
    CHECK(tag_ == Tag::kLocalParams);
    return data_.local_params;
  }
  void set_local_params(CreateLocalMainFrameParamsPtr local_params);

  bool is_provisional_local_params() const { return tag_ == Tag::kProvisionalLocalParams; }
  const CreateProvisionalLocalMainFrameParamsPtr& get_provisional_local_params() const {
    CHECK(tag_ == Tag::kProvisionalLocalParams);
    return data_.provisional_local_params;
  }
  CreateProvisionalLocalMainFrameParamsPtr& get_provisional_local_params() {
    CHECK(tag_ == Tag::kProvisionalLocalParams);
    return data_.provisional_local_params;
  }
  void set_provisional_local_params(CreateProvisionalLocalMainFrameParamsPtr provisional_local_params);

  bool is_remote_params() const { return tag_ == Tag::kRemoteParams; }
  const CreateRemoteMainFrameParamsPtr& get_remote_params() const {
    CHECK(tag_ == Tag::kRemoteParams);
    return data_.remote_params;
  }
  CreateRemoteMainFrameParamsPtr& get_remote_params() {
    CHECK(tag_ == Tag::kRemoteParams);
    return data_.remote_params;
  }
  void set_remote_params(CreateRemoteMainFrameParamsPtr remote_params);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateMainFrameUnion::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CreateMainFrameUnion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLocalParams)>,
        CreateLocalMainFrameParamsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kProvisionalLocalParams)>,
        CreateProvisionalLocalMainFrameParamsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRemoteParams)>,
        CreateRemoteMainFrameParamsPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    CreateLocalMainFrameParamsPtr local_params;
    CreateProvisionalLocalMainFrameParamsPtr provisional_local_params;
    CreateRemoteMainFrameParamsPtr remote_params;
  };

  CreateMainFrameUnion(
      std::in_place_index_t<static_cast<size_t>(Tag::kLocalParams)>,
      CreateLocalMainFrameParamsPtr value);
  CreateMainFrameUnion(
      std::in_place_index_t<static_cast<size_t>(Tag::kProvisionalLocalParams)>,
      CreateProvisionalLocalMainFrameParamsPtr value);
  CreateMainFrameUnion(
      std::in_place_index_t<static_cast<size_t>(Tag::kRemoteParams)>,
      CreateRemoteMainFrameParamsPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class CONTENT_EXPORT CreateViewParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateViewParams, T>::value>;
  using DataView = CreateViewParamsDataView;
  using Data_ = internal::CreateViewParams_Data;

  template <typename... Args>
  static CreateViewParamsPtr New(Args&&... args) {
    return CreateViewParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateViewParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateViewParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateViewParams>::Convert(*this);
  }


  CreateViewParams();

  CreateViewParams(
      const ::blink::RendererPreferences& renderer_preferences,
      const ::blink::web_pref::WebPreferences& web_preferences,
      const std::string& session_storage_namespace_id,
      const std::optional<::blink::FrameToken>& opener_frame_token,
      ::blink::mojom::FrameReplicationStatePtr replication_state,
      const ::base::UnguessableToken& devtools_main_frame_token,
      CreateMainFrameUnionPtr main_frame,
      bool hidden,
      ::blink::mojom::PrerenderParamPtr prerender_param,
      bool never_composited,
      bool window_was_opened_by_another_window,
      ViewWidgetType type,
      ::blink::FencedFrame::DeprecatedFencedFrameMode fenced_frame_mode,
      const std::optional<::url::Origin>& outermost_origin,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> blink_page_broadcast,
      std::optional<::SkColor> base_background_color,
      const ::blink::ColorProviderColorMaps& color_provider_colors,
      const ::base::UnguessableToken& browsing_context_group_token,
      ::network::mojom::AttributionSupport attribution_support,
      ::blink::mojom::PartitionedPopinParamsPtr partitioned_popin_params,
      const std::optional<::base::UnguessableToken>& navigation_metrics_token,
      int32_t history_index,
      int32_t history_length,
      std::optional<::blink::NoiseToken> canvas_noise_token);

CreateViewParams(const CreateViewParams&) = delete;
CreateViewParams& operator=(const CreateViewParams&) = delete;

  ~CreateViewParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateViewParamsPtr>
  CreateViewParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateViewParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateViewParams_UnserializedMessageContext<
            UserType, CreateViewParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateViewParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateViewParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateViewParams_UnserializedMessageContext<
            UserType, CreateViewParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateViewParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::RendererPreferences renderer_preferences;
  
  ::blink::web_pref::WebPreferences web_preferences;
  
  std::string session_storage_namespace_id;
  
  std::optional<::blink::FrameToken> opener_frame_token;
  
  ::blink::mojom::FrameReplicationStatePtr replication_state;
  
  ::base::UnguessableToken devtools_main_frame_token;
  
  CreateMainFrameUnionPtr main_frame;
  
  bool hidden;
  
  ::blink::mojom::PrerenderParamPtr prerender_param;
  
  bool never_composited;
  
  bool window_was_opened_by_another_window;
  
  ViewWidgetType type;
  
  ::blink::FencedFrame::DeprecatedFencedFrameMode fenced_frame_mode;
  
  std::optional<::url::Origin> outermost_origin;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> blink_page_broadcast;
  
  std::optional<::SkColor> base_background_color;
  
  ::blink::ColorProviderColorMaps color_provider_colors;
  
  ::base::UnguessableToken browsing_context_group_token;
  
  ::network::mojom::AttributionSupport attribution_support;
  
  ::blink::mojom::PartitionedPopinParamsPtr partitioned_popin_params;
  
  std::optional<::base::UnguessableToken> navigation_metrics_token;
  
  int32_t history_index;
  
  int32_t history_length;
  
  std::optional<::blink::NoiseToken> canvas_noise_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreateLocalMainFrameParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateLocalMainFrameParams, T>::value>;
  using DataView = CreateLocalMainFrameParamsDataView;
  using Data_ = internal::CreateLocalMainFrameParams_Data;

  template <typename... Args>
  static CreateLocalMainFrameParamsPtr New(Args&&... args) {
    return CreateLocalMainFrameParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateLocalMainFrameParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateLocalMainFrameParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateLocalMainFrameParams>::Convert(*this);
  }


  CreateLocalMainFrameParams();

  CreateLocalMainFrameParams(
      const ::blink::LocalFrameToken& frame_token,
      int32_t routing_id,
      ::mojo::PendingAssociatedReceiver<Frame> frame,
      ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> interface_broker,
      ::mojo::PendingAssociatedRemote<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider_remote,
      bool is_on_initial_empty_document,
      const ::blink::DocumentToken& document_token,
      ::blink::mojom::PolicyContainerPtr policy_container,
      CreateFrameWidgetParamsPtr widget_params,
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories);

CreateLocalMainFrameParams(const CreateLocalMainFrameParams&) = delete;
CreateLocalMainFrameParams& operator=(const CreateLocalMainFrameParams&) = delete;

  ~CreateLocalMainFrameParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateLocalMainFrameParamsPtr>
  CreateLocalMainFrameParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateLocalMainFrameParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateLocalMainFrameParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateLocalMainFrameParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateLocalMainFrameParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateLocalMainFrameParams_UnserializedMessageContext<
            UserType, CreateLocalMainFrameParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateLocalMainFrameParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateLocalMainFrameParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateLocalMainFrameParams_UnserializedMessageContext<
            UserType, CreateLocalMainFrameParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateLocalMainFrameParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::LocalFrameToken frame_token;
  
  int32_t routing_id;
  
  ::mojo::PendingAssociatedReceiver<Frame> frame;
  
  ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> interface_broker;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider_remote;
  
  bool is_on_initial_empty_document;
  
  ::blink::DocumentToken document_token;
  
  ::blink::mojom::PolicyContainerPtr policy_container;
  
  CreateFrameWidgetParamsPtr widget_params;
  
  ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateLocalMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateLocalMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateLocalMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateLocalMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreateProvisionalLocalMainFrameParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateProvisionalLocalMainFrameParams, T>::value>;
  using DataView = CreateProvisionalLocalMainFrameParamsDataView;
  using Data_ = internal::CreateProvisionalLocalMainFrameParams_Data;

  template <typename... Args>
  static CreateProvisionalLocalMainFrameParamsPtr New(Args&&... args) {
    return CreateProvisionalLocalMainFrameParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateProvisionalLocalMainFrameParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateProvisionalLocalMainFrameParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateProvisionalLocalMainFrameParams>::Convert(*this);
  }


  CreateProvisionalLocalMainFrameParams();

  CreateProvisionalLocalMainFrameParams(
      CreateLocalMainFrameParamsPtr local_params,
      const std::optional<::blink::FrameToken>& previous_frame_token);

CreateProvisionalLocalMainFrameParams(const CreateProvisionalLocalMainFrameParams&) = delete;
CreateProvisionalLocalMainFrameParams& operator=(const CreateProvisionalLocalMainFrameParams&) = delete;

  ~CreateProvisionalLocalMainFrameParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateProvisionalLocalMainFrameParamsPtr>
  CreateProvisionalLocalMainFrameParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateProvisionalLocalMainFrameParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateProvisionalLocalMainFrameParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateProvisionalLocalMainFrameParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateProvisionalLocalMainFrameParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateProvisionalLocalMainFrameParams_UnserializedMessageContext<
            UserType, CreateProvisionalLocalMainFrameParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateProvisionalLocalMainFrameParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateProvisionalLocalMainFrameParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateProvisionalLocalMainFrameParams_UnserializedMessageContext<
            UserType, CreateProvisionalLocalMainFrameParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateProvisionalLocalMainFrameParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CreateLocalMainFrameParamsPtr local_params;
  
  std::optional<::blink::FrameToken> previous_frame_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateProvisionalLocalMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateProvisionalLocalMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateProvisionalLocalMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateProvisionalLocalMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreateRemoteMainFrameParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateRemoteMainFrameParams, T>::value>;
  using DataView = CreateRemoteMainFrameParamsDataView;
  using Data_ = internal::CreateRemoteMainFrameParams_Data;

  template <typename... Args>
  static CreateRemoteMainFrameParamsPtr New(Args&&... args) {
    return CreateRemoteMainFrameParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateRemoteMainFrameParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateRemoteMainFrameParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateRemoteMainFrameParams>::Convert(*this);
  }


  CreateRemoteMainFrameParams();

  CreateRemoteMainFrameParams(
      const ::blink::RemoteFrameToken& token,
      ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr frame_interfaces,
      ::blink::mojom::RemoteMainFrameInterfacesPtr main_frame_interfaces);

CreateRemoteMainFrameParams(const CreateRemoteMainFrameParams&) = delete;
CreateRemoteMainFrameParams& operator=(const CreateRemoteMainFrameParams&) = delete;

  ~CreateRemoteMainFrameParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateRemoteMainFrameParamsPtr>
  CreateRemoteMainFrameParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateRemoteMainFrameParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateRemoteMainFrameParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateRemoteMainFrameParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateRemoteMainFrameParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateRemoteMainFrameParams_UnserializedMessageContext<
            UserType, CreateRemoteMainFrameParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateRemoteMainFrameParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateRemoteMainFrameParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateRemoteMainFrameParams_UnserializedMessageContext<
            UserType, CreateRemoteMainFrameParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateRemoteMainFrameParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::RemoteFrameToken token;
  
  ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr frame_interfaces;
  
  ::blink::mojom::RemoteMainFrameInterfacesPtr main_frame_interfaces;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateRemoteMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateRemoteMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateRemoteMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateRemoteMainFrameParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreateFrameWidgetParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateFrameWidgetParams, T>::value>;
  using DataView = CreateFrameWidgetParamsDataView;
  using Data_ = internal::CreateFrameWidgetParams_Data;

  template <typename... Args>
  static CreateFrameWidgetParamsPtr New(Args&&... args) {
    return CreateFrameWidgetParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateFrameWidgetParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateFrameWidgetParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateFrameWidgetParams>::Convert(*this);
  }


  CreateFrameWidgetParams();

  CreateFrameWidgetParams(
      int32_t routing_id,
      ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget,
      ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget,
      const ::blink::VisualProperties& visual_properties);

CreateFrameWidgetParams(const CreateFrameWidgetParams&) = delete;
CreateFrameWidgetParams& operator=(const CreateFrameWidgetParams&) = delete;

  ~CreateFrameWidgetParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateFrameWidgetParamsPtr>
  CreateFrameWidgetParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateFrameWidgetParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateFrameWidgetParams_UnserializedMessageContext<
            UserType, CreateFrameWidgetParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateFrameWidgetParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateFrameWidgetParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateFrameWidgetParams_UnserializedMessageContext<
            UserType, CreateFrameWidgetParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateFrameWidgetParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t routing_id;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget;
  
  ::blink::VisualProperties visual_properties;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreateFrameParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateFrameParams, T>::value>;
  using DataView = CreateFrameParamsDataView;
  using Data_ = internal::CreateFrameParams_Data;

  template <typename... Args>
  static CreateFrameParamsPtr New(Args&&... args) {
    return CreateFrameParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateFrameParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateFrameParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateFrameParams>::Convert(*this);
  }


  CreateFrameParams();

  CreateFrameParams(
      const ::blink::LocalFrameToken& frame_token,
      int32_t routing_id,
      const std::optional<::blink::FrameToken>& previous_frame_token,
      const std::optional<::blink::FrameToken>& opener_frame_token,
      const std::optional<::blink::FrameToken>& parent_frame_token,
      const std::optional<::blink::FrameToken>& previous_sibling_frame_token,
      ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> interface_broker,
      ::blink::mojom::TreeScopeType tree_scope_type,
      ::blink::mojom::FrameReplicationStatePtr replication_state,
      const ::base::UnguessableToken& devtools_frame_token,
      ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties,
      CreateFrameWidgetParamsPtr widget_params,
      bool is_on_initial_empty_document,
      const ::blink::DocumentToken& document_token,
      ::blink::mojom::PolicyContainerPtr policy_container,
      ::mojo::PendingAssociatedReceiver<Frame> frame,
      ::mojo::PendingAssociatedRemote<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider_remote,
      bool is_for_nested_main_frame,
      const std::optional<::base::UnguessableToken>& navigation_metrics_token);

CreateFrameParams(const CreateFrameParams&) = delete;
CreateFrameParams& operator=(const CreateFrameParams&) = delete;

  ~CreateFrameParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateFrameParamsPtr>
  CreateFrameParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateFrameParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateFrameParams_UnserializedMessageContext<
            UserType, CreateFrameParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateFrameParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateFrameParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateFrameParams_UnserializedMessageContext<
            UserType, CreateFrameParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateFrameParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::LocalFrameToken frame_token;
  
  int32_t routing_id;
  
  std::optional<::blink::FrameToken> previous_frame_token;
  
  std::optional<::blink::FrameToken> opener_frame_token;
  
  std::optional<::blink::FrameToken> parent_frame_token;
  
  std::optional<::blink::FrameToken> previous_sibling_frame_token;
  
  ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> interface_broker;
  
  ::blink::mojom::TreeScopeType tree_scope_type;
  
  ::blink::mojom::FrameReplicationStatePtr replication_state;
  
  ::base::UnguessableToken devtools_frame_token;
  
  ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties;
  
  CreateFrameWidgetParamsPtr widget_params;
  
  bool is_on_initial_empty_document;
  
  ::blink::DocumentToken document_token;
  
  ::blink::mojom::PolicyContainerPtr policy_container;
  
  ::mojo::PendingAssociatedReceiver<Frame> frame;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider_remote;
  
  bool is_for_nested_main_frame;
  
  std::optional<::base::UnguessableToken> navigation_metrics_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT SnapshotAccessibilityTreeParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SnapshotAccessibilityTreeParams, T>::value>;
  using DataView = SnapshotAccessibilityTreeParamsDataView;
  using Data_ = internal::SnapshotAccessibilityTreeParams_Data;

  template <typename... Args>
  static SnapshotAccessibilityTreeParamsPtr New(Args&&... args) {
    return SnapshotAccessibilityTreeParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SnapshotAccessibilityTreeParamsPtr From(const U& u) {
    return mojo::TypeConverter<SnapshotAccessibilityTreeParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SnapshotAccessibilityTreeParams>::Convert(*this);
  }


  SnapshotAccessibilityTreeParams();

  SnapshotAccessibilityTreeParams(
      uint32_t ax_mode,
      uint64_t max_nodes,
      ::base::TimeDelta timeout);


  ~SnapshotAccessibilityTreeParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SnapshotAccessibilityTreeParamsPtr>
  SnapshotAccessibilityTreeParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SnapshotAccessibilityTreeParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SnapshotAccessibilityTreeParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SnapshotAccessibilityTreeParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SnapshotAccessibilityTreeParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SnapshotAccessibilityTreeParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SnapshotAccessibilityTreeParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SnapshotAccessibilityTreeParams_UnserializedMessageContext<
            UserType, SnapshotAccessibilityTreeParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SnapshotAccessibilityTreeParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SnapshotAccessibilityTreeParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SnapshotAccessibilityTreeParams_UnserializedMessageContext<
            UserType, SnapshotAccessibilityTreeParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SnapshotAccessibilityTreeParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t ax_mode;
  
  uint64_t max_nodes;
  
  ::base::TimeDelta timeout;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SnapshotAccessibilityTreeParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SnapshotAccessibilityTreeParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SnapshotAccessibilityTreeParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SnapshotAccessibilityTreeParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreateNewWindowParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateNewWindowParams, T>::value>;
  using DataView = CreateNewWindowParamsDataView;
  using Data_ = internal::CreateNewWindowParams_Data;

  template <typename... Args>
  static CreateNewWindowParamsPtr New(Args&&... args) {
    return CreateNewWindowParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateNewWindowParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateNewWindowParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateNewWindowParams>::Convert(*this);
  }


  CreateNewWindowParams();

  CreateNewWindowParams(
      bool allow_popup,
      ::content::mojom::WindowContainerType window_container_type,
      const std::string& session_storage_namespace_id,
      const std::string& clone_from_session_storage_namespace_id,
      const std::string& frame_name,
      bool opener_suppressed,
      bool is_form_submission,
      bool consumes_user_activation,
      ::scoped_refptr<::network::ResourceRequestBody> form_submission_post_data,
      const std::string& form_submission_post_content_type,
      ::WindowOpenDisposition disposition,
      const ::GURL& target_url,
      ::blink::mojom::ReferrerPtr referrer,
      ::blink::mojom::WindowFeaturesPtr features,
      const std::optional<::blink::Impression>& impression,
      const ::blink::NavigationDownloadPolicy& download_policy,
      ::blink::mojom::PictureInPictureWindowOptionsPtr pip_options,
      ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status,
      ::mojo::PendingAssociatedRemote<Frame> frame_remote,
      ::mojo::PendingAssociatedRemote<::blink::mojom::PageBroadcast> page_broadcast_remote,
      ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> main_frame_interface_broker,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> widget_host,
      ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> widget,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidgetHost> frame_widget_host,
      ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidget> frame_widget);

CreateNewWindowParams(const CreateNewWindowParams&) = delete;
CreateNewWindowParams& operator=(const CreateNewWindowParams&) = delete;

  ~CreateNewWindowParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateNewWindowParamsPtr>
  CreateNewWindowParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateNewWindowParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateNewWindowParams_UnserializedMessageContext<
            UserType, CreateNewWindowParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateNewWindowParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateNewWindowParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateNewWindowParams_UnserializedMessageContext<
            UserType, CreateNewWindowParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateNewWindowParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool allow_popup;
  
  ::content::mojom::WindowContainerType window_container_type;
  
  std::string session_storage_namespace_id;
  
  std::string clone_from_session_storage_namespace_id;
  
  std::string frame_name;
  
  bool opener_suppressed;
  
  bool is_form_submission;
  
  bool consumes_user_activation;
  
  ::scoped_refptr<::network::ResourceRequestBody> form_submission_post_data;
  
  std::string form_submission_post_content_type;
  
  ::WindowOpenDisposition disposition;
  
  ::GURL target_url;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  ::blink::mojom::WindowFeaturesPtr features;
  
  std::optional<::blink::Impression> impression;
  
  ::blink::NavigationDownloadPolicy download_policy;
  
  ::blink::mojom::PictureInPictureWindowOptionsPtr pip_options;
  
  ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status;
  
  ::mojo::PendingAssociatedRemote<Frame> frame_remote;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::PageBroadcast> page_broadcast_remote;
  
  ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> main_frame_interface_broker;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::AssociatedInterfaceProvider> associated_interface_provider;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> widget_host;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> widget;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidgetHost> frame_widget_host;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidget> frame_widget;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreateNewWindowReply {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateNewWindowReply, T>::value>;
  using DataView = CreateNewWindowReplyDataView;
  using Data_ = internal::CreateNewWindowReply_Data;

  template <typename... Args>
  static CreateNewWindowReplyPtr New(Args&&... args) {
    return CreateNewWindowReplyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateNewWindowReplyPtr From(const U& u) {
    return mojo::TypeConverter<CreateNewWindowReplyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateNewWindowReply>::Convert(*this);
  }


  CreateNewWindowReply();

  CreateNewWindowReply(
      const ::blink::LocalFrameToken& main_frame_token,
      int32_t main_frame_route_id,
      int32_t widget_routing_id,
      const ::blink::VisualProperties& visual_properties,
      const std::string& cloned_session_storage_namespace_id,
      const ::base::UnguessableToken& devtools_main_frame_token,
      bool wait_for_debugger,
      const ::blink::DocumentToken& document_token,
      ::blink::mojom::PolicyContainerPtr policy_container,
      const ::base::UnguessableToken& browsing_context_group_token,
      const ::blink::ColorProviderColorMaps& color_provider_colors,
      ::blink::mojom::PartitionedPopinParamsPtr partitioned_popin_params,
      const std::optional<::gfx::Rect>& widget_screen_rect,
      const std::optional<::gfx::Rect>& window_screen_rect);

CreateNewWindowReply(const CreateNewWindowReply&) = delete;
CreateNewWindowReply& operator=(const CreateNewWindowReply&) = delete;

  ~CreateNewWindowReply();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateNewWindowReplyPtr>
  CreateNewWindowReplyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateNewWindowReply::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateNewWindowReply_UnserializedMessageContext<
            UserType, CreateNewWindowReply::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateNewWindowReply::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateNewWindowReply::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateNewWindowReply_UnserializedMessageContext<
            UserType, CreateNewWindowReply::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateNewWindowReply::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::LocalFrameToken main_frame_token;
  
  int32_t main_frame_route_id;
  
  int32_t widget_routing_id;
  
  ::blink::VisualProperties visual_properties;
  
  std::string cloned_session_storage_namespace_id;
  
  ::base::UnguessableToken devtools_main_frame_token;
  
  bool wait_for_debugger;
  
  ::blink::DocumentToken document_token;
  
  ::blink::mojom::PolicyContainerPtr policy_container;
  
  ::base::UnguessableToken browsing_context_group_token;
  
  ::blink::ColorProviderColorMaps color_provider_colors;
  
  ::blink::mojom::PartitionedPopinParamsPtr partitioned_popin_params;
  
  std::optional<::gfx::Rect> widget_screen_rect;
  
  std::optional<::gfx::Rect> window_screen_rect;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
CreateMainFrameUnionPtr CreateMainFrameUnion::Clone() const {
  switch (tag_) {
    case Tag::kLocalParams:
      return NewLocalParams(
          mojo::Clone(data_.local_params));
    case Tag::kProvisionalLocalParams:
      return NewProvisionalLocalParams(
          mojo::Clone(data_.provisional_local_params));
    case Tag::kRemoteParams:
      return NewRemoteParams(
          mojo::Clone(data_.remote_params));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CreateMainFrameUnion>::value>::type*>
bool CreateMainFrameUnion::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kLocalParams:
      return mojo::Equals(data_.local_params, other.data_.local_params);
    case Tag::kProvisionalLocalParams:
      return mojo::Equals(data_.provisional_local_params, other.data_.provisional_local_params);
    case Tag::kRemoteParams:
      return mojo::Equals(data_.remote_params, other.data_.remote_params);
  }

  return false;
}
template <typename StructPtrType>
CreateViewParamsPtr CreateViewParams::Clone() const {
  return New(
      mojo::Clone(renderer_preferences),
      mojo::Clone(web_preferences),
      mojo::Clone(session_storage_namespace_id),
      mojo::Clone(opener_frame_token),
      mojo::Clone(replication_state),
      mojo::Clone(devtools_main_frame_token),
      mojo::Clone(main_frame),
      mojo::Clone(hidden),
      mojo::Clone(prerender_param),
      mojo::Clone(never_composited),
      mojo::Clone(window_was_opened_by_another_window),
      mojo::Clone(type),
      mojo::Clone(fenced_frame_mode),
      mojo::Clone(outermost_origin),
      mojo::Clone(blink_page_broadcast),
      mojo::Clone(base_background_color),
      mojo::Clone(color_provider_colors),
      mojo::Clone(browsing_context_group_token),
      mojo::Clone(attribution_support),
      mojo::Clone(partitioned_popin_params),
      mojo::Clone(navigation_metrics_token),
      mojo::Clone(history_index),
      mojo::Clone(history_length),
      mojo::Clone(canvas_noise_token)
  );
}

template <typename T, CreateViewParams::EnableIfSame<T>*>
bool CreateViewParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->renderer_preferences, other_struct.renderer_preferences))
    return false;
  if (!mojo::Equals(this->web_preferences, other_struct.web_preferences))
    return false;
  if (!mojo::Equals(this->session_storage_namespace_id, other_struct.session_storage_namespace_id))
    return false;
  if (!mojo::Equals(this->opener_frame_token, other_struct.opener_frame_token))
    return false;
  if (!mojo::Equals(this->replication_state, other_struct.replication_state))
    return false;
  if (!mojo::Equals(this->devtools_main_frame_token, other_struct.devtools_main_frame_token))
    return false;
  if (!mojo::Equals(this->main_frame, other_struct.main_frame))
    return false;
  if (!mojo::Equals(this->hidden, other_struct.hidden))
    return false;
  if (!mojo::Equals(this->prerender_param, other_struct.prerender_param))
    return false;
  if (!mojo::Equals(this->never_composited, other_struct.never_composited))
    return false;
  if (!mojo::Equals(this->window_was_opened_by_another_window, other_struct.window_was_opened_by_another_window))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->fenced_frame_mode, other_struct.fenced_frame_mode))
    return false;
  if (!mojo::Equals(this->outermost_origin, other_struct.outermost_origin))
    return false;
  if (!mojo::Equals(this->blink_page_broadcast, other_struct.blink_page_broadcast))
    return false;
  if (!mojo::Equals(this->base_background_color, other_struct.base_background_color))
    return false;
  if (!mojo::Equals(this->color_provider_colors, other_struct.color_provider_colors))
    return false;
  if (!mojo::Equals(this->browsing_context_group_token, other_struct.browsing_context_group_token))
    return false;
  if (!mojo::Equals(this->attribution_support, other_struct.attribution_support))
    return false;
  if (!mojo::Equals(this->partitioned_popin_params, other_struct.partitioned_popin_params))
    return false;
  if (!mojo::Equals(this->navigation_metrics_token, other_struct.navigation_metrics_token))
    return false;
  if (!mojo::Equals(this->history_index, other_struct.history_index))
    return false;
  if (!mojo::Equals(this->history_length, other_struct.history_length))
    return false;
  if (!mojo::Equals(this->canvas_noise_token, other_struct.canvas_noise_token))
    return false;
  return true;
}

template <typename T, CreateViewParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.renderer_preferences < rhs.renderer_preferences)
    return true;
  if (rhs.renderer_preferences < lhs.renderer_preferences)
    return false;
  if (lhs.web_preferences < rhs.web_preferences)
    return true;
  if (rhs.web_preferences < lhs.web_preferences)
    return false;
  if (lhs.session_storage_namespace_id < rhs.session_storage_namespace_id)
    return true;
  if (rhs.session_storage_namespace_id < lhs.session_storage_namespace_id)
    return false;
  if (lhs.opener_frame_token < rhs.opener_frame_token)
    return true;
  if (rhs.opener_frame_token < lhs.opener_frame_token)
    return false;
  if (lhs.replication_state < rhs.replication_state)
    return true;
  if (rhs.replication_state < lhs.replication_state)
    return false;
  if (lhs.devtools_main_frame_token < rhs.devtools_main_frame_token)
    return true;
  if (rhs.devtools_main_frame_token < lhs.devtools_main_frame_token)
    return false;
  if (lhs.main_frame < rhs.main_frame)
    return true;
  if (rhs.main_frame < lhs.main_frame)
    return false;
  if (lhs.hidden < rhs.hidden)
    return true;
  if (rhs.hidden < lhs.hidden)
    return false;
  if (lhs.prerender_param < rhs.prerender_param)
    return true;
  if (rhs.prerender_param < lhs.prerender_param)
    return false;
  if (lhs.never_composited < rhs.never_composited)
    return true;
  if (rhs.never_composited < lhs.never_composited)
    return false;
  if (lhs.window_was_opened_by_another_window < rhs.window_was_opened_by_another_window)
    return true;
  if (rhs.window_was_opened_by_another_window < lhs.window_was_opened_by_another_window)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.fenced_frame_mode < rhs.fenced_frame_mode)
    return true;
  if (rhs.fenced_frame_mode < lhs.fenced_frame_mode)
    return false;
  if (lhs.outermost_origin < rhs.outermost_origin)
    return true;
  if (rhs.outermost_origin < lhs.outermost_origin)
    return false;
  if (lhs.blink_page_broadcast < rhs.blink_page_broadcast)
    return true;
  if (rhs.blink_page_broadcast < lhs.blink_page_broadcast)
    return false;
  if (lhs.base_background_color < rhs.base_background_color)
    return true;
  if (rhs.base_background_color < lhs.base_background_color)
    return false;
  if (lhs.color_provider_colors < rhs.color_provider_colors)
    return true;
  if (rhs.color_provider_colors < lhs.color_provider_colors)
    return false;
  if (lhs.browsing_context_group_token < rhs.browsing_context_group_token)
    return true;
  if (rhs.browsing_context_group_token < lhs.browsing_context_group_token)
    return false;
  if (lhs.attribution_support < rhs.attribution_support)
    return true;
  if (rhs.attribution_support < lhs.attribution_support)
    return false;
  if (lhs.partitioned_popin_params < rhs.partitioned_popin_params)
    return true;
  if (rhs.partitioned_popin_params < lhs.partitioned_popin_params)
    return false;
  if (lhs.navigation_metrics_token < rhs.navigation_metrics_token)
    return true;
  if (rhs.navigation_metrics_token < lhs.navigation_metrics_token)
    return false;
  if (lhs.history_index < rhs.history_index)
    return true;
  if (rhs.history_index < lhs.history_index)
    return false;
  if (lhs.history_length < rhs.history_length)
    return true;
  if (rhs.history_length < lhs.history_length)
    return false;
  if (lhs.canvas_noise_token < rhs.canvas_noise_token)
    return true;
  if (rhs.canvas_noise_token < lhs.canvas_noise_token)
    return false;
  return false;
}
template <typename StructPtrType>
CreateLocalMainFrameParamsPtr CreateLocalMainFrameParams::Clone() const {
  return New(
      mojo::Clone(frame_token),
      mojo::Clone(routing_id),
      mojo::Clone(frame),
      mojo::Clone(interface_broker),
      mojo::Clone(associated_interface_provider_remote),
      mojo::Clone(is_on_initial_empty_document),
      mojo::Clone(document_token),
      mojo::Clone(policy_container),
      mojo::Clone(widget_params),
      mojo::Clone(subresource_loader_factories)
  );
}

template <typename T, CreateLocalMainFrameParams::EnableIfSame<T>*>
bool CreateLocalMainFrameParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_token, other_struct.frame_token))
    return false;
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->frame, other_struct.frame))
    return false;
  if (!mojo::Equals(this->interface_broker, other_struct.interface_broker))
    return false;
  if (!mojo::Equals(this->associated_interface_provider_remote, other_struct.associated_interface_provider_remote))
    return false;
  if (!mojo::Equals(this->is_on_initial_empty_document, other_struct.is_on_initial_empty_document))
    return false;
  if (!mojo::Equals(this->document_token, other_struct.document_token))
    return false;
  if (!mojo::Equals(this->policy_container, other_struct.policy_container))
    return false;
  if (!mojo::Equals(this->widget_params, other_struct.widget_params))
    return false;
  if (!mojo::Equals(this->subresource_loader_factories, other_struct.subresource_loader_factories))
    return false;
  return true;
}

template <typename T, CreateLocalMainFrameParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_token < rhs.frame_token)
    return true;
  if (rhs.frame_token < lhs.frame_token)
    return false;
  if (lhs.routing_id < rhs.routing_id)
    return true;
  if (rhs.routing_id < lhs.routing_id)
    return false;
  if (lhs.frame < rhs.frame)
    return true;
  if (rhs.frame < lhs.frame)
    return false;
  if (lhs.interface_broker < rhs.interface_broker)
    return true;
  if (rhs.interface_broker < lhs.interface_broker)
    return false;
  if (lhs.associated_interface_provider_remote < rhs.associated_interface_provider_remote)
    return true;
  if (rhs.associated_interface_provider_remote < lhs.associated_interface_provider_remote)
    return false;
  if (lhs.is_on_initial_empty_document < rhs.is_on_initial_empty_document)
    return true;
  if (rhs.is_on_initial_empty_document < lhs.is_on_initial_empty_document)
    return false;
  if (lhs.document_token < rhs.document_token)
    return true;
  if (rhs.document_token < lhs.document_token)
    return false;
  if (lhs.policy_container < rhs.policy_container)
    return true;
  if (rhs.policy_container < lhs.policy_container)
    return false;
  if (lhs.widget_params < rhs.widget_params)
    return true;
  if (rhs.widget_params < lhs.widget_params)
    return false;
  if (lhs.subresource_loader_factories < rhs.subresource_loader_factories)
    return true;
  if (rhs.subresource_loader_factories < lhs.subresource_loader_factories)
    return false;
  return false;
}
template <typename StructPtrType>
CreateProvisionalLocalMainFrameParamsPtr CreateProvisionalLocalMainFrameParams::Clone() const {
  return New(
      mojo::Clone(local_params),
      mojo::Clone(previous_frame_token)
  );
}

template <typename T, CreateProvisionalLocalMainFrameParams::EnableIfSame<T>*>
bool CreateProvisionalLocalMainFrameParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->local_params, other_struct.local_params))
    return false;
  if (!mojo::Equals(this->previous_frame_token, other_struct.previous_frame_token))
    return false;
  return true;
}

template <typename T, CreateProvisionalLocalMainFrameParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.local_params < rhs.local_params)
    return true;
  if (rhs.local_params < lhs.local_params)
    return false;
  if (lhs.previous_frame_token < rhs.previous_frame_token)
    return true;
  if (rhs.previous_frame_token < lhs.previous_frame_token)
    return false;
  return false;
}
template <typename StructPtrType>
CreateRemoteMainFrameParamsPtr CreateRemoteMainFrameParams::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(frame_interfaces),
      mojo::Clone(main_frame_interfaces)
  );
}

template <typename T, CreateRemoteMainFrameParams::EnableIfSame<T>*>
bool CreateRemoteMainFrameParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->frame_interfaces, other_struct.frame_interfaces))
    return false;
  if (!mojo::Equals(this->main_frame_interfaces, other_struct.main_frame_interfaces))
    return false;
  return true;
}

template <typename T, CreateRemoteMainFrameParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.frame_interfaces < rhs.frame_interfaces)
    return true;
  if (rhs.frame_interfaces < lhs.frame_interfaces)
    return false;
  if (lhs.main_frame_interfaces < rhs.main_frame_interfaces)
    return true;
  if (rhs.main_frame_interfaces < lhs.main_frame_interfaces)
    return false;
  return false;
}
template <typename StructPtrType>
CreateFrameWidgetParamsPtr CreateFrameWidgetParams::Clone() const {
  return New(
      mojo::Clone(routing_id),
      mojo::Clone(frame_widget_host),
      mojo::Clone(frame_widget),
      mojo::Clone(widget_host),
      mojo::Clone(widget),
      mojo::Clone(visual_properties)
  );
}

template <typename T, CreateFrameWidgetParams::EnableIfSame<T>*>
bool CreateFrameWidgetParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->frame_widget_host, other_struct.frame_widget_host))
    return false;
  if (!mojo::Equals(this->frame_widget, other_struct.frame_widget))
    return false;
  if (!mojo::Equals(this->widget_host, other_struct.widget_host))
    return false;
  if (!mojo::Equals(this->widget, other_struct.widget))
    return false;
  if (!mojo::Equals(this->visual_properties, other_struct.visual_properties))
    return false;
  return true;
}

template <typename T, CreateFrameWidgetParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.routing_id < rhs.routing_id)
    return true;
  if (rhs.routing_id < lhs.routing_id)
    return false;
  if (lhs.frame_widget_host < rhs.frame_widget_host)
    return true;
  if (rhs.frame_widget_host < lhs.frame_widget_host)
    return false;
  if (lhs.frame_widget < rhs.frame_widget)
    return true;
  if (rhs.frame_widget < lhs.frame_widget)
    return false;
  if (lhs.widget_host < rhs.widget_host)
    return true;
  if (rhs.widget_host < lhs.widget_host)
    return false;
  if (lhs.widget < rhs.widget)
    return true;
  if (rhs.widget < lhs.widget)
    return false;
  if (lhs.visual_properties < rhs.visual_properties)
    return true;
  if (rhs.visual_properties < lhs.visual_properties)
    return false;
  return false;
}
template <typename StructPtrType>
CreateFrameParamsPtr CreateFrameParams::Clone() const {
  return New(
      mojo::Clone(frame_token),
      mojo::Clone(routing_id),
      mojo::Clone(previous_frame_token),
      mojo::Clone(opener_frame_token),
      mojo::Clone(parent_frame_token),
      mojo::Clone(previous_sibling_frame_token),
      mojo::Clone(interface_broker),
      mojo::Clone(tree_scope_type),
      mojo::Clone(replication_state),
      mojo::Clone(devtools_frame_token),
      mojo::Clone(frame_owner_properties),
      mojo::Clone(widget_params),
      mojo::Clone(is_on_initial_empty_document),
      mojo::Clone(document_token),
      mojo::Clone(policy_container),
      mojo::Clone(frame),
      mojo::Clone(associated_interface_provider_remote),
      mojo::Clone(is_for_nested_main_frame),
      mojo::Clone(navigation_metrics_token)
  );
}

template <typename T, CreateFrameParams::EnableIfSame<T>*>
bool CreateFrameParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_token, other_struct.frame_token))
    return false;
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->previous_frame_token, other_struct.previous_frame_token))
    return false;
  if (!mojo::Equals(this->opener_frame_token, other_struct.opener_frame_token))
    return false;
  if (!mojo::Equals(this->parent_frame_token, other_struct.parent_frame_token))
    return false;
  if (!mojo::Equals(this->previous_sibling_frame_token, other_struct.previous_sibling_frame_token))
    return false;
  if (!mojo::Equals(this->interface_broker, other_struct.interface_broker))
    return false;
  if (!mojo::Equals(this->tree_scope_type, other_struct.tree_scope_type))
    return false;
  if (!mojo::Equals(this->replication_state, other_struct.replication_state))
    return false;
  if (!mojo::Equals(this->devtools_frame_token, other_struct.devtools_frame_token))
    return false;
  if (!mojo::Equals(this->frame_owner_properties, other_struct.frame_owner_properties))
    return false;
  if (!mojo::Equals(this->widget_params, other_struct.widget_params))
    return false;
  if (!mojo::Equals(this->is_on_initial_empty_document, other_struct.is_on_initial_empty_document))
    return false;
  if (!mojo::Equals(this->document_token, other_struct.document_token))
    return false;
  if (!mojo::Equals(this->policy_container, other_struct.policy_container))
    return false;
  if (!mojo::Equals(this->frame, other_struct.frame))
    return false;
  if (!mojo::Equals(this->associated_interface_provider_remote, other_struct.associated_interface_provider_remote))
    return false;
  if (!mojo::Equals(this->is_for_nested_main_frame, other_struct.is_for_nested_main_frame))
    return false;
  if (!mojo::Equals(this->navigation_metrics_token, other_struct.navigation_metrics_token))
    return false;
  return true;
}

template <typename T, CreateFrameParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_token < rhs.frame_token)
    return true;
  if (rhs.frame_token < lhs.frame_token)
    return false;
  if (lhs.routing_id < rhs.routing_id)
    return true;
  if (rhs.routing_id < lhs.routing_id)
    return false;
  if (lhs.previous_frame_token < rhs.previous_frame_token)
    return true;
  if (rhs.previous_frame_token < lhs.previous_frame_token)
    return false;
  if (lhs.opener_frame_token < rhs.opener_frame_token)
    return true;
  if (rhs.opener_frame_token < lhs.opener_frame_token)
    return false;
  if (lhs.parent_frame_token < rhs.parent_frame_token)
    return true;
  if (rhs.parent_frame_token < lhs.parent_frame_token)
    return false;
  if (lhs.previous_sibling_frame_token < rhs.previous_sibling_frame_token)
    return true;
  if (rhs.previous_sibling_frame_token < lhs.previous_sibling_frame_token)
    return false;
  if (lhs.interface_broker < rhs.interface_broker)
    return true;
  if (rhs.interface_broker < lhs.interface_broker)
    return false;
  if (lhs.tree_scope_type < rhs.tree_scope_type)
    return true;
  if (rhs.tree_scope_type < lhs.tree_scope_type)
    return false;
  if (lhs.replication_state < rhs.replication_state)
    return true;
  if (rhs.replication_state < lhs.replication_state)
    return false;
  if (lhs.devtools_frame_token < rhs.devtools_frame_token)
    return true;
  if (rhs.devtools_frame_token < lhs.devtools_frame_token)
    return false;
  if (lhs.frame_owner_properties < rhs.frame_owner_properties)
    return true;
  if (rhs.frame_owner_properties < lhs.frame_owner_properties)
    return false;
  if (lhs.widget_params < rhs.widget_params)
    return true;
  if (rhs.widget_params < lhs.widget_params)
    return false;
  if (lhs.is_on_initial_empty_document < rhs.is_on_initial_empty_document)
    return true;
  if (rhs.is_on_initial_empty_document < lhs.is_on_initial_empty_document)
    return false;
  if (lhs.document_token < rhs.document_token)
    return true;
  if (rhs.document_token < lhs.document_token)
    return false;
  if (lhs.policy_container < rhs.policy_container)
    return true;
  if (rhs.policy_container < lhs.policy_container)
    return false;
  if (lhs.frame < rhs.frame)
    return true;
  if (rhs.frame < lhs.frame)
    return false;
  if (lhs.associated_interface_provider_remote < rhs.associated_interface_provider_remote)
    return true;
  if (rhs.associated_interface_provider_remote < lhs.associated_interface_provider_remote)
    return false;
  if (lhs.is_for_nested_main_frame < rhs.is_for_nested_main_frame)
    return true;
  if (rhs.is_for_nested_main_frame < lhs.is_for_nested_main_frame)
    return false;
  if (lhs.navigation_metrics_token < rhs.navigation_metrics_token)
    return true;
  if (rhs.navigation_metrics_token < lhs.navigation_metrics_token)
    return false;
  return false;
}
template <typename StructPtrType>
SnapshotAccessibilityTreeParamsPtr SnapshotAccessibilityTreeParams::Clone() const {
  return New(
      mojo::Clone(ax_mode),
      mojo::Clone(max_nodes),
      mojo::Clone(timeout)
  );
}

template <typename T, SnapshotAccessibilityTreeParams::EnableIfSame<T>*>
bool SnapshotAccessibilityTreeParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ax_mode, other_struct.ax_mode))
    return false;
  if (!mojo::Equals(this->max_nodes, other_struct.max_nodes))
    return false;
  if (!mojo::Equals(this->timeout, other_struct.timeout))
    return false;
  return true;
}

template <typename T, SnapshotAccessibilityTreeParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ax_mode < rhs.ax_mode)
    return true;
  if (rhs.ax_mode < lhs.ax_mode)
    return false;
  if (lhs.max_nodes < rhs.max_nodes)
    return true;
  if (rhs.max_nodes < lhs.max_nodes)
    return false;
  if (lhs.timeout < rhs.timeout)
    return true;
  if (rhs.timeout < lhs.timeout)
    return false;
  return false;
}
template <typename StructPtrType>
CreateNewWindowParamsPtr CreateNewWindowParams::Clone() const {
  return New(
      mojo::Clone(allow_popup),
      mojo::Clone(window_container_type),
      mojo::Clone(session_storage_namespace_id),
      mojo::Clone(clone_from_session_storage_namespace_id),
      mojo::Clone(frame_name),
      mojo::Clone(opener_suppressed),
      mojo::Clone(is_form_submission),
      mojo::Clone(consumes_user_activation),
      mojo::Clone(form_submission_post_data),
      mojo::Clone(form_submission_post_content_type),
      mojo::Clone(disposition),
      mojo::Clone(target_url),
      mojo::Clone(referrer),
      mojo::Clone(features),
      mojo::Clone(impression),
      mojo::Clone(download_policy),
      mojo::Clone(pip_options),
      mojo::Clone(initiator_activation_and_ad_status),
      mojo::Clone(frame_remote),
      mojo::Clone(page_broadcast_remote),
      mojo::Clone(main_frame_interface_broker),
      mojo::Clone(associated_interface_provider),
      mojo::Clone(widget_host),
      mojo::Clone(widget),
      mojo::Clone(frame_widget_host),
      mojo::Clone(frame_widget)
  );
}

template <typename T, CreateNewWindowParams::EnableIfSame<T>*>
bool CreateNewWindowParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_popup, other_struct.allow_popup))
    return false;
  if (!mojo::Equals(this->window_container_type, other_struct.window_container_type))
    return false;
  if (!mojo::Equals(this->session_storage_namespace_id, other_struct.session_storage_namespace_id))
    return false;
  if (!mojo::Equals(this->clone_from_session_storage_namespace_id, other_struct.clone_from_session_storage_namespace_id))
    return false;
  if (!mojo::Equals(this->frame_name, other_struct.frame_name))
    return false;
  if (!mojo::Equals(this->opener_suppressed, other_struct.opener_suppressed))
    return false;
  if (!mojo::Equals(this->is_form_submission, other_struct.is_form_submission))
    return false;
  if (!mojo::Equals(this->consumes_user_activation, other_struct.consumes_user_activation))
    return false;
  if (!mojo::Equals(this->form_submission_post_data, other_struct.form_submission_post_data))
    return false;
  if (!mojo::Equals(this->form_submission_post_content_type, other_struct.form_submission_post_content_type))
    return false;
  if (!mojo::Equals(this->disposition, other_struct.disposition))
    return false;
  if (!mojo::Equals(this->target_url, other_struct.target_url))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->features, other_struct.features))
    return false;
  if (!mojo::Equals(this->impression, other_struct.impression))
    return false;
  if (!mojo::Equals(this->download_policy, other_struct.download_policy))
    return false;
  if (!mojo::Equals(this->pip_options, other_struct.pip_options))
    return false;
  if (!mojo::Equals(this->initiator_activation_and_ad_status, other_struct.initiator_activation_and_ad_status))
    return false;
  if (!mojo::Equals(this->frame_remote, other_struct.frame_remote))
    return false;
  if (!mojo::Equals(this->page_broadcast_remote, other_struct.page_broadcast_remote))
    return false;
  if (!mojo::Equals(this->main_frame_interface_broker, other_struct.main_frame_interface_broker))
    return false;
  if (!mojo::Equals(this->associated_interface_provider, other_struct.associated_interface_provider))
    return false;
  if (!mojo::Equals(this->widget_host, other_struct.widget_host))
    return false;
  if (!mojo::Equals(this->widget, other_struct.widget))
    return false;
  if (!mojo::Equals(this->frame_widget_host, other_struct.frame_widget_host))
    return false;
  if (!mojo::Equals(this->frame_widget, other_struct.frame_widget))
    return false;
  return true;
}

template <typename T, CreateNewWindowParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allow_popup < rhs.allow_popup)
    return true;
  if (rhs.allow_popup < lhs.allow_popup)
    return false;
  if (lhs.window_container_type < rhs.window_container_type)
    return true;
  if (rhs.window_container_type < lhs.window_container_type)
    return false;
  if (lhs.session_storage_namespace_id < rhs.session_storage_namespace_id)
    return true;
  if (rhs.session_storage_namespace_id < lhs.session_storage_namespace_id)
    return false;
  if (lhs.clone_from_session_storage_namespace_id < rhs.clone_from_session_storage_namespace_id)
    return true;
  if (rhs.clone_from_session_storage_namespace_id < lhs.clone_from_session_storage_namespace_id)
    return false;
  if (lhs.frame_name < rhs.frame_name)
    return true;
  if (rhs.frame_name < lhs.frame_name)
    return false;
  if (lhs.opener_suppressed < rhs.opener_suppressed)
    return true;
  if (rhs.opener_suppressed < lhs.opener_suppressed)
    return false;
  if (lhs.is_form_submission < rhs.is_form_submission)
    return true;
  if (rhs.is_form_submission < lhs.is_form_submission)
    return false;
  if (lhs.consumes_user_activation < rhs.consumes_user_activation)
    return true;
  if (rhs.consumes_user_activation < lhs.consumes_user_activation)
    return false;
  if (lhs.form_submission_post_data < rhs.form_submission_post_data)
    return true;
  if (rhs.form_submission_post_data < lhs.form_submission_post_data)
    return false;
  if (lhs.form_submission_post_content_type < rhs.form_submission_post_content_type)
    return true;
  if (rhs.form_submission_post_content_type < lhs.form_submission_post_content_type)
    return false;
  if (lhs.disposition < rhs.disposition)
    return true;
  if (rhs.disposition < lhs.disposition)
    return false;
  if (lhs.target_url < rhs.target_url)
    return true;
  if (rhs.target_url < lhs.target_url)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.features < rhs.features)
    return true;
  if (rhs.features < lhs.features)
    return false;
  if (lhs.impression < rhs.impression)
    return true;
  if (rhs.impression < lhs.impression)
    return false;
  if (lhs.download_policy < rhs.download_policy)
    return true;
  if (rhs.download_policy < lhs.download_policy)
    return false;
  if (lhs.pip_options < rhs.pip_options)
    return true;
  if (rhs.pip_options < lhs.pip_options)
    return false;
  if (lhs.initiator_activation_and_ad_status < rhs.initiator_activation_and_ad_status)
    return true;
  if (rhs.initiator_activation_and_ad_status < lhs.initiator_activation_and_ad_status)
    return false;
  if (lhs.frame_remote < rhs.frame_remote)
    return true;
  if (rhs.frame_remote < lhs.frame_remote)
    return false;
  if (lhs.page_broadcast_remote < rhs.page_broadcast_remote)
    return true;
  if (rhs.page_broadcast_remote < lhs.page_broadcast_remote)
    return false;
  if (lhs.main_frame_interface_broker < rhs.main_frame_interface_broker)
    return true;
  if (rhs.main_frame_interface_broker < lhs.main_frame_interface_broker)
    return false;
  if (lhs.associated_interface_provider < rhs.associated_interface_provider)
    return true;
  if (rhs.associated_interface_provider < lhs.associated_interface_provider)
    return false;
  if (lhs.widget_host < rhs.widget_host)
    return true;
  if (rhs.widget_host < lhs.widget_host)
    return false;
  if (lhs.widget < rhs.widget)
    return true;
  if (rhs.widget < lhs.widget)
    return false;
  if (lhs.frame_widget_host < rhs.frame_widget_host)
    return true;
  if (rhs.frame_widget_host < lhs.frame_widget_host)
    return false;
  if (lhs.frame_widget < rhs.frame_widget)
    return true;
  if (rhs.frame_widget < lhs.frame_widget)
    return false;
  return false;
}
template <typename StructPtrType>
CreateNewWindowReplyPtr CreateNewWindowReply::Clone() const {
  return New(
      mojo::Clone(main_frame_token),
      mojo::Clone(main_frame_route_id),
      mojo::Clone(widget_routing_id),
      mojo::Clone(visual_properties),
      mojo::Clone(cloned_session_storage_namespace_id),
      mojo::Clone(devtools_main_frame_token),
      mojo::Clone(wait_for_debugger),
      mojo::Clone(document_token),
      mojo::Clone(policy_container),
      mojo::Clone(browsing_context_group_token),
      mojo::Clone(color_provider_colors),
      mojo::Clone(partitioned_popin_params),
      mojo::Clone(widget_screen_rect),
      mojo::Clone(window_screen_rect)
  );
}

template <typename T, CreateNewWindowReply::EnableIfSame<T>*>
bool CreateNewWindowReply::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->main_frame_token, other_struct.main_frame_token))
    return false;
  if (!mojo::Equals(this->main_frame_route_id, other_struct.main_frame_route_id))
    return false;
  if (!mojo::Equals(this->widget_routing_id, other_struct.widget_routing_id))
    return false;
  if (!mojo::Equals(this->visual_properties, other_struct.visual_properties))
    return false;
  if (!mojo::Equals(this->cloned_session_storage_namespace_id, other_struct.cloned_session_storage_namespace_id))
    return false;
  if (!mojo::Equals(this->devtools_main_frame_token, other_struct.devtools_main_frame_token))
    return false;
  if (!mojo::Equals(this->wait_for_debugger, other_struct.wait_for_debugger))
    return false;
  if (!mojo::Equals(this->document_token, other_struct.document_token))
    return false;
  if (!mojo::Equals(this->policy_container, other_struct.policy_container))
    return false;
  if (!mojo::Equals(this->browsing_context_group_token, other_struct.browsing_context_group_token))
    return false;
  if (!mojo::Equals(this->color_provider_colors, other_struct.color_provider_colors))
    return false;
  if (!mojo::Equals(this->partitioned_popin_params, other_struct.partitioned_popin_params))
    return false;
  if (!mojo::Equals(this->widget_screen_rect, other_struct.widget_screen_rect))
    return false;
  if (!mojo::Equals(this->window_screen_rect, other_struct.window_screen_rect))
    return false;
  return true;
}

template <typename T, CreateNewWindowReply::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.main_frame_token < rhs.main_frame_token)
    return true;
  if (rhs.main_frame_token < lhs.main_frame_token)
    return false;
  if (lhs.main_frame_route_id < rhs.main_frame_route_id)
    return true;
  if (rhs.main_frame_route_id < lhs.main_frame_route_id)
    return false;
  if (lhs.widget_routing_id < rhs.widget_routing_id)
    return true;
  if (rhs.widget_routing_id < lhs.widget_routing_id)
    return false;
  if (lhs.visual_properties < rhs.visual_properties)
    return true;
  if (rhs.visual_properties < lhs.visual_properties)
    return false;
  if (lhs.cloned_session_storage_namespace_id < rhs.cloned_session_storage_namespace_id)
    return true;
  if (rhs.cloned_session_storage_namespace_id < lhs.cloned_session_storage_namespace_id)
    return false;
  if (lhs.devtools_main_frame_token < rhs.devtools_main_frame_token)
    return true;
  if (rhs.devtools_main_frame_token < lhs.devtools_main_frame_token)
    return false;
  if (lhs.wait_for_debugger < rhs.wait_for_debugger)
    return true;
  if (rhs.wait_for_debugger < lhs.wait_for_debugger)
    return false;
  if (lhs.document_token < rhs.document_token)
    return true;
  if (rhs.document_token < lhs.document_token)
    return false;
  if (lhs.policy_container < rhs.policy_container)
    return true;
  if (rhs.policy_container < lhs.policy_container)
    return false;
  if (lhs.browsing_context_group_token < rhs.browsing_context_group_token)
    return true;
  if (rhs.browsing_context_group_token < lhs.browsing_context_group_token)
    return false;
  if (lhs.color_provider_colors < rhs.color_provider_colors)
    return true;
  if (rhs.color_provider_colors < lhs.color_provider_colors)
    return false;
  if (lhs.partitioned_popin_params < rhs.partitioned_popin_params)
    return true;
  if (rhs.partitioned_popin_params < lhs.partitioned_popin_params)
    return false;
  if (lhs.widget_screen_rect < rhs.widget_screen_rect)
    return true;
  if (rhs.widget_screen_rect < lhs.widget_screen_rect)
    return false;
  if (lhs.window_screen_rect < rhs.window_screen_rect)
    return true;
  if (rhs.window_screen_rect < lhs.window_screen_rect)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateViewParams::DataView,
                                         ::content::mojom::CreateViewParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateViewParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateViewParamsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::CreateViewParams::renderer_preferences)& renderer_preferences(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->renderer_preferences;
  }

  static const decltype(::content::mojom::CreateViewParams::web_preferences)& web_preferences(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->web_preferences;
  }

  static const decltype(::content::mojom::CreateViewParams::session_storage_namespace_id)& session_storage_namespace_id(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->session_storage_namespace_id;
  }

  static const decltype(::content::mojom::CreateViewParams::opener_frame_token)& opener_frame_token(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->opener_frame_token;
  }

  static const decltype(::content::mojom::CreateViewParams::replication_state)& replication_state(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->replication_state;
  }

  static const decltype(::content::mojom::CreateViewParams::devtools_main_frame_token)& devtools_main_frame_token(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->devtools_main_frame_token;
  }

  static  decltype(::content::mojom::CreateViewParams::main_frame)& main_frame(
       ::content::mojom::CreateViewParamsPtr& input) {
    return input->main_frame;
  }

  static decltype(::content::mojom::CreateViewParams::hidden) hidden(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->hidden;
  }

  static const decltype(::content::mojom::CreateViewParams::prerender_param)& prerender_param(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->prerender_param;
  }

  static decltype(::content::mojom::CreateViewParams::never_composited) never_composited(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->never_composited;
  }

  static decltype(::content::mojom::CreateViewParams::window_was_opened_by_another_window) window_was_opened_by_another_window(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->window_was_opened_by_another_window;
  }

  static decltype(::content::mojom::CreateViewParams::type) type(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->type;
  }

  static decltype(::content::mojom::CreateViewParams::fenced_frame_mode) fenced_frame_mode(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->fenced_frame_mode;
  }

  static const decltype(::content::mojom::CreateViewParams::outermost_origin)& outermost_origin(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->outermost_origin;
  }

  static  decltype(::content::mojom::CreateViewParams::blink_page_broadcast)& blink_page_broadcast(
       ::content::mojom::CreateViewParamsPtr& input) {
    return input->blink_page_broadcast;
  }

  static const decltype(::content::mojom::CreateViewParams::base_background_color)& base_background_color(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->base_background_color;
  }

  static const decltype(::content::mojom::CreateViewParams::color_provider_colors)& color_provider_colors(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->color_provider_colors;
  }

  static const decltype(::content::mojom::CreateViewParams::browsing_context_group_token)& browsing_context_group_token(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->browsing_context_group_token;
  }

  static decltype(::content::mojom::CreateViewParams::attribution_support) attribution_support(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->attribution_support;
  }

  static const decltype(::content::mojom::CreateViewParams::partitioned_popin_params)& partitioned_popin_params(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->partitioned_popin_params;
  }

  static const decltype(::content::mojom::CreateViewParams::navigation_metrics_token)& navigation_metrics_token(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->navigation_metrics_token;
  }

  static decltype(::content::mojom::CreateViewParams::history_index) history_index(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->history_index;
  }

  static decltype(::content::mojom::CreateViewParams::history_length) history_length(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->history_length;
  }

  static const decltype(::content::mojom::CreateViewParams::canvas_noise_token)& canvas_noise_token(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->canvas_noise_token;
  }

  static bool Read(::content::mojom::CreateViewParams::DataView input, ::content::mojom::CreateViewParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateLocalMainFrameParams::DataView,
                                         ::content::mojom::CreateLocalMainFrameParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateLocalMainFrameParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateLocalMainFrameParamsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::CreateLocalMainFrameParams::frame_token)& frame_token(
      const ::content::mojom::CreateLocalMainFrameParamsPtr& input) {
    return input->frame_token;
  }

  static decltype(::content::mojom::CreateLocalMainFrameParams::routing_id) routing_id(
      const ::content::mojom::CreateLocalMainFrameParamsPtr& input) {
    return input->routing_id;
  }

  static  decltype(::content::mojom::CreateLocalMainFrameParams::frame)& frame(
       ::content::mojom::CreateLocalMainFrameParamsPtr& input) {
    return input->frame;
  }

  static  decltype(::content::mojom::CreateLocalMainFrameParams::interface_broker)& interface_broker(
       ::content::mojom::CreateLocalMainFrameParamsPtr& input) {
    return input->interface_broker;
  }

  static  decltype(::content::mojom::CreateLocalMainFrameParams::associated_interface_provider_remote)& associated_interface_provider_remote(
       ::content::mojom::CreateLocalMainFrameParamsPtr& input) {
    return input->associated_interface_provider_remote;
  }

  static decltype(::content::mojom::CreateLocalMainFrameParams::is_on_initial_empty_document) is_on_initial_empty_document(
      const ::content::mojom::CreateLocalMainFrameParamsPtr& input) {
    return input->is_on_initial_empty_document;
  }

  static const decltype(::content::mojom::CreateLocalMainFrameParams::document_token)& document_token(
      const ::content::mojom::CreateLocalMainFrameParamsPtr& input) {
    return input->document_token;
  }

  static  decltype(::content::mojom::CreateLocalMainFrameParams::policy_container)& policy_container(
       ::content::mojom::CreateLocalMainFrameParamsPtr& input) {
    return input->policy_container;
  }

  static  decltype(::content::mojom::CreateLocalMainFrameParams::widget_params)& widget_params(
       ::content::mojom::CreateLocalMainFrameParamsPtr& input) {
    return input->widget_params;
  }

  static  decltype(::content::mojom::CreateLocalMainFrameParams::subresource_loader_factories)& subresource_loader_factories(
       ::content::mojom::CreateLocalMainFrameParamsPtr& input) {
    return input->subresource_loader_factories;
  }

  static bool Read(::content::mojom::CreateLocalMainFrameParams::DataView input, ::content::mojom::CreateLocalMainFrameParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateProvisionalLocalMainFrameParams::DataView,
                                         ::content::mojom::CreateProvisionalLocalMainFrameParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateProvisionalLocalMainFrameParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateProvisionalLocalMainFrameParamsPtr* output) { output->reset(); }

  static  decltype(::content::mojom::CreateProvisionalLocalMainFrameParams::local_params)& local_params(
       ::content::mojom::CreateProvisionalLocalMainFrameParamsPtr& input) {
    return input->local_params;
  }

  static const decltype(::content::mojom::CreateProvisionalLocalMainFrameParams::previous_frame_token)& previous_frame_token(
      const ::content::mojom::CreateProvisionalLocalMainFrameParamsPtr& input) {
    return input->previous_frame_token;
  }

  static bool Read(::content::mojom::CreateProvisionalLocalMainFrameParams::DataView input, ::content::mojom::CreateProvisionalLocalMainFrameParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateRemoteMainFrameParams::DataView,
                                         ::content::mojom::CreateRemoteMainFrameParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateRemoteMainFrameParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateRemoteMainFrameParamsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::CreateRemoteMainFrameParams::token)& token(
      const ::content::mojom::CreateRemoteMainFrameParamsPtr& input) {
    return input->token;
  }

  static  decltype(::content::mojom::CreateRemoteMainFrameParams::frame_interfaces)& frame_interfaces(
       ::content::mojom::CreateRemoteMainFrameParamsPtr& input) {
    return input->frame_interfaces;
  }

  static  decltype(::content::mojom::CreateRemoteMainFrameParams::main_frame_interfaces)& main_frame_interfaces(
       ::content::mojom::CreateRemoteMainFrameParamsPtr& input) {
    return input->main_frame_interfaces;
  }

  static bool Read(::content::mojom::CreateRemoteMainFrameParams::DataView input, ::content::mojom::CreateRemoteMainFrameParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateFrameWidgetParams::DataView,
                                         ::content::mojom::CreateFrameWidgetParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateFrameWidgetParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateFrameWidgetParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::CreateFrameWidgetParams::routing_id) routing_id(
      const ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->routing_id;
  }

  static  decltype(::content::mojom::CreateFrameWidgetParams::frame_widget_host)& frame_widget_host(
       ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->frame_widget_host;
  }

  static  decltype(::content::mojom::CreateFrameWidgetParams::frame_widget)& frame_widget(
       ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->frame_widget;
  }

  static  decltype(::content::mojom::CreateFrameWidgetParams::widget_host)& widget_host(
       ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->widget_host;
  }

  static  decltype(::content::mojom::CreateFrameWidgetParams::widget)& widget(
       ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->widget;
  }

  static const decltype(::content::mojom::CreateFrameWidgetParams::visual_properties)& visual_properties(
      const ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->visual_properties;
  }

  static bool Read(::content::mojom::CreateFrameWidgetParams::DataView input, ::content::mojom::CreateFrameWidgetParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateFrameParams::DataView,
                                         ::content::mojom::CreateFrameParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateFrameParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateFrameParamsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::CreateFrameParams::frame_token)& frame_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->frame_token;
  }

  static decltype(::content::mojom::CreateFrameParams::routing_id) routing_id(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->routing_id;
  }

  static const decltype(::content::mojom::CreateFrameParams::previous_frame_token)& previous_frame_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->previous_frame_token;
  }

  static const decltype(::content::mojom::CreateFrameParams::opener_frame_token)& opener_frame_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->opener_frame_token;
  }

  static const decltype(::content::mojom::CreateFrameParams::parent_frame_token)& parent_frame_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->parent_frame_token;
  }

  static const decltype(::content::mojom::CreateFrameParams::previous_sibling_frame_token)& previous_sibling_frame_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->previous_sibling_frame_token;
  }

  static  decltype(::content::mojom::CreateFrameParams::interface_broker)& interface_broker(
       ::content::mojom::CreateFrameParamsPtr& input) {
    return input->interface_broker;
  }

  static decltype(::content::mojom::CreateFrameParams::tree_scope_type) tree_scope_type(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->tree_scope_type;
  }

  static const decltype(::content::mojom::CreateFrameParams::replication_state)& replication_state(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->replication_state;
  }

  static const decltype(::content::mojom::CreateFrameParams::devtools_frame_token)& devtools_frame_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->devtools_frame_token;
  }

  static const decltype(::content::mojom::CreateFrameParams::frame_owner_properties)& frame_owner_properties(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->frame_owner_properties;
  }

  static  decltype(::content::mojom::CreateFrameParams::widget_params)& widget_params(
       ::content::mojom::CreateFrameParamsPtr& input) {
    return input->widget_params;
  }

  static decltype(::content::mojom::CreateFrameParams::is_on_initial_empty_document) is_on_initial_empty_document(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->is_on_initial_empty_document;
  }

  static const decltype(::content::mojom::CreateFrameParams::document_token)& document_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->document_token;
  }

  static  decltype(::content::mojom::CreateFrameParams::policy_container)& policy_container(
       ::content::mojom::CreateFrameParamsPtr& input) {
    return input->policy_container;
  }

  static  decltype(::content::mojom::CreateFrameParams::frame)& frame(
       ::content::mojom::CreateFrameParamsPtr& input) {
    return input->frame;
  }

  static  decltype(::content::mojom::CreateFrameParams::associated_interface_provider_remote)& associated_interface_provider_remote(
       ::content::mojom::CreateFrameParamsPtr& input) {
    return input->associated_interface_provider_remote;
  }

  static decltype(::content::mojom::CreateFrameParams::is_for_nested_main_frame) is_for_nested_main_frame(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->is_for_nested_main_frame;
  }

  static const decltype(::content::mojom::CreateFrameParams::navigation_metrics_token)& navigation_metrics_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->navigation_metrics_token;
  }

  static bool Read(::content::mojom::CreateFrameParams::DataView input, ::content::mojom::CreateFrameParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::SnapshotAccessibilityTreeParams::DataView,
                                         ::content::mojom::SnapshotAccessibilityTreeParamsPtr> {
  static bool IsNull(const ::content::mojom::SnapshotAccessibilityTreeParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::SnapshotAccessibilityTreeParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::SnapshotAccessibilityTreeParams::ax_mode) ax_mode(
      const ::content::mojom::SnapshotAccessibilityTreeParamsPtr& input) {
    return input->ax_mode;
  }

  static decltype(::content::mojom::SnapshotAccessibilityTreeParams::max_nodes) max_nodes(
      const ::content::mojom::SnapshotAccessibilityTreeParamsPtr& input) {
    return input->max_nodes;
  }

  static const decltype(::content::mojom::SnapshotAccessibilityTreeParams::timeout)& timeout(
      const ::content::mojom::SnapshotAccessibilityTreeParamsPtr& input) {
    return input->timeout;
  }

  static bool Read(::content::mojom::SnapshotAccessibilityTreeParams::DataView input, ::content::mojom::SnapshotAccessibilityTreeParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateNewWindowParams::DataView,
                                         ::content::mojom::CreateNewWindowParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateNewWindowParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateNewWindowParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::CreateNewWindowParams::allow_popup) allow_popup(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->allow_popup;
  }

  static decltype(::content::mojom::CreateNewWindowParams::window_container_type) window_container_type(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->window_container_type;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::session_storage_namespace_id)& session_storage_namespace_id(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->session_storage_namespace_id;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::clone_from_session_storage_namespace_id)& clone_from_session_storage_namespace_id(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->clone_from_session_storage_namespace_id;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::frame_name)& frame_name(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->frame_name;
  }

  static decltype(::content::mojom::CreateNewWindowParams::opener_suppressed) opener_suppressed(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->opener_suppressed;
  }

  static decltype(::content::mojom::CreateNewWindowParams::is_form_submission) is_form_submission(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->is_form_submission;
  }

  static decltype(::content::mojom::CreateNewWindowParams::consumes_user_activation) consumes_user_activation(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->consumes_user_activation;
  }

  static  decltype(::content::mojom::CreateNewWindowParams::form_submission_post_data)& form_submission_post_data(
       ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->form_submission_post_data;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::form_submission_post_content_type)& form_submission_post_content_type(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->form_submission_post_content_type;
  }

  static decltype(::content::mojom::CreateNewWindowParams::disposition) disposition(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->disposition;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::target_url)& target_url(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->target_url;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::referrer)& referrer(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->referrer;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::features)& features(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->features;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::impression)& impression(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->impression;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::download_policy)& download_policy(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->download_policy;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::pip_options)& pip_options(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->pip_options;
  }

  static decltype(::content::mojom::CreateNewWindowParams::initiator_activation_and_ad_status) initiator_activation_and_ad_status(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->initiator_activation_and_ad_status;
  }

  static  decltype(::content::mojom::CreateNewWindowParams::frame_remote)& frame_remote(
       ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->frame_remote;
  }

  static  decltype(::content::mojom::CreateNewWindowParams::page_broadcast_remote)& page_broadcast_remote(
       ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->page_broadcast_remote;
  }

  static  decltype(::content::mojom::CreateNewWindowParams::main_frame_interface_broker)& main_frame_interface_broker(
       ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->main_frame_interface_broker;
  }

  static  decltype(::content::mojom::CreateNewWindowParams::associated_interface_provider)& associated_interface_provider(
       ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->associated_interface_provider;
  }

  static  decltype(::content::mojom::CreateNewWindowParams::widget_host)& widget_host(
       ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->widget_host;
  }

  static  decltype(::content::mojom::CreateNewWindowParams::widget)& widget(
       ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->widget;
  }

  static  decltype(::content::mojom::CreateNewWindowParams::frame_widget_host)& frame_widget_host(
       ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->frame_widget_host;
  }

  static  decltype(::content::mojom::CreateNewWindowParams::frame_widget)& frame_widget(
       ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->frame_widget;
  }

  static bool Read(::content::mojom::CreateNewWindowParams::DataView input, ::content::mojom::CreateNewWindowParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateNewWindowReply::DataView,
                                         ::content::mojom::CreateNewWindowReplyPtr> {
  static bool IsNull(const ::content::mojom::CreateNewWindowReplyPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateNewWindowReplyPtr* output) { output->reset(); }

  static const decltype(::content::mojom::CreateNewWindowReply::main_frame_token)& main_frame_token(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->main_frame_token;
  }

  static decltype(::content::mojom::CreateNewWindowReply::main_frame_route_id) main_frame_route_id(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->main_frame_route_id;
  }

  static decltype(::content::mojom::CreateNewWindowReply::widget_routing_id) widget_routing_id(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->widget_routing_id;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::visual_properties)& visual_properties(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->visual_properties;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::cloned_session_storage_namespace_id)& cloned_session_storage_namespace_id(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->cloned_session_storage_namespace_id;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::devtools_main_frame_token)& devtools_main_frame_token(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->devtools_main_frame_token;
  }

  static decltype(::content::mojom::CreateNewWindowReply::wait_for_debugger) wait_for_debugger(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->wait_for_debugger;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::document_token)& document_token(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->document_token;
  }

  static  decltype(::content::mojom::CreateNewWindowReply::policy_container)& policy_container(
       ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->policy_container;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::browsing_context_group_token)& browsing_context_group_token(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->browsing_context_group_token;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::color_provider_colors)& color_provider_colors(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->color_provider_colors;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::partitioned_popin_params)& partitioned_popin_params(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->partitioned_popin_params;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::widget_screen_rect)& widget_screen_rect(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->widget_screen_rect;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::window_screen_rect)& window_screen_rect(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->window_screen_rect;
  }

  static bool Read(::content::mojom::CreateNewWindowReply::DataView input, ::content::mojom::CreateNewWindowReplyPtr* output);
};


template <>
struct CONTENT_EXPORT UnionTraits<::content::mojom::CreateMainFrameUnion::DataView,
                                        ::content::mojom::CreateMainFrameUnionPtr> {
  static bool IsNull(const ::content::mojom::CreateMainFrameUnionPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateMainFrameUnionPtr* output) { output->reset(); }

  static ::content::mojom::CreateMainFrameUnion::Tag GetTag(const ::content::mojom::CreateMainFrameUnionPtr& input) {
    return input->which();
  }

  static  ::content::mojom::CreateLocalMainFrameParamsPtr& local_params( ::content::mojom::CreateMainFrameUnionPtr& input) {
    return input->get_local_params();
  }

  static  ::content::mojom::CreateProvisionalLocalMainFrameParamsPtr& provisional_local_params( ::content::mojom::CreateMainFrameUnionPtr& input) {
    return input->get_provisional_local_params();
  }

  static  ::content::mojom::CreateRemoteMainFrameParamsPtr& remote_params( ::content::mojom::CreateMainFrameUnionPtr& input) {
    return input->get_remote_params();
  }

  static bool Read(::content::mojom::CreateMainFrameUnion::DataView input, ::content::mojom::CreateMainFrameUnionPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_FRAME_MOJOM_H_