// content/common/frame.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_MOJOM_DATA_VIEW_H_
#define CONTENT_COMMON_FRAME_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "content/common/frame.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_state.mojom-shared.h"
#include "content/common/frame_messages.mojom-shared.h"
#include "content/common/navigation_client.mojom-shared.h"
#include "content/common/web_ui.mojom-shared.h"
#include "content/public/common/extra_mojo_js_features.mojom-shared.h"
#include "content/public/common/window_container_type.mojom-shared.h"
#include "ipc/constants.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "third_party/blink/public/mojom/associated_interfaces/associated_interfaces.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-shared.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-shared.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"
#include "third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared.h"
#include "third_party/blink/public/mojom/page/prerender_page_param.mojom-shared.h"
#include "third_party/blink/public/mojom/partitioned_popins/partitioned_popin_params.mojom-shared.h"
#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace content::mojom {
class CreateViewParamsDataView;

class CreateLocalMainFrameParamsDataView;

class CreateProvisionalLocalMainFrameParamsDataView;

class CreateRemoteMainFrameParamsDataView;

class CreateFrameWidgetParamsDataView;

class CreateFrameParamsDataView;

class SnapshotAccessibilityTreeParamsDataView;

class CreateNewWindowParamsDataView;

class CreateNewWindowReplyDataView;

class CreateMainFrameUnionDataView;


}  // content::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::CreateViewParamsDataView> {
  using Data = ::content::mojom::internal::CreateViewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateLocalMainFrameParamsDataView> {
  using Data = ::content::mojom::internal::CreateLocalMainFrameParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateProvisionalLocalMainFrameParamsDataView> {
  using Data = ::content::mojom::internal::CreateProvisionalLocalMainFrameParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateRemoteMainFrameParamsDataView> {
  using Data = ::content::mojom::internal::CreateRemoteMainFrameParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateFrameWidgetParamsDataView> {
  using Data = ::content::mojom::internal::CreateFrameWidgetParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateFrameParamsDataView> {
  using Data = ::content::mojom::internal::CreateFrameParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::SnapshotAccessibilityTreeParamsDataView> {
  using Data = ::content::mojom::internal::SnapshotAccessibilityTreeParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateNewWindowParamsDataView> {
  using Data = ::content::mojom::internal::CreateNewWindowParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateNewWindowReplyDataView> {
  using Data = ::content::mojom::internal::CreateNewWindowReply_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateMainFrameUnionDataView> {
  using Data = ::content::mojom::internal::CreateMainFrameUnion_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace content::mojom {


enum class ViewWidgetType : int32_t {
  
  kTopLevel = 0,
  
  kGuestView = 1,
  
  kFencedFrame = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ViewWidgetType value);
inline bool IsKnownEnumValue(ViewWidgetType value) {
  return internal::ViewWidgetType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ChildFrameOwnerElementType : int32_t {
  
  kIframe = 0,
  
  kObject = 1,
  
  kEmbed = 2,
  
  kFrame = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ChildFrameOwnerElementType value);
inline bool IsKnownEnumValue(ChildFrameOwnerElementType value) {
  return internal::ChildFrameOwnerElementType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FrameDeleteIntention : int32_t {
  
  kNotMainFrame = 0,
  
  kSpeculativeMainFrameForShutdown = 1,
  
  kSpeculativeMainFrameForNavigationCancelled = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, FrameDeleteIntention value);
inline bool IsKnownEnumValue(FrameDeleteIntention value) {
  return internal::FrameDeleteIntention_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CreateNewWindowStatus : int32_t {
  
  kBlocked = 0,
  
  kIgnore = 1,
  
  kReuse = 2,
  
  kSuccess = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, CreateNewWindowStatus value);
inline bool IsKnownEnumValue(CreateNewWindowStatus value) {
  return internal::CreateNewWindowStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FrameHTMLSerializerHandlerInterfaceBase {};

using FrameHTMLSerializerHandlerPtrDataView =
    mojo::InterfacePtrDataView<FrameHTMLSerializerHandlerInterfaceBase>;
using FrameHTMLSerializerHandlerRequestDataView =
    mojo::InterfaceRequestDataView<FrameHTMLSerializerHandlerInterfaceBase>;
using FrameHTMLSerializerHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameHTMLSerializerHandlerInterfaceBase>;
using FrameHTMLSerializerHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameHTMLSerializerHandlerInterfaceBase>;
class FrameInterfaceBase {};

using FramePtrDataView =
    mojo::InterfacePtrDataView<FrameInterfaceBase>;
using FrameRequestDataView =
    mojo::InterfaceRequestDataView<FrameInterfaceBase>;
using FrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameInterfaceBase>;
using FrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameInterfaceBase>;
class FrameBindingsControlInterfaceBase {};

using FrameBindingsControlPtrDataView =
    mojo::InterfacePtrDataView<FrameBindingsControlInterfaceBase>;
using FrameBindingsControlRequestDataView =
    mojo::InterfaceRequestDataView<FrameBindingsControlInterfaceBase>;
using FrameBindingsControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameBindingsControlInterfaceBase>;
using FrameBindingsControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameBindingsControlInterfaceBase>;
class NavigationRendererCancellationListenerInterfaceBase {};

using NavigationRendererCancellationListenerPtrDataView =
    mojo::InterfacePtrDataView<NavigationRendererCancellationListenerInterfaceBase>;
using NavigationRendererCancellationListenerRequestDataView =
    mojo::InterfaceRequestDataView<NavigationRendererCancellationListenerInterfaceBase>;
using NavigationRendererCancellationListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NavigationRendererCancellationListenerInterfaceBase>;
using NavigationRendererCancellationListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NavigationRendererCancellationListenerInterfaceBase>;
class FrameHostInterfaceBase {};

using FrameHostPtrDataView =
    mojo::InterfacePtrDataView<FrameHostInterfaceBase>;
using FrameHostRequestDataView =
    mojo::InterfaceRequestDataView<FrameHostInterfaceBase>;
using FrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameHostInterfaceBase>;
using FrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameHostInterfaceBase>;


class CreateViewParamsDataView {
 public:
  CreateViewParamsDataView() = default;

  CreateViewParamsDataView(
      internal::CreateViewParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRendererPreferencesDataView(
      ::blink::mojom::RendererPreferencesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRendererPreferences(UserType* output) {
    
    auto* pointer = data_->renderer_preferences.Get();
    return mojo::internal::Deserialize<::blink::mojom::RendererPreferencesDataView>(
        pointer, output, message_);
  }
  inline void GetWebPreferencesDataView(
      ::blink::mojom::WebPreferencesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebPreferences(UserType* output) {
    
    auto* pointer = data_->web_preferences.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebPreferencesDataView>(
        pointer, output, message_);
  }
  inline void GetSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOpenerFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOpenerFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `opener_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOpenerFrameToken` instead "
    "of `ReadOpenerFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->opener_frame_token.is_null() ? &data_->opener_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetReplicationStateDataView(
      ::blink::mojom::FrameReplicationStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplicationState(UserType* output) {
    
    auto* pointer = data_->replication_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameReplicationStateDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsMainFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsMainFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_main_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetMainFrameDataView(
      CreateMainFrameUnionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrame(UserType* output) {
    
    auto* pointer = !data_->main_frame.is_null() ? &data_->main_frame : nullptr;
    return mojo::internal::Deserialize<::content::mojom::CreateMainFrameUnionDataView>(
        pointer, output, message_);
  }
  bool hidden() const {
    return data_->hidden;
  }
  inline void GetPrerenderParamDataView(
      ::blink::mojom::PrerenderParamDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrerenderParam(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PrerenderParamDataView, UserType>(),
    "Attempting to read the optional `prerender_param` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrerenderParam` instead "
    "of `ReadPrerenderParam if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->prerender_param.Get();
    return mojo::internal::Deserialize<::blink::mojom::PrerenderParamDataView>(
        pointer, output, message_);
  }
  bool never_composited() const {
    return data_->never_composited;
  }
  bool window_was_opened_by_another_window() const {
    return data_->window_was_opened_by_another_window;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::content::mojom::ViewWidgetType>(
        data_value, output);
  }
  ViewWidgetType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::ViewWidgetType>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFencedFrameMode(UserType* output) const {
    auto data_value = data_->fenced_frame_mode;
    return mojo::internal::Deserialize<::blink::mojom::DeprecatedFencedFrameMode>(
        data_value, output);
  }
  ::blink::mojom::DeprecatedFencedFrameMode fenced_frame_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DeprecatedFencedFrameMode>(data_->fenced_frame_mode));
  }
  inline void GetOutermostOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutermostOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `outermost_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOutermostOrigin` instead "
    "of `ReadOutermostOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->outermost_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeBlinkPageBroadcast() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::PageBroadcastAssociatedRequestDataView>(
            &data_->blink_page_broadcast, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetBaseBackgroundColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBaseBackgroundColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkColorDataView, UserType>(),
    "Attempting to read the optional `base_background_color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBaseBackgroundColor` instead "
    "of `ReadBaseBackgroundColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->base_background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetColorProviderColorsDataView(
      ::blink::mojom::ColorProviderColorMapsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorProviderColors(UserType* output) {
    
    auto* pointer = data_->color_provider_colors.Get();
    return mojo::internal::Deserialize<::blink::mojom::ColorProviderColorMapsDataView>(
        pointer, output, message_);
  }
  inline void GetBrowsingContextGroupTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowsingContextGroupToken(UserType* output) {
    
    auto* pointer = data_->browsing_context_group_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributionSupport(UserType* output) const {
    auto data_value = data_->attribution_support;
    return mojo::internal::Deserialize<::network::mojom::AttributionSupport>(
        data_value, output);
  }
  ::network::mojom::AttributionSupport attribution_support() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AttributionSupport>(data_->attribution_support));
  }
  inline void GetPartitionedPopinParamsDataView(
      ::blink::mojom::PartitionedPopinParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPartitionedPopinParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PartitionedPopinParamsDataView, UserType>(),
    "Attempting to read the optional `partitioned_popin_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPartitionedPopinParams` instead "
    "of `ReadPartitionedPopinParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->partitioned_popin_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::PartitionedPopinParamsDataView>(
        pointer, output, message_);
  }
  inline void GetNavigationMetricsTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationMetricsToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `navigation_metrics_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNavigationMetricsToken` instead "
    "of `ReadNavigationMetricsToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->navigation_metrics_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  int32_t history_index() const {
    return data_->history_index;
  }
  int32_t history_length() const {
    return data_->history_length;
  }
  inline void GetCanvasNoiseTokenDataView(
      ::blink::mojom::NoiseTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCanvasNoiseToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::NoiseTokenDataView, UserType>(),
    "Attempting to read the optional `canvas_noise_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCanvasNoiseToken` instead "
    "of `ReadCanvasNoiseToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->canvas_noise_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::NoiseTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateViewParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateLocalMainFrameParamsDataView {
 public:
  CreateLocalMainFrameParamsDataView() = default;

  CreateLocalMainFrameParamsDataView(
      internal::CreateLocalMainFrameParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameToken(UserType* output) {
    
    auto* pointer = data_->frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  template <typename UserType>
  UserType TakeFrame() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::content::mojom::FrameAssociatedRequestDataView>(
            &data_->frame, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeInterfaceBroker() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
            &data_->interface_broker, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAssociatedInterfaceProviderRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
            &data_->associated_interface_provider_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool is_on_initial_empty_document() const {
    return data_->is_on_initial_empty_document;
  }
  inline void GetDocumentTokenDataView(
      ::blink::mojom::DocumentTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentToken(UserType* output) {
    
    auto* pointer = data_->document_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::DocumentTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyContainerDataView(
      ::blink::mojom::PolicyContainerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyContainer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PolicyContainerDataView, UserType>(),
    "Attempting to read the optional `policy_container` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPolicyContainer` instead "
    "of `ReadPolicyContainer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->policy_container.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerDataView>(
        pointer, output, message_);
  }
  inline void GetWidgetParamsDataView(
      CreateFrameWidgetParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidgetParams(UserType* output) {
    
    auto* pointer = data_->widget_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CreateFrameWidgetParamsDataView>(
        pointer, output, message_);
  }
  inline void GetSubresourceLoaderFactoriesDataView(
      ::blink::mojom::URLLoaderFactoryBundleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubresourceLoaderFactories(UserType* output) {
    
    auto* pointer = data_->subresource_loader_factories.Get();
    return mojo::internal::Deserialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateLocalMainFrameParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateProvisionalLocalMainFrameParamsDataView {
 public:
  CreateProvisionalLocalMainFrameParamsDataView() = default;

  CreateProvisionalLocalMainFrameParamsDataView(
      internal::CreateProvisionalLocalMainFrameParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocalParamsDataView(
      CreateLocalMainFrameParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalParams(UserType* output) {
    
    auto* pointer = data_->local_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CreateLocalMainFrameParamsDataView>(
        pointer, output, message_);
  }
  inline void GetPreviousFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviousFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `previous_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPreviousFrameToken` instead "
    "of `ReadPreviousFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->previous_frame_token.is_null() ? &data_->previous_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateProvisionalLocalMainFrameParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateRemoteMainFrameParamsDataView {
 public:
  CreateRemoteMainFrameParamsDataView() = default;

  CreateRemoteMainFrameParamsDataView(
      internal::CreateRemoteMainFrameParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::blink::mojom::RemoteFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFrameInterfacesDataView(
      ::blink::mojom::RemoteFrameInterfacesFromBrowserDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInterfaces(UserType* output) {
    
    auto* pointer = data_->frame_interfaces.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
        pointer, output, message_);
  }
  inline void GetMainFrameInterfacesDataView(
      ::blink::mojom::RemoteMainFrameInterfacesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameInterfaces(UserType* output) {
    
    auto* pointer = data_->main_frame_interfaces.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteMainFrameInterfacesDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateRemoteMainFrameParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateFrameWidgetParamsDataView {
 public:
  CreateFrameWidgetParamsDataView() = default;

  CreateFrameWidgetParamsDataView(
      internal::CreateFrameWidgetParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  template <typename UserType>
  UserType TakeFrameWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetHostAssociatedPtrInfoDataView>(
            &data_->frame_widget_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetAssociatedRequestDataView>(
            &data_->frame_widget, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetHostAssociatedPtrInfoDataView>(
            &data_->widget_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetAssociatedRequestDataView>(
            &data_->widget, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetVisualPropertiesDataView(
      ::blink::mojom::VisualPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisualProperties(UserType* output) {
    
    auto* pointer = data_->visual_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::VisualPropertiesDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateFrameWidgetParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateFrameParamsDataView {
 public:
  CreateFrameParamsDataView() = default;

  CreateFrameParamsDataView(
      internal::CreateFrameParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameToken(UserType* output) {
    
    auto* pointer = data_->frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  inline void GetPreviousFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviousFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `previous_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPreviousFrameToken` instead "
    "of `ReadPreviousFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->previous_frame_token.is_null() ? &data_->previous_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetOpenerFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOpenerFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `opener_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOpenerFrameToken` instead "
    "of `ReadOpenerFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->opener_frame_token.is_null() ? &data_->opener_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetParentFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParentFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `parent_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParentFrameToken` instead "
    "of `ReadParentFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->parent_frame_token.is_null() ? &data_->parent_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPreviousSiblingFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviousSiblingFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `previous_sibling_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPreviousSiblingFrameToken` instead "
    "of `ReadPreviousSiblingFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->previous_sibling_frame_token.is_null() ? &data_->previous_sibling_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeInterfaceBroker() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
            &data_->interface_broker, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTreeScopeType(UserType* output) const {
    auto data_value = data_->tree_scope_type;
    return mojo::internal::Deserialize<::blink::mojom::TreeScopeType>(
        data_value, output);
  }
  ::blink::mojom::TreeScopeType tree_scope_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::TreeScopeType>(data_->tree_scope_type));
  }
  inline void GetReplicationStateDataView(
      ::blink::mojom::FrameReplicationStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplicationState(UserType* output) {
    
    auto* pointer = data_->replication_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameReplicationStateDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFrameOwnerPropertiesDataView(
      ::blink::mojom::FrameOwnerPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameOwnerProperties(UserType* output) {
    
    auto* pointer = data_->frame_owner_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameOwnerPropertiesDataView>(
        pointer, output, message_);
  }
  inline void GetWidgetParamsDataView(
      CreateFrameWidgetParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidgetParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::CreateFrameWidgetParamsDataView, UserType>(),
    "Attempting to read the optional `widget_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWidgetParams` instead "
    "of `ReadWidgetParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->widget_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CreateFrameWidgetParamsDataView>(
        pointer, output, message_);
  }
  bool is_on_initial_empty_document() const {
    return data_->is_on_initial_empty_document;
  }
  inline void GetDocumentTokenDataView(
      ::blink::mojom::DocumentTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentToken(UserType* output) {
    
    auto* pointer = data_->document_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::DocumentTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyContainerDataView(
      ::blink::mojom::PolicyContainerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyContainer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PolicyContainerDataView, UserType>(),
    "Attempting to read the optional `policy_container` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPolicyContainer` instead "
    "of `ReadPolicyContainer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->policy_container.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeFrame() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::content::mojom::FrameAssociatedRequestDataView>(
            &data_->frame, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAssociatedInterfaceProviderRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
            &data_->associated_interface_provider_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool is_for_nested_main_frame() const {
    return data_->is_for_nested_main_frame;
  }
  inline void GetNavigationMetricsTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationMetricsToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `navigation_metrics_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNavigationMetricsToken` instead "
    "of `ReadNavigationMetricsToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->navigation_metrics_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateFrameParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SnapshotAccessibilityTreeParamsDataView {
 public:
  SnapshotAccessibilityTreeParamsDataView() = default;

  SnapshotAccessibilityTreeParamsDataView(
      internal::SnapshotAccessibilityTreeParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t ax_mode() const {
    return data_->ax_mode;
  }
  uint64_t max_nodes() const {
    return data_->max_nodes;
  }
  inline void GetTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeout(UserType* output) {
    
    auto* pointer = data_->timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::SnapshotAccessibilityTreeParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateNewWindowParamsDataView {
 public:
  CreateNewWindowParamsDataView() = default;

  CreateNewWindowParamsDataView(
      internal::CreateNewWindowParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool allow_popup() const {
    return data_->allow_popup;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWindowContainerType(UserType* output) const {
    auto data_value = data_->window_container_type;
    return mojo::internal::Deserialize<::content::mojom::WindowContainerType>(
        data_value, output);
  }
  ::content::mojom::WindowContainerType window_container_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::WindowContainerType>(data_->window_container_type));
  }
  inline void GetSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCloneFromSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCloneFromSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->clone_from_session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFrameNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameName(UserType* output) {
    
    auto* pointer = data_->frame_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool opener_suppressed() const {
    return data_->opener_suppressed;
  }
  bool is_form_submission() const {
    return data_->is_form_submission;
  }
  bool consumes_user_activation() const {
    return data_->consumes_user_activation;
  }
  inline void GetFormSubmissionPostDataDataView(
      ::network::mojom::URLRequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormSubmissionPostData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLRequestBodyDataView, UserType>(),
    "Attempting to read the optional `form_submission_post_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFormSubmissionPostData` instead "
    "of `ReadFormSubmissionPostData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->form_submission_post_data.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestBodyDataView>(
        pointer, output, message_);
  }
  inline void GetFormSubmissionPostContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormSubmissionPostContentType(UserType* output) {
    
    auto* pointer = data_->form_submission_post_content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDisposition(UserType* output) const {
    auto data_value = data_->disposition;
    return mojo::internal::Deserialize<::ui::mojom::WindowOpenDisposition>(
        data_value, output);
  }
  ::ui::mojom::WindowOpenDisposition disposition() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::WindowOpenDisposition>(data_->disposition));
  }
  inline void GetTargetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetUrl(UserType* output) {
    
    auto* pointer = data_->target_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  inline void GetFeaturesDataView(
      ::blink::mojom::WindowFeaturesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatures(UserType* output) {
    
    auto* pointer = data_->features.Get();
    return mojo::internal::Deserialize<::blink::mojom::WindowFeaturesDataView>(
        pointer, output, message_);
  }
  inline void GetImpressionDataView(
      ::blink::mojom::ImpressionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImpression(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ImpressionDataView, UserType>(),
    "Attempting to read the optional `impression` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImpression` instead "
    "of `ReadImpression if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->impression.Get();
    return mojo::internal::Deserialize<::blink::mojom::ImpressionDataView>(
        pointer, output, message_);
  }
  inline void GetDownloadPolicyDataView(
      ::blink::mojom::NavigationDownloadPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDownloadPolicy(UserType* output) {
    
    auto* pointer = data_->download_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationDownloadPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetPipOptionsDataView(
      ::blink::mojom::PictureInPictureWindowOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPipOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PictureInPictureWindowOptionsDataView, UserType>(),
    "Attempting to read the optional `pip_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPipOptions` instead "
    "of `ReadPipOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pip_options.Get();
    return mojo::internal::Deserialize<::blink::mojom::PictureInPictureWindowOptionsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorActivationAndAdStatus(UserType* output) const {
    auto data_value = data_->initiator_activation_and_ad_status;
    return mojo::internal::Deserialize<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(
        data_value, output);
  }
  ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(data_->initiator_activation_and_ad_status));
  }
  template <typename UserType>
  UserType TakeFrameRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::content::mojom::FrameAssociatedPtrInfoDataView>(
            &data_->frame_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakePageBroadcastRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::PageBroadcastAssociatedPtrInfoDataView>(
            &data_->page_broadcast_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeMainFrameInterfaceBroker() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
            &data_->main_frame_interface_broker, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAssociatedInterfaceProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::AssociatedInterfaceProviderAssociatedRequestDataView>(
            &data_->associated_interface_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetHostAssociatedRequestDataView>(
            &data_->widget_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetAssociatedPtrInfoDataView>(
            &data_->widget, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetHostAssociatedRequestDataView>(
            &data_->frame_widget_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetAssociatedPtrInfoDataView>(
            &data_->frame_widget, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CreateNewWindowParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateNewWindowReplyDataView {
 public:
  CreateNewWindowReplyDataView() = default;

  CreateNewWindowReplyDataView(
      internal::CreateNewWindowReply_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMainFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameToken(UserType* output) {
    
    auto* pointer = data_->main_frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  int32_t main_frame_route_id() const {
    return data_->main_frame_route_id;
  }
  int32_t widget_routing_id() const {
    return data_->widget_routing_id;
  }
  inline void GetVisualPropertiesDataView(
      ::blink::mojom::VisualPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisualProperties(UserType* output) {
    
    auto* pointer = data_->visual_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::VisualPropertiesDataView>(
        pointer, output, message_);
  }
  inline void GetClonedSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClonedSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->cloned_session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsMainFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsMainFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_main_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool wait_for_debugger() const {
    return data_->wait_for_debugger;
  }
  inline void GetDocumentTokenDataView(
      ::blink::mojom::DocumentTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentToken(UserType* output) {
    
    auto* pointer = data_->document_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::DocumentTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyContainerDataView(
      ::blink::mojom::PolicyContainerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyContainer(UserType* output) {
    
    auto* pointer = data_->policy_container.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerDataView>(
        pointer, output, message_);
  }
  inline void GetBrowsingContextGroupTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowsingContextGroupToken(UserType* output) {
    
    auto* pointer = data_->browsing_context_group_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetColorProviderColorsDataView(
      ::blink::mojom::ColorProviderColorMapsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorProviderColors(UserType* output) {
    
    auto* pointer = data_->color_provider_colors.Get();
    return mojo::internal::Deserialize<::blink::mojom::ColorProviderColorMapsDataView>(
        pointer, output, message_);
  }
  inline void GetPartitionedPopinParamsDataView(
      ::blink::mojom::PartitionedPopinParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPartitionedPopinParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PartitionedPopinParamsDataView, UserType>(),
    "Attempting to read the optional `partitioned_popin_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPartitionedPopinParams` instead "
    "of `ReadPartitionedPopinParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->partitioned_popin_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::PartitionedPopinParamsDataView>(
        pointer, output, message_);
  }
  inline void GetWidgetScreenRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidgetScreenRect(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `widget_screen_rect` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWidgetScreenRect` instead "
    "of `ReadWidgetScreenRect if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->widget_screen_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetWindowScreenRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindowScreenRect(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `window_screen_rect` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWindowScreenRect` instead "
    "of `ReadWindowScreenRect if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->window_screen_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateNewWindowReply_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateMainFrameUnionDataView {
 public:
  using Tag = internal::CreateMainFrameUnion_Data::CreateMainFrameUnion_Tag;

  CreateMainFrameUnionDataView() = default;

  CreateMainFrameUnionDataView(
      internal::CreateMainFrameUnion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_local_params() const { return data_->tag == Tag::kLocalParams; }
  inline void GetLocalParamsDataView(
      CreateLocalMainFrameParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLocalParams(UserType* output) const {
    
    CHECK(is_local_params());
    return mojo::internal::Deserialize<::content::mojom::CreateLocalMainFrameParamsDataView>(
        data_->data.f_local_params.Get(), output, message_);
  }
  bool is_provisional_local_params() const { return data_->tag == Tag::kProvisionalLocalParams; }
  inline void GetProvisionalLocalParamsDataView(
      CreateProvisionalLocalMainFrameParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadProvisionalLocalParams(UserType* output) const {
    
    CHECK(is_provisional_local_params());
    return mojo::internal::Deserialize<::content::mojom::CreateProvisionalLocalMainFrameParamsDataView>(
        data_->data.f_provisional_local_params.Get(), output, message_);
  }
  bool is_remote_params() const { return data_->tag == Tag::kRemoteParams; }
  inline void GetRemoteParamsDataView(
      CreateRemoteMainFrameParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteParams(UserType* output) const {
    
    CHECK(is_remote_params());
    return mojo::internal::Deserialize<::content::mojom::CreateRemoteMainFrameParamsDataView>(
        data_->data.f_remote_params.Get(), output, message_);
  }

 private:
  internal::CreateMainFrameUnion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // content::mojom

#endif  // CONTENT_COMMON_FRAME_MOJOM_DATA_VIEW_H_