// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MAX_VERTICAL_LABELS=6;const LABEL_VERTICAL_SPACING=4;const LABEL_HORIZONTAL_SPACING=3;const LABEL_LABEL_HORIZONTAL_SPACING=25;const Y_AXIS_TICK_LENGTH=10;const GRID_COLOR="#CCC";const TEXT_COLOR="#000";const BACKGROUND_COLOR="#FFF";const MAX_DECIMAL_PRECISION=3;export class TimelineGraphView{constructor(divId,canvasId){this.scrollbar_={position_:0,range_:0};this.graphDiv_=document.getElementById(divId);this.canvas_=document.getElementById(canvasId);this.startTime_=0;this.endTime_=1;this.graph_=null;this.scale_=1e3;this.updateScrollbarRange_(true)}setScale(scale){this.scale_=scale}getLength_(){const timeRange=this.endTime_-this.startTime_;return Math.floor(timeRange/this.scale_)}graphScrolledToRightEdge_(){return this.scrollbar_.position_===this.scrollbar_.range_}updateScrollbarRange_(resetPosition){let scrollbarRange=this.getLength_()-this.canvas_.width;if(scrollbarRange<0){scrollbarRange=0}if(this.scrollbar_.position_>scrollbarRange){resetPosition=true}this.scrollbar_.range_=scrollbarRange;if(resetPosition){this.scrollbar_.position_=scrollbarRange;this.repaint()}}setDateRange(startDate,endDate){this.startTime_=startDate.getTime();this.endTime_=endDate.getTime();if(this.endTime_<=this.startTime_){this.startTime_=this.endTime_-1}this.updateScrollbarRange_(true)}updateEndDate(opt_date){this.endTime_=opt_date||(new Date).getTime();this.updateScrollbarRange_(this.graphScrolledToRightEdge_())}getStartDate(){return new Date(this.startTime_)}setDataSeries(dataSeries){this.graph_=new Graph;for(let i=0;i<dataSeries.length;++i){this.graph_.addDataSeries(dataSeries[i])}this.repaint()}addDataSeries(dataSeries){if(!this.graph_){this.graph_=new Graph}this.graph_.addDataSeries(dataSeries);this.repaint()}repaint(){if(this.canvas_.offsetParent===null){return}this.repaintTimerRunning_=false;const width=this.canvas_.width;let height=this.canvas_.height;const context=this.canvas_.getContext("2d");context.fillStyle=BACKGROUND_COLOR;context.fillRect(0,0,width,height);const fontHeightString=context.font.match(/([0-9]+)px/)[1];const fontHeight=parseInt(fontHeightString);if(fontHeightString.length===0||fontHeight<=0||fontHeight*4>height||width<50){return}context.save();context.translate(.5,.5);let position=this.scrollbar_.position_;if(this.scrollbar_.range_===0){position=this.getLength_()-this.canvas_.width}const visibleStartTime=this.startTime_+position*this.scale_;const textHeight=height;height-=fontHeight+LABEL_VERTICAL_SPACING;this.drawTimeLabels(context,width,height,textHeight,visibleStartTime);context.strokeStyle=GRID_COLOR;context.strokeRect(0,0,width-1,height-1);if(this.graph_){this.graph_.layout(width,height,fontHeight,visibleStartTime,this.scale_);this.graph_.drawTicks(context);this.graph_.drawLines(context);this.graph_.drawLabels(context)}context.restore()}drawTimeLabels(context,width,height,textHeight,startTime){const timeStep=1e3*60;let time=Math.ceil(startTime/timeStep)*timeStep;context.textBaseline="bottom";context.textAlign="center";context.fillStyle=TEXT_COLOR;context.strokeStyle=GRID_COLOR;while(true){const x=Math.round((time-startTime)/this.scale_);if(x>=width){break}const text=new Date(time).toLocaleTimeString();context.fillText(text,x,textHeight);context.beginPath();context.lineTo(x,0);context.lineTo(x,height);context.stroke();time+=timeStep}}getDataSeriesCount(){if(this.graph_){return this.graph_.dataSeries_.length}return 0}hasDataSeries(dataSeries){if(this.graph_){return this.graph_.hasDataSeries(dataSeries)}return false}}class Label{constructor(height,text){this.height=height;this.text=text}}class Graph{constructor(){this.dataSeries_=[];this.width_=0;this.height_=0;this.fontHeight_=0;this.startTime_=0;this.scale_=0;this.min_=0;this.max_=0;this.labels_=[]}addDataSeries(dataSeries){this.dataSeries_.push(dataSeries)}hasDataSeries(dataSeries){for(let i=0;i<this.dataSeries_.length;++i){if(this.dataSeries_[i]===dataSeries){return true}}return false}getValues(dataSeries){if(!dataSeries.isVisible()){return null}return dataSeries.getValues(this.startTime_,this.scale_,this.width_)}layout(width,height,fontHeight,startTime,scale){this.width_=width;this.height_=height;this.fontHeight_=fontHeight;this.startTime_=startTime;this.scale_=scale;let max=0;let min=0;for(let i=0;i<this.dataSeries_.length;++i){const values=this.getValues(this.dataSeries_[i]);if(!values){continue}for(let j=0;j<values.length;++j){if(values[j]>max){max=values[j]}else if(values[j]<min){min=values[j]}}}this.layoutLabels_(min,max)}layoutLabels_(minValue,maxValue){if(maxValue-minValue<1024){this.layoutLabelsBasic_(minValue,maxValue,MAX_DECIMAL_PRECISION);return}const units=["","k","M","G","T","P"];let unit=1;minValue/=1024;maxValue/=1024;while(units[unit+1]&&maxValue-minValue>=1024){minValue/=1024;maxValue/=1024;++unit}this.layoutLabelsBasic_(minValue,maxValue,MAX_DECIMAL_PRECISION);for(let i=0;i<this.labels_.length;++i){this.labels_[i]+=" "+units[unit]}this.min_*=Math.pow(1024,unit);this.max_*=Math.pow(1024,unit)}layoutLabelsBasic_(minValue,maxValue,maxDecimalDigits){this.labels_=[];const range=maxValue-minValue;if(range===0){this.min_=this.max_=maxValue;return}const minLabelSpacing=2*this.fontHeight_+LABEL_VERTICAL_SPACING;let maxLabels=1+this.height_/minLabelSpacing;if(maxLabels<2){maxLabels=2}else if(maxLabels>MAX_VERTICAL_LABELS){maxLabels=MAX_VERTICAL_LABELS}let stepSize=Math.pow(10,-maxDecimalDigits);let stepSizeDecimalDigits=maxDecimalDigits;while(true){if(Math.ceil(range/stepSize)+1<=maxLabels){break}if(Math.ceil(range/(stepSize*2))+1<=maxLabels){stepSize*=2;break}if(Math.ceil(range/(stepSize*5))+1<=maxLabels){stepSize*=5;break}stepSize*=10;if(stepSizeDecimalDigits>0){--stepSizeDecimalDigits}}this.max_=Math.ceil(maxValue/stepSize)*stepSize;this.min_=Math.floor(minValue/stepSize)*stepSize;for(let label=this.max_;label>=this.min_;label-=stepSize){this.labels_.push(label.toFixed(stepSizeDecimalDigits))}}drawTicks(context){const x1=this.width_-1;const x2=this.width_-1-Y_AXIS_TICK_LENGTH;context.fillStyle=GRID_COLOR;context.beginPath();for(let i=1;i<this.labels_.length-1;++i){const y=Math.round(this.height_*i/(this.labels_.length-1));context.moveTo(x1,y);context.lineTo(x2,y)}context.stroke()}drawLines(context){let scale=0;const bottom=this.height_-1;if(this.max_){scale=bottom/(this.max_-this.min_)}for(let i=this.dataSeries_.length-1;i>=0;--i){const values=this.getValues(this.dataSeries_[i]);if(!values){continue}context.strokeStyle=this.dataSeries_[i].getColor();context.beginPath();for(let x=0;x<values.length;++x){context.lineTo(x,bottom-Math.round((values[x]-this.min_)*scale))}context.stroke()}}drawLabels(context){if(this.labels_.length===0){return}const x=this.width_-LABEL_HORIZONTAL_SPACING;context.fillStyle=TEXT_COLOR;context.textAlign="right";context.textBaseline="top";context.fillText(this.labels_[0],x,0);context.textBaseline="bottom";const step=(this.height_-1)/(this.labels_.length-1);for(let i=1;i<this.labels_.length;++i){context.fillText(this.labels_[i],x,step*i)}}}