// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$}from"chrome://resources/js/util.js";export const userMediaRequests=[];export const peerConnectionDataStore={};window.userMediaRequests=userMediaRequests;window.peerConnectionDataStore=peerConnectionDataStore;const rtcStatsEvents=[];let lastRtcStatsTimestamp=0;export function addRtcStatsEvent(event_name,connection_id,value,...extra){const timestamp=extra.pop();const delta=timestamp-lastRtcStatsTimestamp;lastRtcStatsTimestamp=timestamp;rtcStatsEvents.push([event_name,connection_id,value,...extra,delta])}export class DumpCreator{constructor(ignoredContainerElement){document.getElementById("dump-click-target").addEventListener("click",this.onDownloadInternals_.bind(this));document.getElementById("dump-click-target-rtcstats").addEventListener("click",this.onDownloadRtcStats_.bind(this));document.getElementById("audio-recording-click-target").addEventListener("click",this.onAudioDebugRecordingsChanged_.bind(this));document.getElementById("packet-recording-click-target").addEventListener("click",this.onEventLogRecordingsChanged_.bind(this));document.getElementById("datachannel-recording-click-target").addEventListener("click",this.onDataChannelRecordingsChanged_.bind(this))}setAudioDebugRecordingsCheckbox(){document.getElementById("audio-recording-checkbox").checked=true}clearAudioDebugRecordingsCheckbox(){document.getElementById("audio-recording-checkbox").checked=false}setEventLogRecordingsCheckbox(){document.getElementById("packet-recording-checkbox").checked=true}clearEventLogRecordingsCheckbox(){document.getElementById("packet-recording-checkbox").checked=false}setEventLogRecordingsCheckboxMutability(mutable){document.getElementById("packet-recording-checkbox").disabled=!mutable;if(!mutable){const label=document.getElementById("packet-recording-label");label.style="color:red;";label.textContent=" WebRTC event logging's state was set by a command line flag."}}setDataChannelRecordingsCheckbox(){document.getElementById("datachannel-recording-checkbox").checked=true}clearDataChannelRecordingsCheckbox(){document.getElementById("datachannel-recording-checkbox").checked=false}async download(name,blob,useCompression){if(useCompression){const compressionStream=new CompressionStream("gzip");const binaryStream=blob.stream().pipeThrough(compressionStream);const binaryBlob=await new Response(binaryStream).blob();const anchor=document.createElement("a");anchor.download=name+".gz";anchor.href=URL.createObjectURL(binaryBlob);anchor.click();return}const anchor=document.createElement("a");anchor.download=name+".txt";anchor.href=URL.createObjectURL(blob);anchor.click()}async onDownloadInternals_(){const useCompression=document.getElementById("dump-checkbox").checked;const uaData=await navigator.userAgentData.getHighEntropyValues(["fullVersionList"]);const dumpObject={getUserMedia:userMediaRequests,PeerConnections:peerConnectionDataStore,UserAgent:navigator.userAgent,UserAgentData:uaData.fullVersionList};const textBlob=new Blob([JSON.stringify(dumpObject,null,1)],{type:"octet/stream"});await this.download("webrtc_internals_dump",textBlob,useCompression)}async onDownloadRtcStats_(){const serializedRtcStats=["RTCStatsDump",JSON.stringify({fileFormat:3})];for(const ev of rtcStatsEvents){serializedRtcStats.push(JSON.stringify(ev))}const rtcStatsBlob=new Blob([serializedRtcStats.join("\n")],{type:"octet/stream"});await this.download("rtcstats_dump",rtcStatsBlob,true)}onAudioDebugRecordingsChanged_(){const checkbox=document.getElementById("audio-recording-checkbox");chrome.send((checkbox.checked?"en":"dis")+"ableAudioDebugRecordings")}onEventLogRecordingsChanged_(){const checkbox=document.getElementById("packet-recording-checkbox");chrome.send((checkbox.checked?"en":"dis")+"ableEventLogRecordings")}onDataChannelRecordingsChanged_(){const checkbox=document.getElementById("datachannel-recording-checkbox");chrome.send((checkbox.checked?"en":"dis")+"ableDataChannelRecordings")}}