// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
export const MAX_STATS_DATA_POINT_BUFFER_SIZE=1e3;export class TimelineDataSeries{constructor(statsType){this.dataPoints_=[];this.color_="red";this.isVisible_=true;this.cacheStartTime_=null;this.cacheStepSize_=0;this.cacheValues_=[];this.statsType_=statsType}toJSON(){if(this.dataPoints_.length<1){return{}}const values=[];for(let i=0;i<this.dataPoints_.length;++i){values.push(this.dataPoints_[i].value)}return{startTime:this.dataPoints_[0].time,endTime:this.dataPoints_[this.dataPoints_.length-1].time,statsType:this.statsType_,values:JSON.stringify(values)}}addPoint(timeTicks,value){const time=new Date(timeTicks);this.dataPoints_.push(new DataPoint(time,value));if(this.dataPoints_.length>MAX_STATS_DATA_POINT_BUFFER_SIZE){this.dataPoints_.shift()}}isVisible(){return this.isVisible_}show(isVisible){this.isVisible_=isVisible}getColor(){return this.color_}setColor(color){this.color_=color}getCount(){return this.dataPoints_.length}getValues(startTime,stepSize,count){if(this.cacheStartTime_===startTime&&this.cacheStepSize_===stepSize&&this.cacheValues_.length===count){return this.cacheValues_}this.cacheValues_=this.getValuesInternal_(startTime,stepSize,count);this.cacheStartTime_=startTime;this.cacheStepSize_=stepSize;return this.cacheValues_}getValuesInternal_(startTime,stepSize,count){const values=[];let nextPoint=0;let time=startTime;let previousValue=0;for(let i=0;i<count;++i){let currentValue=null;let numPoints=0;while(nextPoint<this.dataPoints_.length&&this.dataPoints_[nextPoint].time<time){currentValue+=this.dataPoints_[nextPoint].value;++nextPoint;++numPoints}values[i]=currentValue==null?previousValue:currentValue/numPoints;previousValue=values[i];time+=stepSize}return values}}class DataPoint{constructor(time,value){this.time=time;this.value=value}}