// content/browser/tracing/traces_internals/traces_internals.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_TEST_UTILS_H_
#define CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_TEST_UTILS_H_

#include "content/browser/tracing/traces_internals/traces_internals.mojom.h"


namespace traces_internals::mojom {


class  TracesInternalsHandlerFactoryInterceptorForTesting : public TracesInternalsHandlerFactory {
  virtual TracesInternalsHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
};
class  TracesInternalsHandlerFactoryAsyncWaiter {
 public:
  explicit TracesInternalsHandlerFactoryAsyncWaiter(TracesInternalsHandlerFactory* proxy);

  TracesInternalsHandlerFactoryAsyncWaiter(const TracesInternalsHandlerFactoryAsyncWaiter&) = delete;
  TracesInternalsHandlerFactoryAsyncWaiter& operator=(const TracesInternalsHandlerFactoryAsyncWaiter&) = delete;

  ~TracesInternalsHandlerFactoryAsyncWaiter();

 private:
  TracesInternalsHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void StartTraceSession(::mojo_base::BigBuffer config_pb, bool enable_privacy_filters, StartTraceSessionCallback callback) override;
  void CloneTraceSession(CloneTraceSessionCallback callback) override;
  void StopTraceSession(StopTraceSessionCallback callback) override;
  void GetTrackEventCategories(GetTrackEventCategoriesCallback callback) override;
  void GetBufferUsage(GetBufferUsageCallback callback) override;
  void GetAllTraceReports(GetAllTraceReportsCallback callback) override;
  void DeleteSingleTrace(const ::base::Token& uuid, DeleteSingleTraceCallback callback) override;
  void DeleteAllTraces(DeleteAllTracesCallback callback) override;
  void UserUploadSingleTrace(const ::base::Token& uuid, UserUploadSingleTraceCallback callback) override;
  void DownloadTrace(const ::base::Token& uuid, DownloadTraceCallback callback) override;
  void GetAllScenarios(GetAllScenariosCallback callback) override;
  void SetEnabledScenarios(const std::vector<std::string>& new_config, SetEnabledScenariosCallback callback) override;
  void SetScenariosConfigFromString(const std::string& config_string, SetScenariosConfigFromStringCallback callback) override;
  void SetScenariosConfigFromBuffer(::mojo_base::BigBuffer config_pb, SetScenariosConfigFromBufferCallback callback) override;
  void GetPrivacyFilterEnabled(GetPrivacyFilterEnabledCallback callback) override;
  void SetPrivacyFilterEnabled(bool enable) override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void StartTraceSession(
      ::mojo_base::BigBuffer config_pb, bool enable_privacy_filters, bool* out_success);
  bool StartTraceSession(::mojo_base::BigBuffer config_pb, bool enable_privacy_filters);
  void CloneTraceSession(
      std::optional<::mojo_base::BigBuffer>* out_trace, std::optional<::base::Token>* out_uuid);
  
  void StopTraceSession(
      bool* out_success);
  bool StopTraceSession();
  void GetTrackEventCategories(
      std::vector<TraceCategoryPtr>* out_categories);
  std::vector<TraceCategoryPtr> GetTrackEventCategories();
  void GetBufferUsage(
      bool* out_success, float* out_percent_full, bool* out_data_loss);
  
  void GetAllTraceReports(
      std::vector<ClientTraceReportPtr>* out_reports);
  std::vector<ClientTraceReportPtr> GetAllTraceReports();
  void DeleteSingleTrace(
      const ::base::Token& uuid, bool* out_success);
  bool DeleteSingleTrace(const ::base::Token& uuid);
  void DeleteAllTraces(
      bool* out_success);
  bool DeleteAllTraces();
  void UserUploadSingleTrace(
      const ::base::Token& uuid, bool* out_success);
  bool UserUploadSingleTrace(const ::base::Token& uuid);
  void DownloadTrace(
      const ::base::Token& uuid, std::optional<::mojo_base::BigBuffer>* out_trace);
  std::optional<::mojo_base::BigBuffer> DownloadTrace(const ::base::Token& uuid);
  void GetAllScenarios(
      std::vector<ScenarioPtr>* out_config);
  std::vector<ScenarioPtr> GetAllScenarios();
  void SetEnabledScenarios(
      const std::vector<std::string>& new_config, bool* out_success);
  bool SetEnabledScenarios(const std::vector<std::string>& new_config);
  void SetScenariosConfigFromString(
      const std::string& config_string, bool* out_success);
  bool SetScenariosConfigFromString(const std::string& config_string);
  void SetScenariosConfigFromBuffer(
      ::mojo_base::BigBuffer config_pb, bool* out_success);
  bool SetScenariosConfigFromBuffer(::mojo_base::BigBuffer config_pb);
  void GetPrivacyFilterEnabled(
      bool* out_enabled);
  bool GetPrivacyFilterEnabled();

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void OnTraceComplete(std::optional<::mojo_base::BigBuffer> trace, const std::optional<::base::Token>& uuid) override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // traces_internals::mojom

#endif  // CONTENT_BROWSER_TRACING_TRACES_INTERNALS_TRACES_INTERNALS_MOJOM_TEST_UTILS_H_