// storage/browser/quota/quota_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  OriginSpec as url_mojom_OriginSpec,
  Origin as url_mojom_Origin
} from '//resources/mojo/url/mojom/origin.mojom-webui.js';







export type QuotaInternalsHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<QuotaInternalsHandlerPendingReceiver>;

export class QuotaInternalsHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<QuotaInternalsHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<QuotaInternalsHandlerPendingReceiver>;
  constructor(handle: MojoHandle|QuotaInternalsHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'storage.mojom.QuotaInternalsHandler',
        scope);
  }
}

export interface QuotaInternalsHandlerInterface {
  getDiskAvailabilityAndTempPoolSize(): Promise<{
        totalSpace: bigint,
        availableSpace: bigint,
        tempPoolSize: bigint, }>;
  getStatistics(): Promise<{
        evictionStatistics: {[key: string]: string}, }>;
  simulateStoragePressure(originUrl: url_mojom_Origin): void;
  retrieveBucketsTable(): Promise<{
        entries: BucketTableEntry[], }>;
  getGlobalUsageForInternals(): Promise<{
        usage: bigint,
        unlimitedUsage: bigint, }>;
  isSimulateStoragePressureAvailable(): Promise<{
        available: boolean, }>;
}

export class QuotaInternalsHandlerRemote implements QuotaInternalsHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<QuotaInternalsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<QuotaInternalsHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|QuotaInternalsHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          QuotaInternalsHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getDiskAvailabilityAndTempPoolSize(): Promise<{
        totalSpace: bigint,
        availableSpace: bigint,
        tempPoolSize: bigint, }> {
    return this.proxy.sendMessage(
        0,
        QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsSpec.$,
        QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getStatistics(): Promise<{
        evictionStatistics: {[key: string]: string}, }> {
    return this.proxy.sendMessage(
        1,
        QuotaInternalsHandler_GetStatistics_ParamsSpec.$,
        QuotaInternalsHandler_GetStatistics_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  simulateStoragePressure(
      originUrl: url_mojom_Origin): void {
    this.proxy.sendMessage(
        2,
        QuotaInternalsHandler_SimulateStoragePressure_ParamsSpec.$,
        null,
        [
          originUrl
        ],
        false);
  }

  retrieveBucketsTable(): Promise<{
        entries: BucketTableEntry[], }> {
    return this.proxy.sendMessage(
        3,
        QuotaInternalsHandler_RetrieveBucketsTable_ParamsSpec.$,
        QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getGlobalUsageForInternals(): Promise<{
        usage: bigint,
        unlimitedUsage: bigint, }> {
    return this.proxy.sendMessage(
        4,
        QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsSpec.$,
        QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  isSimulateStoragePressureAvailable(): Promise<{
        available: boolean, }> {
    return this.proxy.sendMessage(
        5,
        QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsSpec.$,
        QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the QuotaInternalsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class QuotaInternalsHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    QuotaInternalsHandlerRemote, QuotaInternalsHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    QuotaInternalsHandlerRemote, QuotaInternalsHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: QuotaInternalsHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        QuotaInternalsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsSpec.$,
        QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsSpec.$,
        impl.getDiskAvailabilityAndTempPoolSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        QuotaInternalsHandler_GetStatistics_ParamsSpec.$,
        QuotaInternalsHandler_GetStatistics_ResponseParamsSpec.$,
        impl.getStatistics.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        QuotaInternalsHandler_SimulateStoragePressure_ParamsSpec.$,
        null,
        impl.simulateStoragePressure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        QuotaInternalsHandler_RetrieveBucketsTable_ParamsSpec.$,
        QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsSpec.$,
        impl.retrieveBucketsTable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsSpec.$,
        QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsSpec.$,
        impl.getGlobalUsageForInternals.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsSpec.$,
        QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsSpec.$,
        impl.isSimulateStoragePressureAvailable.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class QuotaInternalsHandler {
  static get $interfaceName(): string {
    return "storage.mojom.QuotaInternalsHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): QuotaInternalsHandlerRemote {
    let remote = new QuotaInternalsHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the QuotaInternalsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class QuotaInternalsHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    QuotaInternalsHandlerRemote, QuotaInternalsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    QuotaInternalsHandlerRemote, QuotaInternalsHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getDiskAvailabilityAndTempPoolSize: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getStatistics: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  simulateStoragePressure: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  retrieveBucketsTable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getGlobalUsageForInternals: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isSimulateStoragePressureAvailable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      QuotaInternalsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getDiskAvailabilityAndTempPoolSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsSpec.$,
        QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsSpec.$,
        this.getDiskAvailabilityAndTempPoolSize.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getStatistics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        QuotaInternalsHandler_GetStatistics_ParamsSpec.$,
        QuotaInternalsHandler_GetStatistics_ResponseParamsSpec.$,
        this.getStatistics.createReceiverHandler(true /* expectsResponse */),
        false);
    this.simulateStoragePressure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        QuotaInternalsHandler_SimulateStoragePressure_ParamsSpec.$,
        null,
        this.simulateStoragePressure.createReceiverHandler(false /* expectsResponse */),
        false);
    this.retrieveBucketsTable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        QuotaInternalsHandler_RetrieveBucketsTable_ParamsSpec.$,
        QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsSpec.$,
        this.retrieveBucketsTable.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getGlobalUsageForInternals =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsSpec.$,
        QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsSpec.$,
        this.getGlobalUsageForInternals.createReceiverHandler(true /* expectsResponse */),
        false);
    this.isSimulateStoragePressureAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsSpec.$,
        QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsSpec.$,
        this.isSimulateStoragePressureAvailable.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const BucketTableEntrySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_GetStatistics_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_GetStatistics_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_SimulateStoragePressure_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_RetrieveBucketsTable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface BucketTableEntryMojoType {
  bucketId: bigint;
  storageKey: string;
  name: string;
  usage: bigint;
  useCount: bigint;
  lastAccessed: mojoBase_mojom_Time;
  lastModified: mojoBase_mojom_Time;
}


export type BucketTableEntry = BucketTableEntryMojoType;
mojo.internal.Struct<BucketTableEntryMojoType>(
    BucketTableEntrySpec.$,
    'BucketTableEntry',
    [
      mojo.internal.StructField<BucketTableEntryMojoType, bigint>(
        'bucketId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BucketTableEntryMojoType, string>(
        'storageKey', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BucketTableEntryMojoType, string>(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BucketTableEntryMojoType, bigint>(
        'usage', 24,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BucketTableEntryMojoType, bigint>(
        'useCount', 32,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BucketTableEntryMojoType, mojoBase_mojom_Time>(
        'lastAccessed', 40,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BucketTableEntryMojoType, mojoBase_mojom_Time>(
        'lastModified', 48,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);





export interface QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsMojoType {
}


export type QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params = QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsMojoType>(
    QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsSpec.$,
    'QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params',
    [
    ],
    [[0, 8],]);





export interface QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsMojoType {
  totalSpace: bigint;
  availableSpace: bigint;
  tempPoolSize: bigint;
}


export type QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams = QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsMojoType>(
    QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsSpec.$,
    'QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams',
    [
      mojo.internal.StructField<QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsMojoType, bigint>(
        'totalSpace', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsMojoType, bigint>(
        'availableSpace', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsMojoType, bigint>(
        'tempPoolSize', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface QuotaInternalsHandler_GetStatistics_ParamsMojoType {
}


export type QuotaInternalsHandler_GetStatistics_Params = QuotaInternalsHandler_GetStatistics_ParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_GetStatistics_ParamsMojoType>(
    QuotaInternalsHandler_GetStatistics_ParamsSpec.$,
    'QuotaInternalsHandler_GetStatistics_Params',
    [
    ],
    [[0, 8],]);





export interface QuotaInternalsHandler_GetStatistics_ResponseParamsMojoType {
  evictionStatistics: {[key: string]: string};
}


export type QuotaInternalsHandler_GetStatistics_ResponseParams = QuotaInternalsHandler_GetStatistics_ResponseParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_GetStatistics_ResponseParamsMojoType>(
    QuotaInternalsHandler_GetStatistics_ResponseParamsSpec.$,
    'QuotaInternalsHandler_GetStatistics_ResponseParams',
    [
      mojo.internal.StructField<QuotaInternalsHandler_GetStatistics_ResponseParamsMojoType, {[key: string]: string}>(
        'evictionStatistics', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface QuotaInternalsHandler_SimulateStoragePressure_ParamsMojoType {
  originUrl: url_mojom_Origin;
}


export type QuotaInternalsHandler_SimulateStoragePressure_Params = QuotaInternalsHandler_SimulateStoragePressure_ParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_SimulateStoragePressure_ParamsMojoType>(
    QuotaInternalsHandler_SimulateStoragePressure_ParamsSpec.$,
    'QuotaInternalsHandler_SimulateStoragePressure_Params',
    [
      mojo.internal.StructField<QuotaInternalsHandler_SimulateStoragePressure_ParamsMojoType, url_mojom_Origin>(
        'originUrl', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface QuotaInternalsHandler_RetrieveBucketsTable_ParamsMojoType {
}


export type QuotaInternalsHandler_RetrieveBucketsTable_Params = QuotaInternalsHandler_RetrieveBucketsTable_ParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_RetrieveBucketsTable_ParamsMojoType>(
    QuotaInternalsHandler_RetrieveBucketsTable_ParamsSpec.$,
    'QuotaInternalsHandler_RetrieveBucketsTable_Params',
    [
    ],
    [[0, 8],]);





export interface QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsMojoType {
  entries: BucketTableEntry[];
}


export type QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams = QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsMojoType>(
    QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsSpec.$,
    'QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams',
    [
      mojo.internal.StructField<QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsMojoType, BucketTableEntry[]>(
        'entries', 0,
        0,
        mojo.internal.Array(BucketTableEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsMojoType {
}


export type QuotaInternalsHandler_GetGlobalUsageForInternals_Params = QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsMojoType>(
    QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsSpec.$,
    'QuotaInternalsHandler_GetGlobalUsageForInternals_Params',
    [
    ],
    [[0, 8],]);





export interface QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsMojoType {
  usage: bigint;
  unlimitedUsage: bigint;
}


export type QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams = QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsMojoType>(
    QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsSpec.$,
    'QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams',
    [
      mojo.internal.StructField<QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsMojoType, bigint>(
        'usage', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsMojoType, bigint>(
        'unlimitedUsage', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsMojoType {
}


export type QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params = QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsMojoType>(
    QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsSpec.$,
    'QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params',
    [
    ],
    [[0, 8],]);





export interface QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsMojoType {
  available: boolean;
}


export type QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams = QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsMojoType;
mojo.internal.Struct<QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsMojoType>(
    QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsSpec.$,
    'QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams',
    [
      mojo.internal.StructField<QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsMojoType, boolean>(
        'available', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



