// content/browser/indexed_db/indexed_db_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_H_
#define CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/indexed_db/indexed_db_internals.mojom-features.h"  // IWYU pragma: export
#include "content/browser/indexed_db/indexed_db_internals.mojom-shared.h"  // IWYU pragma: export
#include "content/browser/indexed_db/indexed_db_internals.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom.h"
#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom.h"
#include "components/services/storage/public/mojom/buckets/bucket_id.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace storage::mojom {

class IdbInternalsHandlerProxy;

template <typename ImplRefTraits>
class IdbInternalsHandlerStub;

class IdbInternalsHandlerRequestValidator;
class IdbInternalsHandlerResponseValidator;


class IdbInternalsHandler
    : public IdbInternalsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.IdbInternalsHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IdbInternalsHandlerInterfaceBase;
  using Proxy_ = IdbInternalsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = IdbInternalsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = IdbInternalsHandlerRequestValidator;
  using ResponseValidator_ = IdbInternalsHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAllBucketsAcrossAllStorageKeysMinVersion = 0,
    kDownloadBucketDataMinVersion = 0,
    kForceCloseMinVersion = 0,
    kStartMetadataRecordingMinVersion = 0,
    kStopMetadataRecordingMinVersion = 0,
    kInspectClientMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAllBucketsAcrossAllStorageKeys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DownloadBucketData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForceClose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartMetadataRecording_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopMetadataRecording_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InspectClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IdbInternalsHandler() = default;

  using GetAllBucketsAcrossAllStorageKeysCallback = base::OnceCallback<void(const std::optional<std::string>&, std::vector<IdbPartitionMetadataPtr>)>;
  using GetAllBucketsAcrossAllStorageKeysMojoCallback = base::OnceCallback<void(const std::optional<std::string>&, std::vector<IdbPartitionMetadataPtr>)>;

  virtual void GetAllBucketsAcrossAllStorageKeys(GetAllBucketsAcrossAllStorageKeysCallback callback) = 0;

  using DownloadBucketDataCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using DownloadBucketDataMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void DownloadBucketData(::storage::BucketId bucketId, DownloadBucketDataCallback callback) = 0;

  using ForceCloseCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using ForceCloseMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void ForceClose(::storage::BucketId bucketId, ForceCloseCallback callback) = 0;

  using StartMetadataRecordingCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using StartMetadataRecordingMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void StartMetadataRecording(::storage::BucketId bucket_id, StartMetadataRecordingCallback callback) = 0;

  using StopMetadataRecordingCallback = base::OnceCallback<void(const std::optional<std::string>&, std::vector<::storage::mojom::IdbBucketMetadataPtr>)>;
  using StopMetadataRecordingMojoCallback = base::OnceCallback<void(const std::optional<std::string>&, std::vector<::storage::mojom::IdbBucketMetadataPtr>)>;

  virtual void StopMetadataRecording(::storage::BucketId bucket_id, StopMetadataRecordingCallback callback) = 0;

  using InspectClientCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using InspectClientMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void InspectClient(const ::storage::BucketClientInfo& client_info, InspectClientCallback callback) = 0;
};



class  IdbInternalsHandlerProxy
    : public IdbInternalsHandler {
 public:
  using InterfaceType = IdbInternalsHandler;

  explicit IdbInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAllBucketsAcrossAllStorageKeys(GetAllBucketsAcrossAllStorageKeysCallback callback) final;
  
  void DownloadBucketData(::storage::BucketId bucketId, DownloadBucketDataCallback callback) final;
  
  void ForceClose(::storage::BucketId bucketId, ForceCloseCallback callback) final;
  
  void StartMetadataRecording(::storage::BucketId bucket_id, StartMetadataRecordingCallback callback) final;
  
  void StopMetadataRecording(::storage::BucketId bucket_id, StopMetadataRecordingCallback callback) final;
  
  void InspectClient(const ::storage::BucketClientInfo& client_info, InspectClientCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  IdbInternalsHandlerStubDispatch {
 public:
  static bool Accept(IdbInternalsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IdbInternalsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IdbInternalsHandler>>
class IdbInternalsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IdbInternalsHandlerStub() = default;
  ~IdbInternalsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IdbInternalsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IdbInternalsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  IdbInternalsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  IdbInternalsHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  IdbPartitionMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdbPartitionMetadata, T>::value>;
  using DataView = IdbPartitionMetadataDataView;
  using Data_ = internal::IdbPartitionMetadata_Data;

  template <typename... Args>
  static IdbPartitionMetadataPtr New(Args&&... args) {
    return IdbPartitionMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdbPartitionMetadataPtr From(const U& u) {
    return mojo::TypeConverter<IdbPartitionMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdbPartitionMetadata>::Convert(*this);
  }


  IdbPartitionMetadata();

  IdbPartitionMetadata(
      const ::base::FilePath& partition_path,
      std::vector<::storage::mojom::IdbOriginMetadataPtr> origin_list);

IdbPartitionMetadata(const IdbPartitionMetadata&) = delete;
IdbPartitionMetadata& operator=(const IdbPartitionMetadata&) = delete;

  ~IdbPartitionMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdbPartitionMetadataPtr>
  IdbPartitionMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdbPartitionMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdbPartitionMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdbPartitionMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbPartitionMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbPartitionMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdbPartitionMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdbPartitionMetadata_UnserializedMessageContext<
            UserType, IdbPartitionMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdbPartitionMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdbPartitionMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdbPartitionMetadata_UnserializedMessageContext<
            UserType, IdbPartitionMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdbPartitionMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath partition_path;
  
  std::vector<::storage::mojom::IdbOriginMetadataPtr> origin_list;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdbPartitionMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdbPartitionMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdbPartitionMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdbPartitionMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IdbPartitionMetadataPtr IdbPartitionMetadata::Clone() const {
  return New(
      mojo::Clone(partition_path),
      mojo::Clone(origin_list)
  );
}

template <typename T, IdbPartitionMetadata::EnableIfSame<T>*>
bool IdbPartitionMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->partition_path, other_struct.partition_path))
    return false;
  if (!mojo::Equals(this->origin_list, other_struct.origin_list))
    return false;
  return true;
}

template <typename T, IdbPartitionMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.partition_path < rhs.partition_path)
    return true;
  if (rhs.partition_path < lhs.partition_path)
    return false;
  if (lhs.origin_list < rhs.origin_list)
    return true;
  if (rhs.origin_list < lhs.origin_list)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::IdbPartitionMetadata::DataView,
                                         ::storage::mojom::IdbPartitionMetadataPtr> {
  static bool IsNull(const ::storage::mojom::IdbPartitionMetadataPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::IdbPartitionMetadataPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::IdbPartitionMetadata::partition_path)& partition_path(
      const ::storage::mojom::IdbPartitionMetadataPtr& input) {
    return input->partition_path;
  }

  static const decltype(::storage::mojom::IdbPartitionMetadata::origin_list)& origin_list(
      const ::storage::mojom::IdbPartitionMetadataPtr& input) {
    return input->origin_list;
  }

  static bool Read(::storage::mojom::IdbPartitionMetadata::DataView input, ::storage::mojom::IdbPartitionMetadataPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_H_