// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/runtime.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace Runtime {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Runtime";
const char Metainfo::commandPrefix[] = "Runtime.";
const char Metainfo::version[] = "1.3";



const char* DeepSerializedValue::TypeEnum::Undefined = "undefined";
const char* DeepSerializedValue::TypeEnum::Null = "null";
const char* DeepSerializedValue::TypeEnum::String = "string";
const char* DeepSerializedValue::TypeEnum::Number = "number";
const char* DeepSerializedValue::TypeEnum::Boolean = "boolean";
const char* DeepSerializedValue::TypeEnum::Bigint = "bigint";
const char* DeepSerializedValue::TypeEnum::Regexp = "regexp";
const char* DeepSerializedValue::TypeEnum::Date = "date";
const char* DeepSerializedValue::TypeEnum::Symbol = "symbol";
const char* DeepSerializedValue::TypeEnum::Array = "array";
const char* DeepSerializedValue::TypeEnum::Object = "object";
const char* DeepSerializedValue::TypeEnum::Function = "function";
const char* DeepSerializedValue::TypeEnum::Map = "map";
const char* DeepSerializedValue::TypeEnum::Set = "set";
const char* DeepSerializedValue::TypeEnum::Weakmap = "weakmap";
const char* DeepSerializedValue::TypeEnum::Weakset = "weakset";
const char* DeepSerializedValue::TypeEnum::Error = "error";
const char* DeepSerializedValue::TypeEnum::Proxy = "proxy";
const char* DeepSerializedValue::TypeEnum::Promise = "promise";
const char* DeepSerializedValue::TypeEnum::Typedarray = "typedarray";
const char* DeepSerializedValue::TypeEnum::Arraybuffer = "arraybuffer";
const char* DeepSerializedValue::TypeEnum::Node = "node";
const char* DeepSerializedValue::TypeEnum::Window = "window";
const char* DeepSerializedValue::TypeEnum::Generator = "generator";
CRDTP_BEGIN_DESERIALIZER(DeepSerializedValue)
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", m_objectId),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
    CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
    CRDTP_DESERIALIZE_FIELD_OPT("weakLocalObjectReference", m_weakLocalObjectReference),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DeepSerializedValue)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("objectId", m_objectId);
    CRDTP_SERIALIZE_FIELD("weakLocalObjectReference", m_weakLocalObjectReference);
CRDTP_END_SERIALIZER();





const char* RemoteObject::TypeEnum::Object = "object";
const char* RemoteObject::TypeEnum::Function = "function";
const char* RemoteObject::TypeEnum::Undefined = "undefined";
const char* RemoteObject::TypeEnum::String = "string";
const char* RemoteObject::TypeEnum::Number = "number";
const char* RemoteObject::TypeEnum::Boolean = "boolean";
const char* RemoteObject::TypeEnum::Symbol = "symbol";
const char* RemoteObject::TypeEnum::Bigint = "bigint";

const char* RemoteObject::SubtypeEnum::Array = "array";
const char* RemoteObject::SubtypeEnum::Null = "null";
const char* RemoteObject::SubtypeEnum::Node = "node";
const char* RemoteObject::SubtypeEnum::Regexp = "regexp";
const char* RemoteObject::SubtypeEnum::Date = "date";
const char* RemoteObject::SubtypeEnum::Map = "map";
const char* RemoteObject::SubtypeEnum::Set = "set";
const char* RemoteObject::SubtypeEnum::Weakmap = "weakmap";
const char* RemoteObject::SubtypeEnum::Weakset = "weakset";
const char* RemoteObject::SubtypeEnum::Iterator = "iterator";
const char* RemoteObject::SubtypeEnum::Generator = "generator";
const char* RemoteObject::SubtypeEnum::Error = "error";
const char* RemoteObject::SubtypeEnum::Proxy = "proxy";
const char* RemoteObject::SubtypeEnum::Promise = "promise";
const char* RemoteObject::SubtypeEnum::Typedarray = "typedarray";
const char* RemoteObject::SubtypeEnum::Arraybuffer = "arraybuffer";
const char* RemoteObject::SubtypeEnum::Dataview = "dataview";
const char* RemoteObject::SubtypeEnum::Webassemblymemory = "webassemblymemory";
const char* RemoteObject::SubtypeEnum::Wasmvalue = "wasmvalue";
const char* RemoteObject::SubtypeEnum::Trustedtype = "trustedtype";
CRDTP_BEGIN_DESERIALIZER(RemoteObject)
    CRDTP_DESERIALIZE_FIELD_OPT("className", m_className),
    CRDTP_DESERIALIZE_FIELD_OPT("customPreview", m_customPreview),
    CRDTP_DESERIALIZE_FIELD_OPT("deepSerializedValue", m_deepSerializedValue),
    CRDTP_DESERIALIZE_FIELD_OPT("description", m_description),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", m_objectId),
    CRDTP_DESERIALIZE_FIELD_OPT("preview", m_preview),
    CRDTP_DESERIALIZE_FIELD_OPT("subtype", m_subtype),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
    CRDTP_DESERIALIZE_FIELD_OPT("unserializableValue", m_unserializableValue),
    CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RemoteObject)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("subtype", m_subtype);
    CRDTP_SERIALIZE_FIELD("className", m_className);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("unserializableValue", m_unserializableValue);
    CRDTP_SERIALIZE_FIELD("description", m_description);
    CRDTP_SERIALIZE_FIELD("deepSerializedValue", m_deepSerializedValue);
    CRDTP_SERIALIZE_FIELD("objectId", m_objectId);
    CRDTP_SERIALIZE_FIELD("preview", m_preview);
    CRDTP_SERIALIZE_FIELD("customPreview", m_customPreview);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CustomPreview)
    CRDTP_DESERIALIZE_FIELD_OPT("bodyGetterId", m_bodyGetterId),
    CRDTP_DESERIALIZE_FIELD("header", m_header),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CustomPreview)
    CRDTP_SERIALIZE_FIELD("header", m_header);
    CRDTP_SERIALIZE_FIELD("bodyGetterId", m_bodyGetterId);
CRDTP_END_SERIALIZER();



const char* ObjectPreview::TypeEnum::Object = "object";
const char* ObjectPreview::TypeEnum::Function = "function";
const char* ObjectPreview::TypeEnum::Undefined = "undefined";
const char* ObjectPreview::TypeEnum::String = "string";
const char* ObjectPreview::TypeEnum::Number = "number";
const char* ObjectPreview::TypeEnum::Boolean = "boolean";
const char* ObjectPreview::TypeEnum::Symbol = "symbol";
const char* ObjectPreview::TypeEnum::Bigint = "bigint";

const char* ObjectPreview::SubtypeEnum::Array = "array";
const char* ObjectPreview::SubtypeEnum::Null = "null";
const char* ObjectPreview::SubtypeEnum::Node = "node";
const char* ObjectPreview::SubtypeEnum::Regexp = "regexp";
const char* ObjectPreview::SubtypeEnum::Date = "date";
const char* ObjectPreview::SubtypeEnum::Map = "map";
const char* ObjectPreview::SubtypeEnum::Set = "set";
const char* ObjectPreview::SubtypeEnum::Weakmap = "weakmap";
const char* ObjectPreview::SubtypeEnum::Weakset = "weakset";
const char* ObjectPreview::SubtypeEnum::Iterator = "iterator";
const char* ObjectPreview::SubtypeEnum::Generator = "generator";
const char* ObjectPreview::SubtypeEnum::Error = "error";
const char* ObjectPreview::SubtypeEnum::Proxy = "proxy";
const char* ObjectPreview::SubtypeEnum::Promise = "promise";
const char* ObjectPreview::SubtypeEnum::Typedarray = "typedarray";
const char* ObjectPreview::SubtypeEnum::Arraybuffer = "arraybuffer";
const char* ObjectPreview::SubtypeEnum::Dataview = "dataview";
const char* ObjectPreview::SubtypeEnum::Webassemblymemory = "webassemblymemory";
const char* ObjectPreview::SubtypeEnum::Wasmvalue = "wasmvalue";
const char* ObjectPreview::SubtypeEnum::Trustedtype = "trustedtype";
CRDTP_BEGIN_DESERIALIZER(ObjectPreview)
    CRDTP_DESERIALIZE_FIELD_OPT("description", m_description),
    CRDTP_DESERIALIZE_FIELD_OPT("entries", m_entries),
    CRDTP_DESERIALIZE_FIELD("overflow", m_overflow),
    CRDTP_DESERIALIZE_FIELD("properties", m_properties),
    CRDTP_DESERIALIZE_FIELD_OPT("subtype", m_subtype),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ObjectPreview)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("subtype", m_subtype);
    CRDTP_SERIALIZE_FIELD("description", m_description);
    CRDTP_SERIALIZE_FIELD("overflow", m_overflow);
    CRDTP_SERIALIZE_FIELD("properties", m_properties);
    CRDTP_SERIALIZE_FIELD("entries", m_entries);
CRDTP_END_SERIALIZER();



const char* PropertyPreview::TypeEnum::Object = "object";
const char* PropertyPreview::TypeEnum::Function = "function";
const char* PropertyPreview::TypeEnum::Undefined = "undefined";
const char* PropertyPreview::TypeEnum::String = "string";
const char* PropertyPreview::TypeEnum::Number = "number";
const char* PropertyPreview::TypeEnum::Boolean = "boolean";
const char* PropertyPreview::TypeEnum::Symbol = "symbol";
const char* PropertyPreview::TypeEnum::Accessor = "accessor";
const char* PropertyPreview::TypeEnum::Bigint = "bigint";

const char* PropertyPreview::SubtypeEnum::Array = "array";
const char* PropertyPreview::SubtypeEnum::Null = "null";
const char* PropertyPreview::SubtypeEnum::Node = "node";
const char* PropertyPreview::SubtypeEnum::Regexp = "regexp";
const char* PropertyPreview::SubtypeEnum::Date = "date";
const char* PropertyPreview::SubtypeEnum::Map = "map";
const char* PropertyPreview::SubtypeEnum::Set = "set";
const char* PropertyPreview::SubtypeEnum::Weakmap = "weakmap";
const char* PropertyPreview::SubtypeEnum::Weakset = "weakset";
const char* PropertyPreview::SubtypeEnum::Iterator = "iterator";
const char* PropertyPreview::SubtypeEnum::Generator = "generator";
const char* PropertyPreview::SubtypeEnum::Error = "error";
const char* PropertyPreview::SubtypeEnum::Proxy = "proxy";
const char* PropertyPreview::SubtypeEnum::Promise = "promise";
const char* PropertyPreview::SubtypeEnum::Typedarray = "typedarray";
const char* PropertyPreview::SubtypeEnum::Arraybuffer = "arraybuffer";
const char* PropertyPreview::SubtypeEnum::Dataview = "dataview";
const char* PropertyPreview::SubtypeEnum::Webassemblymemory = "webassemblymemory";
const char* PropertyPreview::SubtypeEnum::Wasmvalue = "wasmvalue";
const char* PropertyPreview::SubtypeEnum::Trustedtype = "trustedtype";
CRDTP_BEGIN_DESERIALIZER(PropertyPreview)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD_OPT("subtype", m_subtype),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
    CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
    CRDTP_DESERIALIZE_FIELD_OPT("valuePreview", m_valuePreview),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PropertyPreview)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("valuePreview", m_valuePreview);
    CRDTP_SERIALIZE_FIELD("subtype", m_subtype);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(EntryPreview)
    CRDTP_DESERIALIZE_FIELD_OPT("key", m_key),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(EntryPreview)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();



CRDTP_BEGIN_DESERIALIZER(CallFrame)
    CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    CRDTP_DESERIALIZE_FIELD("functionName", m_functionName),
    CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    CRDTP_DESERIALIZE_FIELD("scriptId", m_scriptId),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CallFrame)
    CRDTP_SERIALIZE_FIELD("functionName", m_functionName);
    CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(StackTrace)
    CRDTP_DESERIALIZE_FIELD("callFrames", m_callFrames),
    CRDTP_DESERIALIZE_FIELD_OPT("description", m_description),
    CRDTP_DESERIALIZE_FIELD_OPT("parent", m_parent),
    CRDTP_DESERIALIZE_FIELD_OPT("parentId", m_parentId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(StackTrace)
    CRDTP_SERIALIZE_FIELD("description", m_description);
    CRDTP_SERIALIZE_FIELD("callFrames", m_callFrames);
    CRDTP_SERIALIZE_FIELD("parent", m_parent);
    CRDTP_SERIALIZE_FIELD("parentId", m_parentId);
CRDTP_END_SERIALIZER();



CRDTP_BEGIN_DESERIALIZER(StackTraceId)
    CRDTP_DESERIALIZE_FIELD_OPT("debuggerId", m_debuggerId),
    CRDTP_DESERIALIZE_FIELD("id", m_id),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(StackTraceId)
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("debuggerId", m_debuggerId);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace ConsoleAPICalled {
namespace TypeEnum {
const char* Log = "log";
const char* Debug = "debug";
const char* Info = "info";
const char* Error = "error";
const char* Warning = "warning";
const char* Dir = "dir";
const char* Dirxml = "dirxml";
const char* Table = "table";
const char* Trace = "trace";
const char* Clear = "clear";
const char* StartGroup = "startGroup";
const char* StartGroupCollapsed = "startGroupCollapsed";
const char* EndGroup = "endGroup";
const char* Assert = "assert";
const char* Profile = "profile";
const char* ProfileEnd = "profileEnd";
const char* Count = "count";
const char* TimeEnd = "timeEnd";
} // namespace TypeEnum
} // namespace ConsoleAPICalled

// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
          { crdtp::SpanFrom("Runtime.setAsyncCallStackDepth"), crdtp::SpanFrom("Debugger.setAsyncCallStackDepth") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Runtime"), SortedRedirects(), std::move(dispatcher));
}

} // Runtime
} // namespace content
} // namespace protocol
