// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Input_h
#define content_protocol_Input_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace Input {
class TouchPoint;
using GestureSourceType = String;
using MouseButton = String;
using TimeSinceEpoch = double;
class DragDataItem;
class DragData;

// ------------- Forward and enum declarations.

namespace GestureSourceTypeEnum {
CONTENT_EXPORT extern const char Default[];
CONTENT_EXPORT extern const char Touch[];
CONTENT_EXPORT extern const char Mouse[];
} // namespace GestureSourceTypeEnum

namespace MouseButtonEnum {
CONTENT_EXPORT extern const char None[];
CONTENT_EXPORT extern const char Left[];
CONTENT_EXPORT extern const char Middle[];
CONTENT_EXPORT extern const char Right[];
CONTENT_EXPORT extern const char Back[];
CONTENT_EXPORT extern const char Forward[];
} // namespace MouseButtonEnum

namespace DispatchDragEvent {
namespace TypeEnum {
CONTENT_EXPORT extern const char* DragEnter;
CONTENT_EXPORT extern const char* DragOver;
CONTENT_EXPORT extern const char* Drop;
CONTENT_EXPORT extern const char* DragCancel;
} // TypeEnum
} // DispatchDragEvent

namespace DispatchKeyEvent {
namespace TypeEnum {
CONTENT_EXPORT extern const char* KeyDown;
CONTENT_EXPORT extern const char* KeyUp;
CONTENT_EXPORT extern const char* RawKeyDown;
CONTENT_EXPORT extern const char* Char;
} // TypeEnum
} // DispatchKeyEvent

namespace DispatchMouseEvent {
namespace TypeEnum {
CONTENT_EXPORT extern const char* MousePressed;
CONTENT_EXPORT extern const char* MouseReleased;
CONTENT_EXPORT extern const char* MouseMoved;
CONTENT_EXPORT extern const char* MouseWheel;
} // TypeEnum
} // DispatchMouseEvent

namespace DispatchMouseEvent {
namespace PointerTypeEnum {
CONTENT_EXPORT extern const char* Mouse;
CONTENT_EXPORT extern const char* Pen;
} // PointerTypeEnum
} // DispatchMouseEvent

namespace DispatchTouchEvent {
namespace TypeEnum {
CONTENT_EXPORT extern const char* TouchStart;
CONTENT_EXPORT extern const char* TouchEnd;
CONTENT_EXPORT extern const char* TouchMove;
CONTENT_EXPORT extern const char* TouchCancel;
} // TypeEnum
} // DispatchTouchEvent

namespace EmulateTouchFromMouseEvent {
namespace TypeEnum {
CONTENT_EXPORT extern const char* MousePressed;
CONTENT_EXPORT extern const char* MouseReleased;
CONTENT_EXPORT extern const char* MouseMoved;
CONTENT_EXPORT extern const char* MouseWheel;
} // TypeEnum
} // EmulateTouchFromMouseEvent

// ------------- Type and builder declarations.

class CONTENT_EXPORT TouchPoint : public ::crdtp::ProtocolObject<TouchPoint> {
public:
    ~TouchPoint() override;  // Defined below

    double GetX() { return m_x; }
    void SetX(double value);  // Defined below

    double GetY() { return m_y; }
    void SetY(double value);  // Defined below

    bool HasRadiusX() { return !!m_radiusX; }
    double GetRadiusX(double defaultValue) const {
       return m_radiusX.value_or(defaultValue);
    }
    const std::optional<double>& GetRadiusX() const {
       return m_radiusX;
    }
    void SetRadiusX(double value);  // Defined below

    bool HasRadiusY() { return !!m_radiusY; }
    double GetRadiusY(double defaultValue) const {
       return m_radiusY.value_or(defaultValue);
    }
    const std::optional<double>& GetRadiusY() const {
       return m_radiusY;
    }
    void SetRadiusY(double value);  // Defined below

    bool HasRotationAngle() { return !!m_rotationAngle; }
    double GetRotationAngle(double defaultValue) const {
       return m_rotationAngle.value_or(defaultValue);
    }
    const std::optional<double>& GetRotationAngle() const {
       return m_rotationAngle;
    }
    void SetRotationAngle(double value);  // Defined below

    bool HasForce() { return !!m_force; }
    double GetForce(double defaultValue) const {
       return m_force.value_or(defaultValue);
    }
    const std::optional<double>& GetForce() const {
       return m_force;
    }
    void SetForce(double value);  // Defined below

    bool HasTangentialPressure() { return !!m_tangentialPressure; }
    double GetTangentialPressure(double defaultValue) const {
       return m_tangentialPressure.value_or(defaultValue);
    }
    const std::optional<double>& GetTangentialPressure() const {
       return m_tangentialPressure;
    }
    void SetTangentialPressure(double value);  // Defined below

    bool HasTiltX() { return !!m_tiltX; }
    double GetTiltX(double defaultValue) const {
       return m_tiltX.value_or(defaultValue);
    }
    const std::optional<double>& GetTiltX() const {
       return m_tiltX;
    }
    void SetTiltX(double value);  // Defined below

    bool HasTiltY() { return !!m_tiltY; }
    double GetTiltY(double defaultValue) const {
       return m_tiltY.value_or(defaultValue);
    }
    const std::optional<double>& GetTiltY() const {
       return m_tiltY;
    }
    void SetTiltY(double value);  // Defined below

    bool HasTwist() { return !!m_twist; }
    int GetTwist(int defaultValue) const {
       return m_twist.value_or(defaultValue);
    }
    const std::optional<int>& GetTwist() const {
       return m_twist;
    }
    void SetTwist(int value);  // Defined below

    bool HasId() { return !!m_id; }
    double GetId(double defaultValue) const {
       return m_id.value_or(defaultValue);
    }
    const std::optional<double>& GetId() const {
       return m_id;
    }
    void SetId(double value);  // Defined below

    template<int STATE>
    class TouchPointBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            XSet = 1 << 1,
            YSet = 1 << 2,
            AllFieldsSet = (XSet | YSet | 0)};


        TouchPointBuilder<STATE | XSet>& SetX(double value);  // Defined below

        TouchPointBuilder<STATE | YSet>& SetY(double value);  // Defined below

        TouchPointBuilder<STATE>& SetRadiusX(double value);  // Defined below

        TouchPointBuilder<STATE>& SetRadiusY(double value);  // Defined below

        TouchPointBuilder<STATE>& SetRotationAngle(double value);  // Defined below

        TouchPointBuilder<STATE>& SetForce(double value);  // Defined below

        TouchPointBuilder<STATE>& SetTangentialPressure(double value);  // Defined below

        TouchPointBuilder<STATE>& SetTiltX(double value);  // Defined below

        TouchPointBuilder<STATE>& SetTiltY(double value);  // Defined below

        TouchPointBuilder<STATE>& SetTwist(int value);  // Defined below

        TouchPointBuilder<STATE>& SetId(double value);  // Defined below

        std::unique_ptr<TouchPoint> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TouchPoint;
        TouchPointBuilder() : m_result(new TouchPoint()) { }

        template<int STEP> TouchPointBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TouchPointBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Input::TouchPoint> m_result;
    };

    static TouchPointBuilder<0> Create()
    {
        return TouchPointBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TouchPoint();  // Defined below

    double m_x;
    double m_y;
    std::optional<double> m_radiusX;
    std::optional<double> m_radiusY;
    std::optional<double> m_rotationAngle;
    std::optional<double> m_force;
    std::optional<double> m_tangentialPressure;
    std::optional<double> m_tiltX;
    std::optional<double> m_tiltY;
    std::optional<int> m_twist;
    std::optional<double> m_id;
};


class CONTENT_EXPORT DragDataItem : public ::crdtp::ProtocolObject<DragDataItem> {
public:
    ~DragDataItem() override;  // Defined below

    String GetMimeType() { return m_mimeType; }
    void SetMimeType(const String& value);  // Defined below

    String GetData() { return m_data; }
    void SetData(const String& value);  // Defined below

    bool HasTitle() { return !!m_title; }
    String GetTitle(const String& defaultValue) const {
       return m_title.value_or(defaultValue);
    }
    const std::optional<String>& GetTitle() const {
       return m_title;
    }
    void SetTitle(const String& value);  // Defined below

    bool HasBaseURL() { return !!m_baseURL; }
    String GetBaseURL(const String& defaultValue) const {
       return m_baseURL.value_or(defaultValue);
    }
    const std::optional<String>& GetBaseURL() const {
       return m_baseURL;
    }
    void SetBaseURL(const String& value);  // Defined below

    template<int STATE>
    class DragDataItemBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            MimeTypeSet = 1 << 1,
            DataSet = 1 << 2,
            AllFieldsSet = (MimeTypeSet | DataSet | 0)};


        DragDataItemBuilder<STATE | MimeTypeSet>& SetMimeType(const String& value);  // Defined below

        DragDataItemBuilder<STATE | DataSet>& SetData(const String& value);  // Defined below

        DragDataItemBuilder<STATE>& SetTitle(const String& value);  // Defined below

        DragDataItemBuilder<STATE>& SetBaseURL(const String& value);  // Defined below

        std::unique_ptr<DragDataItem> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DragDataItem;
        DragDataItemBuilder() : m_result(new DragDataItem()) { }

        template<int STEP> DragDataItemBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DragDataItemBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Input::DragDataItem> m_result;
    };

    static DragDataItemBuilder<0> Create()
    {
        return DragDataItemBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DragDataItem();  // Defined below

    String m_mimeType;
    String m_data;
    std::optional<String> m_title;
    std::optional<String> m_baseURL;
};


class CONTENT_EXPORT DragData : public ::crdtp::ProtocolObject<DragData> {
public:
    ~DragData() override;  // Defined below

    protocol::Array<protocol::Input::DragDataItem>* GetItems() { return m_items.get(); }
    void SetItems(std::unique_ptr<protocol::Array<protocol::Input::DragDataItem>> value);  // Defined below

    bool HasFiles() { return !!m_files; }
    protocol::Array<String>* GetFiles(protocol::Array<String>* defaultValue) {
       return m_files ? m_files.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetFiles() const {
       return m_files;
    }
    void SetFiles(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    int GetDragOperationsMask() { return m_dragOperationsMask; }
    void SetDragOperationsMask(int value);  // Defined below

    template<int STATE>
    class DragDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ItemsSet = 1 << 1,
            DragOperationsMaskSet = 1 << 2,
            AllFieldsSet = (ItemsSet | DragOperationsMaskSet | 0)};


        DragDataBuilder<STATE | ItemsSet>& SetItems(std::unique_ptr<protocol::Array<protocol::Input::DragDataItem>> value);  // Defined below

        DragDataBuilder<STATE>& SetFiles(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        DragDataBuilder<STATE | DragOperationsMaskSet>& SetDragOperationsMask(int value);  // Defined below

        std::unique_ptr<DragData> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DragData;
        DragDataBuilder() : m_result(new DragData()) { }

        template<int STEP> DragDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DragDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Input::DragData> m_result;
    };

    static DragDataBuilder<0> Create()
    {
        return DragDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DragData();  // Defined below

    std::unique_ptr<protocol::Array<protocol::Input::DragDataItem>> m_items;
    std::unique_ptr<protocol::Array<String>> m_files;
    int m_dragOperationsMask;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline TouchPoint::~TouchPoint() = default;
inline void TouchPoint::SetX(double value) { m_x = value; }
inline void TouchPoint::SetY(double value) { m_y = value; }
inline void TouchPoint::SetRadiusX(double value) { m_radiusX = value; }
inline void TouchPoint::SetRadiusY(double value) { m_radiusY = value; }
inline void TouchPoint::SetRotationAngle(double value) { m_rotationAngle = value; }
inline void TouchPoint::SetForce(double value) { m_force = value; }
inline void TouchPoint::SetTangentialPressure(double value) { m_tangentialPressure = value; }
inline void TouchPoint::SetTiltX(double value) { m_tiltX = value; }
inline void TouchPoint::SetTiltY(double value) { m_tiltY = value; }
inline void TouchPoint::SetTwist(int value) { m_twist = value; }
inline void TouchPoint::SetId(double value) { m_id = value; }

template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE | TouchPoint::TouchPointBuilder<STATE>::XSet>&
TouchPoint::TouchPointBuilder<STATE>::SetX(double value) {
  static_assert(!(STATE & XSet), "property x should not be set yet");
  m_result->SetX(value);
  return castState<XSet>();
}
template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE | TouchPoint::TouchPointBuilder<STATE>::YSet>&
TouchPoint::TouchPointBuilder<STATE>::SetY(double value) {
  static_assert(!(STATE & YSet), "property y should not be set yet");
  m_result->SetY(value);
  return castState<YSet>();
}
template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE>& TouchPoint::TouchPointBuilder<STATE>::SetRadiusX(double value) {
  m_result->SetRadiusX(value);
  return *this;
}
template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE>& TouchPoint::TouchPointBuilder<STATE>::SetRadiusY(double value) {
  m_result->SetRadiusY(value);
  return *this;
}
template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE>& TouchPoint::TouchPointBuilder<STATE>::SetRotationAngle(double value) {
  m_result->SetRotationAngle(value);
  return *this;
}
template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE>& TouchPoint::TouchPointBuilder<STATE>::SetForce(double value) {
  m_result->SetForce(value);
  return *this;
}
template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE>& TouchPoint::TouchPointBuilder<STATE>::SetTangentialPressure(double value) {
  m_result->SetTangentialPressure(value);
  return *this;
}
template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE>& TouchPoint::TouchPointBuilder<STATE>::SetTiltX(double value) {
  m_result->SetTiltX(value);
  return *this;
}
template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE>& TouchPoint::TouchPointBuilder<STATE>::SetTiltY(double value) {
  m_result->SetTiltY(value);
  return *this;
}
template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE>& TouchPoint::TouchPointBuilder<STATE>::SetTwist(int value) {
  m_result->SetTwist(value);
  return *this;
}
template<int STATE>
inline TouchPoint::TouchPointBuilder<STATE>& TouchPoint::TouchPointBuilder<STATE>::SetId(double value) {
  m_result->SetId(value);
  return *this;
}

inline TouchPoint::TouchPoint() {
  m_x = 0;
  m_y = 0;
}
inline DragDataItem::~DragDataItem() = default;
inline void DragDataItem::SetMimeType(const String& value) { m_mimeType = value; }
inline void DragDataItem::SetData(const String& value) { m_data = value; }
inline void DragDataItem::SetTitle(const String& value) { m_title = value; }
inline void DragDataItem::SetBaseURL(const String& value) { m_baseURL = value; }

template<int STATE>
inline DragDataItem::DragDataItemBuilder<STATE | DragDataItem::DragDataItemBuilder<STATE>::MimeTypeSet>&
DragDataItem::DragDataItemBuilder<STATE>::SetMimeType(const String& value) {
  static_assert(!(STATE & MimeTypeSet), "property mimeType should not be set yet");
  m_result->SetMimeType(value);
  return castState<MimeTypeSet>();
}
template<int STATE>
inline DragDataItem::DragDataItemBuilder<STATE | DragDataItem::DragDataItemBuilder<STATE>::DataSet>&
DragDataItem::DragDataItemBuilder<STATE>::SetData(const String& value) {
  static_assert(!(STATE & DataSet), "property data should not be set yet");
  m_result->SetData(value);
  return castState<DataSet>();
}
template<int STATE>
inline DragDataItem::DragDataItemBuilder<STATE>& DragDataItem::DragDataItemBuilder<STATE>::SetTitle(const String& value) {
  m_result->SetTitle(value);
  return *this;
}
template<int STATE>
inline DragDataItem::DragDataItemBuilder<STATE>& DragDataItem::DragDataItemBuilder<STATE>::SetBaseURL(const String& value) {
  m_result->SetBaseURL(value);
  return *this;
}

inline DragDataItem::DragDataItem() {
}
inline DragData::~DragData() = default;
inline void DragData::SetItems(std::unique_ptr<protocol::Array<protocol::Input::DragDataItem>> value) { m_items = std::move(value); }
inline void DragData::SetFiles(std::unique_ptr<protocol::Array<String>> value) { m_files = std::move(value); }
inline void DragData::SetDragOperationsMask(int value) { m_dragOperationsMask = value; }

template<int STATE>
inline DragData::DragDataBuilder<STATE | DragData::DragDataBuilder<STATE>::ItemsSet>&
DragData::DragDataBuilder<STATE>::SetItems(std::unique_ptr<protocol::Array<protocol::Input::DragDataItem>> value) {
  static_assert(!(STATE & ItemsSet), "property items should not be set yet");
  m_result->SetItems(std::move(value));
  return castState<ItemsSet>();
}
template<int STATE>
inline DragData::DragDataBuilder<STATE>& DragData::DragDataBuilder<STATE>::SetFiles(std::unique_ptr<protocol::Array<String>> value) {
  m_result->SetFiles(std::move(value));
  return *this;
}
template<int STATE>
inline DragData::DragDataBuilder<STATE | DragData::DragDataBuilder<STATE>::DragOperationsMaskSet>&
DragData::DragDataBuilder<STATE>::SetDragOperationsMask(int value) {
  static_assert(!(STATE & DragOperationsMaskSet), "property dragOperationsMask should not be set yet");
  m_result->SetDragOperationsMask(value);
  return castState<DragOperationsMaskSet>();
}

inline DragData::DragData() {
  m_dragOperationsMask = 0;
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    class CONTENT_EXPORT DispatchDragEventCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~DispatchDragEventCallback() { }
    };
    virtual void DispatchDragEvent(const String& in_type, double in_x, double in_y, std::unique_ptr<protocol::Input::DragData> in_data, std::optional<int> in_modifiers, std::unique_ptr<DispatchDragEventCallback> callback) = 0;
    class CONTENT_EXPORT DispatchKeyEventCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~DispatchKeyEventCallback() { }
    };
    virtual void DispatchKeyEvent(const String& in_type, std::optional<int> in_modifiers, std::optional<double> in_timestamp, std::optional<String> in_text, std::optional<String> in_unmodifiedText, std::optional<String> in_keyIdentifier, std::optional<String> in_code, std::optional<String> in_key, std::optional<int> in_windowsVirtualKeyCode, std::optional<int> in_nativeVirtualKeyCode, std::optional<bool> in_autoRepeat, std::optional<bool> in_isKeypad, std::optional<bool> in_isSystemKey, std::optional<int> in_location, std::unique_ptr<protocol::Array<String>> in_commands, std::unique_ptr<DispatchKeyEventCallback> callback) = 0;
    class CONTENT_EXPORT InsertTextCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~InsertTextCallback() { }
    };
    virtual void InsertText(const String& in_text, std::unique_ptr<InsertTextCallback> callback) = 0;
    class CONTENT_EXPORT ImeSetCompositionCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ImeSetCompositionCallback() { }
    };
    virtual void ImeSetComposition(const String& in_text, int in_selectionStart, int in_selectionEnd, std::optional<int> in_replacementStart, std::optional<int> in_replacementEnd, std::unique_ptr<ImeSetCompositionCallback> callback) = 0;
    class CONTENT_EXPORT DispatchMouseEventCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~DispatchMouseEventCallback() { }
    };
    virtual void DispatchMouseEvent(const String& in_type, double in_x, double in_y, std::optional<int> in_modifiers, std::optional<double> in_timestamp, std::optional<String> in_button, std::optional<int> in_buttons, std::optional<int> in_clickCount, std::optional<double> in_force, std::optional<double> in_tangentialPressure, std::optional<double> in_tiltX, std::optional<double> in_tiltY, std::optional<int> in_twist, std::optional<double> in_deltaX, std::optional<double> in_deltaY, std::optional<String> in_pointerType, std::unique_ptr<DispatchMouseEventCallback> callback) = 0;
    class CONTENT_EXPORT DispatchTouchEventCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~DispatchTouchEventCallback() { }
    };
    virtual void DispatchTouchEvent(const String& in_type, std::unique_ptr<protocol::Array<protocol::Input::TouchPoint>> in_touchPoints, std::optional<int> in_modifiers, std::optional<double> in_timestamp, std::unique_ptr<DispatchTouchEventCallback> callback) = 0;
    class CONTENT_EXPORT CancelDraggingCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~CancelDraggingCallback() { }
    };
    virtual void CancelDragging(std::unique_ptr<CancelDraggingCallback> callback) = 0;
    virtual DispatchResponse EmulateTouchFromMouseEvent(const String& in_type, int in_x, int in_y, const String& in_button, std::optional<double> in_timestamp, std::optional<double> in_deltaX, std::optional<double> in_deltaY, std::optional<int> in_modifiers, std::optional<int> in_clickCount) = 0;
    virtual DispatchResponse SetIgnoreInputEvents(bool in_ignore) = 0;
    virtual DispatchResponse SetInterceptDrags(bool in_enabled) = 0;
    class CONTENT_EXPORT SynthesizePinchGestureCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SynthesizePinchGestureCallback() { }
    };
    virtual void SynthesizePinchGesture(double in_x, double in_y, double in_scaleFactor, std::optional<int> in_relativeSpeed, std::optional<String> in_gestureSourceType, std::unique_ptr<SynthesizePinchGestureCallback> callback) = 0;
    class CONTENT_EXPORT SynthesizeScrollGestureCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SynthesizeScrollGestureCallback() { }
    };
    virtual void SynthesizeScrollGesture(double in_x, double in_y, std::optional<double> in_xDistance, std::optional<double> in_yDistance, std::optional<double> in_xOverscroll, std::optional<double> in_yOverscroll, std::optional<bool> in_preventFling, std::optional<int> in_speed, std::optional<String> in_gestureSourceType, std::optional<int> in_repeatCount, std::optional<int> in_repeatDelayMs, std::optional<String> in_interactionMarkerName, std::unique_ptr<SynthesizeScrollGestureCallback> callback) = 0;
    class CONTENT_EXPORT SynthesizeTapGestureCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SynthesizeTapGestureCallback() { }
    };
    virtual void SynthesizeTapGesture(double in_x, double in_y, std::optional<int> in_duration, std::optional<int> in_tapCount, std::optional<String> in_gestureSourceType, std::unique_ptr<SynthesizeTapGestureCallback> callback) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void DragIntercepted(std::unique_ptr<protocol::Input::DragData> data);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Input
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Input_h)
