// content/browser/attribution_reporting/attribution_reporting.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/attribution_reporting/attribution_reporting.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/attribution_reporting/attribution_reporting.mojom-params-data.h"
namespace attribution_reporting {
namespace mojom {

NOINLINE static const char* ReportTypeToStringHelper(ReportType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ReportType::kEventLevel:
      return "kEventLevel";
    case ReportType::kAggregatableAttribution:
      return "kAggregatableAttribution";
    case ReportType::kNullAggregatable:
      return "kNullAggregatable";
    default:
      return nullptr;
  }
}

std::string ReportTypeToString(ReportType value) {
  const char *str = ReportTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ReportType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ReportType value) {
  return os << ReportTypeToString(value);
}

NOINLINE static const char* RegistrationTypeToStringHelper(RegistrationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RegistrationType::kSource:
      return "kSource";
    case RegistrationType::kTrigger:
      return "kTrigger";
    default:
      return nullptr;
  }
}

std::string RegistrationTypeToString(RegistrationType value) {
  const char *str = RegistrationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RegistrationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RegistrationType value) {
  return os << RegistrationTypeToString(value);
}

NOINLINE static const char* OsRegistrationResultToStringHelper(OsRegistrationResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OsRegistrationResult::kPassedToOs:
      return "kPassedToOs";
    case OsRegistrationResult::kInvalidRegistrationUrl:
      return "kInvalidRegistrationUrl";
    case OsRegistrationResult::kProhibitedByBrowserPolicy:
      return "kProhibitedByBrowserPolicy";
    case OsRegistrationResult::kRejectedByOs:
      return "kRejectedByOs";
    default:
      return nullptr;
  }
}

std::string OsRegistrationResultToString(OsRegistrationResult value) {
  const char *str = OsRegistrationResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OsRegistrationResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OsRegistrationResult value) {
  return os << OsRegistrationResultToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace attribution_reporting

namespace perfetto {

// static
void TraceFormatTraits<::attribution_reporting::mojom::ReportType>::WriteIntoTrace(
   perfetto::TracedValue context, ::attribution_reporting::mojom::ReportType value) {
  return std::move(context).WriteString(::attribution_reporting::mojom::ReportTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::attribution_reporting::mojom::RegistrationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::attribution_reporting::mojom::RegistrationType value) {
  return std::move(context).WriteString(::attribution_reporting::mojom::RegistrationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::attribution_reporting::mojom::OsRegistrationResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::attribution_reporting::mojom::OsRegistrationResult value) {
  return std::move(context).WriteString(::attribution_reporting::mojom::OsRegistrationResultToString(value));
}

} // namespace perfetto