// components/subresource_filter/core/mojom/subresource_filter.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/subresource_filter/core/mojom/subresource_filter.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/subresource_filter/core/mojom/subresource_filter.mojom-params-data.h"
namespace subresource_filter {
namespace mojom {

NOINLINE static const char* ActivationLevelToStringHelper(ActivationLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ActivationLevel::kDisabled:
      return "kDisabled";
    case ActivationLevel::kDryRun:
      return "kDryRun";
    case ActivationLevel::kEnabled:
      return "kEnabled";
    default:
      return nullptr;
  }
}

std::string ActivationLevelToString(ActivationLevel value) {
  const char *str = ActivationLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ActivationLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ActivationLevel value) {
  return os << ActivationLevelToString(value);
}

NOINLINE static const char* AdsViolationToStringHelper(AdsViolation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AdsViolation::kMobileAdDensityByHeightAbove30:
      return "kMobileAdDensityByHeightAbove30";
    case AdsViolation::kHeavyAdsInterventionAtHostLimit:
      return "kHeavyAdsInterventionAtHostLimit";
    case AdsViolation::kLargeStickyAd:
      return "kLargeStickyAd";
    case AdsViolation::kOverlayPopupAd:
      return "kOverlayPopupAd";
    default:
      return nullptr;
  }
}

std::string AdsViolationToString(AdsViolation value) {
  const char *str = AdsViolationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AdsViolation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AdsViolation value) {
  return os << AdsViolationToString(value);
}

namespace internal {


// static
bool ActivationState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ActivationState_Data* object =
      static_cast<const ActivationState_Data*>(data);


  if (!::subresource_filter::mojom::internal::ActivationLevel_Data
        ::Validate(object->activation_level, validation_context))
    return false;

  return true;
}

ActivationState_Data::ActivationState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentLoadStatistics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentLoadStatistics_Data* object =
      static_cast<const DocumentLoadStatistics_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->evaluation_total_wall_duration, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->evaluation_total_wall_duration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->evaluation_total_cpu_duration, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->evaluation_total_cpu_duration, validation_context))
    return false;

  return true;
}

DocumentLoadStatistics_Data::DocumentLoadStatistics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SubresourceFilterRulesetObserver_SetRulesetForProcess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SubresourceFilterRulesetObserver_SetRulesetForProcess_Params_Data* object =
      static_cast<const SubresourceFilterRulesetObserver_SetRulesetForProcess_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ruleset_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ruleset_file, validation_context))
    return false;

  return true;
}

SubresourceFilterRulesetObserver_SetRulesetForProcess_Params_Data::SubresourceFilterRulesetObserver_SetRulesetForProcess_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace subresource_filter

namespace perfetto {

// static
void TraceFormatTraits<::subresource_filter::mojom::ActivationLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::subresource_filter::mojom::ActivationLevel value) {
  return std::move(context).WriteString(::subresource_filter::mojom::ActivationLevelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::subresource_filter::mojom::AdsViolation>::WriteIntoTrace(
   perfetto::TracedValue context, ::subresource_filter::mojom::AdsViolation value) {
  return std::move(context).WriteString(::subresource_filter::mojom::AdsViolationToString(value));
}

} // namespace perfetto