// components/spellcheck/common/spellcheck.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_SEND_VALIDATION_H_

#include "components/spellcheck/common/spellcheck.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"

#include "components/spellcheck/common/spellcheck.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::spellcheck::mojom::Decoration, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::spellcheck::mojom::SpellCheckBDictLanguageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::spellcheck::mojom::SpellCheckBDictLanguageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::spellcheck::mojom::internal::SpellCheckBDictLanguage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::file(input)) in_file = Traits::file(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file)::BaseType> file_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView, send_validation>(
        in_file,
        file_fragment);

      fragment->file.Set(
          file_fragment.is_null() ? nullptr : file_fragment.data());

      decltype(Traits::language(input)) in_language = Traits::language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->language)::BaseType> language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_language,
        language_fragment);

      fragment->language.Set(
          language_fragment.is_null() ? nullptr : language_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->language.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null language in SpellCheckBDictLanguage struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::spellcheck::mojom::SpellCheckResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::spellcheck::mojom::SpellCheckResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::spellcheck::mojom::internal::SpellCheckResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::spellcheck::mojom::Decoration>(
        Traits::decoration(input),
        &fragment->decoration);

      fragment->location = Traits::location(input);

      fragment->length = Traits::length(input);

      decltype(Traits::replacements(input)) in_replacements = Traits::replacements(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->replacements)::BaseType>
          replacements_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& replacements_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_replacements,
        replacements_fragment,
        &replacements_validate_params);

      fragment->replacements.Set(
          replacements_fragment.is_null() ? nullptr : replacements_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->replacements.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null replacements in SpellCheckResult struct");

      fragment->should_hide_suggestion_menu = Traits::should_hide_suggestion_menu(input);
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_SEND_VALIDATION_H_