// components/services/unzip/public/mojom/unzipper.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_SEND_VALIDATION_H_

#include "components/services/unzip/public/mojom/unzipper.mojom-shared-internal.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"

#include "components/services/unzip/public/mojom/unzipper.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::unzip::mojom::UnzipOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::unzip::mojom::UnzipOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::unzip::mojom::internal::UnzipOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::encoding(input)) in_encoding = Traits::encoding(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->encoding)::BaseType> encoding_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_encoding,
        encoding_fragment);

      fragment->encoding.Set(
          encoding_fragment.is_null() ? nullptr : encoding_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->encoding.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null encoding in UnzipOptions struct");

      decltype(Traits::password(input)) in_password = Traits::password(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->password)::BaseType> password_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_password,
        password_fragment);

      fragment->password.Set(
          password_fragment.is_null() ? nullptr : password_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->password.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null password in UnzipOptions struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::unzip::mojom::InfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::unzip::mojom::InfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::unzip::mojom::internal::Info_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->size_is_valid = Traits::size_is_valid(input);

      fragment->size = Traits::size(input);

      fragment->is_encrypted = Traits::is_encrypted(input);

      fragment->uses_aes_encryption = Traits::uses_aes_encryption(input);
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_SEND_VALIDATION_H_