// components/services/storage/privileged/mojom/indexed_db_control.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_CONTROL_MOJOM_TEST_UTILS_H_
#define COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_CONTROL_MOJOM_TEST_UTILS_H_

#include "components/services/storage/privileged/mojom/indexed_db_control.mojom.h"


namespace storage::mojom {


class  IndexedDBObserverInterceptorForTesting : public IndexedDBObserver {
  virtual IndexedDBObserver* GetForwardingInterface() = 0;
  void OnIndexedDBListChanged(const ::storage::BucketLocator& bucket_locator) override;
  void OnIndexedDBContentChanged(const ::storage::BucketLocator& bucket_locator, const ::std::u16string& database_name, const ::std::u16string& object_store_name) override;
};
class  IndexedDBObserverAsyncWaiter {
 public:
  explicit IndexedDBObserverAsyncWaiter(IndexedDBObserver* proxy);

  IndexedDBObserverAsyncWaiter(const IndexedDBObserverAsyncWaiter&) = delete;
  IndexedDBObserverAsyncWaiter& operator=(const IndexedDBObserverAsyncWaiter&) = delete;

  ~IndexedDBObserverAsyncWaiter();

 private:
  IndexedDBObserver* const proxy_;
};


class  IndexedDBControlInterceptorForTesting : public IndexedDBControl {
  virtual IndexedDBControl* GetForwardingInterface() = 0;
  void BindIndexedDB(const ::storage::BucketLocator& bucket_locator, const ::storage::BucketClientInfo& client_info, ::mojo::PendingRemote<::storage::mojom::IndexedDBClientStateChecker> client_state_checker_remote, ::mojo::PendingReceiver<::blink::mojom::IDBFactory> receiver) override;
  void ForceClose(::storage::BucketId bucket_id, ForceCloseReason reason, ForceCloseCallback callback) override;
  void DownloadBucketData(::storage::BucketId bucket_id, DownloadBucketDataCallback callback) override;
  void GetAllBucketsDetails(GetAllBucketsDetailsCallback callback) override;
  void StartMetadataRecording(::storage::BucketId bucket_id, StartMetadataRecordingCallback callback) override;
  void StopMetadataRecording(::storage::BucketId bucket_id, StopMetadataRecordingCallback callback) override;
  void SetForceKeepSessionState() override;
  void AddObserver(::mojo::PendingRemote<IndexedDBObserver> observer) override;
  void ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) override;
  void BindTestInterfaceForTesting(::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> receiver) override;
};
class  IndexedDBControlAsyncWaiter {
 public:
  explicit IndexedDBControlAsyncWaiter(IndexedDBControl* proxy);

  IndexedDBControlAsyncWaiter(const IndexedDBControlAsyncWaiter&) = delete;
  IndexedDBControlAsyncWaiter& operator=(const IndexedDBControlAsyncWaiter&) = delete;

  ~IndexedDBControlAsyncWaiter();
  void ForceClose(
      ::storage::BucketId bucket_id, ForceCloseReason reason);
  
  void DownloadBucketData(
      ::storage::BucketId bucket_id, bool* out_success, ::base::FilePath* out_temp_path, ::base::FilePath* out_zip_path);
  
  void GetAllBucketsDetails(
      bool* out_incognito, std::vector<::storage::mojom::IdbOriginMetadataPtr>* out_details);
  
  void StartMetadataRecording(
      ::storage::BucketId bucket_id);
  
  void StopMetadataRecording(
      ::storage::BucketId bucket_id, std::vector<::storage::mojom::IdbBucketMetadataPtr>* out_metadata);
  std::vector<::storage::mojom::IdbBucketMetadataPtr> StopMetadataRecording(::storage::BucketId bucket_id);

 private:
  IndexedDBControl* const proxy_;
};




}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_CONTROL_MOJOM_TEST_UTILS_H_