// components/services/quarantine/public/mojom/quarantine.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/quarantine/public/mojom/quarantine.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/quarantine/public/mojom/quarantine.mojom-params-data.h"
#include "components/services/quarantine/public/mojom/quarantine.mojom-shared-message-ids.h"

#include "components/services/quarantine/public/mojom/quarantine.mojom-import-headers.h"
#include "components/services/quarantine/public/mojom/quarantine.mojom-test-utils.h"


namespace quarantine::mojom {
// The declaration includes the definition on other builds.

Quarantine::IPCStableHashFunction Quarantine::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Quarantine>(message.name())) {
    case messages::Quarantine::kQuarantineFile: {
      return &Quarantine::QuarantineFile_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Quarantine::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Quarantine>(message.name())) {
      case messages::Quarantine::kQuarantineFile:
            return "Receive quarantine::mojom::Quarantine::QuarantineFile";
    }
  } else {
    switch (static_cast<messages::Quarantine>(message.name())) {
      case messages::Quarantine::kQuarantineFile:
            return "Receive reply quarantine::mojom::Quarantine::QuarantineFile";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Quarantine::QuarantineFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3c1a68d2;  // IPCStableHash for quarantine::mojom::Quarantine::QuarantineFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Quarantine_QuarantineFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Quarantine_QuarantineFile_ForwardToCallback(
      Quarantine::QuarantineFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  Quarantine_QuarantineFile_ForwardToCallback(const Quarantine_QuarantineFile_ForwardToCallback&) = delete;
  Quarantine_QuarantineFile_ForwardToCallback& operator=(const Quarantine_QuarantineFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Quarantine::QuarantineFileCallback callback_;
};

QuarantineProxy::QuarantineProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuarantineProxy::QuarantineFile(
    const ::base::FilePath& in_full_path, const ::GURL& in_source_url, const ::GURL& in_referrer_url, const std::optional<::url::Origin>& in_request_initiator, const std::string& in_client_guid, QuarantineFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send quarantine::mojom::Quarantine::QuarantineFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("full_path"), in_full_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_url"), in_source_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("referrer_url"), in_referrer_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_initiator"), in_request_initiator,
                        "<value of type const std::optional<::url::Origin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_guid"), in_client_guid,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Quarantine::kQuarantineFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::quarantine::mojom::internal::Quarantine_QuarantineFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->full_path)::BaseType> full_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_full_path,
    full_path_fragment);

  params->full_path.Set(
      full_path_fragment.is_null() ? nullptr : full_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->full_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null full_path in Quarantine.QuarantineFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_url)::BaseType> source_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_source_url,
    source_url_fragment);

  params->source_url.Set(
      source_url_fragment.is_null() ? nullptr : source_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_url in Quarantine.QuarantineFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->referrer_url)::BaseType> referrer_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_referrer_url,
    referrer_url_fragment);

  params->referrer_url.Set(
      referrer_url_fragment.is_null() ? nullptr : referrer_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->referrer_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null referrer_url in Quarantine.QuarantineFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_initiator)::BaseType> request_initiator_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_request_initiator,
    request_initiator_fragment);

  params->request_initiator.Set(
      request_initiator_fragment.is_null() ? nullptr : request_initiator_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->client_guid)::BaseType> client_guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_client_guid,
    client_guid_fragment);

  params->client_guid.Set(
      client_guid_fragment.is_null() ? nullptr : client_guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_guid in Quarantine.QuarantineFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Quarantine::Name_);
  message.set_method_name("QuarantineFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Quarantine_QuarantineFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Quarantine_QuarantineFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Quarantine::QuarantineFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Quarantine_QuarantineFile_ProxyToResponder> proxy(
        new Quarantine_QuarantineFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Quarantine_QuarantineFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Quarantine_QuarantineFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Quarantine_QuarantineFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Quarantine::QuarantineFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      QuarantineFileResult in_result);
};

bool Quarantine_QuarantineFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Quarantine_QuarantineFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Quarantine_QuarantineFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Quarantine.0
  bool success = true;
  QuarantineFileResult p_result{};
  Quarantine_QuarantineFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Quarantine::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Quarantine_QuarantineFile_ProxyToResponder::Run(
    QuarantineFileResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply quarantine::mojom::Quarantine::QuarantineFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type QuarantineFileResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Quarantine::kQuarantineFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::quarantine::mojom::internal::Quarantine_QuarantineFile_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::quarantine::mojom::QuarantineFileResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Quarantine::Name_);
  message.set_method_name("QuarantineFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool QuarantineStubDispatch::Accept(
    Quarantine* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Quarantine>(message->header()->name)) {
    case messages::Quarantine::kQuarantineFile: {
      break;
    }
  }
  return false;
}

// static
bool QuarantineStubDispatch::AcceptWithResponder(
    Quarantine* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Quarantine>(message->header()->name)) {
    case messages::Quarantine::kQuarantineFile: {
      internal::Quarantine_QuarantineFile_Params_Data* params =
          reinterpret_cast<
              internal::Quarantine_QuarantineFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Quarantine.0
      bool success = true;
      ::base::FilePath p_full_path{};
      ::GURL p_source_url{};
      ::GURL p_referrer_url{};
      std::optional<::url::Origin> p_request_initiator{};
      std::string p_client_guid{};
      Quarantine_QuarantineFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFullPath(&p_full_path))
        success = false;
      if (success && !input_data_view.ReadSourceUrl(&p_source_url))
        success = false;
      if (success && !input_data_view.ReadReferrerUrl(&p_referrer_url))
        success = false;
      if (success && !input_data_view.ReadRequestInitiator(&p_request_initiator))
        success = false;
      if (success && !input_data_view.ReadClientGuid(&p_client_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Quarantine::Name_, 0, false);
        return false;
      }
      auto callback =
          Quarantine_QuarantineFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QuarantineFile(        
        std::move(p_full_path), 
        std::move(p_source_url), 
        std::move(p_referrer_url), 
        std::move(p_request_initiator), 
        std::move(p_client_guid), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kQuarantineValidationInfo[] = {
    { &internal::Quarantine_QuarantineFile_Params_Data::Validate,
     &internal::Quarantine_QuarantineFile_ResponseParams_Data::Validate},
};

bool QuarantineRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::quarantine::mojom::Quarantine::Name_,
    kQuarantineValidationInfo);
}

bool QuarantineResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::quarantine::mojom::Quarantine::Name_,
    kQuarantineValidationInfo);
}


}  // quarantine::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace quarantine::mojom {


void QuarantineInterceptorForTesting::QuarantineFile(const ::base::FilePath& full_path, const ::GURL& source_url, const ::GURL& referrer_url, const std::optional<::url::Origin>& request_initiator, const std::string& client_guid, QuarantineFileCallback callback) {
  GetForwardingInterface()->QuarantineFile(
    std::move(full_path)
    , 
    std::move(source_url)
    , 
    std::move(referrer_url)
    , 
    std::move(request_initiator)
    , 
    std::move(client_guid)
    , std::move(callback));
}
QuarantineAsyncWaiter::QuarantineAsyncWaiter(
    Quarantine* proxy) : proxy_(proxy) {}

QuarantineAsyncWaiter::~QuarantineAsyncWaiter() = default;


void QuarantineAsyncWaiter::QuarantineFile(
    const ::base::FilePath& full_path, const ::GURL& source_url, const ::GURL& referrer_url, const std::optional<::url::Origin>& request_initiator, const std::string& client_guid, QuarantineFileResult* out_result) {
  base::RunLoop loop;
  proxy_->QuarantineFile(
      std::move(full_path),
      std::move(source_url),
      std::move(referrer_url),
      std::move(request_initiator),
      std::move(client_guid),
      base::BindOnce(
          [](base::RunLoop* loop,
             QuarantineFileResult* out_result
,
             QuarantineFileResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

QuarantineFileResult QuarantineAsyncWaiter::QuarantineFile(
    const ::base::FilePath& full_path, const ::GURL& source_url, const ::GURL& referrer_url, const std::optional<::url::Origin>& request_initiator, const std::string& client_guid) {
  QuarantineFileResult async_wait_result;
  QuarantineFile(std::move(full_path),std::move(source_url),std::move(referrer_url),std::move(request_initiator),std::move(client_guid),&async_wait_result);
  return async_wait_result;
}






}  // quarantine::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif