// components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_PAINT_PREVIEW_COMPOSITOR_PUBLIC_MOJOM_PAINT_PREVIEW_COMPOSITOR_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_PAINT_PREVIEW_COMPOSITOR_PUBLIC_MOJOM_PAINT_PREVIEW_COMPOSITOR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-shared-internal.h"
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-shared.h"
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace paint_preview::mojom {
class PaintPreviewBeginCompositeRequestDataView;

class SubframeClipRectDataView;

class FrameDataDataView;

class PaintPreviewBeginCompositeResponseDataView;



}  // paint_preview::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::paint_preview::mojom::PaintPreviewBeginCompositeRequestDataView> {
  using Data = ::paint_preview::mojom::internal::PaintPreviewBeginCompositeRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::SubframeClipRectDataView> {
  using Data = ::paint_preview::mojom::internal::SubframeClipRect_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::FrameDataDataView> {
  using Data = ::paint_preview::mojom::internal::FrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::paint_preview::mojom::PaintPreviewBeginCompositeResponseDataView> {
  using Data = ::paint_preview::mojom::internal::PaintPreviewBeginCompositeResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace paint_preview::mojom {


enum class PaintPreviewCompositor_BeginCompositeStatus : int32_t {
  
  kSuccess = 0,
  
  kPartialSuccess = 1,
  
  kDeserializingFailure = -1,
  
  kCompositingFailure = -2,
  kMinValue = -2,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, PaintPreviewCompositor_BeginCompositeStatus value);
inline bool IsKnownEnumValue(PaintPreviewCompositor_BeginCompositeStatus value) {
  return internal::PaintPreviewCompositor_BeginCompositeStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PaintPreviewCompositor_BitmapStatus : int32_t {
  
  kSuccess = 0,
  
  kMissingFrame = 1,
  
  kAllocFailed = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PaintPreviewCompositor_BitmapStatus value);
inline bool IsKnownEnumValue(PaintPreviewCompositor_BitmapStatus value) {
  return internal::PaintPreviewCompositor_BitmapStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PaintPreviewCompositorInterfaceBase {};

using PaintPreviewCompositorPtrDataView =
    mojo::InterfacePtrDataView<PaintPreviewCompositorInterfaceBase>;
using PaintPreviewCompositorRequestDataView =
    mojo::InterfaceRequestDataView<PaintPreviewCompositorInterfaceBase>;
using PaintPreviewCompositorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaintPreviewCompositorInterfaceBase>;
using PaintPreviewCompositorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaintPreviewCompositorInterfaceBase>;
class PaintPreviewCompositorCollectionInterfaceBase {};

using PaintPreviewCompositorCollectionPtrDataView =
    mojo::InterfacePtrDataView<PaintPreviewCompositorCollectionInterfaceBase>;
using PaintPreviewCompositorCollectionRequestDataView =
    mojo::InterfaceRequestDataView<PaintPreviewCompositorCollectionInterfaceBase>;
using PaintPreviewCompositorCollectionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PaintPreviewCompositorCollectionInterfaceBase>;
using PaintPreviewCompositorCollectionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PaintPreviewCompositorCollectionInterfaceBase>;


class PaintPreviewBeginCompositeRequestDataView {
 public:
  PaintPreviewBeginCompositeRequestDataView() = default;

  PaintPreviewBeginCompositeRequestDataView(
      internal::PaintPreviewBeginCompositeRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPreviewDataView(
      ::mojo_base::mojom::ProtoWrapperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreview(UserType* output) {
    
    auto* pointer = data_->preview.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProtoWrapperDataView>(
        pointer, output, message_);
  }
  inline void GetRecordingMapDataView(
      mojo::MapDataView<::mojo_base::mojom::UnguessableTokenDataView, ::paint_preview::mojom::SerializedRecordingDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecordingMap(UserType* output) {
    
    auto* pointer = data_->recording_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::UnguessableTokenDataView, ::paint_preview::mojom::SerializedRecordingDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PaintPreviewBeginCompositeRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SubframeClipRectDataView {
 public:
  SubframeClipRectDataView() = default;

  SubframeClipRectDataView(
      internal::SubframeClipRect_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameGuidDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameGuid(UserType* output) {
    
    auto* pointer = data_->frame_guid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetClipRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClipRect(UserType* output) {
    
    auto* pointer = data_->clip_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
 private:
  internal::SubframeClipRect_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameDataDataView {
 public:
  FrameDataDataView() = default;

  FrameDataDataView(
      internal::FrameData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScrollExtentsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollExtents(UserType* output) {
    
    auto* pointer = data_->scroll_extents.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetScrollOffsetsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollOffsets(UserType* output) {
    
    auto* pointer = data_->scroll_offsets.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetSubframesDataView(
      mojo::ArrayDataView<SubframeClipRectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubframes(UserType* output) {
    
    auto* pointer = data_->subframes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::paint_preview::mojom::SubframeClipRectDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FrameData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PaintPreviewBeginCompositeResponseDataView {
 public:
  PaintPreviewBeginCompositeResponseDataView() = default;

  PaintPreviewBeginCompositeResponseDataView(
      internal::PaintPreviewBeginCompositeResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRootFrameGuidDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootFrameGuid(UserType* output) {
    
    auto* pointer = data_->root_frame_guid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFramesDataView(
      mojo::MapDataView<::mojo_base::mojom::UnguessableTokenDataView, FrameDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrames(UserType* output) {
    
    auto* pointer = data_->frames.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::mojo_base::mojom::UnguessableTokenDataView, ::paint_preview::mojom::FrameDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PaintPreviewBeginCompositeResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // paint_preview::mojom

#endif  // COMPONENTS_SERVICES_PAINT_PREVIEW_COMPOSITOR_PUBLIC_MOJOM_PAINT_PREVIEW_COMPOSITOR_MOJOM_DATA_VIEW_H_