// components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-shared-internal.h"
#include "components/services/on_device_translation/public/mojom/translator.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-data-view.h"




namespace std {

template <>
struct hash<::on_device_translation::mojom::CreateTranslatorResult>
    : public mojo::internal::EnumHashImpl<::on_device_translation::mojom::CreateTranslatorResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_translation::mojom::CreateTranslatorResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::on_device_translation::mojom::CreateTranslatorResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::on_device_translation::mojom::CreateTranslatorResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_translation::mojom::OnDeviceTranslationLanguagePackageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_translation::mojom::OnDeviceTranslationLanguagePackageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_translation::mojom::internal::OnDeviceTranslationLanguagePackage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::language1(input)) in_language1 = Traits::language1(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language1)::BaseType> language1_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_language1,
      language1_fragment);

    fragment->language1.Set(
        language1_fragment.is_null() ? nullptr : language1_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->language1.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language1 in OnDeviceTranslationLanguagePackage struct");

    decltype(Traits::language2(input)) in_language2 = Traits::language2(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language2)::BaseType> language2_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_language2,
      language2_fragment);

    fragment->language2.Set(
        language2_fragment.is_null() ? nullptr : language2_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->language2.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language2 in OnDeviceTranslationLanguagePackage struct");
  }

  static bool Deserialize(::on_device_translation::mojom::internal::OnDeviceTranslationLanguagePackage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_translation::mojom::OnDeviceTranslationLanguagePackageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::on_device_translation::mojom::OnDeviceTranslationServiceConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::on_device_translation::mojom::OnDeviceTranslationServiceConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::on_device_translation::mojom::internal::OnDeviceTranslationServiceConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::packages(input)) in_packages = Traits::packages(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->packages)::BaseType>
        packages_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& packages_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::on_device_translation::mojom::OnDeviceTranslationLanguagePackageDataView>>(
      in_packages,
      packages_fragment,
      &packages_validate_params);

    fragment->packages.Set(
        packages_fragment.is_null() ? nullptr : packages_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->packages.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null packages in OnDeviceTranslationServiceConfig struct");

    decltype(Traits::file_operation_proxy(input)) in_file_operation_proxy = Traits::file_operation_proxy(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::on_device_translation::mojom::FileOperationProxyInterfaceBase>>(
      in_file_operation_proxy,
      &fragment->file_operation_proxy,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->file_operation_proxy)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid file_operation_proxy in OnDeviceTranslationServiceConfig struct");
  }

  static bool Deserialize(::on_device_translation::mojom::internal::OnDeviceTranslationServiceConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::on_device_translation::mojom::OnDeviceTranslationServiceConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace on_device_translation::mojom {

inline void OnDeviceTranslationLanguagePackageDataView::GetLanguage1DataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language1.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void OnDeviceTranslationLanguagePackageDataView::GetLanguage2DataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language2.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void OnDeviceTranslationServiceConfigDataView::GetPackagesDataView(
    mojo::ArrayDataView<OnDeviceTranslationLanguagePackageDataView>* output) {
  auto pointer = data_->packages.Get();
  *output = mojo::ArrayDataView<OnDeviceTranslationLanguagePackageDataView>(pointer, message_);
}



}  // on_device_translation::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::on_device_translation::mojom::CreateTranslatorResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::on_device_translation::mojom::CreateTranslatorResult value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_SHARED_H_