// components/services/filesystem/public/mojom/types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/filesystem/public/mojom/types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/filesystem/public/mojom/types.mojom-params-data.h"
#include "components/services/filesystem/public/mojom/types.mojom-shared-message-ids.h"

#include "components/services/filesystem/public/mojom/types.mojom-import-headers.h"
#include "components/services/filesystem/public/mojom/types.mojom-test-utils.h"


namespace filesystem::mojom {
TimespecOrNow::TimespecOrNow()
    : now(),
      seconds() {}

TimespecOrNow::TimespecOrNow(
    bool now_in,
    double seconds_in)
    : now(std::move(now_in)),
      seconds(std::move(seconds_in)) {}

TimespecOrNow::~TimespecOrNow() = default;
size_t TimespecOrNow::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->now);
  seed = mojo::internal::Hash(seed, this->seconds);
  return seed;
}

void TimespecOrNow::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "now"), this->now,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seconds"), this->seconds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TimespecOrNow::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileInformation::FileInformation()
    : type(),
      size(),
      atime(),
      mtime(),
      ctime() {}

FileInformation::FileInformation(
    FsFileType type_in,
    int64_t size_in,
    double atime_in,
    double mtime_in,
    double ctime_in)
    : type(std::move(type_in)),
      size(std::move(size_in)),
      atime(std::move(atime_in)),
      mtime(std::move(mtime_in)),
      ctime(std::move(ctime_in)) {}

FileInformation::~FileInformation() = default;
size_t FileInformation::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->size);
  seed = mojo::internal::Hash(seed, this->atime);
  seed = mojo::internal::Hash(seed, this->mtime);
  seed = mojo::internal::Hash(seed, this->ctime);
  return seed;
}

void FileInformation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FsFileType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "atime"), this->atime,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mtime"), this->mtime,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ctime"), this->ctime,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DirectoryEntry::DirectoryEntry()
    : name(),
      display_name(),
      type() {}

DirectoryEntry::DirectoryEntry(
    const ::base::SafeBaseName& name_in,
    const std::string& display_name_in,
    FsFileType type_in)
    : name(std::move(name_in)),
      display_name(std::move(display_name_in)),
      type(std::move(type_in)) {}

DirectoryEntry::~DirectoryEntry() = default;

void DirectoryEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::SafeBaseName&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FsFileType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DirectoryEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // filesystem::mojom


namespace mojo {


// static
bool StructTraits<::filesystem::mojom::TimespecOrNow::DataView, ::filesystem::mojom::TimespecOrNowPtr>::Read(
    ::filesystem::mojom::TimespecOrNow::DataView input,
    ::filesystem::mojom::TimespecOrNowPtr* output) {
  bool success = true;
  ::filesystem::mojom::TimespecOrNowPtr result(::filesystem::mojom::TimespecOrNow::New());
  
      if (success)
        result->now = input.now();
      if (success)
        result->seconds = input.seconds();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::filesystem::mojom::FileInformation::DataView, ::filesystem::mojom::FileInformationPtr>::Read(
    ::filesystem::mojom::FileInformation::DataView input,
    ::filesystem::mojom::FileInformationPtr* output) {
  bool success = true;
  ::filesystem::mojom::FileInformationPtr result(::filesystem::mojom::FileInformation::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->size = input.size();
      if (success)
        result->atime = input.atime();
      if (success)
        result->mtime = input.mtime();
      if (success)
        result->ctime = input.ctime();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::filesystem::mojom::DirectoryEntry::DataView, ::filesystem::mojom::DirectoryEntryPtr>::Read(
    ::filesystem::mojom::DirectoryEntry::DataView input,
    ::filesystem::mojom::DirectoryEntryPtr* output) {
  bool success = true;
  ::filesystem::mojom::DirectoryEntryPtr result(::filesystem::mojom::DirectoryEntry::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace filesystem::mojom {




}  // filesystem::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif