// components/remote_cocoa/common/text_input_host.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_TEXT_INPUT_HOST_MOJOM_TEST_UTILS_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_TEXT_INPUT_HOST_MOJOM_TEST_UTILS_H_

#include "components/remote_cocoa/common/text_input_host.mojom.h"


namespace remote_cocoa::mojom {


class  TextInputHostInterceptorForTesting : public TextInputHost {
  virtual TextInputHost* GetForwardingInterface() = 0;
  void HasClient(HasClientCallback callback) override;
  void HasInputContext(HasInputContextCallback callback) override;
  void IsRTL(IsRTLCallback callback) override;
  void GetSelectionRange(GetSelectionRangeCallback callback) override;
  void GetSelectionText(GetSelectionTextCallback callback) override;
  void InsertText(const ::std::u16string& text, bool as_character) override;
  void DeleteRange(const ::gfx::Range& range) override;
  void SetCompositionText(const ::std::u16string& text, const ::gfx::Range& selected_range, const ::gfx::Range& replacement_range) override;
  void ConfirmCompositionText() override;
  void HasCompositionText(HasCompositionTextCallback callback) override;
  void GetCompositionTextRange(GetCompositionTextRangeCallback callback) override;
  void GetAttributedSubstringForRange(const ::gfx::Range& requested_range, GetAttributedSubstringForRangeCallback callback) override;
  void GetFirstRectForRange(const ::gfx::Range& requested_range, GetFirstRectForRangeCallback callback) override;
  void IsTextEditCommandEnabled(::ui::TextEditCommand command, IsTextEditCommandEnabledCallback callback) override;
  void SetTextEditCommandForNextKeyEvent(::ui::TextEditCommand command) override;
};
class  TextInputHostAsyncWaiter {
 public:
  explicit TextInputHostAsyncWaiter(TextInputHost* proxy);

  TextInputHostAsyncWaiter(const TextInputHostAsyncWaiter&) = delete;
  TextInputHostAsyncWaiter& operator=(const TextInputHostAsyncWaiter&) = delete;

  ~TextInputHostAsyncWaiter();
  void HasClient(
      bool* out_has_client);
  bool HasClient();
  void HasInputContext(
      bool* out_has_input_context);
  bool HasInputContext();
  void IsRTL(
      bool* out_is_rtl);
  bool IsRTL();
  void GetSelectionRange(
      ::gfx::Range* out_range);
  ::gfx::Range GetSelectionRange();
  void GetSelectionText(
      bool* out_result, ::std::u16string* out_text);
  
  void HasCompositionText(
      bool* out_has_composition_text);
  bool HasCompositionText();
  void GetCompositionTextRange(
      ::gfx::Range* out_composition_range);
  ::gfx::Range GetCompositionTextRange();
  void GetAttributedSubstringForRange(
      const ::gfx::Range& requested_range, ::std::u16string* out_text, ::gfx::Range* out_actual_range);
  
  void GetFirstRectForRange(
      const ::gfx::Range& requested_range, ::gfx::Rect* out_rect, ::gfx::Range* out_actual_range);
  
  void IsTextEditCommandEnabled(
      ::ui::TextEditCommand command, bool* out_enabled);
  bool IsTextEditCommandEnabled(::ui::TextEditCommand command);

 private:
  TextInputHost* const proxy_;
};




}  // remote_cocoa::mojom

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_TEXT_INPUT_HOST_MOJOM_TEST_UTILS_H_