// components/remote_cocoa/common/select_file_dialog.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/remote_cocoa/common/select_file_dialog.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/select_file_dialog.mojom-params-data.h"
namespace remote_cocoa {
namespace mojom {

NOINLINE static const char* SelectFileDialogTypeToStringHelper(SelectFileDialogType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SelectFileDialogType::kFolder:
      return "kFolder";
    case SelectFileDialogType::kUploadFolder:
      return "kUploadFolder";
    case SelectFileDialogType::kExistingFolder:
      return "kExistingFolder";
    case SelectFileDialogType::kOpenFile:
      return "kOpenFile";
    case SelectFileDialogType::kOpenMultiFile:
      return "kOpenMultiFile";
    case SelectFileDialogType::kSaveAsFile:
      return "kSaveAsFile";
    default:
      return nullptr;
  }
}

std::string SelectFileDialogTypeToString(SelectFileDialogType value) {
  const char *str = SelectFileDialogTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SelectFileDialogType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SelectFileDialogType value) {
  return os << SelectFileDialogTypeToString(value);
}

namespace internal {


// static
bool SelectFileTypeInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectFileTypeInfo_Data* object =
      static_cast<const SelectFileTypeInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extensions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->extensions, validation_context,
                                         &extensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_description_overrides, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_description_overrides_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_description_overrides, validation_context,
                                         &extension_description_overrides_validate_params)) {
    return false;
  }

  return true;
}

SelectFileTypeInfo_Data::SelectFileTypeInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SelectFileDialog_Show_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectFileDialog_Show_Params_Data* object =
      static_cast<const SelectFileDialog_Show_Params_Data*>(data);


  if (!::remote_cocoa::mojom::internal::SelectFileDialogType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->file_types, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_extension, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& default_extension_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->default_extension, validation_context,
                                         &default_extension_validate_params)) {
    return false;
  }

  return true;
}

SelectFileDialog_Show_Params_Data::SelectFileDialog_Show_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SelectFileDialog_Show_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectFileDialog_Show_ResponseParams_Data* object =
      static_cast<const SelectFileDialog_Show_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->files, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->files, validation_context,
                                         &files_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_tags, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_tags_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->file_tags, validation_context,
                                         &file_tags_validate_params)) {
    return false;
  }

  return true;
}

SelectFileDialog_Show_ResponseParams_Data::SelectFileDialog_Show_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace remote_cocoa

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::SelectFileDialogType>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::SelectFileDialogType value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::SelectFileDialogTypeToString(value));
}

} // namespace perfetto