// components/remote_cocoa/common/native_widget_ns_window_host.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_HOST_MOJOM_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_HOST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/remote_cocoa/common/native_widget_ns_window_host.mojom-features.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/native_widget_ns_window_host.mojom-shared.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/native_widget_ns_window_host.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/process_id.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "ui/base/accelerators/mojom/accelerator.mojom.h"
#include "ui/base/mojom/dialog_button.mojom-forward.h"
#include "ui/base/mojom/window_open_disposition.mojom.h"
#include "ui/display/mojom/display.mojom.h"
#include "ui/events/mojom/event.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/ca_layer_params.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace remote_cocoa::mojom {

class NativeWidgetNSWindowHostProxy;

template <typename ImplRefTraits>
class NativeWidgetNSWindowHostStub;

class NativeWidgetNSWindowHostRequestValidator;
class NativeWidgetNSWindowHostResponseValidator;


class NativeWidgetNSWindowHost
    : public NativeWidgetNSWindowHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.NativeWidgetNSWindowHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    4, 
    11, 
    12, 
    13, 
    14, 
    15, 
    17, 
    18, 
    37, 
    38, 
    39, 
    40, 
    41, 
    42, 
    43, 
    46, 
    47, 
    48, 
    49, 
    50
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NativeWidgetNSWindowHostInterfaceBase;
  using Proxy_ = NativeWidgetNSWindowHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = NativeWidgetNSWindowHostStub<ImplRefTraits>;

  using RequestValidator_ = NativeWidgetNSWindowHostRequestValidator;
  using ResponseValidator_ = NativeWidgetNSWindowHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnVisibilityChangedMinVersion = 0,
    kOnSpaceActivationChangedMinVersion = 0,
    kOnWindowNativeThemeChangedMinVersion = 0,
    kOnViewSizeChangedMinVersion = 0,
    kGetSheetOffsetYMinVersion = 0,
    kSetKeyboardAccessibleMinVersion = 0,
    kOnIsFirstResponderChangedMinVersion = 0,
    kOnMouseCaptureActiveChangedMinVersion = 0,
    kOnScrollEventMinVersion = 0,
    kOnMouseEventMinVersion = 0,
    kOnGestureEventMinVersion = 0,
    kDispatchKeyEventRemoteMinVersion = 0,
    kDispatchKeyEventToMenuControllerRemoteMinVersion = 0,
    kDispatchMonitorEventMinVersion = 0,
    kGetHasMenuControllerMinVersion = 0,
    kGetHitTestResultMinVersion = 0,
    kGetTooltipTextAtMinVersion = 0,
    kGetWidgetIsModalMinVersion = 0,
    kGetIsFocusedViewTextualMinVersion = 0,
    kOnWindowGeometryChangedMinVersion = 0,
    kOnWindowWillStartLiveResizeMinVersion = 0,
    kOnWindowDidEndLiveResizeMinVersion = 0,
    kOnWindowFullscreenTransitionStartMinVersion = 0,
    kOnWindowFullscreenTransitionCompleteMinVersion = 0,
    kOnWindowMiniaturizedChangedMinVersion = 0,
    kOnWindowZoomedChangedMinVersion = 0,
    kOnWindowDisplayChangedMinVersion = 0,
    kOnWindowWillCloseMinVersion = 0,
    kOnWindowHasClosedMinVersion = 0,
    kOnWindowKeyStatusChangedMinVersion = 0,
    kOnWindowStateRestorationDataChangedMinVersion = 0,
    kOnSheetModalShownMinVersion = 0,
    kOnSheetModalClosedMinVersion = 0,
    kOnImmersiveFullscreenToolbarRevealChangedMinVersion = 0,
    kOnImmersiveFullscreenMenuBarRevealChangedMinVersion = 0,
    kOnAutohidingMenuBarHeightChangedMinVersion = 0,
    kDoDialogButtonActionMinVersion = 0,
    kGetDialogButtonInfoMinVersion = 0,
    kGetDoDialogButtonsExistMinVersion = 0,
    kGetShouldShowWindowTitleMinVersion = 0,
    kGetCanWindowBecomeKeyMinVersion = 0,
    kGetAlwaysRenderWindowAsKeyMinVersion = 0,
    kOnWindowCloseRequestedMinVersion = 0,
    kGetWindowFrameTitlebarHeightMinVersion = 0,
    kOnFocusWindowToolbarMinVersion = 0,
    kSetRemoteAccessibilityTokensMinVersion = 0,
    kGetRootViewAccessibilityTokenMinVersion = 0,
    kValidateUserInterfaceItemMinVersion = 0,
    kWillExecuteCommandMinVersion = 0,
    kExecuteCommandMinVersion = 0,
    kHandleAcceleratorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnVisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSpaceActivationChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowNativeThemeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnViewSizeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSheetOffsetY_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetKeyboardAccessible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnIsFirstResponderChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMouseCaptureActiveChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnScrollEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMouseEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnGestureEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchKeyEventRemote_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchKeyEventToMenuControllerRemote_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchMonitorEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetHasMenuController_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetHitTestResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTooltipTextAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWidgetIsModal_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetIsFocusedViewTextual_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowGeometryChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowWillStartLiveResize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowDidEndLiveResize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowFullscreenTransitionStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowFullscreenTransitionComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowMiniaturizedChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowZoomedChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowDisplayChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowWillClose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowHasClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowKeyStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowStateRestorationDataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSheetModalShown_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSheetModalClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnImmersiveFullscreenToolbarRevealChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnImmersiveFullscreenMenuBarRevealChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAutohidingMenuBarHeightChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DoDialogButtonAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDialogButtonInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDoDialogButtonsExist_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetShouldShowWindowTitle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCanWindowBecomeKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAlwaysRenderWindowAsKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWindowCloseRequested_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWindowFrameTitlebarHeight_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFocusWindowToolbar_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetRemoteAccessibilityTokens_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRootViewAccessibilityToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ValidateUserInterfaceItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WillExecuteCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleAccelerator_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NativeWidgetNSWindowHost() = default;

  virtual void OnVisibilityChanged(bool visible) = 0;

  virtual void OnSpaceActivationChanged(bool is_space_active) = 0;

  virtual void OnWindowNativeThemeChanged() = 0;

  virtual void OnViewSizeChanged(const ::gfx::Size& new_size) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetSheetOffsetY(int32_t* out_offset_y);
  using GetSheetOffsetYCallback = base::OnceCallback<void(int32_t)>;
  using GetSheetOffsetYMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void GetSheetOffsetY(GetSheetOffsetYCallback callback) = 0;

  virtual void SetKeyboardAccessible(bool enabled) = 0;

  virtual void OnIsFirstResponderChanged(bool is_first_responder) = 0;

  virtual void OnMouseCaptureActiveChanged(bool capture_is_active) = 0;

  virtual void OnScrollEvent(::std::unique_ptr<::ui::Event> event) = 0;

  virtual void OnMouseEvent(::std::unique_ptr<::ui::Event> event) = 0;

  virtual void OnGestureEvent(::std::unique_ptr<::ui::Event> event) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DispatchKeyEventRemote(::std::unique_ptr<::ui::Event> event, bool* out_event_handled);
  using DispatchKeyEventRemoteCallback = base::OnceCallback<void(bool)>;
  using DispatchKeyEventRemoteMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DispatchKeyEventRemote(::std::unique_ptr<::ui::Event> event, DispatchKeyEventRemoteCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DispatchKeyEventToMenuControllerRemote(::std::unique_ptr<::ui::Event> event, bool* out_event_swallowed, bool* out_event_handled);
  using DispatchKeyEventToMenuControllerRemoteCallback = base::OnceCallback<void(bool, bool)>;
  using DispatchKeyEventToMenuControllerRemoteMojoCallback = base::OnceCallback<void(bool, bool)>;

  virtual void DispatchKeyEventToMenuControllerRemote(::std::unique_ptr<::ui::Event> event, DispatchKeyEventToMenuControllerRemoteCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DispatchMonitorEvent(::std::unique_ptr<::ui::Event> event, bool target_is_this_window, bool* out_event_handled);
  using DispatchMonitorEventCallback = base::OnceCallback<void(bool)>;
  using DispatchMonitorEventMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DispatchMonitorEvent(::std::unique_ptr<::ui::Event> event, bool target_is_this_window, DispatchMonitorEventCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetHasMenuController(bool* out_has_menu_controller);
  using GetHasMenuControllerCallback = base::OnceCallback<void(bool)>;
  using GetHasMenuControllerMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetHasMenuController(GetHasMenuControllerCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetHitTestResult(const ::gfx::Point& location_in_content, HitTestResult* out_hit_test_result);
  using GetHitTestResultCallback = base::OnceCallback<void(HitTestResult)>;
  using GetHitTestResultMojoCallback = base::OnceCallback<void(HitTestResult)>;

  virtual void GetHitTestResult(const ::gfx::Point& location_in_content, GetHitTestResultCallback callback) = 0;

  using GetTooltipTextAtCallback = base::OnceCallback<void(const ::std::u16string&)>;
  using GetTooltipTextAtMojoCallback = base::OnceCallback<void(const ::std::u16string&)>;

  virtual void GetTooltipTextAt(const ::gfx::Point& location_in_content, GetTooltipTextAtCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetWidgetIsModal(bool* out_widget_is_modal);
  using GetWidgetIsModalCallback = base::OnceCallback<void(bool)>;
  using GetWidgetIsModalMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetWidgetIsModal(GetWidgetIsModalCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetIsFocusedViewTextual(bool* out_is_textual);
  using GetIsFocusedViewTextualCallback = base::OnceCallback<void(bool)>;
  using GetIsFocusedViewTextualMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetIsFocusedViewTextual(GetIsFocusedViewTextualCallback callback) = 0;

  virtual void OnWindowGeometryChanged(const ::gfx::Rect& window_bounds_in_screen_dips, const ::gfx::Rect& content_bounds_in_screen_dips) = 0;

  virtual void OnWindowWillStartLiveResize() = 0;

  virtual void OnWindowDidEndLiveResize() = 0;

  virtual void OnWindowFullscreenTransitionStart(bool target_fullscreen_state) = 0;

  virtual void OnWindowFullscreenTransitionComplete(bool is_fullscreen) = 0;

  virtual void OnWindowMiniaturizedChanged(bool miniaturized) = 0;

  virtual void OnWindowZoomedChanged(bool zoomed) = 0;

  virtual void OnWindowDisplayChanged(const ::display::Display& display) = 0;

  virtual void OnWindowWillClose() = 0;

  virtual void OnWindowHasClosed() = 0;

  virtual void OnWindowKeyStatusChanged(bool is_key, bool is_content_first_responder, bool full_keyboard_access_enabled) = 0;

  virtual void OnWindowStateRestorationDataChanged(const std::vector<uint8_t>& data) = 0;

  virtual void OnSheetModalShown() = 0;

  virtual void OnSheetModalClosed() = 0;

  virtual void OnImmersiveFullscreenToolbarRevealChanged(bool is_revealed) = 0;

  virtual void OnImmersiveFullscreenMenuBarRevealChanged(double reveal_amount) = 0;

  virtual void OnAutohidingMenuBarHeightChanged(int32_t menu_bar_height) = 0;

  virtual void DoDialogButtonAction(::ui::mojom::DialogButton button) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetDialogButtonInfo(::ui::mojom::DialogButton button, bool* out_button_exists, ::std::u16string* out_title, bool* out_is_button_enabled, bool* out_is_button_default);
  using GetDialogButtonInfoCallback = base::OnceCallback<void(bool, const ::std::u16string&, bool, bool)>;
  using GetDialogButtonInfoMojoCallback = base::OnceCallback<void(bool, const ::std::u16string&, bool, bool)>;

  virtual void GetDialogButtonInfo(::ui::mojom::DialogButton button, GetDialogButtonInfoCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetDoDialogButtonsExist(bool* out_buttons_exist);
  using GetDoDialogButtonsExistCallback = base::OnceCallback<void(bool)>;
  using GetDoDialogButtonsExistMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetDoDialogButtonsExist(GetDoDialogButtonsExistCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetShouldShowWindowTitle(bool* out_should_show_window_title);
  using GetShouldShowWindowTitleCallback = base::OnceCallback<void(bool)>;
  using GetShouldShowWindowTitleMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetShouldShowWindowTitle(GetShouldShowWindowTitleCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetCanWindowBecomeKey(bool* out_can_window_become_key);
  using GetCanWindowBecomeKeyCallback = base::OnceCallback<void(bool)>;
  using GetCanWindowBecomeKeyMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetCanWindowBecomeKey(GetCanWindowBecomeKeyCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetAlwaysRenderWindowAsKey(bool* out_always_render_as_key);
  using GetAlwaysRenderWindowAsKeyCallback = base::OnceCallback<void(bool)>;
  using GetAlwaysRenderWindowAsKeyMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetAlwaysRenderWindowAsKey(GetAlwaysRenderWindowAsKeyCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool OnWindowCloseRequested(bool* out_can_window_close);
  using OnWindowCloseRequestedCallback = base::OnceCallback<void(bool)>;
  using OnWindowCloseRequestedMojoCallback = base::OnceCallback<void(bool)>;

  virtual void OnWindowCloseRequested(OnWindowCloseRequestedCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetWindowFrameTitlebarHeight(bool* out_override_titlebar_height, float* out_titlebar_height);
  using GetWindowFrameTitlebarHeightCallback = base::OnceCallback<void(bool, float)>;
  using GetWindowFrameTitlebarHeightMojoCallback = base::OnceCallback<void(bool, float)>;

  virtual void GetWindowFrameTitlebarHeight(GetWindowFrameTitlebarHeightCallback callback) = 0;

  virtual void OnFocusWindowToolbar() = 0;

  virtual void SetRemoteAccessibilityTokens(const std::vector<uint8_t>& window_token, const std::vector<uint8_t>& view_token) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetRootViewAccessibilityToken(::base::ProcessId* out_host_pid, std::vector<uint8_t>* out_element_token);
  using GetRootViewAccessibilityTokenCallback = base::OnceCallback<void(::base::ProcessId, const std::vector<uint8_t>&)>;
  using GetRootViewAccessibilityTokenMojoCallback = base::OnceCallback<void(::base::ProcessId, const std::vector<uint8_t>&)>;

  virtual void GetRootViewAccessibilityToken(GetRootViewAccessibilityTokenCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ValidateUserInterfaceItem(int32_t command, ValidateUserInterfaceItemResultPtr* out_result);
  using ValidateUserInterfaceItemCallback = base::OnceCallback<void(ValidateUserInterfaceItemResultPtr)>;
  using ValidateUserInterfaceItemMojoCallback = base::OnceCallback<void(ValidateUserInterfaceItemResultPtr)>;

  virtual void ValidateUserInterfaceItem(int32_t command, ValidateUserInterfaceItemCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WillExecuteCommand(int32_t command, ::WindowOpenDisposition window_open_disposition, bool is_before_first_responder, bool* out_will_execute);
  using WillExecuteCommandCallback = base::OnceCallback<void(bool)>;
  using WillExecuteCommandMojoCallback = base::OnceCallback<void(bool)>;

  virtual void WillExecuteCommand(int32_t command, ::WindowOpenDisposition window_open_disposition, bool is_before_first_responder, WillExecuteCommandCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ExecuteCommand(int32_t command, ::WindowOpenDisposition window_open_disposition, bool is_before_first_responder, bool* out_was_executed);
  using ExecuteCommandCallback = base::OnceCallback<void(bool)>;
  using ExecuteCommandMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ExecuteCommand(int32_t command, ::WindowOpenDisposition window_open_disposition, bool is_before_first_responder, ExecuteCommandCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool HandleAccelerator(const ::ui::Accelerator& accelerator, bool require_priority_handler, bool* out_was_handled);
  using HandleAcceleratorCallback = base::OnceCallback<void(bool)>;
  using HandleAcceleratorMojoCallback = base::OnceCallback<void(bool)>;

  virtual void HandleAccelerator(const ::ui::Accelerator& accelerator, bool require_priority_handler, HandleAcceleratorCallback callback) = 0;
};



class  NativeWidgetNSWindowHostProxy
    : public NativeWidgetNSWindowHost {
 public:
  using InterfaceType = NativeWidgetNSWindowHost;

  explicit NativeWidgetNSWindowHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnVisibilityChanged(bool visible) final;
  
  void OnSpaceActivationChanged(bool is_space_active) final;
  
  void OnWindowNativeThemeChanged() final;
  
  void OnViewSizeChanged(const ::gfx::Size& new_size) final;
  
  bool GetSheetOffsetY(int32_t* out_offset_y) final;
  
  void GetSheetOffsetY(GetSheetOffsetYCallback callback) final;
  
  void SetKeyboardAccessible(bool enabled) final;
  
  void OnIsFirstResponderChanged(bool is_first_responder) final;
  
  void OnMouseCaptureActiveChanged(bool capture_is_active) final;
  
  void OnScrollEvent(::std::unique_ptr<::ui::Event> event) final;
  
  void OnMouseEvent(::std::unique_ptr<::ui::Event> event) final;
  
  void OnGestureEvent(::std::unique_ptr<::ui::Event> event) final;
  
  bool DispatchKeyEventRemote(::std::unique_ptr<::ui::Event> event, bool* out_event_handled) final;
  
  void DispatchKeyEventRemote(::std::unique_ptr<::ui::Event> event, DispatchKeyEventRemoteCallback callback) final;
  
  bool DispatchKeyEventToMenuControllerRemote(::std::unique_ptr<::ui::Event> event, bool* out_event_swallowed, bool* out_event_handled) final;
  
  void DispatchKeyEventToMenuControllerRemote(::std::unique_ptr<::ui::Event> event, DispatchKeyEventToMenuControllerRemoteCallback callback) final;
  
  bool DispatchMonitorEvent(::std::unique_ptr<::ui::Event> event, bool target_is_this_window, bool* out_event_handled) final;
  
  void DispatchMonitorEvent(::std::unique_ptr<::ui::Event> event, bool target_is_this_window, DispatchMonitorEventCallback callback) final;
  
  bool GetHasMenuController(bool* out_has_menu_controller) final;
  
  void GetHasMenuController(GetHasMenuControllerCallback callback) final;
  
  bool GetHitTestResult(const ::gfx::Point& location_in_content, HitTestResult* out_hit_test_result) final;
  
  void GetHitTestResult(const ::gfx::Point& location_in_content, GetHitTestResultCallback callback) final;
  
  void GetTooltipTextAt(const ::gfx::Point& location_in_content, GetTooltipTextAtCallback callback) final;
  
  bool GetWidgetIsModal(bool* out_widget_is_modal) final;
  
  void GetWidgetIsModal(GetWidgetIsModalCallback callback) final;
  
  bool GetIsFocusedViewTextual(bool* out_is_textual) final;
  
  void GetIsFocusedViewTextual(GetIsFocusedViewTextualCallback callback) final;
  
  void OnWindowGeometryChanged(const ::gfx::Rect& window_bounds_in_screen_dips, const ::gfx::Rect& content_bounds_in_screen_dips) final;
  
  void OnWindowWillStartLiveResize() final;
  
  void OnWindowDidEndLiveResize() final;
  
  void OnWindowFullscreenTransitionStart(bool target_fullscreen_state) final;
  
  void OnWindowFullscreenTransitionComplete(bool is_fullscreen) final;
  
  void OnWindowMiniaturizedChanged(bool miniaturized) final;
  
  void OnWindowZoomedChanged(bool zoomed) final;
  
  void OnWindowDisplayChanged(const ::display::Display& display) final;
  
  void OnWindowWillClose() final;
  
  void OnWindowHasClosed() final;
  
  void OnWindowKeyStatusChanged(bool is_key, bool is_content_first_responder, bool full_keyboard_access_enabled) final;
  
  void OnWindowStateRestorationDataChanged(const std::vector<uint8_t>& data) final;
  
  void OnSheetModalShown() final;
  
  void OnSheetModalClosed() final;
  
  void OnImmersiveFullscreenToolbarRevealChanged(bool is_revealed) final;
  
  void OnImmersiveFullscreenMenuBarRevealChanged(double reveal_amount) final;
  
  void OnAutohidingMenuBarHeightChanged(int32_t menu_bar_height) final;
  
  void DoDialogButtonAction(::ui::mojom::DialogButton button) final;
  
  bool GetDialogButtonInfo(::ui::mojom::DialogButton button, bool* out_button_exists, ::std::u16string* out_title, bool* out_is_button_enabled, bool* out_is_button_default) final;
  
  void GetDialogButtonInfo(::ui::mojom::DialogButton button, GetDialogButtonInfoCallback callback) final;
  
  bool GetDoDialogButtonsExist(bool* out_buttons_exist) final;
  
  void GetDoDialogButtonsExist(GetDoDialogButtonsExistCallback callback) final;
  
  bool GetShouldShowWindowTitle(bool* out_should_show_window_title) final;
  
  void GetShouldShowWindowTitle(GetShouldShowWindowTitleCallback callback) final;
  
  bool GetCanWindowBecomeKey(bool* out_can_window_become_key) final;
  
  void GetCanWindowBecomeKey(GetCanWindowBecomeKeyCallback callback) final;
  
  bool GetAlwaysRenderWindowAsKey(bool* out_always_render_as_key) final;
  
  void GetAlwaysRenderWindowAsKey(GetAlwaysRenderWindowAsKeyCallback callback) final;
  
  bool OnWindowCloseRequested(bool* out_can_window_close) final;
  
  void OnWindowCloseRequested(OnWindowCloseRequestedCallback callback) final;
  
  bool GetWindowFrameTitlebarHeight(bool* out_override_titlebar_height, float* out_titlebar_height) final;
  
  void GetWindowFrameTitlebarHeight(GetWindowFrameTitlebarHeightCallback callback) final;
  
  void OnFocusWindowToolbar() final;
  
  void SetRemoteAccessibilityTokens(const std::vector<uint8_t>& window_token, const std::vector<uint8_t>& view_token) final;
  
  bool GetRootViewAccessibilityToken(::base::ProcessId* out_host_pid, std::vector<uint8_t>* out_element_token) final;
  
  void GetRootViewAccessibilityToken(GetRootViewAccessibilityTokenCallback callback) final;
  
  bool ValidateUserInterfaceItem(int32_t command, ValidateUserInterfaceItemResultPtr* out_result) final;
  
  void ValidateUserInterfaceItem(int32_t command, ValidateUserInterfaceItemCallback callback) final;
  
  bool WillExecuteCommand(int32_t command, ::WindowOpenDisposition window_open_disposition, bool is_before_first_responder, bool* out_will_execute) final;
  
  void WillExecuteCommand(int32_t command, ::WindowOpenDisposition window_open_disposition, bool is_before_first_responder, WillExecuteCommandCallback callback) final;
  
  bool ExecuteCommand(int32_t command, ::WindowOpenDisposition window_open_disposition, bool is_before_first_responder, bool* out_was_executed) final;
  
  void ExecuteCommand(int32_t command, ::WindowOpenDisposition window_open_disposition, bool is_before_first_responder, ExecuteCommandCallback callback) final;
  
  bool HandleAccelerator(const ::ui::Accelerator& accelerator, bool require_priority_handler, bool* out_was_handled) final;
  
  void HandleAccelerator(const ::ui::Accelerator& accelerator, bool require_priority_handler, HandleAcceleratorCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NativeWidgetNSWindowHostStubDispatch {
 public:
  static bool Accept(NativeWidgetNSWindowHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NativeWidgetNSWindowHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NativeWidgetNSWindowHost>>
class NativeWidgetNSWindowHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NativeWidgetNSWindowHostStub() = default;
  ~NativeWidgetNSWindowHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeWidgetNSWindowHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeWidgetNSWindowHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NativeWidgetNSWindowHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NativeWidgetNSWindowHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  ValidateUserInterfaceItemResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ValidateUserInterfaceItemResult, T>::value>;
  using DataView = ValidateUserInterfaceItemResultDataView;
  using Data_ = internal::ValidateUserInterfaceItemResult_Data;

  template <typename... Args>
  static ValidateUserInterfaceItemResultPtr New(Args&&... args) {
    return ValidateUserInterfaceItemResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ValidateUserInterfaceItemResultPtr From(const U& u) {
    return mojo::TypeConverter<ValidateUserInterfaceItemResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ValidateUserInterfaceItemResult>::Convert(*this);
  }


  ValidateUserInterfaceItemResult();

  ValidateUserInterfaceItemResult(
      bool enable,
      bool disable_if_has_no_key_equivalent,
      const std::optional<::std::u16string>& new_title,
      bool set_hidden_state,
      bool new_hidden_state,
      bool set_toggle_state,
      bool new_toggle_state);


  ~ValidateUserInterfaceItemResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ValidateUserInterfaceItemResultPtr>
  ValidateUserInterfaceItemResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ValidateUserInterfaceItemResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ValidateUserInterfaceItemResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ValidateUserInterfaceItemResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ValidateUserInterfaceItemResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ValidateUserInterfaceItemResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ValidateUserInterfaceItemResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ValidateUserInterfaceItemResult_UnserializedMessageContext<
            UserType, ValidateUserInterfaceItemResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ValidateUserInterfaceItemResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ValidateUserInterfaceItemResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ValidateUserInterfaceItemResult_UnserializedMessageContext<
            UserType, ValidateUserInterfaceItemResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ValidateUserInterfaceItemResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool enable;
  
  bool disable_if_has_no_key_equivalent;
  
  std::optional<::std::u16string> new_title;
  
  bool set_hidden_state;
  
  bool new_hidden_state;
  
  bool set_toggle_state;
  
  bool new_toggle_state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ValidateUserInterfaceItemResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ValidateUserInterfaceItemResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ValidateUserInterfaceItemResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ValidateUserInterfaceItemResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ValidateUserInterfaceItemResultPtr ValidateUserInterfaceItemResult::Clone() const {
  return New(
      mojo::Clone(enable),
      mojo::Clone(disable_if_has_no_key_equivalent),
      mojo::Clone(new_title),
      mojo::Clone(set_hidden_state),
      mojo::Clone(new_hidden_state),
      mojo::Clone(set_toggle_state),
      mojo::Clone(new_toggle_state)
  );
}

template <typename T, ValidateUserInterfaceItemResult::EnableIfSame<T>*>
bool ValidateUserInterfaceItemResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->enable, other_struct.enable))
    return false;
  if (!mojo::Equals(this->disable_if_has_no_key_equivalent, other_struct.disable_if_has_no_key_equivalent))
    return false;
  if (!mojo::Equals(this->new_title, other_struct.new_title))
    return false;
  if (!mojo::Equals(this->set_hidden_state, other_struct.set_hidden_state))
    return false;
  if (!mojo::Equals(this->new_hidden_state, other_struct.new_hidden_state))
    return false;
  if (!mojo::Equals(this->set_toggle_state, other_struct.set_toggle_state))
    return false;
  if (!mojo::Equals(this->new_toggle_state, other_struct.new_toggle_state))
    return false;
  return true;
}

template <typename T, ValidateUserInterfaceItemResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.enable < rhs.enable)
    return true;
  if (rhs.enable < lhs.enable)
    return false;
  if (lhs.disable_if_has_no_key_equivalent < rhs.disable_if_has_no_key_equivalent)
    return true;
  if (rhs.disable_if_has_no_key_equivalent < lhs.disable_if_has_no_key_equivalent)
    return false;
  if (lhs.new_title < rhs.new_title)
    return true;
  if (rhs.new_title < lhs.new_title)
    return false;
  if (lhs.set_hidden_state < rhs.set_hidden_state)
    return true;
  if (rhs.set_hidden_state < lhs.set_hidden_state)
    return false;
  if (lhs.new_hidden_state < rhs.new_hidden_state)
    return true;
  if (rhs.new_hidden_state < lhs.new_hidden_state)
    return false;
  if (lhs.set_toggle_state < rhs.set_toggle_state)
    return true;
  if (rhs.set_toggle_state < lhs.set_toggle_state)
    return false;
  if (lhs.new_toggle_state < rhs.new_toggle_state)
    return true;
  if (rhs.new_toggle_state < lhs.new_toggle_state)
    return false;
  return false;
}


}  // remote_cocoa::mojom

namespace mojo {


template <>
struct  StructTraits<::remote_cocoa::mojom::ValidateUserInterfaceItemResult::DataView,
                                         ::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr* output) { output->reset(); }

  static decltype(::remote_cocoa::mojom::ValidateUserInterfaceItemResult::enable) enable(
      const ::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr& input) {
    return input->enable;
  }

  static decltype(::remote_cocoa::mojom::ValidateUserInterfaceItemResult::disable_if_has_no_key_equivalent) disable_if_has_no_key_equivalent(
      const ::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr& input) {
    return input->disable_if_has_no_key_equivalent;
  }

  static const decltype(::remote_cocoa::mojom::ValidateUserInterfaceItemResult::new_title)& new_title(
      const ::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr& input) {
    return input->new_title;
  }

  static decltype(::remote_cocoa::mojom::ValidateUserInterfaceItemResult::set_hidden_state) set_hidden_state(
      const ::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr& input) {
    return input->set_hidden_state;
  }

  static decltype(::remote_cocoa::mojom::ValidateUserInterfaceItemResult::new_hidden_state) new_hidden_state(
      const ::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr& input) {
    return input->new_hidden_state;
  }

  static decltype(::remote_cocoa::mojom::ValidateUserInterfaceItemResult::set_toggle_state) set_toggle_state(
      const ::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr& input) {
    return input->set_toggle_state;
  }

  static decltype(::remote_cocoa::mojom::ValidateUserInterfaceItemResult::new_toggle_state) new_toggle_state(
      const ::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr& input) {
    return input->new_toggle_state;
  }

  static bool Read(::remote_cocoa::mojom::ValidateUserInterfaceItemResult::DataView input, ::remote_cocoa::mojom::ValidateUserInterfaceItemResultPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_HOST_MOJOM_H_