// components/remote_cocoa/common/menu.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_DATA_VIEW_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/remote_cocoa/common/menu.mojom-shared-internal.h"
#include "components/remote_cocoa/common/font.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"


namespace remote_cocoa::mojom {
class MenuItemCommonFieldsDataView;

class SubmenuMenuItemDataView;

class MenuControllerParamsDataView;

class ContextMenuDataView;

class MenuItemDataView;


}  // remote_cocoa::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::MenuItemCommonFieldsDataView> {
  using Data = ::remote_cocoa::mojom::internal::MenuItemCommonFields_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::SubmenuMenuItemDataView> {
  using Data = ::remote_cocoa::mojom::internal::SubmenuMenuItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::MenuControllerParamsDataView> {
  using Data = ::remote_cocoa::mojom::internal::MenuControllerParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::ContextMenuDataView> {
  using Data = ::remote_cocoa::mojom::internal::ContextMenu_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::MenuItemDataView> {
  using Data = ::remote_cocoa::mojom::internal::MenuItem_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace remote_cocoa::mojom {
// Interface base classes. They are used for type safety check.
class MenuHostInterfaceBase {};

using MenuHostPtrDataView =
    mojo::InterfacePtrDataView<MenuHostInterfaceBase>;
using MenuHostRequestDataView =
    mojo::InterfaceRequestDataView<MenuHostInterfaceBase>;
using MenuHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MenuHostInterfaceBase>;
using MenuHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MenuHostInterfaceBase>;
class MenuInterfaceBase {};

using MenuPtrDataView =
    mojo::InterfacePtrDataView<MenuInterfaceBase>;
using MenuRequestDataView =
    mojo::InterfaceRequestDataView<MenuInterfaceBase>;
using MenuAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MenuInterfaceBase>;
using MenuAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MenuInterfaceBase>;


class MenuItemCommonFieldsDataView {
 public:
  MenuItemCommonFieldsDataView() = default;

  MenuItemCommonFieldsDataView(
      internal::MenuItemCommonFields_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t command_id() const {
    return data_->command_id;
  }
  inline void GetLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool may_have_mnemonics() const {
    return data_->may_have_mnemonics;
  }
  bool is_checked() const {
    return data_->is_checked;
  }
  inline void GetIconDataView(
      ::gfx::mojom::ImageSkiaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ImageSkiaDataView, UserType>(),
    "Attempting to read the optional `icon` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIcon` instead "
    "of `ReadIcon if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ImageSkiaDataView>(
        pointer, output, message_);
  }
  bool is_enabled() const {
    return data_->is_enabled;
  }
  bool is_visible() const {
    return data_->is_visible;
  }
  bool is_alerted() const {
    return data_->is_alerted;
  }
  bool is_new_feature() const {
    return data_->is_new_feature;
  }
 private:
  internal::MenuItemCommonFields_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SubmenuMenuItemDataView {
 public:
  SubmenuMenuItemDataView() = default;

  SubmenuMenuItemDataView(
      internal::SubmenuMenuItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCommonDataView(
      MenuItemCommonFieldsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommon(UserType* output) {
    
    auto* pointer = data_->common.Get();
    return mojo::internal::Deserialize<::remote_cocoa::mojom::MenuItemCommonFieldsDataView>(
        pointer, output, message_);
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<MenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::remote_cocoa::mojom::MenuItemDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SubmenuMenuItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MenuControllerParamsDataView {
 public:
  MenuControllerParamsDataView() = default;

  MenuControllerParamsDataView(
      internal::MenuControllerParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBadgeFontDataView(
      ::remote_cocoa::mojom::FontDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBadgeFont(UserType* output) {
    
    auto* pointer = data_->badge_font.Get();
    return mojo::internal::Deserialize<::remote_cocoa::mojom::FontDataView>(
        pointer, output, message_);
  }
  inline void GetBadgeColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBadgeColor(UserType* output) {
    
    auto* pointer = data_->badge_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetBadgeTextColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBadgeTextColor(UserType* output) {
    
    auto* pointer = data_->badge_text_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  uint32_t badge_horizontal_margin() const {
    return data_->badge_horizontal_margin;
  }
  uint32_t badge_internal_padding() const {
    return data_->badge_internal_padding;
  }
  uint32_t badge_min_height() const {
    return data_->badge_min_height;
  }
  uint32_t badge_radius() const {
    return data_->badge_radius;
  }
  inline void GetIphDotColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIphDotColor(UserType* output) {
    
    auto* pointer = data_->iph_dot_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
 private:
  internal::MenuControllerParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContextMenuDataView {
 public:
  ContextMenuDataView() = default;

  ContextMenuDataView(
      internal::ContextMenu_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemsDataView(
      mojo::ArrayDataView<MenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::remote_cocoa::mojom::MenuItemDataView>>(
        pointer, output, message_);
  }
  inline void GetAnchorDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnchor(UserType* output) {
    
    auto* pointer = data_->anchor.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  uint64_t target_view_id() const {
    return data_->target_view_id;
  }
  inline void GetParamsDataView(
      MenuControllerParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::remote_cocoa::mojom::MenuControllerParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContextMenu_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MenuItemDataView {
 public:
  using Tag = internal::MenuItem_Data::MenuItem_Tag;

  MenuItemDataView() = default;

  MenuItemDataView(
      internal::MenuItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_separator() const { return data_->tag == Tag::kSeparator; }
  inline void GetSeparatorDataView(
      MenuItemCommonFieldsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSeparator(UserType* output) const {
    
    CHECK(is_separator());
    return mojo::internal::Deserialize<::remote_cocoa::mojom::MenuItemCommonFieldsDataView>(
        data_->data.f_separator.Get(), output, message_);
  }
  bool is_regular() const { return data_->tag == Tag::kRegular; }
  inline void GetRegularDataView(
      MenuItemCommonFieldsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRegular(UserType* output) const {
    
    CHECK(is_regular());
    return mojo::internal::Deserialize<::remote_cocoa::mojom::MenuItemCommonFieldsDataView>(
        data_->data.f_regular.Get(), output, message_);
  }
  bool is_submenu() const { return data_->tag == Tag::kSubmenu; }
  inline void GetSubmenuDataView(
      SubmenuMenuItemDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSubmenu(UserType* output) const {
    
    CHECK(is_submenu());
    return mojo::internal::Deserialize<::remote_cocoa::mojom::SubmenuMenuItemDataView>(
        data_->data.f_submenu.Get(), output, message_);
  }

 private:
  internal::MenuItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // remote_cocoa::mojom

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_DATA_VIEW_H_