// components/remote_cocoa/common/font.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_SHARED_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/remote_cocoa/common/font.mojom-shared-internal.h"




#include "components/remote_cocoa/common/font.mojom-data-view.h"




namespace std {

template <>
struct hash<::remote_cocoa::mojom::SystemFont>
    : public mojo::internal::EnumHashImpl<::remote_cocoa::mojom::SystemFont> {};

template <>
struct hash<::remote_cocoa::mojom::FontWeight>
    : public mojo::internal::EnumHashImpl<::remote_cocoa::mojom::FontWeight> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::SystemFont, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::remote_cocoa::mojom::SystemFont, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::remote_cocoa::mojom::SystemFont>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::FontWeight, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::remote_cocoa::mojom::FontWeight, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::remote_cocoa::mojom::FontWeight>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::FontDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::remote_cocoa::mojom::FontDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::remote_cocoa::mojom::internal::Font_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<decltype(fragment->name)>
        name_fragment(fragment.message());
    name_fragment.Claim(&fragment->name);
    
    mojo::internal::Serialize<::remote_cocoa::mojom::FontNameDataView>(
      in_name,
      name_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in Font struct");

    fragment->size = Traits::size(input);

    fragment->style = Traits::style(input);

    
    mojo::internal::Serialize<::remote_cocoa::mojom::FontWeight>(
      Traits::weight(input),
      &fragment->weight);
  }

  static bool Deserialize(::remote_cocoa::mojom::internal::Font_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::remote_cocoa::mojom::FontDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::remote_cocoa::mojom::FontNameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::remote_cocoa::mojom::FontNameDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::remote_cocoa::mojom::internal::FontName_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::remote_cocoa::mojom::FontNameDataView::Tag::kSystemFont: {
    decltype(Traits::system_font(input))
    in_system_font = Traits::system_font(input);
        
mojo::internal::Serialize<::remote_cocoa::mojom::SystemFont>(
  in_system_font,
  &fragment->data.f_system_font);
    break;
  }
  case ::remote_cocoa::mojom::FontNameDataView::Tag::kRegularFont: {
    decltype(Traits::regular_font(input))
    in_regular_font = Traits::regular_font(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_regular_font)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_regular_font,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null regular_font in FontName union");
    fragment->data.f_regular_font.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::remote_cocoa::mojom::internal::FontName_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::remote_cocoa::mojom::FontNameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace remote_cocoa::mojom {

inline void FontDataView::GetNameDataView(
    FontNameDataView* output) {
  auto pointer = &data_->name;
  *output = FontNameDataView(pointer, message_);
}


inline void FontNameDataView::GetRegularFontDataView(
    mojo::StringDataView* output) const {
  CHECK(is_regular_font());
  *output = mojo::StringDataView(data_->data.f_regular_font.Get(), message_);
}


}  // remote_cocoa::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::remote_cocoa::mojom::SystemFont> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::remote_cocoa::mojom::SystemFont value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::remote_cocoa::mojom::FontWeight> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::remote_cocoa::mojom::FontWeight value);
};

} // namespace perfetto

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_SHARED_H_