// components/remote_cocoa/common/font.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/remote_cocoa/common/font.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/font.mojom-params-data.h"
namespace remote_cocoa {
namespace mojom {

NOINLINE static const char* SystemFontToStringHelper(SystemFont value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SystemFont::kGeneral:
      return "kGeneral";
    case SystemFont::kMenu:
      return "kMenu";
    case SystemFont::kToolTip:
      return "kToolTip";
    default:
      return nullptr;
  }
}

std::string SystemFontToString(SystemFont value) {
  const char *str = SystemFontToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SystemFont value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SystemFont value) {
  return os << SystemFontToString(value);
}

NOINLINE static const char* FontWeightToStringHelper(FontWeight value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FontWeight::kThin:
      return "kThin";
    case FontWeight::kExtraLight:
      return "kExtraLight";
    case FontWeight::kLight:
      return "kLight";
    case FontWeight::kNormal:
      return "kNormal";
    case FontWeight::kMedium:
      return "kMedium";
    case FontWeight::kSemibold:
      return "kSemibold";
    case FontWeight::kBold:
      return "kBold";
    case FontWeight::kExtraBold:
      return "kExtraBold";
    case FontWeight::kBlack:
      return "kBlack";
    default:
      return nullptr;
  }
}

std::string FontWeightToString(FontWeight value) {
  const char *str = FontWeightToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FontWeight value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FontWeight value) {
  return os << FontWeightToString(value);
}

namespace internal {
// static
bool FontName_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const FontName_Data* object = static_cast<const FontName_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case FontName_Tag::kSystemFont: {


      if (!::remote_cocoa::mojom::internal::SystemFont_Data
            ::Validate(object->data.f_system_font, validation_context))
        return false;
      return true;
    }
    case FontName_Tag::kRegularFont: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_regular_font, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& regular_font_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_regular_font, validation_context,
                                             &regular_font_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in FontName");
      return false;
    }
  }
}


// static
bool Font_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Font_Data* object =
      static_cast<const Font_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->name, validation_context))
    return false;


  if (!::remote_cocoa::mojom::internal::FontWeight_Data
        ::Validate(object->weight, validation_context))
    return false;

  return true;
}

Font_Data::Font_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace remote_cocoa

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::SystemFont>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::SystemFont value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::SystemFontToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::FontWeight>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::FontWeight value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::FontWeightToString(value));
}

} // namespace perfetto