// components/printing/common/print.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_TEST_UTILS_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_TEST_UTILS_H_

#include "components/printing/common/print.mojom.h"


namespace printing::mojom {


class  PrintPreviewUIInterceptorForTesting : public PrintPreviewUI {
  virtual PrintPreviewUI* GetForwardingInterface() = 0;
  void SetOptionsFromDocument(OptionsFromDocumentParamsPtr params, int32_t request_id) override;
  void DidPrepareDocumentForPreview(int32_t document_cookie, int32_t request_id) override;
  void DidPreviewPage(DidPreviewPageParamsPtr params, int32_t request_id) override;
  void MetafileReadyForPrinting(DidPreviewDocumentParamsPtr params, int32_t request_id) override;
  void PrintPreviewFailed(int32_t document_cookie, int32_t request_id) override;
  void PrintPreviewCancelled(int32_t document_cookie, int32_t request_id) override;
  void PrinterSettingsInvalid(int32_t document_cookie, int32_t request_id) override;
  void DidGetDefaultPageLayout(::printing::mojom::PageSizeMarginsPtr page_layout_in_points, const ::gfx::RectF& printable_area_in_points, bool all_pages_have_custom_size, bool all_pages_have_custom_orientation, int32_t request_id) override;
  void DidStartPreview(DidStartPreviewParamsPtr params, int32_t request_id) override;
};
class  PrintPreviewUIAsyncWaiter {
 public:
  explicit PrintPreviewUIAsyncWaiter(PrintPreviewUI* proxy);

  PrintPreviewUIAsyncWaiter(const PrintPreviewUIAsyncWaiter&) = delete;
  PrintPreviewUIAsyncWaiter& operator=(const PrintPreviewUIAsyncWaiter&) = delete;

  ~PrintPreviewUIAsyncWaiter();

 private:
  PrintPreviewUI* const proxy_;
};


class  PrintRenderFrameInterceptorForTesting : public PrintRenderFrame {
  virtual PrintRenderFrame* GetForwardingInterface() = 0;
  void PrintRequestedPages() override;
  void PrintWithParams(PrintPagesParamsPtr params, PrintWithParamsCallback callback) override;
  void PrintForSystemDialog() override;
  void InitiatePrintPreview(bool has_selection) override;
  void SetPrintPreviewUI(::mojo::PendingAssociatedRemote<PrintPreviewUI> preview) override;
  void PrintPreview(::base::Value::Dict settings) override;
  void OnPrintPreviewDialogClosed() override;
  void PrintFrameContent(PrintFrameContentParamsPtr params, PrintFrameContentCallback callback) override;
  void ConnectToPdfRenderer() override;
  void PrintingDone(bool success) override;
  void PrintNodeUnderContextMenu() override;
};
class  PrintRenderFrameAsyncWaiter {
 public:
  explicit PrintRenderFrameAsyncWaiter(PrintRenderFrame* proxy);

  PrintRenderFrameAsyncWaiter(const PrintRenderFrameAsyncWaiter&) = delete;
  PrintRenderFrameAsyncWaiter& operator=(const PrintRenderFrameAsyncWaiter&) = delete;

  ~PrintRenderFrameAsyncWaiter();
  void PrintWithParams(
      PrintPagesParamsPtr params,
base::expected<
  PrintWithParamsResultDataPtr,
  PrintFailureReason>* out_result);
  PrintRenderFrame_PrintWithParams_ResponseParam_ResultPtr PrintWithParams(PrintPagesParamsPtr params);
  void PrintFrameContent(
      PrintFrameContentParamsPtr params, int32_t* out_document_cookie, DidPrintContentParamsPtr* out_params);
  

 private:
  PrintRenderFrame* const proxy_;
};


class  PrintManagerHostInterceptorForTesting : public PrintManagerHost {
  virtual PrintManagerHost* GetForwardingInterface() = 0;
  void DidGetPrintedPagesCount(int32_t cookie, uint32_t number_pages) override;
  void GetDefaultPrintSettings(GetDefaultPrintSettingsCallback callback) override;
  void DidShowPrintDialog() override;
  void DidPrintDocument(DidPrintDocumentParamsPtr params, DidPrintDocumentCallback callback) override;
  void IsPrintingEnabled(IsPrintingEnabledCallback callback) override;
  void ScriptedPrint(ScriptedPrintParamsPtr params, ScriptedPrintCallback callback) override;
  void PrintingFailed(int32_t cookie, PrintFailureReason reason) override;
  void UpdatePrintSettings(::base::Value::Dict job_settings, UpdatePrintSettingsCallback callback) override;
  void SetupScriptedPrintPreview(SetupScriptedPrintPreviewCallback callback) override;
  void ShowScriptedPrintPreview(bool is_modifiable) override;
  void RequestPrintPreview(RequestPrintPreviewParamsPtr params) override;
  void CheckForCancel(int32_t preview_ui_id, int32_t request_id, CheckForCancelCallback callback) override;
  void SetAccessibilityTree(int32_t cookie, const ::ui::AXTreeUpdate& accessibility_tree) override;
};
class  PrintManagerHostAsyncWaiter {
 public:
  explicit PrintManagerHostAsyncWaiter(PrintManagerHost* proxy);

  PrintManagerHostAsyncWaiter(const PrintManagerHostAsyncWaiter&) = delete;
  PrintManagerHostAsyncWaiter& operator=(const PrintManagerHostAsyncWaiter&) = delete;

  ~PrintManagerHostAsyncWaiter();
  void GetDefaultPrintSettings(
      PrintParamsPtr* out_default_settings);
  PrintParamsPtr GetDefaultPrintSettings();
  void DidPrintDocument(
      DidPrintDocumentParamsPtr params, bool* out_completed);
  bool DidPrintDocument(DidPrintDocumentParamsPtr params);
  void IsPrintingEnabled(
      bool* out_printing_enabled);
  bool IsPrintingEnabled();
  void ScriptedPrint(
      ScriptedPrintParamsPtr params, PrintPagesParamsPtr* out_settings);
  PrintPagesParamsPtr ScriptedPrint(ScriptedPrintParamsPtr params);
  void UpdatePrintSettings(
      ::base::Value::Dict job_settings, PrintPagesParamsPtr* out_current_settings);
  PrintPagesParamsPtr UpdatePrintSettings(::base::Value::Dict job_settings);
  void SetupScriptedPrintPreview(
      );
  
  void CheckForCancel(
      int32_t preview_ui_id, int32_t request_id, bool* out_cancel);
  bool CheckForCancel(int32_t preview_ui_id, int32_t request_id);

 private:
  PrintManagerHost* const proxy_;
};




}  // printing::mojom

#endif  // COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_TEST_UTILS_H_