// components/persistent_cache/mojom/persistent_cache.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_H_
#define COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/persistent_cache/mojom/persistent_cache.mojom-features.h"  // IWYU pragma: export
#include "components/persistent_cache/mojom/persistent_cache.mojom-shared.h"  // IWYU pragma: export
#include "components/persistent_cache/mojom/persistent_cache.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/persistent_cache/mojom/persistent_cache_mojom_traits.h"




namespace persistent_cache::mojom {








class  ReadWriteBackendParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadWriteBackendParams, T>::value>;
  using DataView = ReadWriteBackendParamsDataView;
  using Data_ = internal::ReadWriteBackendParams_Data;

  template <typename... Args>
  static ReadWriteBackendParamsPtr New(Args&&... args) {
    return ReadWriteBackendParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadWriteBackendParamsPtr From(const U& u) {
    return mojo::TypeConverter<ReadWriteBackendParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadWriteBackendParams>::Convert(*this);
  }


  ReadWriteBackendParams();

  ReadWriteBackendParams(
      ::base::File db_file,
      ::base::File journal_file,
      ::base::UnsafeSharedMemoryRegion shared_lock);

ReadWriteBackendParams(const ReadWriteBackendParams&) = delete;
ReadWriteBackendParams& operator=(const ReadWriteBackendParams&) = delete;

  ~ReadWriteBackendParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadWriteBackendParamsPtr>
  ReadWriteBackendParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadWriteBackendParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadWriteBackendParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadWriteBackendParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadWriteBackendParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadWriteBackendParams_UnserializedMessageContext<
            UserType, ReadWriteBackendParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadWriteBackendParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadWriteBackendParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadWriteBackendParams_UnserializedMessageContext<
            UserType, ReadWriteBackendParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadWriteBackendParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::File db_file;
  
  ::base::File journal_file;
  
  ::base::UnsafeSharedMemoryRegion shared_lock;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadWriteBackendParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadWriteBackendParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadWriteBackendParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadWriteBackendParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ReadWriteBackendParamsPtr ReadWriteBackendParams::Clone() const {
  return New(
      mojo::Clone(db_file),
      mojo::Clone(journal_file),
      mojo::Clone(shared_lock)
  );
}

template <typename T, ReadWriteBackendParams::EnableIfSame<T>*>
bool ReadWriteBackendParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->db_file, other_struct.db_file))
    return false;
  if (!mojo::Equals(this->journal_file, other_struct.journal_file))
    return false;
  if (!mojo::Equals(this->shared_lock, other_struct.shared_lock))
    return false;
  return true;
}

template <typename T, ReadWriteBackendParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.db_file < rhs.db_file)
    return true;
  if (rhs.db_file < lhs.db_file)
    return false;
  if (lhs.journal_file < rhs.journal_file)
    return true;
  if (rhs.journal_file < lhs.journal_file)
    return false;
  if (lhs.shared_lock < rhs.shared_lock)
    return true;
  if (rhs.shared_lock < lhs.shared_lock)
    return false;
  return false;
}


}  // persistent_cache::mojom

namespace mojo {


template <>
struct  StructTraits<::persistent_cache::mojom::ReadWriteBackendParams::DataView,
                                         ::persistent_cache::mojom::ReadWriteBackendParamsPtr> {
  static bool IsNull(const ::persistent_cache::mojom::ReadWriteBackendParamsPtr& input) { return !input; }
  static void SetToNull(::persistent_cache::mojom::ReadWriteBackendParamsPtr* output) { output->reset(); }

  static  decltype(::persistent_cache::mojom::ReadWriteBackendParams::db_file)& db_file(
       ::persistent_cache::mojom::ReadWriteBackendParamsPtr& input) {
    return input->db_file;
  }

  static  decltype(::persistent_cache::mojom::ReadWriteBackendParams::journal_file)& journal_file(
       ::persistent_cache::mojom::ReadWriteBackendParamsPtr& input) {
    return input->journal_file;
  }

  static  decltype(::persistent_cache::mojom::ReadWriteBackendParams::shared_lock)& shared_lock(
       ::persistent_cache::mojom::ReadWriteBackendParamsPtr& input) {
    return input->shared_lock;
  }

  static bool Read(::persistent_cache::mojom::ReadWriteBackendParams::DataView input, ::persistent_cache::mojom::ReadWriteBackendParamsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_H_