// components/persistent_cache/mojom/persistent_cache.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_SEND_VALIDATION_H_

#include "components/persistent_cache/mojom/persistent_cache.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"

#include "components/persistent_cache/mojom/persistent_cache.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::persistent_cache::mojom::ReadWriteBackendParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::persistent_cache::mojom::ReadWriteBackendParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::persistent_cache::mojom::internal::ReadWriteBackendParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::db_file(input)) in_db_file = Traits::db_file(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->db_file)::BaseType> db_file_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FileDataView, send_validation>(
        in_db_file,
        db_file_fragment);

      fragment->db_file.Set(
          db_file_fragment.is_null() ? nullptr : db_file_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->db_file.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null db_file in ReadWriteBackendParams struct");

      decltype(Traits::journal_file(input)) in_journal_file = Traits::journal_file(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->journal_file)::BaseType> journal_file_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FileDataView, send_validation>(
        in_journal_file,
        journal_file_fragment);

      fragment->journal_file.Set(
          journal_file_fragment.is_null() ? nullptr : journal_file_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->journal_file.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null journal_file in ReadWriteBackendParams struct");

      decltype(Traits::shared_lock(input)) in_shared_lock = Traits::shared_lock(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shared_lock)::BaseType> shared_lock_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView, send_validation>(
        in_shared_lock,
        shared_lock_fragment);

      fragment->shared_lock.Set(
          shared_lock_fragment.is_null() ? nullptr : shared_lock_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->shared_lock.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shared_lock in ReadWriteBackendParams struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_SEND_VALIDATION_H_