// components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/password_manager/services/csv_password/public/mojom/csv_password_parser.mojom-params-data.h"
namespace password_manager {
namespace mojom {

NOINLINE static const char* CSVPassword_StatusToStringHelper(CSVPassword_Status value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CSVPassword_Status::kOK:
      return "kOK";
    case CSVPassword_Status::kSyntaxError:
      return "kSyntaxError";
    case CSVPassword_Status::kSemanticError:
      return "kSemanticError";
    default:
      return nullptr;
  }
}

std::string CSVPassword_StatusToString(CSVPassword_Status value) {
  const char *str = CSVPassword_StatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CSVPassword_Status value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CSVPassword_Status value) {
  return os << CSVPassword_StatusToString(value);
}

namespace internal {


// static
bool CSVPasswordSequence_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CSVPasswordSequence_Data* object =
      static_cast<const CSVPasswordSequence_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->csv_passwords, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& csv_passwords_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->csv_passwords, validation_context,
                                         &csv_passwords_validate_params)) {
    return false;
  }

  return true;
}

CSVPasswordSequence_Data::CSVPasswordSequence_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSVPassword_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CSVPassword_Data* object =
      static_cast<const CSVPassword_Data*>(data);


  if (!::password_manager::mojom::internal::CSVPassword_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& username_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->username, validation_context,
                                         &username_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& password_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->password, validation_context,
                                         &password_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->note, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& note_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->note, validation_context,
                                         &note_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& invalid_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->invalid_url, validation_context,
                                         &invalid_url_validate_params)) {
    return false;
  }

  return true;
}

CSVPassword_Data::CSVPassword_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSVPasswordParser_ParseCSV_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CSVPasswordParser_ParseCSV_Params_Data* object =
      static_cast<const CSVPasswordParser_ParseCSV_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_csv, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& raw_csv_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_csv, validation_context,
                                         &raw_csv_validate_params)) {
    return false;
  }

  return true;
}

CSVPasswordParser_ParseCSV_Params_Data::CSVPasswordParser_ParseCSV_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSVPasswordParser_ParseCSV_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CSVPasswordParser_ParseCSV_ResponseParams_Data* object =
      static_cast<const CSVPasswordParser_ParseCSV_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->sequence, validation_context))
    return false;

  return true;
}

CSVPasswordParser_ParseCSV_ResponseParams_Data::CSVPasswordParser_ParseCSV_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace password_manager

namespace perfetto {

// static
void TraceFormatTraits<::password_manager::mojom::CSVPassword_Status>::WriteIntoTrace(
   perfetto::TracedValue context, ::password_manager::mojom::CSVPassword_Status value) {
  return std::move(context).WriteString(::password_manager::mojom::CSVPassword_StatusToString(value));
}

} // namespace perfetto