// components/paint_preview/common/mojom/paint_preview_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-features.h"  // IWYU pragma: export
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared.h"  // IWYU pragma: export
#include "components/paint_preview/common/mojom/paint_preview_types.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/paint_preview/common/mojom/paint_preview_types_mojom_traits.h"




namespace paint_preview::mojom {





class  SerializedRecording {
 public:
  using DataView = SerializedRecordingDataView;
  using Data_ = internal::SerializedRecording_Data;
  using Tag = Data_::SerializedRecording_Tag;

  template <typename... Args>
  static SerializedRecordingPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |file|.
  static SerializedRecordingPtr NewFile(
      ::base::File value);
  // Construct an instance holding |buffer|.
  static SerializedRecordingPtr NewBuffer(
      ::mojo_base::BigBuffer value);

  template <typename U>
  static SerializedRecordingPtr From(const U& u) {
    return mojo::TypeConverter<SerializedRecordingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerializedRecording>::Convert(*this);
  }
  ~SerializedRecording();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SerializedRecording(const SerializedRecording& other) = delete;
  SerializedRecording& operator=(const SerializedRecording& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SerializedRecordingPtr>
  SerializedRecordingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SerializedRecording>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SerializedRecording>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_file() const { return tag_ == Tag::kFile; }
  const ::base::File& get_file() const {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  ::base::File& get_file() {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  void set_file(::base::File file);

  bool is_buffer() const { return tag_ == Tag::kBuffer; }
  const ::mojo_base::BigBuffer& get_buffer() const {
    CHECK(tag_ == Tag::kBuffer);
    return data_.buffer;
  }
  ::mojo_base::BigBuffer& get_buffer() {
    CHECK(tag_ == Tag::kBuffer);
    return data_.buffer;
  }
  void set_buffer(::mojo_base::BigBuffer buffer);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerializedRecording::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SerializedRecording::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
        ::base::File value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBuffer)>,
        ::mojo_base::BigBuffer value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::base::File file;
    ::mojo_base::BigBuffer buffer;
  };

  SerializedRecording(
      std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
      ::base::File value);
  SerializedRecording(
      std::in_place_index_t<static_cast<size_t>(Tag::kBuffer)>,
      ::mojo_base::BigBuffer value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
SerializedRecordingPtr SerializedRecording::Clone() const {
  switch (tag_) {
    case Tag::kFile:
      return NewFile(
          mojo::Clone(data_.file));
    case Tag::kBuffer:
      return NewBuffer(
          mojo::Clone(data_.buffer));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SerializedRecording>::value>::type*>
bool SerializedRecording::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFile:
      return mojo::Equals(data_.file, other.data_.file);
    case Tag::kBuffer:
      return mojo::Equals(data_.buffer, other.data_.buffer);
  }

  return false;
}


}  // paint_preview::mojom

namespace mojo {


template <>
struct  UnionTraits<::paint_preview::mojom::SerializedRecording::DataView,
                                        ::paint_preview::mojom::SerializedRecordingPtr> {
  static bool IsNull(const ::paint_preview::mojom::SerializedRecordingPtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::SerializedRecordingPtr* output) { output->reset(); }

  static ::paint_preview::mojom::SerializedRecording::Tag GetTag(const ::paint_preview::mojom::SerializedRecordingPtr& input) {
    return input->which();
  }

  static  ::base::File& file( ::paint_preview::mojom::SerializedRecordingPtr& input) {
    return input->get_file();
  }

  static  ::mojo_base::BigBuffer& buffer( ::paint_preview::mojom::SerializedRecordingPtr& input) {
    return input->get_buffer();
  }

  static bool Read(::paint_preview::mojom::SerializedRecording::DataView input, ::paint_preview::mojom::SerializedRecordingPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_H_