// components/paint_preview/common/mojom/paint_preview_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_SHARED_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/paint_preview/common/mojom/paint_preview_types.mojom-data-view.h"




namespace std {

template <>
struct hash<::paint_preview::mojom::RecordingPersistence>
    : public mojo::internal::EnumHashImpl<::paint_preview::mojom::RecordingPersistence> {};

template <>
struct hash<::paint_preview::mojom::ClipCoordOverride>
    : public mojo::internal::EnumHashImpl<::paint_preview::mojom::ClipCoordOverride> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::RecordingPersistence, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::paint_preview::mojom::RecordingPersistence, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::paint_preview::mojom::RecordingPersistence>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::ClipCoordOverride, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::paint_preview::mojom::ClipCoordOverride, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::paint_preview::mojom::ClipCoordOverride>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::paint_preview::mojom::SerializedRecordingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::paint_preview::mojom::SerializedRecordingDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::paint_preview::mojom::internal::SerializedRecording_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::paint_preview::mojom::SerializedRecordingDataView::Tag::kFile: {
    decltype(Traits::file(input))
    in_file = Traits::file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
  in_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file in SerializedRecording union");
    fragment->data.f_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::paint_preview::mojom::SerializedRecordingDataView::Tag::kBuffer: {
    decltype(Traits::buffer(input))
    in_buffer = Traits::buffer(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_buffer)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
  in_buffer,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null buffer in SerializedRecording union");
    fragment->data.f_buffer.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::paint_preview::mojom::internal::SerializedRecording_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::paint_preview::mojom::SerializedRecordingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace paint_preview::mojom {

inline void SerializedRecordingDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) const {
  CHECK(is_file());
  *output = ::mojo_base::mojom::FileDataView(data_->data.f_file.Get(), message_);
}
inline void SerializedRecordingDataView::GetBufferDataView(
    ::mojo_base::mojom::BigBufferDataView* output) const {
  CHECK(is_buffer());
  *output = ::mojo_base::mojom::BigBufferDataView(data_->data.f_buffer.Get(), message_);
}


}  // paint_preview::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::paint_preview::mojom::RecordingPersistence> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::paint_preview::mojom::RecordingPersistence value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::paint_preview::mojom::ClipCoordOverride> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::paint_preview::mojom::ClipCoordOverride value);
};

} // namespace perfetto

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_TYPES_MOJOM_SHARED_H_