// components/paint_preview/common/mojom/paint_preview_recorder.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-features.h"  // IWYU pragma: export
#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared.h"  // IWYU pragma: export
#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-forward.h"  // IWYU pragma: export
#include "components/paint_preview/common/mojom/paint_preview_types.mojom.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"




namespace paint_preview::mojom {

class PaintPreviewRecorderProxy;

template <typename ImplRefTraits>
class PaintPreviewRecorderStub;

class PaintPreviewRecorderRequestValidator;
class PaintPreviewRecorderResponseValidator;


class PaintPreviewRecorder
    : public PaintPreviewRecorderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "paint_preview.mojom.PaintPreviewRecorder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PaintPreviewRecorderInterfaceBase;
  using Proxy_ = PaintPreviewRecorderProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaintPreviewRecorderStub<ImplRefTraits>;

  using RequestValidator_ = PaintPreviewRecorderRequestValidator;
  using ResponseValidator_ = PaintPreviewRecorderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCapturePaintPreviewMinVersion = 0,
    kGetGeometryMetadataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CapturePaintPreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetGeometryMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PaintPreviewRecorder() = default;

  using CapturePaintPreviewCallback = base::OnceCallback<void(base::expected<
  PaintPreviewCaptureResponsePtr,
  PaintPreviewStatus>)>;
  using CapturePaintPreviewResult = base::expected<
  PaintPreviewCaptureResponsePtr,
  PaintPreviewStatus>;
  using CapturePaintPreviewMojoCallback = base::OnceCallback<void(PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr)>;

  virtual void CapturePaintPreview(PaintPreviewCaptureParamsPtr params, CapturePaintPreviewCallback callback) = 0;

  using GetGeometryMetadataCallback = base::OnceCallback<void(GeometryMetadataResponsePtr)>;
  using GetGeometryMetadataMojoCallback = base::OnceCallback<void(GeometryMetadataResponsePtr)>;

  virtual void GetGeometryMetadata(GeometryMetadataParamsPtr params, GetGeometryMetadataCallback callback) = 0;
};



class  PaintPreviewRecorderProxy
    : public PaintPreviewRecorder {
 public:
  using InterfaceType = PaintPreviewRecorder;

  explicit PaintPreviewRecorderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CapturePaintPreview(PaintPreviewCaptureParamsPtr params, CapturePaintPreviewCallback callback) final;
  
  void GetGeometryMetadata(GeometryMetadataParamsPtr params, GetGeometryMetadataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PaintPreviewRecorderStubDispatch {
 public:
  static bool Accept(PaintPreviewRecorder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaintPreviewRecorder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaintPreviewRecorder>>
class PaintPreviewRecorderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaintPreviewRecorderStub() = default;
  ~PaintPreviewRecorderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaintPreviewRecorderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaintPreviewRecorderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PaintPreviewRecorderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PaintPreviewRecorderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result {
 public:
  using DataView = PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultDataView;
  using Data_ = internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Data;
  using Tag = Data_::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result_Tag;

  template <typename... Args>
  static PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr NewSuccess(
      PaintPreviewCaptureResponsePtr value);
  // Construct an instance holding |failure|.
  static PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr NewFailure(
      PaintPreviewStatus value);

  template <typename U>
  static PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result>::Convert(*this);
  }
  ~PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result(const PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result& other) = delete;
  PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result& operator=(const PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr>
  PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const PaintPreviewCaptureResponsePtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  PaintPreviewCaptureResponsePtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(PaintPreviewCaptureResponsePtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  PaintPreviewStatus get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(PaintPreviewStatus failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        PaintPreviewCaptureResponsePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        PaintPreviewStatus value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    PaintPreviewCaptureResponsePtr success;
    PaintPreviewStatus failure;
  };

  PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      PaintPreviewCaptureResponsePtr value);
  PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      PaintPreviewStatus value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  PaintPreviewCaptureParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaintPreviewCaptureParams, T>::value>;
  using DataView = PaintPreviewCaptureParamsDataView;
  using Data_ = internal::PaintPreviewCaptureParams_Data;

  template <typename... Args>
  static PaintPreviewCaptureParamsPtr New(Args&&... args) {
    return PaintPreviewCaptureParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaintPreviewCaptureParamsPtr From(const U& u) {
    return mojo::TypeConverter<PaintPreviewCaptureParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaintPreviewCaptureParams>::Convert(*this);
  }


  PaintPreviewCaptureParams();

  PaintPreviewCaptureParams(
      ::paint_preview::RecordingPersistence persistence,
      const ::base::UnguessableToken& guid,
      GeometryMetadataParamsPtr geometry_metadata_params,
      bool is_main_frame,
      bool capture_links,
      ::base::File file,
      uint64_t max_capture_size,
      uint64_t max_decoded_image_size_bytes,
      bool skip_accelerated_content);

PaintPreviewCaptureParams(const PaintPreviewCaptureParams&) = delete;
PaintPreviewCaptureParams& operator=(const PaintPreviewCaptureParams&) = delete;

  ~PaintPreviewCaptureParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaintPreviewCaptureParamsPtr>
  PaintPreviewCaptureParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaintPreviewCaptureParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaintPreviewCaptureParams_UnserializedMessageContext<
            UserType, PaintPreviewCaptureParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaintPreviewCaptureParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaintPreviewCaptureParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaintPreviewCaptureParams_UnserializedMessageContext<
            UserType, PaintPreviewCaptureParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaintPreviewCaptureParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::paint_preview::RecordingPersistence persistence;
  
  ::base::UnguessableToken guid;
  
  GeometryMetadataParamsPtr geometry_metadata_params;
  
  bool is_main_frame;
  
  bool capture_links;
  
  ::base::File file;
  
  uint64_t max_capture_size;
  
  uint64_t max_decoded_image_size_bytes;
  
  bool skip_accelerated_content;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LinkData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LinkData, T>::value>;
  using DataView = LinkDataDataView;
  using Data_ = internal::LinkData_Data;

  template <typename... Args>
  static LinkDataPtr New(Args&&... args) {
    return LinkDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LinkDataPtr From(const U& u) {
    return mojo::TypeConverter<LinkDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LinkData>::Convert(*this);
  }


  LinkData();

  LinkData(
      const ::GURL& url,
      const ::gfx::Rect& rect);


  ~LinkData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LinkDataPtr>
  LinkDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LinkData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LinkData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LinkData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LinkData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LinkData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LinkData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LinkData_UnserializedMessageContext<
            UserType, LinkData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LinkData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LinkData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LinkData_UnserializedMessageContext<
            UserType, LinkData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LinkData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::gfx::Rect rect;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LinkData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LinkData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LinkData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LinkData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PaintPreviewCaptureResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaintPreviewCaptureResponse, T>::value>;
  using DataView = PaintPreviewCaptureResponseDataView;
  using Data_ = internal::PaintPreviewCaptureResponse_Data;

  template <typename... Args>
  static PaintPreviewCaptureResponsePtr New(Args&&... args) {
    return PaintPreviewCaptureResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaintPreviewCaptureResponsePtr From(const U& u) {
    return mojo::TypeConverter<PaintPreviewCaptureResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaintPreviewCaptureResponse>::Convert(*this);
  }


  PaintPreviewCaptureResponse();

  PaintPreviewCaptureResponse(
      const std::optional<::base::UnguessableToken>& embedding_token,
      const base::flat_map<uint32_t, ::base::UnguessableToken>& content_id_to_embedding_token,
      std::vector<LinkDataPtr> links,
      ::base::TimeDelta blink_recording_time,
      uint64_t serialized_size,
      GeometryMetadataResponsePtr geometry_metadata,
      std::optional<::mojo_base::BigBuffer> skp);

PaintPreviewCaptureResponse(const PaintPreviewCaptureResponse&) = delete;
PaintPreviewCaptureResponse& operator=(const PaintPreviewCaptureResponse&) = delete;

  ~PaintPreviewCaptureResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaintPreviewCaptureResponsePtr>
  PaintPreviewCaptureResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaintPreviewCaptureResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaintPreviewCaptureResponse_UnserializedMessageContext<
            UserType, PaintPreviewCaptureResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PaintPreviewCaptureResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PaintPreviewCaptureResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaintPreviewCaptureResponse_UnserializedMessageContext<
            UserType, PaintPreviewCaptureResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaintPreviewCaptureResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::UnguessableToken> embedding_token;
  
  base::flat_map<uint32_t, ::base::UnguessableToken> content_id_to_embedding_token;
  
  std::vector<LinkDataPtr> links;
  
  ::base::TimeDelta blink_recording_time;
  
  uint64_t serialized_size;
  
  GeometryMetadataResponsePtr geometry_metadata;
  
  std::optional<::mojo_base::BigBuffer> skp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GeometryMetadataParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GeometryMetadataParams, T>::value>;
  using DataView = GeometryMetadataParamsDataView;
  using Data_ = internal::GeometryMetadataParams_Data;

  template <typename... Args>
  static GeometryMetadataParamsPtr New(Args&&... args) {
    return GeometryMetadataParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GeometryMetadataParamsPtr From(const U& u) {
    return mojo::TypeConverter<GeometryMetadataParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GeometryMetadataParams>::Convert(*this);
  }


  GeometryMetadataParams();

  GeometryMetadataParams(
      const ::gfx::Rect& clip_rect,
      ::paint_preview::mojom::ClipCoordOverride clip_x_coord_override,
      ::paint_preview::mojom::ClipCoordOverride clip_y_coord_override,
      bool clip_rect_is_hint);


  ~GeometryMetadataParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GeometryMetadataParamsPtr>
  GeometryMetadataParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GeometryMetadataParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GeometryMetadataParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GeometryMetadataParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GeometryMetadataParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GeometryMetadataParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GeometryMetadataParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GeometryMetadataParams_UnserializedMessageContext<
            UserType, GeometryMetadataParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GeometryMetadataParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GeometryMetadataParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GeometryMetadataParams_UnserializedMessageContext<
            UserType, GeometryMetadataParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GeometryMetadataParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect clip_rect;
  
  ::paint_preview::mojom::ClipCoordOverride clip_x_coord_override;
  
  ::paint_preview::mojom::ClipCoordOverride clip_y_coord_override;
  
  bool clip_rect_is_hint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GeometryMetadataParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GeometryMetadataParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GeometryMetadataParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GeometryMetadataParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GeometryMetadataResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GeometryMetadataResponse, T>::value>;
  using DataView = GeometryMetadataResponseDataView;
  using Data_ = internal::GeometryMetadataResponse_Data;

  template <typename... Args>
  static GeometryMetadataResponsePtr New(Args&&... args) {
    return GeometryMetadataResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GeometryMetadataResponsePtr From(const U& u) {
    return mojo::TypeConverter<GeometryMetadataResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GeometryMetadataResponse>::Convert(*this);
  }


  GeometryMetadataResponse();

  GeometryMetadataResponse(
      const ::gfx::Point& scroll_offsets,
      const ::gfx::Point& frame_offsets);


  ~GeometryMetadataResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GeometryMetadataResponsePtr>
  GeometryMetadataResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GeometryMetadataResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GeometryMetadataResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GeometryMetadataResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GeometryMetadataResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GeometryMetadataResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GeometryMetadataResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GeometryMetadataResponse_UnserializedMessageContext<
            UserType, GeometryMetadataResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GeometryMetadataResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GeometryMetadataResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GeometryMetadataResponse_UnserializedMessageContext<
            UserType, GeometryMetadataResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GeometryMetadataResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Point scroll_offsets;
  
  ::gfx::Point frame_offsets;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GeometryMetadataResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GeometryMetadataResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GeometryMetadataResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GeometryMetadataResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result>::value>::type*>
bool PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
PaintPreviewCaptureParamsPtr PaintPreviewCaptureParams::Clone() const {
  return New(
      mojo::Clone(persistence),
      mojo::Clone(guid),
      mojo::Clone(geometry_metadata_params),
      mojo::Clone(is_main_frame),
      mojo::Clone(capture_links),
      mojo::Clone(file),
      mojo::Clone(max_capture_size),
      mojo::Clone(max_decoded_image_size_bytes),
      mojo::Clone(skip_accelerated_content)
  );
}

template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>*>
bool PaintPreviewCaptureParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->persistence, other_struct.persistence))
    return false;
  if (!mojo::Equals(this->guid, other_struct.guid))
    return false;
  if (!mojo::Equals(this->geometry_metadata_params, other_struct.geometry_metadata_params))
    return false;
  if (!mojo::Equals(this->is_main_frame, other_struct.is_main_frame))
    return false;
  if (!mojo::Equals(this->capture_links, other_struct.capture_links))
    return false;
  if (!mojo::Equals(this->file, other_struct.file))
    return false;
  if (!mojo::Equals(this->max_capture_size, other_struct.max_capture_size))
    return false;
  if (!mojo::Equals(this->max_decoded_image_size_bytes, other_struct.max_decoded_image_size_bytes))
    return false;
  if (!mojo::Equals(this->skip_accelerated_content, other_struct.skip_accelerated_content))
    return false;
  return true;
}

template <typename T, PaintPreviewCaptureParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.persistence < rhs.persistence)
    return true;
  if (rhs.persistence < lhs.persistence)
    return false;
  if (lhs.guid < rhs.guid)
    return true;
  if (rhs.guid < lhs.guid)
    return false;
  if (lhs.geometry_metadata_params < rhs.geometry_metadata_params)
    return true;
  if (rhs.geometry_metadata_params < lhs.geometry_metadata_params)
    return false;
  if (lhs.is_main_frame < rhs.is_main_frame)
    return true;
  if (rhs.is_main_frame < lhs.is_main_frame)
    return false;
  if (lhs.capture_links < rhs.capture_links)
    return true;
  if (rhs.capture_links < lhs.capture_links)
    return false;
  if (lhs.file < rhs.file)
    return true;
  if (rhs.file < lhs.file)
    return false;
  if (lhs.max_capture_size < rhs.max_capture_size)
    return true;
  if (rhs.max_capture_size < lhs.max_capture_size)
    return false;
  if (lhs.max_decoded_image_size_bytes < rhs.max_decoded_image_size_bytes)
    return true;
  if (rhs.max_decoded_image_size_bytes < lhs.max_decoded_image_size_bytes)
    return false;
  if (lhs.skip_accelerated_content < rhs.skip_accelerated_content)
    return true;
  if (rhs.skip_accelerated_content < lhs.skip_accelerated_content)
    return false;
  return false;
}
template <typename StructPtrType>
LinkDataPtr LinkData::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(rect)
  );
}

template <typename T, LinkData::EnableIfSame<T>*>
bool LinkData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->rect, other_struct.rect))
    return false;
  return true;
}

template <typename T, LinkData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.rect < rhs.rect)
    return true;
  if (rhs.rect < lhs.rect)
    return false;
  return false;
}
template <typename StructPtrType>
PaintPreviewCaptureResponsePtr PaintPreviewCaptureResponse::Clone() const {
  return New(
      mojo::Clone(embedding_token),
      mojo::Clone(content_id_to_embedding_token),
      mojo::Clone(links),
      mojo::Clone(blink_recording_time),
      mojo::Clone(serialized_size),
      mojo::Clone(geometry_metadata),
      mojo::Clone(skp)
  );
}

template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>*>
bool PaintPreviewCaptureResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->embedding_token, other_struct.embedding_token))
    return false;
  if (!mojo::Equals(this->content_id_to_embedding_token, other_struct.content_id_to_embedding_token))
    return false;
  if (!mojo::Equals(this->links, other_struct.links))
    return false;
  if (!mojo::Equals(this->blink_recording_time, other_struct.blink_recording_time))
    return false;
  if (!mojo::Equals(this->serialized_size, other_struct.serialized_size))
    return false;
  if (!mojo::Equals(this->geometry_metadata, other_struct.geometry_metadata))
    return false;
  if (!mojo::Equals(this->skp, other_struct.skp))
    return false;
  return true;
}

template <typename T, PaintPreviewCaptureResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.embedding_token < rhs.embedding_token)
    return true;
  if (rhs.embedding_token < lhs.embedding_token)
    return false;
  if (lhs.content_id_to_embedding_token < rhs.content_id_to_embedding_token)
    return true;
  if (rhs.content_id_to_embedding_token < lhs.content_id_to_embedding_token)
    return false;
  if (lhs.links < rhs.links)
    return true;
  if (rhs.links < lhs.links)
    return false;
  if (lhs.blink_recording_time < rhs.blink_recording_time)
    return true;
  if (rhs.blink_recording_time < lhs.blink_recording_time)
    return false;
  if (lhs.serialized_size < rhs.serialized_size)
    return true;
  if (rhs.serialized_size < lhs.serialized_size)
    return false;
  if (lhs.geometry_metadata < rhs.geometry_metadata)
    return true;
  if (rhs.geometry_metadata < lhs.geometry_metadata)
    return false;
  if (lhs.skp < rhs.skp)
    return true;
  if (rhs.skp < lhs.skp)
    return false;
  return false;
}
template <typename StructPtrType>
GeometryMetadataParamsPtr GeometryMetadataParams::Clone() const {
  return New(
      mojo::Clone(clip_rect),
      mojo::Clone(clip_x_coord_override),
      mojo::Clone(clip_y_coord_override),
      mojo::Clone(clip_rect_is_hint)
  );
}

template <typename T, GeometryMetadataParams::EnableIfSame<T>*>
bool GeometryMetadataParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->clip_rect, other_struct.clip_rect))
    return false;
  if (!mojo::Equals(this->clip_x_coord_override, other_struct.clip_x_coord_override))
    return false;
  if (!mojo::Equals(this->clip_y_coord_override, other_struct.clip_y_coord_override))
    return false;
  if (!mojo::Equals(this->clip_rect_is_hint, other_struct.clip_rect_is_hint))
    return false;
  return true;
}

template <typename T, GeometryMetadataParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.clip_rect < rhs.clip_rect)
    return true;
  if (rhs.clip_rect < lhs.clip_rect)
    return false;
  if (lhs.clip_x_coord_override < rhs.clip_x_coord_override)
    return true;
  if (rhs.clip_x_coord_override < lhs.clip_x_coord_override)
    return false;
  if (lhs.clip_y_coord_override < rhs.clip_y_coord_override)
    return true;
  if (rhs.clip_y_coord_override < lhs.clip_y_coord_override)
    return false;
  if (lhs.clip_rect_is_hint < rhs.clip_rect_is_hint)
    return true;
  if (rhs.clip_rect_is_hint < lhs.clip_rect_is_hint)
    return false;
  return false;
}
template <typename StructPtrType>
GeometryMetadataResponsePtr GeometryMetadataResponse::Clone() const {
  return New(
      mojo::Clone(scroll_offsets),
      mojo::Clone(frame_offsets)
  );
}

template <typename T, GeometryMetadataResponse::EnableIfSame<T>*>
bool GeometryMetadataResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scroll_offsets, other_struct.scroll_offsets))
    return false;
  if (!mojo::Equals(this->frame_offsets, other_struct.frame_offsets))
    return false;
  return true;
}

template <typename T, GeometryMetadataResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scroll_offsets < rhs.scroll_offsets)
    return true;
  if (rhs.scroll_offsets < lhs.scroll_offsets)
    return false;
  if (lhs.frame_offsets < rhs.frame_offsets)
    return true;
  if (rhs.frame_offsets < lhs.frame_offsets)
    return false;
  return false;
}


}  // paint_preview::mojom

namespace mojo {


template <>
struct  StructTraits<::paint_preview::mojom::PaintPreviewCaptureParams::DataView,
                                         ::paint_preview::mojom::PaintPreviewCaptureParamsPtr> {
  static bool IsNull(const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::PaintPreviewCaptureParamsPtr* output) { output->reset(); }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::persistence) persistence(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->persistence;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureParams::guid)& guid(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->guid;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureParams::geometry_metadata_params)& geometry_metadata_params(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->geometry_metadata_params;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::is_main_frame) is_main_frame(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->is_main_frame;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::capture_links) capture_links(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->capture_links;
  }

  static  decltype(::paint_preview::mojom::PaintPreviewCaptureParams::file)& file(
       ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->file;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::max_capture_size) max_capture_size(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->max_capture_size;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::max_decoded_image_size_bytes) max_decoded_image_size_bytes(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->max_decoded_image_size_bytes;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureParams::skip_accelerated_content) skip_accelerated_content(
      const ::paint_preview::mojom::PaintPreviewCaptureParamsPtr& input) {
    return input->skip_accelerated_content;
  }

  static bool Read(::paint_preview::mojom::PaintPreviewCaptureParams::DataView input, ::paint_preview::mojom::PaintPreviewCaptureParamsPtr* output);
};


template <>
struct  StructTraits<::paint_preview::mojom::LinkData::DataView,
                                         ::paint_preview::mojom::LinkDataPtr> {
  static bool IsNull(const ::paint_preview::mojom::LinkDataPtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::LinkDataPtr* output) { output->reset(); }

  static const decltype(::paint_preview::mojom::LinkData::url)& url(
      const ::paint_preview::mojom::LinkDataPtr& input) {
    return input->url;
  }

  static const decltype(::paint_preview::mojom::LinkData::rect)& rect(
      const ::paint_preview::mojom::LinkDataPtr& input) {
    return input->rect;
  }

  static bool Read(::paint_preview::mojom::LinkData::DataView input, ::paint_preview::mojom::LinkDataPtr* output);
};


template <>
struct  StructTraits<::paint_preview::mojom::PaintPreviewCaptureResponse::DataView,
                                         ::paint_preview::mojom::PaintPreviewCaptureResponsePtr> {
  static bool IsNull(const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::PaintPreviewCaptureResponsePtr* output) { output->reset(); }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::embedding_token)& embedding_token(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->embedding_token;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::content_id_to_embedding_token)& content_id_to_embedding_token(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->content_id_to_embedding_token;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::links)& links(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->links;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::blink_recording_time)& blink_recording_time(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->blink_recording_time;
  }

  static decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::serialized_size) serialized_size(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->serialized_size;
  }

  static const decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::geometry_metadata)& geometry_metadata(
      const ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->geometry_metadata;
  }

  static  decltype(::paint_preview::mojom::PaintPreviewCaptureResponse::skp)& skp(
       ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& input) {
    return input->skp;
  }

  static bool Read(::paint_preview::mojom::PaintPreviewCaptureResponse::DataView input, ::paint_preview::mojom::PaintPreviewCaptureResponsePtr* output);
};


template <>
struct  StructTraits<::paint_preview::mojom::GeometryMetadataParams::DataView,
                                         ::paint_preview::mojom::GeometryMetadataParamsPtr> {
  static bool IsNull(const ::paint_preview::mojom::GeometryMetadataParamsPtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::GeometryMetadataParamsPtr* output) { output->reset(); }

  static const decltype(::paint_preview::mojom::GeometryMetadataParams::clip_rect)& clip_rect(
      const ::paint_preview::mojom::GeometryMetadataParamsPtr& input) {
    return input->clip_rect;
  }

  static decltype(::paint_preview::mojom::GeometryMetadataParams::clip_x_coord_override) clip_x_coord_override(
      const ::paint_preview::mojom::GeometryMetadataParamsPtr& input) {
    return input->clip_x_coord_override;
  }

  static decltype(::paint_preview::mojom::GeometryMetadataParams::clip_y_coord_override) clip_y_coord_override(
      const ::paint_preview::mojom::GeometryMetadataParamsPtr& input) {
    return input->clip_y_coord_override;
  }

  static decltype(::paint_preview::mojom::GeometryMetadataParams::clip_rect_is_hint) clip_rect_is_hint(
      const ::paint_preview::mojom::GeometryMetadataParamsPtr& input) {
    return input->clip_rect_is_hint;
  }

  static bool Read(::paint_preview::mojom::GeometryMetadataParams::DataView input, ::paint_preview::mojom::GeometryMetadataParamsPtr* output);
};


template <>
struct  StructTraits<::paint_preview::mojom::GeometryMetadataResponse::DataView,
                                         ::paint_preview::mojom::GeometryMetadataResponsePtr> {
  static bool IsNull(const ::paint_preview::mojom::GeometryMetadataResponsePtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::GeometryMetadataResponsePtr* output) { output->reset(); }

  static const decltype(::paint_preview::mojom::GeometryMetadataResponse::scroll_offsets)& scroll_offsets(
      const ::paint_preview::mojom::GeometryMetadataResponsePtr& input) {
    return input->scroll_offsets;
  }

  static const decltype(::paint_preview::mojom::GeometryMetadataResponse::frame_offsets)& frame_offsets(
      const ::paint_preview::mojom::GeometryMetadataResponsePtr& input) {
    return input->frame_offsets;
  }

  static bool Read(::paint_preview::mojom::GeometryMetadataResponse::DataView input, ::paint_preview::mojom::GeometryMetadataResponsePtr* output);
};


template <>
struct  UnionTraits<::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result::DataView,
                                        ::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr> {
  static bool IsNull(const ::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result::Tag GetTag(const ::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::paint_preview::mojom::PaintPreviewCaptureResponsePtr& success( ::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::paint_preview::mojom::PaintPreviewStatus failure(const ::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_Result::DataView input, ::paint_preview::mojom::PaintPreviewRecorder_CapturePaintPreview_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_H_