// components/page_image_service/mojom/page_image_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/page_image_service/mojom/page_image_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/page_image_service/mojom/page_image_service.mojom-params-data.h"
namespace page_image_service {
namespace mojom {

NOINLINE static const char* ClientIdToStringHelper(ClientId value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ClientId::Journeys:
      return "Journeys";
    case ClientId::JourneysSidePanel:
      return "JourneysSidePanel";
    case ClientId::NtpRealbox:
      return "NtpRealbox";
    case ClientId::NtpQuests:
      return "NtpQuests";
    case ClientId::Bookmarks:
      return "Bookmarks";
    case ClientId::NtpTabResumption:
      return "NtpTabResumption";
    case ClientId::HistoryEmbeddings:
      return "HistoryEmbeddings";
    default:
      return nullptr;
  }
}

std::string ClientIdToString(ClientId value) {
  const char *str = ClientIdToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ClientId value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ClientId value) {
  return os << ClientIdToString(value);
}

namespace internal {


// static
bool Options_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Options_Data* object =
      static_cast<const Options_Data*>(data);

  return true;
}

Options_Data::Options_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImageResult_Data* object =
      static_cast<const ImageResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_url, validation_context))
    return false;

  return true;
}

ImageResult_Data::ImageResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageImageServiceHandler_GetPageImageUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageImageServiceHandler_GetPageImageUrl_Params_Data* object =
      static_cast<const PageImageServiceHandler_GetPageImageUrl_Params_Data*>(data);


  if (!::page_image_service::mojom::internal::ClientId_Data
        ::Validate(object->client_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

PageImageServiceHandler_GetPageImageUrl_Params_Data::PageImageServiceHandler_GetPageImageUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageImageServiceHandler_GetPageImageUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageImageServiceHandler_GetPageImageUrl_ResponseParams_Data* object =
      static_cast<const PageImageServiceHandler_GetPageImageUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

PageImageServiceHandler_GetPageImageUrl_ResponseParams_Data::PageImageServiceHandler_GetPageImageUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace page_image_service

namespace perfetto {

// static
void TraceFormatTraits<::page_image_service::mojom::ClientId>::WriteIntoTrace(
   perfetto::TracedValue context, ::page_image_service::mojom::ClientId value) {
  return std::move(context).WriteString(::page_image_service::mojom::ClientIdToString(value));
}

} // namespace perfetto